/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.accessories;

import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.slot.SlotReference;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import reliquary.compat.accessories.AccessoriesCompatClient;
import reliquary.init.ModItems;
import reliquary.util.PlayerInventoryProvider;

public class AccessoriesCompat {
    private final Set<String> containerNames = new CopyOnWriteArraySet<String>();
    private long lastTagsRefresh = -1L;
    private static final int TAGS_REFRESH_COOLDOWN = 100;

    private void addPlayerInventoryHandlers() {
        PlayerInventoryProvider.get().addPlayerInventoryHandler("accessories", this::getAccessoriesSlotTags, AccessoriesCompat::getSize, AccessoriesCompat::getStackInSlot, AccessoriesCompat::setStackInSlot, true);
    }

    public AccessoriesCompat(IEventBus modBus) {
        if (FMLEnvironment.dist.isClient()) {
            AccessoriesCompatClient.registerRenderers(modBus);
        }
        modBus.addListener(this::onSetup);
        this.addPlayerInventoryHandlers();
    }

    private void onSetup(FMLCommonSetupEvent event) {
        AccessoriesAPI.registerAccessory((Item)ModItems.MOB_CHARM_BELT.get(), (Accessory)new Accessory(this){

            public boolean canEquipFromUse(ItemStack stack) {
                return false;
            }
        });
    }

    public static ItemStack getStackInSlot(LivingEntity entity, String slotName, int slot) {
        return AccessoriesCapability.getOptionally((LivingEntity)entity).map(cap -> {
            AccessoriesContainer container = (AccessoriesContainer)cap.getContainers().get(slotName);
            if (container == null) {
                return ItemStack.EMPTY;
            }
            return container.getAccessories().getItem(slot);
        }).orElse(ItemStack.EMPTY);
    }

    public static void setStackInSlot(LivingEntity entity, String slotName, int slot, ItemStack stack) {
        AccessoriesCapability.getOptionally((LivingEntity)entity).ifPresent(cap -> SlotReference.of((LivingEntity)entity, (String)slotName, (int)slot).setStack(stack));
    }

    private static int getSize(LivingEntity entity, String slotName) {
        return AccessoriesCapability.getOptionally((LivingEntity)entity).map(cap -> {
            AccessoriesContainer container = (AccessoriesContainer)cap.getContainers().get(slotName);
            if (container == null) {
                return 0;
            }
            return container.getSize();
        }).orElse(0);
    }

    private Set<String> getAccessoriesSlotTags(Player player) {
        long gameTime = player.level().getGameTime();
        if (this.lastTagsRefresh + 100L < gameTime) {
            this.lastTagsRefresh = gameTime;
            this.containerNames.clear();
            this.containerNames.addAll(AccessoriesCapability.getOptionally((LivingEntity)player).map(capability -> capability.getContainers().keySet()).orElse(Collections.emptySet()));
        }
        return this.containerNames;
    }
}

