/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import reliquary.Reliquary;
import reliquary.crafting.MobCharmRecipe;
import reliquary.init.ModItems;
import reliquary.item.MobCharmFragmentItem;
import reliquary.item.MobCharmRegistry;

public class MobCharmRecipeMaker {
    private MobCharmRecipeMaker() {
    }

    public static List<RecipeHolder<CraftingRecipe>> getRecipes() {
        ArrayList<RecipeHolder<CraftingRecipe>> recipes = new ArrayList<RecipeHolder<CraftingRecipe>>();
        MobCharmRecipe.REGISTERED_RECIPES.forEach(baseRecipe -> MobCharmRecipeMaker.addMobCharmRecipes(recipes, baseRecipe));
        return recipes;
    }

    private static void addMobCharmRecipes(List<RecipeHolder<CraftingRecipe>> recipes, MobCharmRecipe baseRecipe) {
        for (ResourceLocation regName : MobCharmRegistry.getRegisteredNames()) {
            NonNullList inputs = NonNullList.create();
            baseRecipe.getIngredients().forEach(i -> {
                if (Arrays.stream(i.getItems()).anyMatch(stack -> stack.getItem() instanceof MobCharmFragmentItem)) {
                    ItemStack[] items = new ItemStack[i.getItems().length];
                    for (int j = 0; j < i.getItems().length; ++j) {
                        ItemStack item = i.getItems()[j];
                        items[j] = item.getItem() instanceof MobCharmFragmentItem ? ModItems.MOB_CHARM_FRAGMENT.get().getStackFor(regName) : item;
                    }
                    inputs.add((Object)Ingredient.of((ItemStack[])items));
                } else {
                    inputs.add(i);
                }
            });
            ItemStack output = ModItems.MOB_CHARM.get().getStackFor(regName);
            ShapedRecipePattern pattern = new ShapedRecipePattern(3, 3, inputs, Optional.empty());
            ResourceLocation id = Reliquary.getRL("mob_charm_" + regName.toString().replace(':', '_'));
            recipes.add((RecipeHolder<CraftingRecipe>)new RecipeHolder(id, (Recipe)new ShapedRecipe("reliquary.mob_charm", CraftingBookCategory.MISC, pattern, output)));
        }
    }
}

