/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import reliquary.block.tile.PedestalBlockEntity;
import reliquary.init.ModDataComponents;
import reliquary.init.ModItems;
import reliquary.item.ItemBase;
import reliquary.item.MobCharmDefinition;
import reliquary.item.MobCharmRegistry;
import reliquary.network.MobCharmDamagePayload;
import reliquary.pedestal.PedestalRegistry;
import reliquary.reference.Config;
import reliquary.util.MobHelper;
import reliquary.util.PlayerInventoryProvider;
import reliquary.util.WorldHelper;

public class MobCharmItem
extends ItemBase {
    private final CharmInventoryHandler charmInventoryHandler = new CharmInventoryHandler();

    public MobCharmItem() {
        super(new Item.Properties().stacksTo(1).durability(10).setNoRepair());
        NeoForge.EVENT_BUS.addListener(this::onEntityTargetedEvent);
        NeoForge.EVENT_BUS.addListener(this::onLivingUpdate);
        NeoForge.EVENT_BUS.addListener(this::onLivingDeath);
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)Config.COMMON.items.mobCharm.durability.get();
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        BuiltInRegistries.ENTITY_TYPE.getOptional(MobCharmItem.getEntityEggRegistryName(stack)).ifPresent(entityType -> tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip"), (Object[])new Object[]{entityType.getDescription().getString()}).withStyle(ChatFormatting.GRAY)));
    }

    @Override
    public MutableComponent getName(ItemStack stack) {
        return BuiltInRegistries.ENTITY_TYPE.getOptional(MobCharmItem.getEntityEggRegistryName(stack)).map(entityType -> Component.translatable((String)this.getDescriptionId(), (Object[])new Object[]{entityType.getDescription().getString()}).withStyle(ChatFormatting.GREEN)).orElseGet(() -> super.getName(stack));
    }

    @Override
    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        for (ResourceLocation entityRegistryName : MobCharmRegistry.getRegisteredNames()) {
            itemConsumer.accept(this.getStackFor(entityRegistryName));
        }
    }

    private void onEntityTargetedEvent(LivingChangeTargetEvent event) {
        Player player;
        LivingEntity livingEntity;
        block3: {
            block2: {
                if (event.getEntity().level().isClientSide() || !((livingEntity = event.getNewAboutToBeSetTarget()) instanceof Player)) break block2;
                player = (Player)livingEntity;
                if (!(event.getNewAboutToBeSetTarget() instanceof FakePlayer) && (livingEntity = event.getEntity()) instanceof Mob) break block3;
            }
            return;
        }
        Mob entity = (Mob)livingEntity;
        MobCharmRegistry.getCharmDefinitionFor((Entity)entity).ifPresent(charmDefinition -> {
            if (this.isMobCharmPresent(player, (MobCharmDefinition)charmDefinition)) {
                event.setCanceled(true);
            }
        });
    }

    private void onLivingUpdate(EntityTickEvent.Pre event) {
        Entity entity;
        if (event.getEntity().level().isClientSide() || !((entity = event.getEntity()) instanceof Mob)) {
            return;
        }
        Mob entity2 = (Mob)entity;
        Player player = this.getRealPlayer(entity2.getTarget()).orElse(null);
        if (player == null) {
            player = this.getRealPlayer(entity2.getLastHurtByMob()).orElse(null);
        }
        if (player == null) {
            player = MobHelper.getTargetedPlayerFromMemory(entity2).orElse(null);
        }
        if (player == null) {
            return;
        }
        Player finalPlayer = player;
        MobCharmRegistry.getCharmDefinitionFor((Entity)entity2).ifPresent(charmDefinition -> {
            if (this.isMobCharmPresent(finalPlayer, (MobCharmDefinition)charmDefinition)) {
                MobHelper.resetTarget(entity2, true);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    private Optional<Player> getRealPlayer(@Nullable LivingEntity livingEntity) {
        Optional<Player> optional;
        if (livingEntity instanceof Player) {
            Player p = (Player)livingEntity;
            if (!(livingEntity instanceof FakePlayer)) {
                optional = Optional.of(p);
                return optional;
            }
        }
        optional = Optional.empty();
        return optional;
    }

    private void onLivingDeath(LivingDeathEvent event) {
        Entity entity;
        if (event.getSource().getEntity() == null || !((entity = event.getSource().getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        MobCharmRegistry.getCharmDefinitionFor((Entity)event.getEntity()).ifPresent(charmDefinition -> {
            if (!this.charmInventoryHandler.damagePlayersMobCharm(player, charmDefinition.getRegistryName())) {
                this.damageMobCharmInPedestal((Player)player, charmDefinition.getRegistryName());
            }
        });
    }

    private void damageMobCharmInPedestal(Player player, ResourceLocation entityRegistryName) {
        List<BlockPos> pedestalPositions = PedestalRegistry.getPositionsInRange(player.level().dimension().registry(), player.blockPosition(), (Integer)Config.COMMON.items.mobCharm.pedestalRange.get());
        Level level = player.getCommandSenderWorld();
        for (BlockPos pos : pedestalPositions) {
            WorldHelper.getBlockEntity((BlockGetter)level, pos, PedestalBlockEntity.class).ifPresent(pedestal -> this.damageMobCharmInPedestal(player, entityRegistryName, (PedestalBlockEntity)pedestal));
        }
    }

    private void damageMobCharmInPedestal(Player player, ResourceLocation entityRegistryName, PedestalBlockEntity pedestal) {
        if (pedestal.isEnabled()) {
            ItemStack pedestalItem = pedestal.getItem();
            if (MobCharmItem.isCharmFor(pedestalItem, entityRegistryName)) {
                if (pedestalItem.getDamageValue() + (Integer)Config.COMMON.items.mobCharm.damagePerKill.get() > pedestalItem.getMaxDamage()) {
                    pedestal.destroyItem();
                } else {
                    pedestalItem.setDamageValue(pedestalItem.getDamageValue() + (Integer)Config.COMMON.items.mobCharm.damagePerKill.get());
                }
            } else if (pedestalItem.getItem() == ModItems.MOB_CHARM_BELT.get()) {
                ModItems.MOB_CHARM_BELT.get().damageCharm(player, pedestalItem, entityRegistryName);
            }
        }
    }

    private boolean isMobCharmPresent(Player player, MobCharmDefinition charmDefinition) {
        return this.charmInventoryHandler.playerHasMobCharm(player, charmDefinition) || this.pedestalWithCharmInRange(player, charmDefinition);
    }

    private boolean isCharmOrBeltFor(ItemStack slotStack, ResourceLocation registryName) {
        return MobCharmItem.isCharmFor(slotStack, registryName) || slotStack.getItem() == ModItems.MOB_CHARM_BELT.get() && ModItems.MOB_CHARM_BELT.get().hasCharm(slotStack, registryName);
    }

    static boolean isCharmFor(ItemStack slotStack, ResourceLocation registryName) {
        return slotStack.getItem() == ModItems.MOB_CHARM.get() && MobCharmItem.getEntityEggRegistryName(slotStack).equals((Object)registryName);
    }

    private boolean pedestalWithCharmInRange(Player player, MobCharmDefinition charmDefinition) {
        List<BlockPos> pedestalPositions = PedestalRegistry.getPositionsInRange(player.level().dimension().registry(), player.blockPosition(), (Integer)Config.COMMON.items.mobCharm.pedestalRange.get());
        Level level = player.getCommandSenderWorld();
        for (BlockPos pos : pedestalPositions) {
            if (!WorldHelper.getBlockEntity((BlockGetter)level, pos, PedestalBlockEntity.class).map(pedestal -> this.hasCharm(charmDefinition.getRegistryName(), (PedestalBlockEntity)pedestal)).orElse(false).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean hasCharm(ResourceLocation entityRegistryName, PedestalBlockEntity pedestal) {
        if (pedestal.isEnabled()) {
            ItemStack pedestalItem = pedestal.getItem();
            return this.isCharmOrBeltFor(pedestalItem, entityRegistryName);
        }
        return false;
    }

    public static void setEntityRegistryName(ItemStack charm, ResourceLocation regName) {
        charm.set(ModDataComponents.ENTITY_NAME, (Object)regName);
    }

    public ItemStack getStackFor(ResourceLocation entityRegistryName) {
        ItemStack ret = new ItemStack((ItemLike)this);
        MobCharmItem.setEntityRegistryName(ret, entityRegistryName);
        return ret;
    }

    public static ResourceLocation getEntityEggRegistryName(ItemStack charm) {
        return (ResourceLocation)charm.getOrDefault(ModDataComponents.ENTITY_NAME, (Object)BuiltInRegistries.ENTITY_TYPE.getDefaultKey());
    }

    public boolean isEnchantable(ItemStack p_41456_) {
        return false;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return false;
    }

    public static class CharmInventoryHandler {
        private long lastCharmCacheTime = -1L;
        private final Map<UUID, Set<ResourceLocation>> charmsInInventoryCache = new HashMap<UUID, Set<ResourceLocation>>();

        protected Set<ResourceLocation> getCharmRegistryNames(Player player) {
            return PlayerInventoryProvider.get().getFromPlayerInventoryHandlers(player, (slotStack, set) -> {
                if (slotStack.isEmpty()) {
                    return set;
                }
                if (slotStack.getItem() == ModItems.MOB_CHARM.get()) {
                    set.add(MobCharmItem.getEntityEggRegistryName(slotStack));
                }
                if (slotStack.getItem() == ModItems.MOB_CHARM_BELT.get()) {
                    set.addAll(ModItems.MOB_CHARM_BELT.get().getCharmRegistryNames((ItemStack)slotStack));
                }
                return set;
            }, set -> false, HashSet::new);
        }

        public boolean playerHasMobCharm(Player player, MobCharmDefinition charmDefinition) {
            ResourceLocation registryName = charmDefinition.getRegistryName();
            if (this.lastCharmCacheTime != player.level().getGameTime()) {
                this.lastCharmCacheTime = player.level().getGameTime();
                this.charmsInInventoryCache.clear();
            }
            return this.charmsInInventoryCache.computeIfAbsent(player.getUUID(), u -> this.getCharmRegistryNames(player)).contains(registryName);
        }

        public boolean damagePlayersMobCharm(ServerPlayer player, ResourceLocation entityRegistryName) {
            if (player.isCreative()) {
                return true;
            }
            return this.damageCharmInPlayersInventory(player, entityRegistryName);
        }

        private boolean damageCharmInPlayersInventory(ServerPlayer player, ResourceLocation entityRegistryName) {
            return PlayerInventoryProvider.get().getFromPlayerInventoryHandlers((Player)player, (slotStack, damaged) -> {
                if (slotStack.isEmpty()) {
                    return false;
                }
                if (MobCharmItem.isCharmFor(slotStack, entityRegistryName)) {
                    if (slotStack.getDamageValue() + (Integer)Config.COMMON.items.mobCharm.damagePerKill.get() > slotStack.getMaxDamage()) {
                        slotStack.setCount(0);
                        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new MobCharmDamagePayload(ItemStack.EMPTY, -1), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    } else {
                        slotStack.setDamageValue(slotStack.getDamageValue() + (Integer)Config.COMMON.items.mobCharm.damagePerKill.get());
                        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new MobCharmDamagePayload((ItemStack)slotStack, -1), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                    return true;
                }
                return this.damageMobCharmInBelt(player, entityRegistryName, (ItemStack)slotStack);
            }, damaged -> damaged, () -> false);
        }

        protected boolean damageMobCharmInBelt(ServerPlayer player, ResourceLocation entityRegistryName, ItemStack belt) {
            ItemStack charmStack;
            if (belt.getItem() == ModItems.MOB_CHARM_BELT.get() && !(charmStack = ModItems.MOB_CHARM_BELT.get().damageCharm((Player)player, belt, entityRegistryName)).isEmpty()) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new MobCharmDamagePayload(charmStack, -1), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return true;
            }
            return false;
        }
    }
}

