/*
 * Decompiled with CFR 0.152.
 */
package hexagonnico.undergroundworlds.entities;

import hexagonnico.undergroundworlds.config.ModConfig;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BlackRecluse
extends Spider {
    public BlackRecluse(EntityType<? extends BlackRecluse> type, Level world) {
        super(type, world);
    }

    public boolean doHurtTarget(@NotNull Entity target) {
        if (super.doHurtTarget(target)) {
            if (target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                switch (this.level().getDifficulty()) {
                    case EASY: {
                        if (ModConfig.BLACK_RECLUSE_POISON_TIME_EASY.get() <= 0) break;
                        livingTarget.addEffect(new MobEffectInstance(MobEffects.POISON, ModConfig.BLACK_RECLUSE_POISON_TIME_EASY.get() * 20), (Entity)this);
                        break;
                    }
                    case NORMAL: {
                        if (ModConfig.BLACK_RECLUSE_POISON_TIME_NORMAL.get() <= 0) break;
                        livingTarget.addEffect(new MobEffectInstance(MobEffects.POISON, ModConfig.BLACK_RECLUSE_POISON_TIME_NORMAL.get() * 20), (Entity)this);
                        break;
                    }
                    case HARD: {
                        if (ModConfig.BLACK_RECLUSE_POISON_TIME_HARD.get() <= 0) break;
                        livingTarget.addEffect(new MobEffectInstance(MobEffects.POISON, ModConfig.BLACK_RECLUSE_POISON_TIME_HARD.get() * 20), (Entity)this);
                    }
                }
            }
            return true;
        }
        return false;
    }
}

