/*
 * Decompiled with CFR 0.152.
 */
package hexagonnico.undergroundworlds.items;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public enum ModToolTiers implements Tier
{
    TEMPLE("incorrect_for_temple_tool", 2031, 14.0f, 3.0f, 15, () -> Ingredient.EMPTY),
    JUNGLE("incorrect_for_jungle_tool", 512, 14.0f, 3.0f, 10, () -> Ingredient.EMPTY),
    FREEZING("incorrect_for_freezing_tool", 250, 12.0f, 2.5f, 15, () -> Ingredient.EMPTY);

    private final TagKey<Block> incorrectBlocksForDrops;
    private final int uses;
    private final float speed;
    private final float damage;
    private final int enchantmentValue;
    private final Supplier<Ingredient> repairIngredient;

    private ModToolTiers(String incorrectBlocksForDrops, int uses, float speed, float damage, int enchantmentValue, Supplier<Ingredient> repairIngredient) {
        this.incorrectBlocksForDrops = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergroundworlds", (String)incorrectBlocksForDrops));
        this.uses = uses;
        this.speed = speed;
        this.damage = damage;
        this.enchantmentValue = enchantmentValue;
        this.repairIngredient = Suppliers.memoize(repairIngredient::get);
    }

    public int getUses() {
        return this.uses;
    }

    public float getSpeed() {
        return this.speed;
    }

    public float getAttackDamageBonus() {
        return this.damage;
    }

    @NotNull
    public TagKey<Block> getIncorrectBlocksForDrops() {
        return this.incorrectBlocksForDrops;
    }

    public int getEnchantmentValue() {
        return this.enchantmentValue;
    }

    @NotNull
    public Ingredient getRepairIngredient() {
        return this.repairIngredient.get();
    }
}

