/*
 * Decompiled with CFR 0.152.
 */
package hexagonnico.undergroundworlds.items;

import hexagonnico.undergroundworlds.UndergroundWorlds;
import hexagonnico.undergroundworlds.config.ModConfig;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class SpiderArmorItem
extends ArmorItem {
    public SpiderArmorItem(ArmorItem.Type type, Item.Properties properties) {
        super(UndergroundWorlds.SPIDER_ARMOR_MATERIAL.get(), type, properties);
    }

    public void appendHoverText(@NotNull ItemStack item, @NotNull Item.TooltipContext context, @NotNull List<Component> components, @NotNull TooltipFlag flag) {
        super.appendHoverText(item, context, components, flag);
        components.add((Component)Component.empty());
        components.add((Component)Component.translatable((String)"item.modifiers.undergroundworlds.full_set").withStyle(ChatFormatting.GRAY));
        components.add((Component)Component.literal((String)((int)(ModConfig.SPIDER_ARMOR_POISON_CHANCE.get() * 100.0) + "% ")).append((Component)Component.translatable((String)"item.modifiers.undergroundworlds.spider_armor_full_set")).withStyle(ChatFormatting.BLUE));
    }

    public static boolean isWearingFullSet(LivingEntity entity) {
        return entity.getItemBySlot(EquipmentSlot.HEAD).is((Item)UndergroundWorlds.SPIDER_HELMET.get()) && entity.getItemBySlot(EquipmentSlot.CHEST).is((Item)UndergroundWorlds.SPIDER_CHESTPLATE.get()) && entity.getItemBySlot(EquipmentSlot.LEGS).is((Item)UndergroundWorlds.SPIDER_LEGGINGS.get()) && entity.getItemBySlot(EquipmentSlot.FEET).is((Item)UndergroundWorlds.SPIDER_BOOTS.get());
    }
}

