/*
 * Decompiled with CFR 0.152.
 */
package hexagonnico.undergroundworlds.mixin;

import hexagonnico.undergroundworlds.UndergroundWorlds;
import hexagonnico.undergroundworlds.config.ModConfig;
import hexagonnico.undergroundworlds.entities.IcyCreeper;
import hexagonnico.undergroundworlds.items.CharmItem;
import hexagonnico.undergroundworlds.items.ModToolTiers;
import hexagonnico.undergroundworlds.items.SpiderArmorItem;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Inject(at={@At(value="TAIL")}, method={"hurt"}, cancellable=true)
    public void hurt(DamageSource damageSource, float damage, CallbackInfoReturnable<Boolean> callbackInfo) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)livingEntityMixin;
            livingEntityMixin = damageSource.getDirectEntity();
            if (livingEntityMixin instanceof LivingEntity) {
                TieredItem tieredItem;
                Item item;
                LivingEntity attacker = (LivingEntity)livingEntityMixin;
                ItemStack itemInHand = attacker.getItemInHand(InteractionHand.MAIN_HAND);
                if (itemInHand.is((Item)UndergroundWorlds.BLADE_OF_THE_JUNGLE.get()) && (double)attacker.getRandom().nextFloat() < ModConfig.BLADE_OF_THE_JUNGLE_POISON_CHANCE.get()) {
                    target.addEffect(new MobEffectInstance(MobEffects.POISON, ModConfig.BLADE_OF_THE_JUNGLE_POISON_TIME.get() * 20), (Entity)attacker);
                } else if (ModConfig.FREEZING_TOOLS_FREEZE_TIME.get() > 0 && (item = itemInHand.getItem()) instanceof TieredItem && (tieredItem = (TieredItem)item).getTier().equals((Object)ModToolTiers.FREEZING) && target.canFreeze()) {
                    target.setTicksFrozen(Math.min(target.getTicksFrozen() + ModConfig.FREEZING_TOOLS_FREEZE_TIME.get() * 20, ModConfig.FREEZING_TOOLS_MAX_FREEZE_TIME.get() * 20));
                }
                if (SpiderArmorItem.isWearingFullSet(target) && (double)attacker.getRandom().nextFloat() < ModConfig.SPIDER_ARMOR_POISON_CHANCE.get()) {
                    attacker.addEffect(new MobEffectInstance(MobEffects.POISON, ModConfig.SPIDER_ARMOR_POISON_TIME.get() * 20), (Entity)target);
                }
                if (ModConfig.ICY_CREEPER_CAN_FREEZE.get().booleanValue() && attacker instanceof IcyCreeper && target.canFreeze()) {
                    target.setTicksFrozen((int)(damage * 20.0f));
                }
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"canBeAffected"}, cancellable=true)
    public void canBeAffected(MobEffectInstance effectInstance, CallbackInfoReturnable<Boolean> callbackInfo) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)livingEntityMixin;
            if (effectInstance.is(MobEffects.POISON) && CharmItem.useCharm(livingEntity, UndergroundWorlds.ANTIDOTE_FLASK.get()) || effectInstance.is(MobEffects.BLINDNESS) && CharmItem.useCharm(livingEntity, UndergroundWorlds.DESERT_CHARM.get())) {
                callbackInfo.setReturnValue((Object)false);
            }
        }
    }
}

