/*
 * Decompiled with CFR 0.152.
 */
package hexagonnico.undergroundworlds.utils;

import hexagonnico.undergroundworlds.UndergroundWorlds;
import hexagonnico.undergroundworlds.renderers.AshanRenderer;
import hexagonnico.undergroundworlds.renderers.BlackRecluseRenderer;
import hexagonnico.undergroundworlds.renderers.FrozenZombieRenderer;
import hexagonnico.undergroundworlds.renderers.IcyCreeperRenderer;
import hexagonnico.undergroundworlds.renderers.JungleBeeModel;
import hexagonnico.undergroundworlds.renderers.JungleBeeRenderer;
import hexagonnico.undergroundworlds.renderers.JungleZombieRenderer;
import hexagonnico.undergroundworlds.renderers.SpiderHatchlingRenderer;
import hexagonnico.undergroundworlds.renderers.WrappedRenderer;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class RegisterRenderersUtils {
    public static void registerBlockEntityRenderers(BlockEntityRendererRegister register) {
        register.accept(UndergroundWorlds.MOD_CHEST_ENTITY.get(), ChestRenderer::new);
        register.accept(UndergroundWorlds.TEMPLE_CHEST_ENTITY.get(), ChestRenderer::new);
    }

    public static void registerEntityRenderers(EntityRendererRegister register) {
        register.accept(UndergroundWorlds.JUNGLE_ZOMBIE.get(), JungleZombieRenderer::new);
        register.accept(UndergroundWorlds.JUNGLE_BEE.get(), JungleBeeRenderer::new);
        register.accept(UndergroundWorlds.BLACK_RECLUSE.get(), BlackRecluseRenderer::new);
        register.accept(UndergroundWorlds.SPIDER_HATCHLING.get(), SpiderHatchlingRenderer::new);
        register.accept(UndergroundWorlds.FROZEN_ZOMBIE.get(), FrozenZombieRenderer::new);
        register.accept(UndergroundWorlds.ICY_CREEPER.get(), IcyCreeperRenderer::new);
        register.accept(UndergroundWorlds.ASHAN.get(), AshanRenderer::new);
        register.accept(UndergroundWorlds.WRAPPED.get(), WrappedRenderer::new);
    }

    public static void registerLayerDefinitions(BiConsumer<ModelLayerLocation, Supplier<LayerDefinition>> register) {
        register.accept(JungleBeeRenderer.MODEL_LAYER_LOCATION, JungleBeeModel::createBodyLayer);
    }

    @FunctionalInterface
    public static interface BlockEntityRendererRegister {
        public <T extends BlockEntity> void accept(BlockEntityType<? extends T> var1, BlockEntityRendererProvider<T> var2);
    }

    @FunctionalInterface
    public static interface EntityRendererRegister {
        public <T extends Entity> void accept(EntityType<? extends T> var1, EntityRendererProvider<T> var2);
    }
}

