/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.client.container;

import com.tcn.cosmoslibrary.client.container.CosmosContainerMenuItemStack;
import com.tcn.cosmoslibrary.client.container.slot.SlotBucket;
import com.tcn.cosmoslibrary.client.container.slot.SlotRestrictedAccess;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.cosmoslibrary.common.lib.CosmosChunkPos;
import com.tcn.dimensionalpocketsii.core.management.PocketsRegistrationManager;
import com.tcn.dimensionalpocketsii.pocket.core.Pocket;
import com.tcn.dimensionalpocketsii.pocket.core.registry.StorageManager;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class ContainerElytraplateConnector
extends CosmosContainerMenuItemStack {
    private Pocket pocket;
    private Container bucketSlots;

    public static ContainerElytraplateConnector createContainerServerSide(int windowID, Inventory playerInventory, ItemStack stackIn) {
        int z;
        CompoundTag chunkPos;
        int x;
        CosmosChunkPos chunk;
        Pocket pocket_;
        CompoundTag nbtData;
        CompoundTag compound;
        if (stackIn.has(DataComponents.CUSTOM_DATA) && (compound = ((CustomData)stackIn.get(DataComponents.CUSTOM_DATA)).copyTag()).contains("nbt_data") && (nbtData = compound.getCompound("nbt_data")).contains("chunk_pos") && (pocket_ = StorageManager.getPocketFromChunkPosition(null, chunk = new CosmosChunkPos(x = (chunkPos = nbtData.getCompound("chunk_pos")).getInt("x"), z = chunkPos.getInt("z")))) != null) {
            return new ContainerElytraplateConnector(windowID, playerInventory, pocket_, (Container)new SimpleContainer(2), pocket_, stackIn);
        }
        return new ContainerElytraplateConnector(windowID, playerInventory, (Container)new SimpleContainer(54), (Container)new SimpleContainer(2), new Pocket(null), stackIn);
    }

    public static ContainerElytraplateConnector createContainerClientSide(int windowID, Inventory playerInventory, RegistryFriendlyByteBuf extraData) {
        return new ContainerElytraplateConnector(windowID, playerInventory, (Container)new SimpleContainer(54), (Container)new SimpleContainer(2), Pocket.readFromNBT(extraData.readNbt(), (HolderLookup.Provider)extraData.registryAccess()), (ItemStack)ItemStack.STREAM_CODEC.decode((Object)extraData));
    }

    protected ContainerElytraplateConnector(int id, Inventory playerInventoryIn, Container pocketIn, final Container contentsIn, @Nullable Pocket pocketActual, ItemStack stackIn) {
        super((MenuType)PocketsRegistrationManager.CONTAINER_TYPE_ELYTRAPLATE_CONNECTOR.get(), id, playerInventoryIn, stackIn);
        int x;
        int x2;
        int y;
        this.bucketSlots = contentsIn;
        if (pocketActual != null) {
            this.pocket = pocketActual;
        }
        for (y = 0; y < 10; ++y) {
            for (x2 = 0; x2 < 4; ++x2) {
                this.addSlot(new Slot(pocketIn, x2 + y * 4, 266 + x2 * 18, 17 + y * 18));
            }
        }
        for (y = 0; y < 2; ++y) {
            for (x2 = 0; x2 < 4; ++x2) {
                this.addSlot((Slot)new SlotRestrictedAccess(pocketIn, 40 + x2 + y * 4, 266 + x2 * 18, 210 + y * 18, true, true));
            }
        }
        this.addSlot((Slot)new SlotRestrictedAccess(pocketIn, 48, 37, 42, 1, false, false));
        this.addSlot((Slot)new SlotRestrictedAccess(pocketIn, 49, 16, 42, 1, false, false));
        this.addSlot((Slot)new SlotRestrictedAccess(pocketIn, 50, 58, 42, 1, false, false));
        this.addSlot((Slot)new SlotRestrictedAccess(pocketIn, 51, 16, 85, 1, false, false));
        this.addSlot((Slot)new SlotRestrictedAccess(pocketIn, 52, 37, 85, 1, false, false));
        this.addSlot((Slot)new SlotRestrictedAccess(pocketIn, 53, 58, 85, 1, false, false));
        this.addSlot((Slot)new SlotBucket(contentsIn, 0, 60, 184){

            public void set(ItemStack stackIn) {
                super.set(stackIn);
                if (!contentsIn.getItem(0).isEmpty()) {
                    ItemStack fillStack;
                    Optional fluidStack = FluidUtil.getFluidContained((ItemStack)stackIn);
                    if (fluidStack.isPresent()) {
                        int amount;
                        FluidStack fluid = (FluidStack)fluidStack.get();
                        if (fluid != null && (amount = ContainerElytraplateConnector.this.pocket.fill(fluid, IFluidHandler.FluidAction.SIMULATE)) == fluid.getAmount()) {
                            if (contentsIn.getItem(0).getItem().equals(FluidUtil.tryEmptyContainer((ItemStack)stackIn, (IFluidHandler)ContainerElytraplateConnector.this.pocket.getFluidTank(), (int)amount, null, (boolean)false).result.getItem()) && contentsIn.getItem(1).getCount() < contentsIn.getItem(1).getMaxStackSize()) {
                                ContainerElytraplateConnector.this.pocket.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                                contentsIn.getItem(0).shrink(1);
                                contentsIn.getItem(1).grow(1);
                            }
                            if (contentsIn.getItem(1).isEmpty()) {
                                ContainerElytraplateConnector.this.pocket.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                                contentsIn.setItem(1, FluidUtil.tryEmptyContainer((ItemStack)stackIn, (IFluidHandler)ContainerElytraplateConnector.this.pocket.getFluidTank(), (int)amount, null, (boolean)false).result);
                                contentsIn.getItem(0).shrink(1);
                            }
                        }
                    } else if (ContainerElytraplateConnector.this.pocket.getCurrentFluidAmount() > 0 && contentsIn.getItem(1).isEmpty() && !(fillStack = FluidUtil.tryFillContainer((ItemStack)stackIn, (IFluidHandler)ContainerElytraplateConnector.this.pocket.getFluidTank(), (int)ContainerElytraplateConnector.this.pocket.getCurrentFluidAmount(), null, (boolean)true).result).isEmpty()) {
                        contentsIn.setItem(1, fillStack);
                        contentsIn.getItem(0).shrink(1);
                        this.setChanged();
                    }
                }
            }
        });
        this.addSlot((Slot)new SlotRestrictedAccess(contentsIn, 1, 60, 205, 1, false, true));
        for (x = 0; x < 3; ++x) {
            for (int y2 = 0; y2 < 9; ++y2) {
                this.addSlot(new Slot((Container)playerInventoryIn, y2 + (x + 1) * 9, 92 + y2 * 18, 170 + x * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)playerInventoryIn, x, 92 + x * 18, 228));
        }
    }

    public boolean stillValid(Player playerIn) {
        return true;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index >= 0 && index < 48 ? !this.moveItemStackTo(itemstack1, 54, this.slots.size(), false) : (index >= 54 && index < this.slots.size() - 9 ? !this.moveItemStackTo(itemstack1, 0, 54, false) : index >= this.slots.size() - 9 && index < this.slots.size() && !this.moveItemStackTo(itemstack1, 48, this.slots.size() - 9, false) && !this.moveItemStackTo(itemstack1, 0, 48, false))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack != null ? itemstack : ItemStack.EMPTY;
    }

    public Pocket getPocket() {
        return this.pocket;
    }

    public void removed(Player playerIn) {
        if (!this.bucketSlots.getItem(0).isEmpty() || !this.bucketSlots.getItem(1).isEmpty()) {
            playerIn.getInventory().placeItemBackInInventory(this.bucketSlots.removeItemNoUpdate(0));
            playerIn.getInventory().placeItemBackInInventory(this.bucketSlots.removeItemNoUpdate(1));
        }
    }

    public static class Provider
    implements MenuProvider {
        public AbstractContainerMenu createMenu(int indexIn, Inventory playerInventoryIn, Player playerIn) {
            return ContainerElytraplateConnector.createContainerServerSide(indexIn, playerInventoryIn, playerInventoryIn.getArmor(2));
        }

        public Component getDisplayName() {
            return ComponentHelper.title((String)"dimensionalpocketsii.gui.elytraplate.screen.title");
        }
    }
}

