/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.client.container;

import com.tcn.cosmoslibrary.client.container.CosmosContainerMenuItemStack;
import com.tcn.cosmoslibrary.client.container.slot.SlotArmourItem;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.dimensionalpocketsii.core.management.PocketsRegistrationManager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;

public class ContainerElytraplateEnderChest
extends CosmosContainerMenuItemStack {
    private final Container container;
    private final int containerRows;

    public static ContainerElytraplateEnderChest createContainerServerSide(int windowID, Inventory playerInventoryIn, Container containerIn, ItemStack stackIn) {
        return new ContainerElytraplateEnderChest(windowID, playerInventoryIn, containerIn, stackIn);
    }

    public static ContainerElytraplateEnderChest createContainerClientSide(int windowID, Inventory playerInventoryIn, RegistryFriendlyByteBuf extraData) {
        return new ContainerElytraplateEnderChest(windowID, playerInventoryIn, (Container)new SimpleContainer(27), (ItemStack)ItemStack.STREAM_CODEC.decode((Object)extraData));
    }

    public ContainerElytraplateEnderChest(int indexIn, Inventory playerInventoryIn, Container containerIn, ItemStack stackIn) {
        super((MenuType)PocketsRegistrationManager.CONTAINER_TYPE_ELYTRAPLATE_ENDER_CHEST.get(), indexIn, playerInventoryIn, stackIn);
        ContainerElytraplateEnderChest.checkContainerSize((Container)containerIn, (int)27);
        this.container = containerIn;
        this.containerRows = 3;
        containerIn.startOpen(playerInventoryIn.player);
        int i = (this.containerRows - 4) * 18;
        for (int j = 0; j < this.containerRows; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot(containerIn, k + j * 9, 21 + k * 18, 15 + j * 18));
            }
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.addSlot(new Slot((Container)playerInventoryIn, j1 + l * 9 + 9, 31 + j1 * 18, 98 + l * 18 + i));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.addSlot(new Slot((Container)playerInventoryIn, i1, 31 + i1 * 18, 155 + i));
        }
        this.addSlot((Slot)new SlotArmourItem(playerInventoryIn, 39, 11, 80, this.getPlayer(), 0));
        this.addSlot((Slot)new SlotArmourItem(playerInventoryIn, 38, 11, 99, this.getPlayer(), 1));
        this.addSlot((Slot)new SlotArmourItem(playerInventoryIn, 37, 11, 118, this.getPlayer(), 2));
        this.addSlot((Slot)new SlotArmourItem(playerInventoryIn, 36, 11, 137, this.getPlayer(), 3));
    }

    public boolean stillValid(Player playerIn) {
        return this.container.stillValid(playerIn);
    }

    public ItemStack quickMoveStack(Player playerIn, int indexIn) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(indexIn);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (indexIn >= this.slots.size() - 4 && indexIn < this.slots.size() ? !this.moveItemStackTo(itemstack1, this.containerRows * 9, this.slots.size() - 4, false) : (indexIn < this.containerRows * 9 ? !this.moveItemStackTo(itemstack1, this.containerRows * 9, this.slots.size() - 4, false) : (itemstack.getItem() instanceof ArmorItem ? !this.moveItemStackTo(itemstack1, this.slots.size() - 4, this.slots.size(), false) && !this.moveItemStackTo(itemstack1, 0, this.containerRows * 9, false) : !this.moveItemStackTo(itemstack1, 0, this.containerRows * 9, false)))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        this.container.stopOpen(playerIn);
    }

    public Container getContainer() {
        return this.container;
    }

    public int getRowCount() {
        return this.containerRows;
    }

    public static class Provider
    implements MenuProvider {
        public AbstractContainerMenu createMenu(int indexIn, Inventory playerInventoryIn, Player playerIn) {
            return ContainerElytraplateEnderChest.createContainerServerSide(indexIn, playerInventoryIn, (Container)playerIn.getEnderChestInventory(), playerInventoryIn.getArmor(2));
        }

        public Component getDisplayName() {
            return ComponentHelper.title((String)"dimensionalpocketsii.gui.elytraplate.ender_chest.title");
        }
    }
}

