/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.dimensionalpocketsii.client.renderer.model.DimensionalTridentModel;
import com.tcn.dimensionalpocketsii.core.entity.DimensionalTridentEnhancedEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RendererDimensionalTridentEnhanced
extends EntityRenderer<DimensionalTridentEnhancedEntity> {
    public static final ResourceLocation TRIDENT_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"dimensionalpocketsii", (String)"textures/entity/dimensional_trident_enhanced.png");
    private final DimensionalTridentModel model = new DimensionalTridentModel();

    public RendererDimensionalTridentEnhanced(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
    }

    public void render(DimensionalTridentEnhancedEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource typeBuffer, int packedLightIn) {
        matrixStack.pushPose();
        matrixStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.yRotO, (float)entityIn.getYRot()) - 90.0f));
        matrixStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.xRotO, (float)entityIn.getXRot()) + 90.0f));
        VertexConsumer ivertexbuilder = ItemRenderer.getFoilBufferDirect((MultiBufferSource)typeBuffer, (RenderType)this.model.renderType(this.getTextureLocation(entityIn)), (boolean)false, (boolean)entityIn.isFoil());
        this.model.renderToBuffer(matrixStack, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, ComponentColour.WHITE.decOpaque());
        matrixStack.popPose();
        super.render((Entity)entityIn, entityYaw, partialTicks, matrixStack, typeBuffer, packedLightIn);
    }

    public ResourceLocation getTextureLocation(DimensionalTridentEnhancedEntity entityIn) {
        return TRIDENT_LOCATION;
    }
}

