/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.client.screen;

import com.google.common.collect.Lists;
import com.ibm.icu.text.DecimalFormat;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tcn.cosmoslibrary.CosmosReference;
import com.tcn.cosmoslibrary.client.ui.CosmosUISystem;
import com.tcn.cosmoslibrary.client.ui.screen.widget.CosmosButtonUIHelp;
import com.tcn.cosmoslibrary.client.ui.screen.widget.CosmosButtonUIMode;
import com.tcn.cosmoslibrary.client.ui.screen.widget.CosmosButtonWithType;
import com.tcn.cosmoslibrary.client.ui.screen.widget.CosmosListWidget;
import com.tcn.cosmoslibrary.client.ui.screen.widget.CosmosUIHelpElement;
import com.tcn.cosmoslibrary.common.enums.EnumUIHelp;
import com.tcn.cosmoslibrary.common.enums.EnumUIMode;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IEnergyHolder;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.dimensionalpocketsii.PocketReference;
import com.tcn.dimensionalpocketsii.client.container.ContainerElytraplateConnector;
import com.tcn.dimensionalpocketsii.client.screen.button.DimensionalButton;
import com.tcn.dimensionalpocketsii.core.item.armour.DimensionalElytraplate;
import com.tcn.dimensionalpocketsii.core.network.packet.elytraplate.PacketElytraplateUpdateUIHelp;
import com.tcn.dimensionalpocketsii.core.network.packet.elytraplate.PacketElytraplateUpdateUIMode;
import com.tcn.dimensionalpocketsii.pocket.core.Pocket;
import com.tcn.dimensionalpocketsii.pocket.network.packet.PacketAllowedPlayer;
import com.tcn.dimensionalpocketsii.pocket.network.packet.PacketBlockSideState;
import com.tcn.dimensionalpocketsii.pocket.network.packet.PacketEmptyTank;
import com.tcn.dimensionalpocketsii.pocket.network.packet.PacketHostileSpawnState;
import com.tcn.dimensionalpocketsii.pocket.network.packet.PacketLock;
import com.tcn.dimensionalpocketsii.pocket.network.packet.PacketLockToAllowedPlayers;
import com.tcn.dimensionalpocketsii.pocket.network.packet.PacketTrapPlayers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class ScreenElytraplateConnector
extends AbstractContainerScreen<ContainerElytraplateConnector> {
    protected ResourceLocation WIDGET_TEXTURE;
    protected ArrayList<CosmosListWidget> widgetList = new ArrayList();
    protected ArrayList<String> fromList = new ArrayList();
    private boolean scrollEnabled = false;
    private int currentScroll;
    private int topIndex = 0;
    protected int selectedIndex = -1;
    private int[] listIndex;
    private int[] scrollElementIndex;
    private int[] energyBarData = new int[]{14, 184};
    private int[] fluidBarData = new int[]{37, 52, 185, 184, 18, 57};
    private int[] screenCoords;
    private UUID playerUUID;
    private ItemStack stack;
    private Pocket pocket;
    protected CosmosButtonUIMode uiModeButton;
    protected CosmosButtonUIHelp uiHelpButton;
    private int[] uiHelpButtonIndex;
    protected List<CosmosUIHelpElement> uiHelpElements = Lists.newArrayList();
    private boolean hasUIHelp = false;
    private boolean hasUIHelpElementDeadzone = false;
    private int[] uiHelpElementDeadzone;
    private int uiHelpTitleYOffset = 0;
    private CosmosButtonWithType buttonTextClear;
    private int[] TCBI = new int[]{191, 18, 18};
    private CosmosButtonWithType buttonTextPlus;
    private int[] TABI = new int[]{212, 18, 18};
    private CosmosButtonWithType buttonTextMinus;
    private int[] TMBI = new int[]{233, 18, 18};
    private CosmosButtonWithType buttonTankClear;
    private int[] TBCI = new int[]{59, 225, 20};
    private DimensionalButton buttonNorth;
    private int[] NBI = new int[]{57, 20, 18};
    private DimensionalButton buttonSouth;
    private int[] SBI = new int[]{15, 63, 18};
    private DimensionalButton buttonUp;
    private int[] UBI = new int[]{15, 20, 18};
    private DimensionalButton buttonDown;
    private int[] DBI = new int[]{36, 20, 18};
    private DimensionalButton buttonEast;
    private int[] EBI = new int[]{57, 63, 18};
    private DimensionalButton buttonWest;
    private int[] WBI = new int[]{36, 63, 18};
    private EditBox textField;
    private int[] textFieldI = new int[]{98, 23, 93, 16};
    private CosmosButtonWithType buttonLock;
    private int[] LBI = new int[]{13, 124};
    private CosmosButtonWithType buttonAllowedPlayers;
    private int[] APBI = new int[]{13, 145};
    private DimensionalButton buttonTrapPlayers;
    private int[] TPBI = new int[]{36, 124};
    private CosmosButtonWithType buttonHostileSpawn;
    private int[] HSBI = new int[]{36, 145};
    private CosmosButtonWithType buttonPlaceHolder0;
    private int[] PB0I = new int[]{59, 124};
    private CosmosButtonWithType buttonPlaceHolder1;
    private int[] PB1I = new int[]{59, 145};

    public ScreenElytraplateConnector(ContainerElytraplateConnector containerIn, Inventory inventoryIn, Component componentIn) {
        super((AbstractContainerMenu)containerIn, inventoryIn, componentIn);
        this.pocket = containerIn.getPocket();
        this.playerUUID = ((ContainerElytraplateConnector)this.getMenu()).getPlayer().getUUID();
        this.stack = ((ContainerElytraplateConnector)this.getMenu()).getStack();
        this.setImageDims(362, 256);
        this.setTitleLabelDims(88, 4);
        this.setInventoryLabelDims(88, 157);
        this.setListDims(94, 52, 138, 98, 14, 0);
        this.setScrollElementDims(237, 52);
        this.setUIHelpButtonIndex(345, 19);
        this.setUIHelpTitleOffset(5);
        this.setUIHelpElementDeadzone(0, 0, 360, 256);
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        this.setScreenCoords(CosmosUISystem.Init.getScreenCoords((AbstractContainerScreen)this, (int)this.imageWidth, (int)this.imageHeight));
        this.initTextField();
        this.addButtons();
        super.init();
        this.addUIHelpElements();
    }

    public void containerTick() {
        super.containerTick();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (this.pocket != null) {
            ComponentColour colour = ComponentColour.col((int)this.pocket.getDisplayColour());
            ComponentColour textColour = this.getUIMode().equals((Object)EnumUIMode.LIGHT) ? ComponentColour.BLACK : ComponentColour.SCREEN_LIGHT;
            CosmosUISystem.FontRenderer.drawString((GuiGraphics)graphics, (Font)this.font, (int[])this.getScreenCoords(), (int)93, (int)40, (boolean)true, (Component)ComponentHelper.style((ComponentColour)ComponentColour.getCompColourForScreen((ComponentColour)colour), (String)"dimensionalpocketsii.gui.header.allowed_players"));
            CosmosUISystem.FontRenderer.drawString((GuiGraphics)graphics, (Font)this.font, (int[])this.getScreenCoords(), (int)8, (int)4, (boolean)true, (Component)ComponentHelper.style((ComponentColour)textColour, (String)"dimensionalpocketsii.gui.header.config"));
            CosmosUISystem.FontRenderer.drawString((GuiGraphics)graphics, (Font)this.font, (int[])this.getScreenCoords(), (int)262, (int)4, (boolean)true, (Component)ComponentHelper.style((ComponentColour)textColour, (String)"dimensionalpocketsii.gui.header.pocket_inv"));
            CosmosUISystem.FontRenderer.drawString((GuiGraphics)graphics, (Font)this.font, (int[])this.getScreenCoords(), (int)8, (int)169, (boolean)true, (Component)ComponentHelper.style((ComponentColour)textColour, (String)"dimensionalpocketsii.gui.header.storage"));
            CosmosUISystem.FontRenderer.drawString((GuiGraphics)graphics, (Font)this.font, (int[])this.getScreenCoords(), (int)8, (int)110, (boolean)true, (Component)ComponentHelper.style((ComponentColour)textColour, (String)"dimensionalpocketsii.gui.header.settings"));
        }
        this.textField.render(graphics, mouseX, mouseY, partialTicks);
        this.renderComponents(graphics, mouseX, mouseY, partialTicks);
        this.renderComponentHoverEffect(graphics, Style.EMPTY, mouseX, mouseY);
        this.renderUIHelpElements(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.getHasUIHelpShow()) {
            if (this.hasUIHelpElementDeadzone) {
                if (mouseX <= this.getScreenCoords()[0] + this.uiHelpElementDeadzone[0] || mouseX >= this.getScreenCoords()[0] + this.uiHelpElementDeadzone[2] || mouseY <= this.getScreenCoords()[1] + this.uiHelpElementDeadzone[1] || mouseY >= this.getScreenCoords()[1] + this.uiHelpElementDeadzone[3]) {
                    super.renderTooltip(graphics, mouseX, mouseY);
                }
            } else {
                super.renderTooltip(graphics, mouseX, mouseY);
            }
        } else {
            super.renderTooltip(graphics, mouseX, mouseY);
        }
    }

    public void renderComponents(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderScrollElement(graphics);
        this.updateWidgetList();
        this.renderWidgetList(graphics, mouseX, mouseY, partialTicks);
        this.addUIHelpElements();
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        CosmosUISystem.Render.renderStaticElementWithUIMode((GuiGraphics)graphics, (int[])this.getScreenCoords(), (int)0, (int)0, (int)0, (int)0, (int)Mth.clamp((int)this.imageWidth, (int)0, (int)256), (int)this.imageHeight, (EnumUIMode)this.getUIMode(), (ResourceLocation[])PocketReference.GUI.RESOURCE.CONNECTOR);
        CosmosUISystem.Render.renderStaticElementWithUIMode((GuiGraphics)graphics, (int[])this.getScreenCoords(), (int)256, (int)0, (int)0, (int)0, (int)106, (int)this.imageHeight, (EnumUIMode)this.getUIMode(), (ResourceLocation[])PocketReference.GUI.RESOURCE.CONNECTOR_SIDE);
        if (((ContainerElytraplateConnector)this.menu).getPocket() != null) {
            ComponentColour colour = ComponentColour.col((int)this.pocket.getDisplayColour());
            float[] rgb = colour.equals((Object)ComponentColour.POCKET_PURPLE) ? ComponentColour.rgbFloatArray((ComponentColour)ComponentColour.POCKET_PURPLE_LIGHT) : ComponentColour.rgbFloatArray((ComponentColour)colour);
            CosmosUISystem.Render.renderStaticElementWithUIMode((GuiGraphics)graphics, (int[])this.getScreenCoords(), (int)0, (int)0, (int)0, (int)0, (int)256, (int)256, (float[])new float[]{rgb[0], rgb[1], rgb[2], 1.0f}, (EnumUIMode)this.getUIMode(), (ResourceLocation[])PocketReference.GUI.RESOURCE.CONNECTOR_BASE_NORMAL);
            CosmosUISystem.Render.renderStaticElementWithUIMode((GuiGraphics)graphics, (int[])this.getScreenCoords(), (int)256, (int)0, (int)0, (int)0, (int)106, (int)256, (float[])new float[]{rgb[0], rgb[1], rgb[2], 1.0f}, (EnumUIMode)this.getUIMode(), (ResourceLocation[])PocketReference.GUI.RESOURCE.CONNECTOR_BASE_SIDE);
            CosmosUISystem.Render.renderStaticElementWithUIMode((GuiGraphics)graphics, (int[])this.getScreenCoords(), (int)0, (int)0, (int)0, (int)0, (int)256, (int)256, (EnumUIMode)this.getUIMode(), (ResourceLocation[])PocketReference.GUI.RESOURCE.CONNECTOR_OVERLAY_NORMAL);
            CosmosUISystem.Render.renderStaticElementWithUIMode((GuiGraphics)graphics, (int[])this.getScreenCoords(), (int)256, (int)0, (int)0, (int)0, (int)106, (int)256, (EnumUIMode)this.getUIMode(), (ResourceLocation[])PocketReference.GUI.RESOURCE.CONNECTOR_OVERLAY_SIDE);
            CosmosUISystem.Render.renderFluidTank((GuiGraphics)graphics, (int[])this.getScreenCoords(), (int)this.fluidBarData[0], (int)this.fluidBarData[2], (IFluidTank)this.pocket.getFluidTank(), (int)this.pocket.getFluidLevelScaled(57), (int)57);
            CosmosUISystem.Render.renderEnergyDisplay((GuiGraphics)graphics, (ComponentColour)ComponentColour.RED, (IEnergyHolder)this.pocket, (int[])this.getScreenCoords(), (int)this.energyBarData[0], (int)this.energyBarData[1], (int)16, (int)58, (boolean)false);
        }
        this.textField.render(graphics, mouseX + 30, mouseY, partialTicks);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, this.getUIMode().equals((Object)EnumUIMode.DARK) ? 0xFFFFFF : ComponentColour.BLACK.dec(), false);
        graphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, this.getUIMode().equals((Object)EnumUIMode.DARK) ? 0xFFFFFF : ComponentColour.BLACK.dec(), false);
    }

    public void renderComponentHoverEffect(GuiGraphics graphics, Style style, int mouseX, int mouseY) {
        if (this.getUIHelp().equals((Object)EnumUIHelp.SHOWN)) {
            this.renderHelpElementHoverEffect(graphics, mouseX, mouseY);
        } else {
            Component[] comp;
            if (this.getHasUIHelp() && this.uiHelpButton.isMouseOver((double)mouseX, (double)mouseY)) {
                comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"cosmoslibrary.gui.ui_help.info"), ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"cosmoslibrary.gui.ui_help.value").append((Component)this.getUIHelp().getColouredComp())};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
            }
            if (this.uiModeButton.isMouseOver((double)mouseX, (double)mouseY)) {
                comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"cosmoslibrary.gui.ui_mode.info"), ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"cosmoslibrary.gui.ui_mode.value").append((Component)this.getUIMode().getColouredComp())};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
            } else if (CosmosUISystem.Hovering.isHovering((int)mouseX, (int)mouseY, (int)(this.getScreenCoords()[0] + this.fluidBarData[0] - 1), (int)(this.getScreenCoords()[0] + this.fluidBarData[0] + 16), (int)(this.getScreenCoords()[1] + this.fluidBarData[2]), (int)(this.getScreenCoords()[1] + this.fluidBarData[2] + 57))) {
                FluidTank tank = this.pocket.getFluidTank();
                DecimalFormat formatter = new DecimalFormat("#,###,###,###");
                String amount_string = formatter.format((long)tank.getFluidAmount());
                String capacity_string = formatter.format((long)tank.getCapacity());
                String fluid_name = tank.getFluid().getTranslationKey();
                Component[] comp2 = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.fluid_bar.pre").append((Component)ComponentHelper.style3((ComponentColour)ComponentColour.CYAN, (String)"bold", (String)"[ ", (String)fluid_name, (String)" ]")), ComponentHelper.style2((ComponentColour)ComponentColour.ORANGE, (String)(amount_string + " / " + capacity_string), (String)"dimensionalpocketsii.gui.fluid_bar.suff")};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp2), mouseX, mouseY);
            } else if (CosmosUISystem.Hovering.isHovering((int)mouseX, (int)mouseY, (int)(this.getScreenCoords()[0] + this.energyBarData[0] - 1), (int)(this.getScreenCoords()[0] + this.energyBarData[0] + 16), (int)(this.getScreenCoords()[1] + this.energyBarData[1] - 1), (int)(this.getScreenCoords()[1] + this.energyBarData[1] + 58))) {
                DecimalFormat formatter = new DecimalFormat("#,###,###,###");
                String amount_string = formatter.format((long)this.pocket.getEnergyStored());
                String capacity_string = formatter.format((long)this.pocket.getMaxEnergyStored());
                Component[] comp3 = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.energy_bar.pre"), ComponentHelper.style2((ComponentColour)ComponentColour.RED, (String)(amount_string + " / " + capacity_string), (String)"dimensionalpocketsii.gui.energy_bar.suff")};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp3), mouseX, mouseY);
            } else if (this.buttonLock.isMouseOver((double)mouseX, (double)mouseY)) {
                comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.lock_info"), ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.lock_value").append((Component)this.pocket.getLockState().getColouredComp())};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
            } else if (this.buttonTrapPlayers.isMouseOver(mouseX, mouseY)) {
                comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.trap_players_info"), ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.trap_players_value").append((Component)this.pocket.getTrapState().getColouredComp())};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
            } else if (this.buttonHostileSpawn.isMouseOver((double)mouseX, (double)mouseY)) {
                comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.hostile_spawn_info"), ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.hostile_spawn_value").append((Component)this.pocket.getHostileSpawnState().getColouredComp())};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
            } else if (this.buttonAllowedPlayers.isMouseOver((double)mouseX, (double)mouseY)) {
                comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.allowed_player_info"), ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.allowed_player_value").append((Component)this.pocket.getAllowedPlayerState().getColouredComp())};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
            } else if (this.buttonTextClear.isMouseOver((double)mouseX, (double)mouseY)) {
                graphics.renderTooltip(this.font, (Component)ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.button.text.clear"), mouseX, mouseY);
            } else if (this.buttonTextPlus.isMouseOver((double)mouseX, (double)mouseY)) {
                graphics.renderTooltip(this.font, (Component)ComponentHelper.style((ComponentColour)ComponentColour.GREEN, (String)"dimensionalpocketsii.gui.button.text.plus"), mouseX, mouseY);
            } else if (this.buttonTextMinus.isMouseOver((double)mouseX, (double)mouseY)) {
                graphics.renderTooltip(this.font, (Component)ComponentHelper.style((ComponentColour)ComponentColour.RED, (String)"dimensionalpocketsii.gui.button.text.minus"), mouseX, mouseY);
            } else if (this.buttonTankClear.isMouseOver((double)mouseX, (double)mouseY)) {
                if (!ScreenElytraplateConnector.hasShiftDown()) {
                    graphics.renderTooltip(this.font, (Component)ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.button.tank_clear"), mouseX, mouseY);
                } else {
                    comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.button.tank_clear"), ComponentHelper.style((ComponentColour)ComponentColour.RED, (String)"bold", (String)"dimensionalpocketsii.gui.button.tank_clear_shift")};
                    graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
                }
            } else if (this.buttonDown.isMouseOver(mouseX, mouseY)) {
                comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.button.direction.prefix").append((Component)ComponentHelper.style3((ComponentColour)ComponentColour.YELLOW, (String)"bold", (String)" [", (String)"dimensionalpocketsii.gui.button.direction.down", (String)"]")), ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.button.direction.suffix").append((Component)this.pocket.getSide(Direction.DOWN).getColouredComp())};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
            } else if (this.buttonUp.isMouseOver(mouseX, mouseY)) {
                comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.button.direction.prefix").append((Component)ComponentHelper.style3((ComponentColour)ComponentColour.ORANGE, (String)"bold", (String)" [", (String)"dimensionalpocketsii.gui.button.direction.up", (String)"]")), ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.button.direction.suffix").append((Component)this.pocket.getSide(Direction.UP).getColouredComp())};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
            } else if (this.buttonNorth.isMouseOver(mouseX, mouseY)) {
                comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.button.direction.prefix").append((Component)ComponentHelper.style3((ComponentColour)ComponentColour.BLUE, (String)"bold", (String)" [", (String)"dimensionalpocketsii.gui.button.direction.north", (String)"]")), ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.button.direction.suffix").append((Component)this.pocket.getSide(Direction.NORTH).getColouredComp())};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
            } else if (this.buttonSouth.isMouseOver(mouseX, mouseY)) {
                comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.button.direction.prefix").append((Component)ComponentHelper.style3((ComponentColour)ComponentColour.LIME, (String)"bold", (String)" [", (String)"dimensionalpocketsii.gui.button.direction.south", (String)"]")), ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.button.direction.suffix").append((Component)this.pocket.getSide(Direction.SOUTH).getColouredComp())};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
            } else if (this.buttonWest.isMouseOver(mouseX, mouseY)) {
                comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.button.direction.prefix").append((Component)ComponentHelper.style3((ComponentColour)ComponentColour.WHITE, (String)"bold", (String)" [", (String)"dimensionalpocketsii.gui.button.direction.west", (String)"]")), ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.button.direction.suffix").append((Component)this.pocket.getSide(Direction.WEST).getColouredComp())};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
            } else if (this.buttonEast.isMouseOver(mouseX, mouseY)) {
                comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.button.direction.prefix").append((Component)ComponentHelper.style3((ComponentColour)ComponentColour.GRAY, (String)"bold", (String)" [", (String)"dimensionalpocketsii.gui.button.direction.east", (String)"]")), ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.button.direction.suffix").append((Component)this.pocket.getSide(Direction.EAST).getColouredComp())};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
            }
        }
    }

    protected void renderUIHelpElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.getHasUIHelpShow()) {
            for (CosmosUIHelpElement element : this.uiHelpElements) {
                element.render(graphics, mouseX, mouseY, partialTicks);
            }
            for (Renderable widget : this.renderables) {
                if (widget instanceof CosmosUIHelpElement || widget instanceof CosmosButtonUIHelp || widget instanceof CosmosButtonUIMode || !(widget instanceof Button)) continue;
                Button button = (Button)widget;
                button.active = false;
            }
        }
    }

    protected void updateWidgetList() {
        if (this.pocket != null) {
            this.updateFromList(this.pocket.getAllowedPlayersArray());
            this.updateFromStringList();
        }
    }

    protected void addButtons() {
        this.clearWidgets();
        int[] screen_coords = CosmosUISystem.Init.getScreenCoords((AbstractContainerScreen)this, (int)this.imageWidth, (int)this.imageHeight);
        this.uiModeButton = (CosmosButtonUIMode)this.addRenderableWidget((GuiEventListener)new CosmosButtonUIMode(this.getUIMode(), this.getScreenCoords()[0] + 345, this.getScreenCoords()[1] + 5, false, true, true, (Component)ComponentHelper.empty(), button -> this.changeUIMode()));
        if (this.getHasUIHelp()) {
            this.addUIHelpButton(screen_coords, this.uiHelpButtonIndex, button -> this.changeUIHelp());
        }
        int[] sides = new int[]{0, 0, 0, 0, 0, 0};
        for (Direction c : Direction.values()) {
            sides[c.get3DDataValue()] = this.pocket.getSideArray()[c.get3DDataValue()].getIndex();
        }
        this.buttonDown = (DimensionalButton)this.addRenderableWidget((GuiEventListener)new DimensionalButton(this.getScreenCoords()[0] + this.DBI[0], this.getScreenCoords()[1] + this.DBI[1], 18, true, true, sides[0], (Component)ComponentHelper.empty(), button -> this.clickButton(this.buttonDown, true), button -> (MutableComponent)button.get()));
        this.buttonUp = (DimensionalButton)this.addRenderableWidget((GuiEventListener)new DimensionalButton(this.getScreenCoords()[0] + this.UBI[0], this.getScreenCoords()[1] + this.UBI[1], 18, true, true, sides[1], (Component)ComponentHelper.empty(), button -> this.clickButton(this.buttonUp, true), button -> (MutableComponent)button.get()));
        this.buttonNorth = (DimensionalButton)this.addRenderableWidget((GuiEventListener)new DimensionalButton(this.getScreenCoords()[0] + this.NBI[0], this.getScreenCoords()[1] + this.NBI[1], 18, true, true, sides[2], (Component)ComponentHelper.empty(), button -> this.clickButton(this.buttonNorth, true), button -> (MutableComponent)button.get()));
        this.buttonSouth = (DimensionalButton)this.addRenderableWidget((GuiEventListener)new DimensionalButton(this.getScreenCoords()[0] + this.SBI[0], this.getScreenCoords()[1] + this.SBI[1], 18, true, true, sides[3], (Component)ComponentHelper.empty(), button -> this.clickButton(this.buttonSouth, true), button -> (MutableComponent)button.get()));
        this.buttonWest = (DimensionalButton)this.addRenderableWidget((GuiEventListener)new DimensionalButton(this.getScreenCoords()[0] + this.WBI[0], this.getScreenCoords()[1] + this.WBI[1], 18, true, true, sides[4], (Component)ComponentHelper.empty(), button -> this.clickButton(this.buttonWest, true), button -> (MutableComponent)button.get()));
        this.buttonEast = (DimensionalButton)this.addRenderableWidget((GuiEventListener)new DimensionalButton(this.getScreenCoords()[0] + this.EBI[0], this.getScreenCoords()[1] + this.EBI[1], 18, true, true, sides[5], (Component)ComponentHelper.empty(), button -> this.clickButton(this.buttonEast, true), button -> (MutableComponent)button.get()));
        this.buttonTrapPlayers = (DimensionalButton)this.addRenderableWidget((GuiEventListener)new DimensionalButton(this.getScreenCoords()[0] + this.TPBI[0], this.getScreenCoords()[1] + this.TPBI[1], 18, true, true, this.pocket.getTrapState().getIndex() + 14, (Component)ComponentHelper.empty(), button -> this.clickButton(this.buttonTrapPlayers, true), button -> (MutableComponent)button.get()));
        this.buttonTankClear = (CosmosButtonWithType)this.addRenderableWidget((GuiEventListener)new CosmosButtonWithType(CosmosButtonWithType.TYPE.FLUID, this.getScreenCoords()[0] + this.TBCI[0], this.getScreenCoords()[1] + this.TBCI[1], 18, !this.pocket.getFluidTank().isEmpty(), true, this.pocket.getFluidTank().isEmpty() ? 15 : 16, (Component)ComponentHelper.empty(), (button, isLeftClick) -> this.clickButton((Button)this.buttonTankClear, isLeftClick)));
        this.buttonLock = (CosmosButtonWithType)this.addRenderableWidget((GuiEventListener)new CosmosButtonWithType(CosmosButtonWithType.TYPE.GENERAL, this.getScreenCoords()[0] + this.LBI[0], this.getScreenCoords()[1] + this.LBI[1], 18, true, true, this.pocket.getLockState().getIndex() + 8, (Component)ComponentHelper.empty(), (button, isLeftClick) -> this.clickButton((Button)this.buttonLock, isLeftClick)));
        this.buttonAllowedPlayers = (CosmosButtonWithType)this.addRenderableWidget((GuiEventListener)new CosmosButtonWithType(CosmosButtonWithType.TYPE.GENERAL, this.getScreenCoords()[0] + this.APBI[0], this.getScreenCoords()[1] + this.APBI[1], 18, true, true, this.pocket.getAllowedPlayerState().getIndex() + 10, (Component)ComponentHelper.empty(), (button, isLeftClick) -> this.clickButton((Button)this.buttonAllowedPlayers, isLeftClick)));
        this.buttonHostileSpawn = (CosmosButtonWithType)this.addRenderableWidget((GuiEventListener)new CosmosButtonWithType(CosmosButtonWithType.TYPE.GENERAL, this.getScreenCoords()[0] + this.HSBI[0], this.getScreenCoords()[1] + this.HSBI[1], 18, true, true, this.pocket.getHostileSpawnState().getIndex() + 15, (Component)ComponentHelper.empty(), (button, isLeftClick) -> this.clickButton((Button)this.buttonHostileSpawn, isLeftClick)));
        this.buttonTextClear = (CosmosButtonWithType)this.addRenderableWidget((GuiEventListener)new CosmosButtonWithType(CosmosButtonWithType.TYPE.GENERAL, this.getScreenCoords()[0] + this.TCBI[0], this.getScreenCoords()[1] + this.TCBI[1], 18, true, true, 14, (Component)ComponentHelper.empty(), (button, isLeftClick) -> this.clickButton((Button)this.buttonTextClear, isLeftClick)));
        this.buttonTextPlus = (CosmosButtonWithType)this.addRenderableWidget((GuiEventListener)new CosmosButtonWithType(CosmosButtonWithType.TYPE.GENERAL, this.getScreenCoords()[0] + this.TABI[0], this.getScreenCoords()[1] + this.TABI[1], 18, true, true, 1, (Component)ComponentHelper.empty(), (button, isLeftClick) -> this.clickButton((Button)this.buttonTextPlus, isLeftClick)));
        this.buttonTextMinus = (CosmosButtonWithType)this.addRenderableWidget((GuiEventListener)new CosmosButtonWithType(CosmosButtonWithType.TYPE.GENERAL, this.getScreenCoords()[0] + this.TMBI[0], this.getScreenCoords()[1] + this.TMBI[1], 18, true, true, 2, (Component)ComponentHelper.empty(), (button, isLeftClick) -> this.clickButton((Button)this.buttonTextMinus, isLeftClick)));
        this.buttonPlaceHolder0 = (CosmosButtonWithType)this.addRenderableWidget((GuiEventListener)new CosmosButtonWithType(CosmosButtonWithType.TYPE.GENERAL, this.getScreenCoords()[0] + this.PB0I[0], this.getScreenCoords()[1] + this.PB0I[1], 18, true, true, 0, (Component)ComponentHelper.empty(), (button, isLeftClick) -> this.clickButton((Button)this.buttonPlaceHolder0, isLeftClick)));
        this.buttonPlaceHolder1 = (CosmosButtonWithType)this.addRenderableWidget((GuiEventListener)new CosmosButtonWithType(CosmosButtonWithType.TYPE.GENERAL, this.getScreenCoords()[0] + this.PB1I[0], this.getScreenCoords()[1] + this.PB1I[1], 18, true, true, 0, (Component)ComponentHelper.empty(), (button, isLeftClick) -> this.clickButton((Button)this.buttonPlaceHolder1, isLeftClick)));
    }

    private void clickButton(Button button, boolean isLeftClick) {
        if (isLeftClick) {
            if (button.equals(this.buttonLock)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new PacketLock(this.pocket.getDominantChunkPos(), !this.pocket.getLockStateValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.pocket.setLockState(!this.pocket.getLockStateValue());
            } else if (button.equals((Object)this.buttonTrapPlayers)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new PacketTrapPlayers(this.pocket.getDominantChunkPos(), !this.pocket.getTrapStateValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.pocket.setTrapState(!this.pocket.getTrapStateValue());
            } else if (button.equals(this.buttonHostileSpawn)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new PacketHostileSpawnState(this.pocket.getDominantChunkPos(), !this.pocket.getHostileSpawnStateValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.pocket.setHostileSpawnState(!this.pocket.getHostileSpawnStateValue());
            } else if (button.equals(this.buttonAllowedPlayers)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new PacketLockToAllowedPlayers(this.pocket.getDominantChunkPos(), !this.pocket.getAllowedPlayerStateValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.pocket.setAllowedPlayerState(!this.pocket.getAllowedPlayerStateValue());
            }
            if (this.textField != null) {
                int selected;
                String value = this.textField.getValue();
                if (button.equals(this.buttonTextClear)) {
                    this.textField.setValue("");
                } else if (button.equals(this.buttonTextPlus)) {
                    if (!value.isEmpty() && value.length() >= 3) {
                        PacketDistributor.sendToServer((CustomPacketPayload)new PacketAllowedPlayer(this.pocket.getDominantChunkPos(), value, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        this.pocket.addAllowedPlayerNBT(value);
                        this.textField.setValue("");
                    }
                } else if (button.equals(this.buttonTextMinus) && (selected = this.getSelectedWidgetIndex()) != 0) {
                    String string = this.getWidgetList().get(selected).getDisplayString();
                    PacketDistributor.sendToServer((CustomPacketPayload)new PacketAllowedPlayer(this.pocket.getDominantChunkPos(), string, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    this.pocket.removeAllowedPlayerNBT(string);
                    this.removeElement();
                }
            }
            if (button.equals(this.buttonTankClear)) {
                if (ScreenElytraplateConnector.hasShiftDown()) {
                    System.out.println("TEST");
                    PacketDistributor.sendToServer((CustomPacketPayload)new PacketEmptyTank(this.pocket.getDominantChunkPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    this.pocket.emptyFluidTank();
                }
            } else if (button.equals((Object)this.buttonDown)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new PacketBlockSideState(this.pocket.getDominantChunkPos(), Direction.DOWN.get3DDataValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.pocket.cycleSide(Direction.DOWN, true);
            } else if (button.equals((Object)this.buttonUp)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new PacketBlockSideState(this.pocket.getDominantChunkPos(), Direction.UP.get3DDataValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.pocket.cycleSide(Direction.UP, true);
            } else if (button.equals((Object)this.buttonNorth)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new PacketBlockSideState(this.pocket.getDominantChunkPos(), Direction.NORTH.get3DDataValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.pocket.cycleSide(Direction.NORTH, true);
            } else if (button.equals((Object)this.buttonSouth)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new PacketBlockSideState(this.pocket.getDominantChunkPos(), Direction.SOUTH.get3DDataValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.pocket.cycleSide(Direction.SOUTH, true);
            } else if (button.equals((Object)this.buttonWest)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new PacketBlockSideState(this.pocket.getDominantChunkPos(), Direction.WEST.get3DDataValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.pocket.cycleSide(Direction.WEST, true);
            } else if (button.equals((Object)this.buttonEast)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new PacketBlockSideState(this.pocket.getDominantChunkPos(), Direction.EAST.get3DDataValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.pocket.cycleSide(Direction.EAST, true);
            }
        }
        this.addButtons();
    }

    protected void addUIHelpElements() {
        this.clearUIHelpElementList();
        this.addRenderableUIHelpElement(this.getScreenCoords(), 12, 182, 20, 62, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.RED, (String)"dimensionalpocketsii.gui.help.power_display"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.power_display_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.power_display_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 35, 182, 20, 62, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.ORANGE, (String)"dimensionalpocketsii.gui.help.fluid_display"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.fluid_display_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.fluid_display_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 58, 182, 20, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_BLUE, (String)"dimensionalpocketsii.gui.help.slot.bucket_input"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.slot.bucket_input_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.slot.bucket_input_two"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.slot.bucket_input_three"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.slot.bucket_input_four")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 58, 203, 20, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.GREEN, (String)"dimensionalpocketsii.gui.help.slot.bucket_output"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.slot.bucket_output_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.slot.bucket_output_two"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.slot.bucket_output_three")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 58, 224, 20, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.RED, (String)"dimensionalpocketsii.gui.help.fluid_clear_button"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.fluid_clear_button_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.fluid_clear_button_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 12, 40, 66, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.POCKET_PURPLE_LIGHT, (String)"dimensionalpocketsii.gui.help.pocket.surrounding"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.surrounding_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.surrounding_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 12, 84, 66, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.POCKET_PURPLE_LIGHT, (String)"dimensionalpocketsii.gui.help.pocket.surrounding"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.surrounding_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.surrounding_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 12, 17, 66, 22, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.PURPLE, (String)"dimensionalpocketsii.gui.help.pocket.surrounding_config"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.surrounding_config_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.surrounding_config_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 12, 61, 66, 22, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.PURPLE, (String)"dimensionalpocketsii.gui.help.pocket.surrounding_config"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.surrounding_config_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.surrounding_config_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 92, 17, 97, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.help.pocket.allowed_players"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.allowed_players_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.allowed_players_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 190, 17, 20, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.RED, (String)"dimensionalpocketsii.gui.help.pocket.text_clear"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.text_clear_one")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 211, 17, 20, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.GREEN, (String)"dimensionalpocketsii.gui.help.pocket.add_player"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.add_player_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.add_player_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 232, 17, 20, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.RED, (String)"dimensionalpocketsii.gui.help.pocket.remove_player"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.remove_player_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.remove_player_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 92, 50, 142, 102, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.help.pocket.allowed_players_list"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.allowed_players_list_one")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 235, 50, 17, 102, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.help.pocket.scroll_bar"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.scroll_bar_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.scroll_bar_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 12, 123, 20, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.RED, (String)"dimensionalpocketsii.gui.help.pocket.lock"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.lock_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.lock_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 12, 144, 20, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.YELLOW, (String)"dimensionalpocketsii.gui.help.pocket.allow"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.allow_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.allow_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 35, 123, 20, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_RED, (String)"dimensionalpocketsii.gui.help.pocket.trap"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.trap_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.trap_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 35, 144, 20, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.GREEN, (String)"dimensionalpocketsii.gui.help.pocket.mobs"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.mobs_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.mobs_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 58, 123, 20, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.TURQUOISE, (String)"dimensionalpocketsii.gui.help.pocket.mode"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.mode_one")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 58, 144, 20, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.help.pocket.state"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.state_one")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 264, 15, 74, 182, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.help.pocket.items"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.items_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.items_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 264, 208, 74, 38, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.CYAN, (String)"dimensionalpocketsii.gui.help.pocket.buffer_items"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.buffer_items_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.buffer_items_two")});
    }

    public void initTextField() {
        this.textField = new EditBox(this.font, this.getScreenCoords()[0] + this.textFieldI[0], this.getScreenCoords()[1] + this.textFieldI[1], this.textFieldI[2], this.textFieldI[3], (Component)ComponentHelper.title((String)"Allowed Player Entry"));
        this.textField.setMaxLength(16);
        this.textField.setVisible(true);
        this.textField.setTextColor(0xFFFFFF);
        this.textField.setBordered(false);
        this.textField.setCanLoseFocus(true);
        this.textField.setEditable(true);
        this.addWidget((GuiEventListener)this.textField);
    }

    protected void setImageDims(int widthIn, int heightIn) {
        this.imageWidth = widthIn;
        this.imageHeight = heightIn;
    }

    protected void setTitleLabelDims(int posX, int posY) {
        this.titleLabelX = posX;
        this.titleLabelY = posY;
    }

    protected void setInventoryLabelDims(int posX, int posY) {
        this.inventoryLabelX = posX;
        this.inventoryLabelY = posY;
    }

    protected void setScreenCoords(int[] coordsIn) {
        this.screenCoords = coordsIn;
    }

    protected int[] getScreenCoords() {
        return this.screenCoords;
    }

    public EnumUIMode getUIMode() {
        if (this.stack != null) {
            return DimensionalElytraplate.getUIMode(this.stack);
        }
        return EnumUIMode.DARK;
    }

    public EnumUIHelp getUIHelp() {
        if (this.stack != null) {
            return DimensionalElytraplate.getUIHelp(this.stack);
        }
        return EnumUIHelp.HIDDEN;
    }

    private void changeUIMode() {
        PacketDistributor.sendToServer((CustomPacketPayload)new PacketElytraplateUpdateUIMode(this.playerUUID, 2, this.getUIMode().getNextState()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        DimensionalElytraplate.setUIMode(this.stack, this.getUIMode().getNextState());
    }

    private void changeUIHelp() {
        PacketDistributor.sendToServer((CustomPacketPayload)new PacketElytraplateUpdateUIHelp(this.playerUUID, 2, this.getUIHelp().getNextState()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        DimensionalElytraplate.setUIHelp(this.stack, this.getUIHelp().getNextState());
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double directionX, double directionY) {
        if (this.scrollEnabled()) {
            int maxScroll = this.widgetList.size() - this.widgetCount();
            this.currentScroll = (int)((double)this.currentScroll + -directionY);
            if (this.currentScroll >= 0) {
                if (this.currentScroll <= maxScroll) {
                    if (directionY == -1.0) {
                        if (this.topIndex < this.fromList.size()) {
                            ++this.topIndex;
                        }
                    } else if (this.topIndex > 0) {
                        --this.topIndex;
                    }
                    return true;
                }
                this.currentScroll = maxScroll;
                return false;
            }
            this.currentScroll = 0;
            return false;
        }
        return this.textField != null && this.textField.mouseScrolled(mouseX, mouseY, directionX, directionY) ? true : super.mouseScrolled(mouseX, mouseY, directionX, directionY);
    }

    public boolean keyPressed(int keyCode, int mouseX, int mouseY) {
        if (keyCode == 256) {
            this.minecraft.player.closeContainer();
        }
        return this.textField != null && !this.textField.keyPressed(keyCode, mouseX, mouseY) && !this.textField.canConsumeInput() ? super.keyPressed(keyCode, mouseX, mouseY) : true;
    }

    public boolean charTyped(char charIn, int p_98522_) {
        return this.textField != null && !this.textField.charTyped(charIn, p_98522_) && !this.textField.canConsumeInput() ? super.charTyped(charIn, p_98522_) : true;
    }

    public void resize(Minecraft mc, int width, int height) {
        this.clearWidgetList();
        super.resize(mc, width, height);
    }

    protected void setListDims(int x, int y, int width, int height, int widgetHeightIn, int widgetSpacingIn) {
        this.listIndex = new int[]{x, y, width, height, widgetHeightIn, widgetSpacingIn};
    }

    protected void setScrollElementDims(int x, int y) {
        this.scrollEnabled = true;
        this.scrollElementIndex = new int[]{x, y};
    }

    protected void setWidgetTexture(ResourceLocation textureIn) {
        this.WIDGET_TEXTURE = textureIn;
    }

    protected void updateFromList(ArrayList<String> fromListIn) {
        this.fromList = fromListIn;
    }

    public CosmosListWidget addListWidget(CosmosListWidget widget) {
        this.widgetList.add(widget);
        return widget;
    }

    protected CosmosListWidget getListWidget(int index) {
        return this.widgetList.get(index);
    }

    protected ArrayList<CosmosListWidget> getWidgetList() {
        return this.widgetList;
    }

    protected void removeElement() {
        if (this.topIndex > 0) {
            --this.topIndex;
        }
        this.selectedIndex = -1;
    }

    protected void selectWidget(int index) {
        for (int i = 0; i < this.widgetList.size(); ++i) {
            this.widgetList.get(i).deselect();
        }
        this.widgetList.get(index).setSelectedState(true);
    }

    protected void deselectWidget(int index) {
        this.widgetList.get(index).setSelectedState(false);
    }

    public int getSelectedWidgetIndex() {
        if (this.selectedIndex > 0) {
            return this.selectedIndex;
        }
        return 0;
    }

    public int widgetCount() {
        return (int)Math.floor(this.listIndex[3] / (this.listIndex[4] + this.listIndex[5]));
    }

    public boolean scrollEnabled() {
        return this.widgetList.size() > this.widgetCount();
    }

    protected void clearWidgetList() {
        this.widgetList.clear();
    }

    private void renderWidgetList(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < this.widgetList.size(); ++i) {
            CosmosListWidget widget = this.getListWidget(i);
            if (i < this.topIndex || i > this.topIndex + this.widgetCount() || i >= this.widgetList.size()) continue;
            widget.renderWidget(graphics, this.font, this.getScreenCoords(), this.listIndex[0], this.listIndex[1] + (this.listIndex[4] + this.listIndex[5]) * (i - this.topIndex), mouseX, mouseY, i, this.listIndex[1] + this.listIndex[3]);
        }
    }

    protected void updateFromStringList() {
        this.clearWidgetList();
        int spacing_y = this.listIndex[4] + this.listIndex[5];
        for (int i = 0; i < this.fromList.size(); ++i) {
            CosmosListWidget widget = new CosmosListWidget(this.listIndex[0], this.listIndex[1] + spacing_y * i, this.listIndex[2], this.listIndex[4], this.WIDGET_TEXTURE, this.fromList.get(i), ComponentColour.WHITE);
            this.widgetList.add(widget);
            if (i != this.selectedIndex) continue;
            this.getListWidget(i).setSelectedState(true);
        }
    }

    protected void renderScrollElement(GuiGraphics graphics) {
        int[] scrollType = new int[]{15, 0, 15};
        if (this.widgetList.size() > 0) {
            int div = this.widgetList.size() == this.widgetCount() ? 1 : this.widgetList.size() - this.widgetCount();
            int increment = this.listIndex[3] / div;
            int posX = this.scrollElementIndex[0];
            int posY = this.scrollElementIndex[1];
            int posYUpdated = Mth.clamp((int)(posY + this.currentScroll * increment), (int)posY, (int)(this.listIndex[1] + this.listIndex[3] - 1 - this.listIndex[4]));
            int type = this.getUIMode().equals((Object)EnumUIMode.DARK) ? 0 : 1;
            CosmosUISystem.Render.renderStaticElementToggled((GuiGraphics)graphics, (int[])this.getScreenCoords(), (int)posX, (int)(this.scrollEnabled ? posYUpdated : posY), (int)scrollType[0], (int)scrollType[type + 1], (int)13, (int)15, (boolean)true, (ResourceLocation)CosmosReference.RESOURCE.BASE.GUI_ELEMENT_MISC_LOC);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        for (int i = 0; i < this.widgetList.size(); ++i) {
            CosmosListWidget widget = this.getListWidget(i);
            if (widget.isMouseOver() && i != 0) {
                widget.mousePressed(this.minecraft, mouseX, mouseY);
                this.selectWidget(i);
                this.selectedIndex = i;
                continue;
            }
            if (!(mouseX < (double)this.listIndex[0] || mouseX > (double)(this.listIndex[0] + this.listIndex[2]) || mouseY < (double)this.listIndex[1]) && !(mouseY > (double)(this.listIndex[1] + this.listIndex[3]))) continue;
        }
        if (!this.textField.mouseClicked(mouseX, mouseY, mouseButton)) {
            this.textField.setFocused(false);
        } else {
            this.textField.setFocused(true);
        }
        if (this.buttonLock.isMouseOver(mouseX, mouseY) && this.buttonLock.isActive() && this.buttonLock.isVisible()) {
            if (mouseButton == 1) {
                this.buttonLock.onClick(false);
            } else if (mouseButton == 0) {
                this.buttonLock.onClick(true);
            }
        }
        if (this.buttonAllowedPlayers.isMouseOver(mouseX, mouseY) && this.buttonAllowedPlayers.isActive() && this.buttonAllowedPlayers.isVisible()) {
            if (mouseButton == 1) {
                this.buttonAllowedPlayers.onClick(false);
            } else if (mouseButton == 0) {
                this.buttonAllowedPlayers.onClick(true);
            }
        }
        if (this.buttonHostileSpawn.isMouseOver(mouseX, mouseY) && this.buttonHostileSpawn.isActive() && this.buttonHostileSpawn.isVisible()) {
            if (mouseButton == 1) {
                this.buttonHostileSpawn.onClick(false);
            } else if (mouseButton == 0) {
                this.buttonHostileSpawn.onClick(true);
            }
        }
        if (this.buttonTextClear.isMouseOver(mouseX, mouseY) && this.buttonTextClear.isActive() && this.buttonTextClear.isVisible()) {
            if (mouseButton == 1) {
                this.buttonTextClear.onClick(false);
            } else if (mouseButton == 0) {
                this.buttonTextClear.onClick(true);
            }
        }
        if (this.buttonTextMinus.isMouseOver(mouseX, mouseY) && this.buttonTextMinus.isActive() && this.buttonTextMinus.isVisible()) {
            if (mouseButton == 1) {
                this.buttonTextMinus.onClick(false);
            } else if (mouseButton == 0) {
                this.buttonTextMinus.onClick(true);
            }
        }
        if (this.buttonTextPlus.isMouseOver(mouseX, mouseY) && this.buttonTextPlus.isActive() && this.buttonTextPlus.isVisible()) {
            if (mouseButton == 1) {
                this.buttonTextPlus.onClick(false);
            } else if (mouseButton == 0) {
                this.buttonTextPlus.onClick(true);
            }
        }
        if (this.buttonTankClear.isMouseOver(mouseX, mouseY) && this.buttonTankClear.isActive() && this.buttonTankClear.isVisible()) {
            if (mouseButton == 1) {
                this.buttonTankClear.onClick(false);
            } else if (mouseButton == 0) {
                this.buttonTankClear.onClick(true);
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void addUIHelpButton(int[] screen_coords, int[] indexIn, Button.OnPress pressAction) {
        this.uiHelpButton = (CosmosButtonUIHelp)this.addRenderableWidget((GuiEventListener)new CosmosButtonUIHelp(this.getUIHelp(), screen_coords[0] + indexIn[0], screen_coords[1] + indexIn[1], true, true, (Component)ComponentHelper.empty(), pressAction));
    }

    protected void clearUIHelpElementList() {
        this.uiHelpElements.clear();
    }

    protected void setHasUIElementDeadzone() {
        this.hasUIHelpElementDeadzone = true;
    }

    protected void addRenderableUIHelpElement(int[] screenCoords, int xIn, int yIn, int widthIn, int heightIn, Component ... descIn) {
        this.addRenderableUIHelpElement(screenCoords, xIn, yIn, widthIn, heightIn, true, descIn);
    }

    protected void addRenderableUIHelpElement(int[] screenCoords, int xIn, int yIn, int widthIn, int heightIn, boolean isVisible, Component ... descIn) {
        this.addUIHelpElement(new CosmosUIHelpElement(screenCoords[0] + xIn, screenCoords[1] + yIn, widthIn, heightIn, descIn).setVisible(isVisible));
    }

    private CosmosUIHelpElement addUIHelpElement(CosmosUIHelpElement elementIn) {
        this.uiHelpElements.add(elementIn);
        return elementIn;
    }

    protected void setUIHelpElementDeadzone(int minX, int minY, int maxX, int maxY) {
        this.setHasUIElementDeadzone();
        this.uiHelpElementDeadzone = new int[]{minX, minY, maxX, maxY};
    }

    protected boolean getHasUIHelp() {
        return this.hasUIHelp;
    }

    protected boolean getHasUIHelpShow() {
        return this.getHasUIHelp() && this.getUIHelp().equals((Object)EnumUIHelp.SHOWN);
    }

    protected void setHasUIHelp() {
        this.hasUIHelp = true;
    }

    protected void setUIHelpButtonIndex(int posX, int posY) {
        this.setHasUIHelp();
        this.uiHelpButtonIndex = new int[]{posX, posY};
    }

    protected void setUIHelpTitleOffset(int yOffset) {
        this.uiHelpTitleYOffset = yOffset;
    }

    protected void renderHelpElementHoverEffect(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.getHasUIHelpShow() && this.getUIHelp().equals((Object)EnumUIHelp.SHOWN)) {
            for (CosmosUIHelpElement element : this.uiHelpElements) {
                if (!element.isMouseOver((double)mouseX, (double)mouseY)) continue;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                graphics.renderComponentTooltip(this.font, element.getHoverElement(), mouseX, mouseY);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            MutableComponent title = ComponentHelper.style((ComponentColour)ComponentColour.GREEN, (String)"cosmoslibrary.gui_help_title");
            graphics.renderComponentTooltip(this.font, Arrays.asList(title), this.getScreenCoords()[0] * 2 / 2 + this.imageWidth / 2 - this.font.width((FormattedText)title) / 2 - 13, this.getScreenCoords()[1] - 2 + this.uiHelpTitleYOffset);
        }
    }
}

