/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.client.screen.button;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TomeChangeButton
extends Button {
    private final boolean isForward;
    private final boolean playTurnSound;
    private ResourceLocation texture;

    public TomeChangeButton(int posX, int posY, boolean isForwardIn, boolean playTurnSoundIn, ResourceLocation textureIn, Button.OnPress onPressIn, Button.CreateNarration createNarr) {
        super(posX, posY, 25, 13, (Component)ComponentHelper.empty(), onPressIn, createNarr);
        this.isForward = isForwardIn;
        this.playTurnSound = playTurnSoundIn;
        this.texture = textureIn;
        this.visible = true;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            int i = 0;
            int j = 230;
            if (this.isMouseOver(mouseX, mouseY)) {
                i += 25;
            }
            if (!this.isForward) {
                j += 13;
            }
            graphics.blit(this.texture, this.getX(), this.getY(), i, j, 25, 13);
        }
    }

    public void playDownSound(SoundManager handler) {
        if (this.playTurnSound) {
            handler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)5.0f));
        }
    }
}

