/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.core.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.dimensionalpocketsii.pocket.core.shift.EnumShiftDirection;
import com.tcn.dimensionalpocketsii.pocket.core.shift.Shifter;
import com.tcn.dimensionalpocketsii.pocket.core.shift.ShifterCore;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class DimShiftCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcherIn) {
        dispatcherIn.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"dim").then(Commands.literal((String)"shift").requires(commandSource -> commandSource.hasPermission(2)))).then(Commands.literal((String)"shift").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(((RequiredArgumentBuilder)Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(commandContext -> DimShiftCommand.shiftToDimension((CommandSourceStack)commandContext.getSource(), EntityArgument.getPlayer((CommandContext)commandContext, (String)"target"), DimensionArgument.getDimension((CommandContext)commandContext, (String)"dimension"), null))).then(Commands.argument((String)"targetPos", (ArgumentType)Vec3Argument.vec3()).executes(commandContext -> DimShiftCommand.shiftToDimension((CommandSourceStack)commandContext.getSource(), EntityArgument.getPlayer((CommandContext)commandContext, (String)"target"), DimensionArgument.getDimension((CommandContext)commandContext, (String)"dimension"), Vec3Argument.getVec3((CommandContext)commandContext, (String)"targetPos"))))))));
    }

    private static int shiftToDimension(CommandSourceStack commandSourceIn, ServerPlayer serverPlayer, ServerLevel serverWorldIn, @Nullable Vec3 locationIn) {
        if (locationIn != null) {
            BlockPos pos = new BlockPos((int)locationIn.x, (int)locationIn.y, (int)locationIn.z);
            ResourceKey dimension = serverWorldIn.dimension();
            Shifter shifterIn = Shifter.createTeleporter((ResourceKey<Level>)dimension, EnumShiftDirection.GENERIC, pos, serverPlayer.getRotationVector().y, serverPlayer.getRotationVector().x, true, false, false);
            ShifterCore.shiftPlayerToDimension((Player)serverPlayer, shifterIn, false);
            commandSourceIn.sendSuccess(() -> ComponentHelper.style((ComponentColour)ComponentColour.CYAN, (String)"dimensionalpocketsii.direction.generic.pre").append((Component)ComponentHelper.style((ComponentColour)ComponentColour.ORANGE, (String)("@" + serverPlayer.getDisplayName().getString()))).append((Component)ComponentHelper.comp((String)"dimensionalpocketsii.direction.generic.mid")).append((Component)ComponentHelper.style((ComponentColour)ComponentColour.GREEN, (String)dimension.location().toString())), true);
        } else {
            ResourceKey dimension = serverWorldIn.dimension();
            Shifter shifterIn = Shifter.createTeleporter((ResourceKey<Level>)dimension, EnumShiftDirection.GENERIC, serverWorldIn.getSharedSpawnPos(), serverPlayer.getRotationVector().y, serverPlayer.getRotationVector().x, true, false, false);
            ShifterCore.shiftPlayerToDimension((Player)serverPlayer, shifterIn, false);
            commandSourceIn.sendSuccess(() -> ComponentHelper.style((ComponentColour)ComponentColour.CYAN, (String)"dimensionalpocketsii.direction.generic.pre").append((Component)ComponentHelper.style((ComponentColour)ComponentColour.ORANGE, (String)("@" + serverPlayer.getDisplayName().getString()))).append((Component)ComponentHelper.comp((String)"dimensionalpocketsii.direction.generic.mid")).append((Component)ComponentHelper.style((ComponentColour)ComponentColour.GREEN, (String)dimension.location().toString())), true);
        }
        return 1;
    }
}

