/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.core.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.cosmoslibrary.common.lib.CosmosChunkPos;
import com.tcn.dimensionalpocketsii.pocket.core.Pocket;
import com.tcn.dimensionalpocketsii.pocket.core.registry.StorageManager;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Vec2Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;

public class PocketRecoverModeratorCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcherIn) {
        dispatcherIn.register((LiteralArgumentBuilder)Commands.literal((String)"dim").then(Commands.literal((String)"pocket").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"recover").then((ArgumentBuilder)Commands.literal((String)"moderator"))).requires(commandSource -> commandSource.hasPermission(2))).then(Commands.literal((String)"moderator").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"chunkPos", (ArgumentType)Vec2Argument.vec2()).executes(commandContext -> PocketRecoverModeratorCommand.recoverPocket((CommandSourceStack)commandContext.getSource(), EntityArgument.getPlayer((CommandContext)commandContext, (String)"player"), ((CommandSourceStack)commandContext.getSource()).getLevel(), Vec2Argument.getVec2((CommandContext)commandContext, (String)"chunkPos")))))))));
    }

    private static int recoverPocket(CommandSourceStack commandSourceIn, ServerPlayer serverPlayer, ServerLevel serverWorldIn, Vec2 locationIn) {
        CosmosChunkPos chunkPos = new CosmosChunkPos((double)locationIn.x, (double)locationIn.y);
        String playerDisplayName = serverPlayer.getDisplayName().getString();
        UUID playerUUID = serverPlayer.getUUID();
        Pocket pocketIn = StorageManager.getPocketFromChunkPosition(null, chunkPos);
        if (serverPlayer.isCreative()) {
            if (pocketIn.exists()) {
                ItemStack pocketStack = pocketIn.generateItemStackWithNBT();
                if (serverPlayer.getInventory().add(pocketStack)) {
                    commandSourceIn.sendSuccess(() -> ComponentHelper.style2((ComponentColour)ComponentColour.GREEN, (String)"dimensionalpocketsii.command.recoverpocket.success.single", (String)(": [ " + chunkPos.getX() + ", " + chunkPos.getZ() + " ]")), true);
                    System.out.println("Player: [ " + playerDisplayName + ", " + String.valueOf(playerUUID) + " ] Just activated the Recover Pocket Command. For Pocket: " + String.valueOf(chunkPos));
                } else {
                    commandSourceIn.sendFailure((Component)ComponentHelper.comp((String)"dimensionalpocketsii.command.recoverpocket.error.no_space"));
                }
            } else {
                commandSourceIn.sendFailure((Component)ComponentHelper.comp((String)"dimensionalpocketsii.command.recoverpocket.error.exists"));
            }
        } else {
            commandSourceIn.sendFailure((Component)ComponentHelper.comp((String)"dimensionalpocketsii.command.recoverpocket.error.creative"));
        }
        return 1;
    }
}

