/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.core.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.cosmoslibrary.common.lib.CosmosChunkPos;
import com.tcn.dimensionalpocketsii.pocket.core.Pocket;
import com.tcn.dimensionalpocketsii.pocket.core.registry.StorageManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Vec2Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;

public class PocketTransferCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcherIn) {
        dispatcherIn.register((LiteralArgumentBuilder)Commands.literal((String)"dim").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"pocket").then((ArgumentBuilder)Commands.literal((String)"transfer"))).requires(commandSource -> commandSource.hasPermission(2))).then(Commands.literal((String)"transfer").then(Commands.argument((String)"chunkPos", (ArgumentType)Vec2Argument.vec2()).then(Commands.argument((String)"newPlayer", (ArgumentType)EntityArgument.player()).executes(commandContext -> PocketTransferCommand.transferPocket((CommandSourceStack)commandContext.getSource(), Vec2Argument.getVec2((CommandContext)commandContext, (String)"chunkPos"), ((CommandSourceStack)commandContext.getSource()).getEntity(), EntityArgument.getPlayer((CommandContext)commandContext, (String)"newPlayer"))))))));
    }

    private static int transferPocket(CommandSourceStack commandSourceIn, Vec2 vector, Entity senderEntity, ServerPlayer newPlayer) {
        if (senderEntity instanceof ServerPlayer) {
            ServerPlayer oldPlayer = (ServerPlayer)senderEntity;
            if (!oldPlayer.equals((Object)newPlayer)) {
                CosmosChunkPos chunkPos = new CosmosChunkPos((double)vector.x, (double)vector.y);
                Pocket pocket = StorageManager.getPocketFromChunkPosition(null, chunkPos);
                if (pocket.exists()) {
                    if (pocket.checkIfOwner((Player)oldPlayer)) {
                        pocket.updateOwner(oldPlayer, newPlayer);
                    } else {
                        commandSourceIn.sendFailure((Component)ComponentHelper.comp((String)"dimensionalpocketsii.command.transfer.error.not_owner"));
                    }
                } else {
                    commandSourceIn.sendFailure((Component)ComponentHelper.comp((String)"dimensionalpocketsii.command.recoverpocket.error.exists"));
                }
            } else {
                commandSourceIn.sendFailure((Component)ComponentHelper.comp((String)"dimensionalpocketsii.command.transfer.error.owner_same"));
            }
        }
        return 1;
    }
}

