/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.core.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.cosmoslibrary.common.lib.CosmosChunkPos;
import com.tcn.dimensionalpocketsii.pocket.core.Pocket;
import com.tcn.dimensionalpocketsii.pocket.core.registry.StorageManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Vec2Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec2;

public class PocketTransferModeratorCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcherIn) {
        dispatcherIn.register((LiteralArgumentBuilder)Commands.literal((String)"dim").then(Commands.literal((String)"pocket").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"transfer").then((ArgumentBuilder)Commands.literal((String)"moderator"))).requires(commandSource -> commandSource.hasPermission(3))).then(Commands.literal((String)"transfer").then(Commands.argument((String)"chunkPos", (ArgumentType)Vec2Argument.vec2()).then(Commands.argument((String)"newPlayer", (ArgumentType)EntityArgument.player()).executes(commandContext -> PocketTransferModeratorCommand.transferPocket((CommandSourceStack)commandContext.getSource(), Vec2Argument.getVec2((CommandContext)commandContext, (String)"chunkPos"), EntityArgument.getPlayer((CommandContext)commandContext, (String)"newPlayer")))))))));
    }

    private static int transferPocket(CommandSourceStack commandSourceIn, Vec2 vector, ServerPlayer newPlayer) {
        CosmosChunkPos chunkPos = new CosmosChunkPos((double)vector.x, (double)vector.y);
        Pocket pocket = StorageManager.getPocketFromChunkPosition(null, chunkPos);
        if (pocket.exists()) {
            pocket.updateOwner(null, newPlayer);
        } else {
            commandSourceIn.sendFailure((Component)ComponentHelper.comp((String)"dimensionalpocketsii.command.recoverpocket.error.exists"));
        }
        return 1;
    }
}

