/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.core.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.cosmoslibrary.common.lib.CosmosChunkPos;
import com.tcn.dimensionalpocketsii.core.management.PocketsDimensionManager;
import com.tcn.dimensionalpocketsii.pocket.core.Pocket;
import com.tcn.dimensionalpocketsii.pocket.core.registry.StorageManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class SetSpawnCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcherIn) {
        dispatcherIn.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"dim").requires(commandSource -> commandSource.hasPermission(0))).then(Commands.literal((String)"setspawn").executes(commandContext -> SetSpawnCommand.setSpawn((CommandSourceStack)commandContext.getSource()))));
    }

    private static int setSpawn(CommandSourceStack commandSourceIn) {
        Entity entity = commandSourceIn.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (serverPlayer.level().dimension().equals(PocketsDimensionManager.POCKET_WORLD)) {
                BlockPos spawnPos = BlockPos.ZERO;
                BlockPos playerPos = serverPlayer.blockPosition();
                CosmosChunkPos chunkPos = CosmosChunkPos.scaleToChunkPos((BlockPos)playerPos);
                Pocket pocket = StorageManager.getPocketFromChunkPosition(null, chunkPos);
                CosmosChunkPos domChunkPos = pocket.getDominantChunkPos();
                if (pocket.getChunkInfo().isSingleChunk()) {
                    spawnPos = new BlockPos(playerPos.getX() & 0xF, playerPos.getY(), playerPos.getZ() & 0xF);
                } else if (chunkPos.equals((Object)domChunkPos)) {
                    spawnPos = new BlockPos(playerPos.getX() & 0xF, playerPos.getY(), playerPos.getZ() & 0xF);
                } else {
                    int chunkX = chunkPos.getX() - domChunkPos.getX();
                    int chunkZ = chunkPos.getZ() - domChunkPos.getZ();
                    int chunkOffsetX = chunkX * 16;
                    int chunkOffsetZ = chunkZ * 16;
                    int posXlocated = (playerPos.getX() & 0xF) + chunkOffsetX;
                    int posZlocated = (playerPos.getZ() & 0xF) + chunkOffsetZ;
                    spawnPos = new BlockPos(posXlocated, playerPos.getY(), posZlocated);
                }
                if (pocket.exists()) {
                    if (pocket.checkIfOwner((Player)serverPlayer)) {
                        pocket.setSpawnInPocket(spawnPos, serverPlayer.getRotationVector().y, serverPlayer.getRotationVector().x);
                        BlockPos finalPozzy = new BlockPos((Vec3i)spawnPos);
                        commandSourceIn.sendSuccess(() -> ComponentHelper.style3((ComponentColour)ComponentColour.GREEN, (String)"", (String)"dimensionalpocketsii.command.setspawn.success.pre", (String)(finalPozzy.getX() + ", " + finalPozzy.getY() + ", " + finalPozzy.getZ()), (String)"dimensionalpocketsii.command.setspawn.success.suff"), true);
                    } else {
                        commandSourceIn.sendFailure((Component)ComponentHelper.comp((String)"dimensionalpocketsii.pocket.status.action.not_owner"));
                    }
                } else {
                    commandSourceIn.sendFailure((Component)ComponentHelper.comp((String)"dimensionalpocketsii.pocket.status.action.null"));
                }
            } else {
                commandSourceIn.sendFailure((Component)ComponentHelper.comp((String)"dimensionalpocketsii.command.setspawn.error.dimension"));
            }
        }
        return 1;
    }
}

