/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.core.item;

import com.google.common.base.Suppliers;
import com.tcn.dimensionalpocketsii.core.management.PocketsRegistrationManager;
import java.util.function.Supplier;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public enum CoreItemTier implements Tier
{
    DIMENSIONAL((TagKey<Block>)BlockTags.INCORRECT_FOR_NETHERITE_TOOL, 4000, 12.0f, 6.0f, 25, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)PocketsRegistrationManager.DIMENSIONAL_INGOT.get()})),
    DIMENSIONAL_ENHANCED((TagKey<Block>)BlockTags.INCORRECT_FOR_NETHERITE_TOOL, 6000, 16.0f, 8.0f, 35, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)PocketsRegistrationManager.DIMENSIONAL_INGOT.get()}));

    private final TagKey<Block> incorrectBlocksForDrops;
    private final int uses;
    private final float speed;
    private final float damage;
    private final int enchantmentValue;
    private final Supplier<Ingredient> repairIngredient;

    private CoreItemTier(TagKey<Block> incorrectBlockForDrops, int usesIn, float speedIn, float damageBonusIn, int enchantmentValueIn, Supplier<Ingredient> repairIngredientIn) {
        this.incorrectBlocksForDrops = incorrectBlockForDrops;
        this.uses = usesIn;
        this.speed = speedIn;
        this.damage = damageBonusIn;
        this.enchantmentValue = enchantmentValueIn;
        this.repairIngredient = Suppliers.memoize(repairIngredientIn::get);
    }

    public TagKey<Block> getIncorrectBlocksForDrops() {
        return this.incorrectBlocksForDrops;
    }

    public int getUses() {
        return this.uses;
    }

    public float getSpeed() {
        return this.speed;
    }

    public float getAttackDamageBonus() {
        return this.damage;
    }

    public int getEnchantmentValue() {
        return this.enchantmentValue;
    }

    public Ingredient getRepairIngredient() {
        return this.repairIngredient.get();
    }
}

