/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.core.item;

import com.tcn.cosmoslibrary.common.enums.EnumUIMode;
import com.tcn.cosmoslibrary.common.item.CosmosItem;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.cosmoslibrary.common.util.CosmosUtil;
import com.tcn.dimensionalpocketsii.client.screen.ScreenItemTome;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class DimensionalTome
extends CosmosItem {
    public DimensionalTome(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (worldIn.isClientSide()) {
            this.openScreen(playerIn);
        }
        playerIn.swing(handIn);
        return InteractionResultHolder.pass((Object)playerIn.getItemInHand(handIn));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openScreen(Player playerIn) {
        Minecraft.getInstance().setScreen((Screen)new ScreenItemTome(true, playerIn.getUUID(), CosmosUtil.getStack((Player)playerIn)));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        if (!ComponentHelper.isShiftKeyDown((Minecraft)Minecraft.getInstance())) {
            tooltip.add((Component)ComponentHelper.getTooltipInfo((String)"dimensionalpocketsii.info.tome_info"));
            tooltip.add((Component)ComponentHelper.shiftForMoreDetails());
        } else {
            tooltip.add((Component)ComponentHelper.getTooltipOne((String)"dimensionalpocketsii.info.tome_shift_one"));
            tooltip.add((Component)ComponentHelper.getTooltipTwo((String)"dimensionalpocketsii.info.tome_shift_two"));
            tooltip.add((Component)ComponentHelper.shiftForLessDetails());
        }
    }

    public static void setPage(ItemStack stackIn, int page) {
        if (stackIn.has(DataComponents.CUSTOM_DATA)) {
            CompoundTag compound = ((CustomData)stackIn.get(DataComponents.CUSTOM_DATA)).copyTag();
            compound.putInt("page", page);
            stackIn.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)compound));
        } else {
            CompoundTag compound = new CompoundTag();
            compound.putInt("page", page);
            stackIn.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)compound));
        }
    }

    public static int getPage(ItemStack stackIn) {
        if (stackIn.has(DataComponents.CUSTOM_DATA)) {
            CompoundTag compound = ((CustomData)stackIn.get(DataComponents.CUSTOM_DATA)).copyTag();
            return compound.getInt("page");
        }
        return 0;
    }

    public static void setUIMode(ItemStack stackIn, EnumUIMode mode) {
        if (stackIn.has(DataComponents.CUSTOM_DATA)) {
            CompoundTag compound = ((CustomData)stackIn.get(DataComponents.CUSTOM_DATA)).copyTag();
            compound.putInt("mode", mode.getIndex());
            stackIn.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)compound));
        } else {
            CompoundTag compound = new CompoundTag();
            compound.putInt("mode", mode.getIndex());
            stackIn.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)compound));
        }
    }

    public static EnumUIMode getUIMode(ItemStack stackIn) {
        if (stackIn.has(DataComponents.CUSTOM_DATA)) {
            CompoundTag compound = ((CustomData)stackIn.get(DataComponents.CUSTOM_DATA)).copyTag();
            return EnumUIMode.getStateFromIndex((int)compound.getInt("mode"));
        }
        return EnumUIMode.DARK;
    }
}

