/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.core.item.armour;

import com.tcn.cosmoslibrary.common.chat.CosmosChatUtil;
import com.tcn.cosmoslibrary.common.enums.EnumUIHelp;
import com.tcn.cosmoslibrary.common.enums.EnumUIMode;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.cosmoslibrary.common.lib.CosmosChunkPos;
import com.tcn.cosmoslibrary.energy.CosmosEnergyUtil;
import com.tcn.cosmoslibrary.energy.interfaces.ICosmosEnergyItem;
import com.tcn.cosmoslibrary.energy.interfaces.IEnergyStorageBulk;
import com.tcn.cosmoslibrary.energy.item.CosmosEnergyArmourItemElytra;
import com.tcn.cosmoslibrary.energy.item.CosmosEnergyItem;
import com.tcn.cosmoslibrary.energy.item.CosmosEnergyStorageItem;
import com.tcn.dimensionalpocketsii.core.item.armour.EnumElytraSetting;
import com.tcn.dimensionalpocketsii.core.item.armour.module.EnumElytraModule;
import com.tcn.dimensionalpocketsii.core.management.PocketsRegistrationManager;
import com.tcn.dimensionalpocketsii.pocket.core.Pocket;
import com.tcn.dimensionalpocketsii.pocket.core.block.entity.AbstractBlockEntityPocket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class DimensionalElytraplate
extends CosmosEnergyArmourItemElytra {
    public DimensionalElytraplate(Holder<ArmorMaterial> materialIn, ArmorItem.Type typeIn, Item.Properties builderIn, boolean damageableIn, CosmosEnergyItem.Properties energyProperties) {
        super(materialIn, typeIn, builderIn, damageableIn, energyProperties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag tag;
        if (!ComponentHelper.isShiftKeyDown((Minecraft)Minecraft.getInstance())) {
            tooltip.add((Component)ComponentHelper.getTooltipInfo((String)"dimensionalpocketsii.item.info.elytraplate"));
            tooltip.add((Component)ComponentHelper.shiftForMoreDetails());
        } else {
            tooltip.add((Component)ComponentHelper.getTooltipOne((String)"dimensionalpocketsii.item.info.elytraplate_one"));
            tooltip.add((Component)ComponentHelper.getTooltipTwo((String)"dimensionalpocketsii.item.info.elytraplate_two"));
            tooltip.add((Component)ComponentHelper.getTooltipThree((String)"dimensionalpocketsii.item.info.elytraplate_three").append((Component)ComponentHelper.style((ComponentColour)ComponentColour.YELLOW, (String)PocketsRegistrationManager.SUIT_SETTINGS.getKey().getName())).append((Component)ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_BLUE, (String)"dimensionalpocketsii.item.info.elytraplate_key")));
            tooltip.add((Component)ComponentHelper.getTooltipFour((String)"dimensionalpocketsii.item.info.elytraplate_usage"));
            tooltip.add((Component)ComponentHelper.getTooltipLimit((String)"dimensionalpocketsii.item.info.elytraplate_limitation"));
            tooltip.add((Component)ComponentHelper.getTooltipLimit((String)"dimensionalpocketsii.item.info.elytraplate_limitation_combat"));
            tooltip.add((Component)ComponentHelper.shiftForLessDetails());
        }
        if (stack.has(DataComponents.CUSTOM_DATA) && ((tag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag()).contains("nbt_data") || tag.contains("moduleList"))) {
            CompoundTag nbt_data = tag.getCompound("nbt_data");
            if (!ComponentHelper.isControlKeyDown((Minecraft)Minecraft.getInstance())) {
                tooltip.add((Component)ComponentHelper.ctrlForMoreDetails());
            } else {
                if (nbt_data.contains("chunk_pos")) {
                    CompoundTag pos_tag = nbt_data.getCompound("chunk_pos");
                    tooltip.add((Component)ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.info.shifter.pocket").append((Component)ComponentHelper.comp((String)("\u00a77[ \u00a7b" + pos_tag.getInt("x") + "\u00a77, \u00a7b" + pos_tag.getInt("z") + "\u00a77 ]"))));
                }
                if (nbt_data.contains("player_pos")) {
                    CompoundTag player_pos = nbt_data.getCompound("player_pos");
                    tooltip.add((Component)ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.info.shifter_player_pos").append((Component)ComponentHelper.comp((String)("\u00a77[ \u00a73" + player_pos.getInt("x") + "\u00a77, \u00a73" + player_pos.getInt("y") + "\u00a77, \u00a73" + player_pos.getInt("z") + "\u00a77 ]"))));
                }
                if (nbt_data.contains("dimension")) {
                    CompoundTag dimension = nbt_data.getCompound("dimension");
                    tooltip.add((Component)ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.info.shifter_source_dimension").append((Component)ComponentHelper.comp((String)("\u00a77[ \u00a7a" + dimension.getString("namespace") + "\u00a77: \u00a7a" + dimension.getString("path") + "\u00a77 ]"))));
                }
                tooltip.add((Component)ComponentHelper.ctrlForLessDetails());
            }
            if (!ComponentHelper.isAltKeyDown((Minecraft)Minecraft.getInstance())) {
                tooltip.add((Component)ComponentHelper.altForMoreDetails((ComponentColour)ComponentColour.POCKET_PURPLE_LIGHT));
            } else {
                if (tag.contains("settings_data")) {
                    tooltip.add((Component)ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.item.info.elytraplate_settings"));
                    for (int i = 0; i < 6; ++i) {
                        EnumElytraSetting setting = EnumElytraSetting.getStateFromIndex(i);
                        tooltip.add((Component)ComponentHelper.comp((String)"  ").append((Component)setting.getColouredDisplayComp().append((Component)ComponentHelper.comp((String)"\u00a77[ ").append((Component)setting.getValueComp(DimensionalElytraplate.getElytraSetting(stack, setting))).append((Component)ComponentHelper.comp((String)"\u00a77 ]")))));
                    }
                }
                if (!DimensionalElytraplate.getInstalledModules(stack).isEmpty()) {
                    ArrayList<EnumElytraModule> list = DimensionalElytraplate.getInstalledModules(stack);
                    tooltip.add((Component)ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.item.info.elytraplate_modules"));
                    for (int i = 0; i < list.size(); ++i) {
                        tooltip.add((Component)ComponentHelper.comp((String)"  ").append((Component)list.get(i).getColouredComp()));
                    }
                }
                tooltip.add((Component)ComponentHelper.altForLessDetails((ComponentColour)ComponentColour.POCKET_PURPLE_LIGHT));
            }
        }
        super.appendHoverText(stack, context, tooltip, flagIn);
    }

    public void onCraftedBy(ItemStack stackIn, Level levelIn, Player playerIn) {
        if (!DimensionalElytraplate.getElytraSetting(stackIn, EnumElytraSetting.ELYTRA_FLY).booleanValue()) {
            DimensionalElytraplate.addOrUpdateElytraSetting(stackIn, EnumElytraSetting.ELYTRA_FLY, true);
        }
    }

    public void inventoryTick(ItemStack stackIn, Level levelIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!levelIn.isClientSide() && entityIn instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entityIn;
            if (itemSlot == 38) {
                float energy;
                if (this.hasEnergy(stackIn) && DimensionalElytraplate.hasModuleInstalled(stackIn, EnumElytraModule.BATTERY) && DimensionalElytraplate.getElytraSetting(stackIn, EnumElytraSetting.CHARGER).booleanValue()) {
                    Inventory inv = serverPlayer.getInventory();
                    for (int i = 0; i < inv.getContainerSize(); ++i) {
                        IEnergyStorage energyItem;
                        Object object;
                        ItemStack testStack = inv.getItem(i);
                        Item testItem = testStack.getItem();
                        if (testItem instanceof CosmosEnergyStorageItem || testItem instanceof DimensionalElytraplate || (object = testStack.getCapability(Capabilities.EnergyStorage.ITEM)) instanceof IEnergyStorageBulk || !(object instanceof IEnergyStorage) || !(energyItem = (IEnergyStorage)object).canReceive()) continue;
                        this.extractEnergy(stackIn, energyItem.receiveEnergy(this.getMaxExtract(stackIn), false), false);
                    }
                }
                if (this.getEnergy(stackIn) < this.getMaxEnergyStored(stackIn) && DimensionalElytraplate.hasModuleInstalled(stackIn, EnumElytraModule.SOLAR) && DimensionalElytraplate.getElytraSetting(stackIn, EnumElytraSetting.SOLAR).booleanValue() && levelIn.canSeeSky(new BlockPos((Vec3i)serverPlayer.blockPosition())) && levelIn.isDay() && this.receiveEnergy(stackIn, (int)(energy = (Mth.clamp((float)Mth.sin((float)((float)levelIn.dayTime() / 1000.0f * 0.525f + 4.6f)), (float)0.0f, (float)1.0f) + 1.1f) * 200.0f), true) > 0) {
                    this.receiveEnergy(stackIn, (int)energy, false);
                }
            }
        }
    }

    public int getMaxEnergyStored(ItemStack stackIn) {
        int n;
        Item item = stackIn.getItem();
        if (!(item instanceof DimensionalElytraplate)) {
            n = 0;
        } else {
            DimensionalElytraplate elytraItem = (DimensionalElytraplate)item;
            n = DimensionalElytraplate.hasModuleInstalled(stackIn, EnumElytraModule.BATTERY) ? elytraItem.maxEnergyStored * 6 : elytraItem.maxEnergyStored;
        }
        return n;
    }

    public IEnergyStorageBulk getEnergyCapability(ItemStack stackIn) {
        return CosmosEnergyUtil.getDefaultBulk((ItemStack)stackIn, (ICosmosEnergyItem)this);
    }

    public boolean isFlyEnabled(ItemStack stackIn) {
        return !this.hasEnergy(stackIn) ? false : DimensionalElytraplate.getElytraSetting(stackIn, EnumElytraSetting.ELYTRA_FLY);
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return this.isFlyEnabled(stack);
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return true;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.getLevel();
        BlockEntity entity = level.getBlockEntity(context.getClickedPos());
        if (entity != null) {
            if (entity instanceof AbstractBlockEntityPocket) {
                AbstractBlockEntityPocket blockEntity = (AbstractBlockEntityPocket)entity;
                Pocket pocket = blockEntity.getPocket();
                if (this.addOrUpdateShifterInformation(stack, pocket, level, context.getPlayer())) {
                    return InteractionResult.sidedSuccess((boolean)level.isClientSide());
                }
            } else {
                return InteractionResult.PASS;
            }
        }
        return InteractionResult.FAIL;
    }

    public static boolean addModule(ItemStack stackIn, EnumElytraModule moduleIn, boolean simulate) {
        ArrayList<EnumElytraModule> list = DimensionalElytraplate.getInstalledModules(stackIn);
        if (stackIn.getItem() instanceof DimensionalElytraplate && !DimensionalElytraplate.hasModuleInstalled(stackIn, moduleIn)) {
            if (!simulate) {
                list.add(moduleIn);
                DimensionalElytraplate.addOrUpdateElytraSetting(stackIn, moduleIn.getSetting(), true);
                DimensionalElytraplate.saveModuleList(list, stackIn);
            }
            return true;
        }
        return false;
    }

    public static ItemStack removeModule(ItemStack stackIn, EnumElytraModule moduleIn, boolean simulate) {
        if (stackIn.getItem() instanceof DimensionalElytraplate && DimensionalElytraplate.hasModuleInstalled(stackIn, moduleIn)) {
            ArrayList<EnumElytraModule> list = DimensionalElytraplate.getInstalledModules(stackIn);
            if (!simulate) {
                list.remove((Object)moduleIn);
                DimensionalElytraplate.saveModuleList(list, stackIn);
            }
            return new ItemStack((ItemLike)moduleIn.getModuleItem().asActualItem());
        }
        return ItemStack.EMPTY;
    }

    public static boolean hasModuleInstalled(ItemStack stackIn, EnumElytraModule moduleIn) {
        ArrayList<EnumElytraModule> list = DimensionalElytraplate.getInstalledModules(stackIn);
        return stackIn.getItem() instanceof DimensionalElytraplate && !list.isEmpty() && list.contains((Object)moduleIn);
    }

    public static boolean removeAllModules(ItemStack stackIn, boolean simulate) {
        CompoundTag compound;
        if (stackIn.getItem() instanceof DimensionalElytraplate && stackIn.has(DataComponents.CUSTOM_DATA) && (compound = ((CustomData)stackIn.get(DataComponents.CUSTOM_DATA)).copyTag()).contains("moduleList")) {
            if (!simulate) {
                compound.remove("moduleList");
                stackIn.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)compound));
            }
            return true;
        }
        return false;
    }

    public static void saveModuleList(ArrayList<EnumElytraModule> listIn, ItemStack stackIn) {
        CompoundTag stackTag = ((CustomData)stackIn.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        CompoundTag newList = new CompoundTag();
        if (stackIn.getItem() instanceof DimensionalElytraplate) {
            for (int i = 0; i < listIn.size(); ++i) {
                EnumElytraModule module = listIn.get(i);
                newList.putInt(Integer.toString(i), module.getIndex());
            }
        }
        newList.putInt("size", listIn.size());
        stackTag.put("moduleList", (Tag)newList);
        stackIn.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)stackTag));
    }

    public static CompoundTag getModuleList(ItemStack stackIn) {
        CompoundTag compound;
        if (stackIn.getItem() instanceof DimensionalElytraplate && (compound = ((CustomData)stackIn.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag()).contains("moduleList")) {
            return compound.getCompound("moduleList");
        }
        return null;
    }

    public static ArrayList<EnumElytraModule> getInstalledModules(ItemStack stackIn) {
        ArrayList<EnumElytraModule> list = new ArrayList<EnumElytraModule>();
        CompoundTag compound = DimensionalElytraplate.getModuleList(stackIn);
        if (stackIn.getItem() instanceof DimensionalElytraplate && compound != null) {
            for (int i = 0; i < compound.getInt("size"); ++i) {
                list.add(EnumElytraModule.getStateFromIndex(compound.getInt(Integer.toString(i))));
            }
        }
        return list;
    }

    public boolean addOrUpdateShifterInformation(ItemStack stackIn, Pocket pocketIn, Level levelIn, Player playerIn) {
        if (pocketIn != null && pocketIn.checkIfOwner(playerIn)) {
            CosmosChunkPos chunkPos = pocketIn.getDominantChunkPos();
            int x = chunkPos.getX();
            int z = chunkPos.getZ();
            if (playerIn.isShiftKeyDown()) {
                CompoundTag stackTag = ((CustomData)stackIn.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                CompoundTag nbtTag = stackTag.contains("nbt_data") ? stackTag.getCompound("nbt_data") : new CompoundTag();
                CompoundTag chunkTag = new CompoundTag();
                chunkTag.putInt("x", x);
                chunkTag.putInt("z", z);
                nbtTag.put("chunk_pos", (Tag)chunkTag);
                nbtTag.putInt("colour", pocketIn.getDisplayColour());
                CompoundTag posTag = new CompoundTag();
                BlockPos playerPos = playerIn.blockPosition();
                posTag.putInt("x", playerPos.getX());
                posTag.putInt("y", playerPos.getY());
                posTag.putInt("z", playerPos.getZ());
                posTag.putFloat("yaw", playerIn.getRotationVector().y);
                posTag.putFloat("pitch", playerIn.getRotationVector().x);
                nbtTag.put("player_pos", (Tag)posTag);
                DimensionalElytraplate.addOrUpdateElytraSetting(stackIn, EnumElytraSetting.TELEPORT_TO_BLOCK, true);
                CompoundTag dimension = new CompoundTag();
                dimension.putString("namespace", levelIn.dimension().location().getNamespace());
                dimension.putString("path", levelIn.dimension().location().getPath());
                nbtTag.put("dimension", (Tag)dimension);
                stackTag.put("nbt_data", (Tag)nbtTag);
                stackIn.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)stackTag));
                CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.style((ComponentColour)ComponentColour.PURPLE, (String)"dimensionalpocketsii.item.message.elytraplate.linked").append((Component)ComponentHelper.comp((String)("\u00a77 {" + x + ", " + z + "}"))));
                return true;
            }
        }
        return false;
    }

    public static Boolean getElytraSetting(ItemStack stackIn, EnumElytraSetting settingIn) {
        CompoundTag compoundIn = ((CustomData)stackIn.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (compoundIn.contains("settings_data")) {
            CompoundTag settingsData = compoundIn.getCompound("settings_data");
            return settingsData.getBoolean(settingIn.getName());
        }
        return false;
    }

    public static void addOrUpdateElytraSetting(ItemStack stackIn, EnumElytraSetting settingIn, boolean valueIn) {
        CompoundTag compoundIn = ((CustomData)stackIn.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (settingIn != null) {
            CompoundTag settingsData = compoundIn.contains("settings_data") ? compoundIn.getCompound("settings_data") : new CompoundTag();
            settingsData.putBoolean(settingIn.getName(), valueIn);
            compoundIn.put("settings_data", (Tag)settingsData);
            stackIn.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)compoundIn));
        }
    }

    public static EnumUIMode getUIMode(ItemStack stackIn) {
        if (stackIn.has(DataComponents.CUSTOM_DATA)) {
            return EnumUIMode.getStateFromIndex((int)((CustomData)stackIn.get(DataComponents.CUSTOM_DATA)).copyTag().getInt("mode"));
        }
        return EnumUIMode.DARK;
    }

    public static void setUIMode(ItemStack stackIn, EnumUIMode mode) {
        CompoundTag compound = ((CustomData)stackIn.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        compound.putInt("mode", mode.getIndex());
        stackIn.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)compound));
    }

    public static EnumUIHelp getUIHelp(ItemStack stackIn) {
        if (stackIn.has(DataComponents.CUSTOM_DATA)) {
            return EnumUIHelp.getStateFromIndex((int)((CustomData)stackIn.get(DataComponents.CUSTOM_DATA)).copyTag().getInt("help"));
        }
        return EnumUIHelp.HIDDEN;
    }

    public static void setUIHelp(ItemStack stackIn, EnumUIHelp mode) {
        CompoundTag compound = ((CustomData)stackIn.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        compound.putInt("help", mode.getIndex());
        stackIn.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)compound));
    }
}

