/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.core.item.armour;

import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;

public enum EnumElytraSetting {
    TELEPORT_TO_BLOCK(0, "tele_to_block", "dimensionalpocketsii.elytraplate.setting.teleport", "dimensionalpocketsii.item.info.elytraplate.setting.teleport", "dimensionalpocketsii.item.info.elytraplate.setting.teleport.true", "dimensionalpocketsii.item.info.elytraplate.setting.teleport.false", ComponentColour.GREEN),
    ELYTRA_FLY(1, "elytra_fly", "dimensionalpocketsii.elytraplate.setting.elytra_fly", "dimensionalpocketsii.item.info.elytraplate.setting.elytra_fly", "dimensionalpocketsii.item.info.elytraplate.setting.elytra_fly.enabled", "dimensionalpocketsii.item.info.elytraplate.setting.elytra_fly.disabled", ComponentColour.CYAN),
    VISOR(2, "visor", "dimensionalpocketsii.elytraplate.setting.visor", "dimensionalpocketsii.item.info.elytraplate.setting.visor", "dimensionalpocketsii.item.info.elytraplate.setting.visor.enabled", "dimensionalpocketsii.item.info.elytraplate.setting.visor.disabled", ComponentColour.LIGHT_BLUE),
    SOLAR(3, "solar", "dimensionalpocketsii.elytraplate.setting.solar", "dimensionalpocketsii.item.info.elytraplate.setting.solar", "dimensionalpocketsii.item.info.elytraplate.setting.solar.enabled", "dimensionalpocketsii.item.info.elytraplate.setting.solar.disabled", ComponentColour.BLUE),
    CHARGER(4, "charger", "dimensionalpocketsii.elytraplate.setting.charger", "dimensionalpocketsii.item.info.elytraplate.setting.charger", "dimensionalpocketsii.item.info.elytraplate.setting.charger.enabled", "dimensionalpocketsii.item.info.elytraplate.setting.charger.disabled", ComponentColour.RED),
    FIREWORK(5, "firework", "dimensionalpocketsii.elytraplate.setting.firework", "dimensionalpocketsii.item.info.elytraplate.setting.firework", "dimensionalpocketsii.item.info.elytraplate.setting.firework.enabled", "dimensionalpocketsii.item.info.elytraplate.setting.firework.disabled", ComponentColour.YELLOW);

    private int index;
    private String name;
    private final String localizedName;
    private final String displayName;
    private final String trueValue;
    private final String falseValue;
    private final ComponentColour displayColour;
    public static final int LENGTH = 6;
    public static final StreamCodec<ByteBuf, EnumElytraSetting> STREAM_CODEC;

    private EnumElytraSetting(int indexIn, String nameIn, String localizedNameIn, String displayNameIn, String trueValueIn, String falseValueIn, ComponentColour displayColourIn) {
        this.index = indexIn;
        this.name = nameIn;
        this.localizedName = localizedNameIn;
        this.displayName = displayNameIn;
        this.displayColour = displayColourIn;
        this.trueValue = trueValueIn;
        this.falseValue = falseValueIn;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public MutableComponent getColouredComp() {
        return ComponentHelper.style((ComponentColour)this.displayColour, (String)this.localizedName);
    }

    public MutableComponent getColouredDisplayComp() {
        return ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)this.displayName);
    }

    public MutableComponent getValueComp(boolean value) {
        return ComponentHelper.style((ComponentColour)(value ? ComponentColour.GREEN : ComponentColour.RED), (String)"bold", (String)(value ? this.trueValue : this.falseValue));
    }

    public EnumElytraSetting getNextState() {
        switch (this.ordinal()) {
            case 0: {
                return ELYTRA_FLY;
            }
            case 1: {
                return VISOR;
            }
            case 2: {
                return SOLAR;
            }
            case 3: {
                return CHARGER;
            }
            case 4: {
                return FIREWORK;
            }
            case 5: {
                return TELEPORT_TO_BLOCK;
            }
        }
        throw new IllegalStateException("Unable to obtain state of [" + String.valueOf((Object)this) + "]");
    }

    public static EnumElytraSetting getNextState(EnumElytraSetting previous) {
        switch (previous.ordinal()) {
            case 0: {
                return ELYTRA_FLY;
            }
            case 1: {
                return VISOR;
            }
            case 2: {
                return SOLAR;
            }
            case 3: {
                return CHARGER;
            }
            case 4: {
                return FIREWORK;
            }
            case 5: {
                return TELEPORT_TO_BLOCK;
            }
        }
        throw new IllegalStateException("Unable to obtain state of [" + String.valueOf((Object)previous) + "]");
    }

    public static EnumElytraSetting getStateFromIndex(int index) {
        switch (index) {
            case 0: {
                return TELEPORT_TO_BLOCK;
            }
            case 1: {
                return ELYTRA_FLY;
            }
            case 2: {
                return VISOR;
            }
            case 3: {
                return SOLAR;
            }
            case 4: {
                return CHARGER;
            }
            case 5: {
                return FIREWORK;
            }
        }
        throw new IllegalStateException("No state exists with index: [" + index + "]");
    }

    static {
        STREAM_CODEC = new StreamCodec<ByteBuf, EnumElytraSetting>(){

            public EnumElytraSetting decode(ByteBuf bufIn) {
                return EnumElytraSetting.getStateFromIndex(bufIn.readInt());
            }

            public void encode(ByteBuf bufIn, EnumElytraSetting modeIn) {
                bufIn.writeInt(modeIn.getIndex());
            }
        };
    }
}

