/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.core.item.device;

import com.tcn.cosmoslibrary.common.chat.CosmosChatUtil;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.cosmoslibrary.common.lib.CosmosChunkPos;
import com.tcn.cosmoslibrary.common.lib.MathHelper;
import com.tcn.cosmoslibrary.core.teleport.EnumSafeTeleport;
import com.tcn.cosmoslibrary.energy.item.CosmosEnergyItem;
import com.tcn.dimensionalpocketsii.core.management.PocketsDimensionManager;
import com.tcn.dimensionalpocketsii.pocket.core.Pocket;
import com.tcn.dimensionalpocketsii.pocket.core.block.entity.AbstractBlockEntityPocket;
import com.tcn.dimensionalpocketsii.pocket.core.registry.StorageManager;
import com.tcn.dimensionalpocketsii.pocket.core.shift.EnumShiftDirection;
import com.tcn.dimensionalpocketsii.pocket.core.shift.Shifter;
import com.tcn.dimensionalpocketsii.pocket.core.shift.ShifterCore;
import com.tcn.dimensionalpocketsii.pocket.core.util.PocketUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class AbstractDimensionalShifterItem
extends CosmosEnergyItem {
    public AbstractDimensionalShifterItem(Item.Properties properties, CosmosEnergyItem.Properties energyProperties) {
        super(properties, energyProperties);
    }

    public boolean canAttackBlock(BlockState state, Level worldIn, BlockPos pos, Player player) {
        return false;
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.has(DataComponents.CUSTOM_DATA)) {
            CompoundTag stackTag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag();
            if (!ComponentHelper.isControlKeyDown((Minecraft)Minecraft.getInstance())) {
                tooltip.add((Component)ComponentHelper.ctrlForMoreDetails());
            } else {
                if (stackTag.contains("nbt_data")) {
                    CompoundTag nbtData = stackTag.getCompound("nbt_data");
                    if (nbtData.contains("chunk_pos")) {
                        CompoundTag chunkPos = nbtData.getCompound("chunk_pos");
                        int[] chunk = new int[]{chunkPos.getInt("x"), chunkPos.getInt("z")};
                        tooltip.add((Component)ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.info.shifter.pocket").append((Component)ComponentHelper.comp((String)("\u00a77[ \u00a7b" + chunk[0] + "\u00a77, \u00a7b" + chunk[1] + "\u00a77 ]"))));
                    }
                    if (nbtData.contains("player_data")) {
                        CompoundTag player_pos = nbtData.getCompound("player_data");
                        int x = player_pos.getInt("x");
                        int y = player_pos.getInt("y");
                        int z = player_pos.getInt("z");
                        boolean tele_to_block = player_pos.getBoolean("tele_to_block");
                        if (tele_to_block) {
                            tooltip.add((Component)ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.item.message.shifter.mode_change_prefix").append((Component)ComponentHelper.comp((String)"\u00a77[ ").append((Component)ComponentHelper.style((ComponentColour)ComponentColour.GREEN, (String)"dimensionalpocketsii.item.message.shifter.mode_change_true")).append((Component)ComponentHelper.comp((String)"\u00a77 ]"))));
                        } else {
                            tooltip.add((Component)ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.item.message.shifter.mode_change_prefix").append((Component)ComponentHelper.comp((String)"\u00a77[ ").append((Component)ComponentHelper.style((ComponentColour)ComponentColour.RED, (String)"dimensionalpocketsii.item.message.shifter.mode_change_false")).append((Component)ComponentHelper.comp((String)"\u00a77 ]"))));
                        }
                        tooltip.add((Component)ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.info.shifter_player_pos").append((Component)ComponentHelper.comp((String)("\u00a77[ \u00a73" + x + "\u00a77, \u00a73" + y + "\u00a77, \u00a73" + z + "\u00a77 ]"))));
                    }
                    if (nbtData.contains("dimension_data")) {
                        CompoundTag dimension = nbtData.getCompound("dimension_data");
                        String namespace = dimension.getString("namespace");
                        String path = dimension.getString("path");
                        tooltip.add((Component)ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.info.shifter_source_dimension").append((Component)ComponentHelper.comp((String)("\u00a77[ \u00a7a" + namespace + "\u00a77: \u00a7a" + path + "\u00a77 ]"))));
                    }
                }
                tooltip.add((Component)ComponentHelper.ctrlForLessDetails());
            }
        }
        super.appendHoverText(stack, context, tooltip, flagIn);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        AbstractBlockEntityPocket blockEntity;
        Pocket pocket;
        Player playerIn = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        Level world = context.getLevel();
        BlockEntity entity = world.getBlockEntity(pos);
        if (entity != null && entity instanceof AbstractBlockEntityPocket && this.addOrUpdateShifterInformation(stack, pocket = (blockEntity = (AbstractBlockEntityPocket)entity).getPocket(), world, playerIn)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    /*
     * Enabled aggressive block sorting
     */
    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        CompoundTag playerData;
        ItemStack stack = playerIn.getItemInHand(handIn);
        BlockPos player_pos_actual = playerIn.blockPosition();
        if (!stack.has(DataComponents.CUSTOM_DATA)) {
            CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.item.message.shifter.not_linked"));
            return InteractionResultHolder.pass((Object)playerIn.getItemInHand(handIn));
        }
        CompoundTag stack_tag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag();
        if (!stack_tag.contains("nbt_data")) return InteractionResultHolder.pass((Object)playerIn.getItemInHand(handIn));
        CompoundTag nbtData = stack_tag.getCompound("nbt_data");
        if (playerIn.isShiftKeyDown()) {
            if (!nbtData.contains("chunk_pos")) return InteractionResultHolder.pass((Object)playerIn.getItemInHand(handIn));
            CompoundTag chunkPos = nbtData.getCompound("chunk_pos");
            if (!nbtData.contains("player_pos")) return InteractionResultHolder.pass((Object)playerIn.getItemInHand(handIn));
            CompoundTag playerData2 = nbtData.getCompound("player_pos");
            if (!nbtData.contains("dimension_data")) return InteractionResultHolder.pass((Object)playerIn.getItemInHand(handIn));
            CompoundTag dimensionData = nbtData.getCompound("dimension_data");
            int[] chunk = new int[]{chunkPos.getInt("x"), chunkPos.getInt("z")};
            CosmosChunkPos savedChunkPos = new CosmosChunkPos(chunk[0], chunk[1]);
            Pocket pocket = StorageManager.getPocketFromChunkPosition(worldIn, savedChunkPos);
            int player_x = playerData2.getInt("x");
            int player_y = playerData2.getInt("y");
            int player_z = playerData2.getInt("z");
            float player_pitch = playerData2.getFloat("pitch");
            float player_yaw = playerData2.getFloat("yaw");
            boolean tele_to_block = playerData2.getBoolean("tele_to_block");
            BlockPos teleport_pos = new BlockPos(player_x, player_y, player_z);
            String namespace = dimensionData.getString("namespace");
            String path = dimensionData.getString("path");
            ResourceLocation dimension = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
            ResourceKey saved_dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimension);
            if (!this.hasEnergy(stack)) {
                CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.item.message.shifter.no_energy"));
                return InteractionResultHolder.pass((Object)playerIn.getItemInHand(handIn));
            }
            if (!pocket.exists()) {
                CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.status.action.null"));
                return InteractionResultHolder.pass((Object)playerIn.getItemInHand(handIn));
            }
            if (!PocketUtil.isDimensionEqual(worldIn, PocketsDimensionManager.POCKET_WORLD)) {
                CompoundTag playerDataNew = new CompoundTag();
                playerDataNew.putInt("x", player_pos_actual.getX());
                playerDataNew.putInt("y", player_pos_actual.getY());
                playerDataNew.putInt("z", player_pos_actual.getZ());
                playerDataNew.putFloat("yaw", playerIn.getRotationVector().y);
                playerDataNew.putFloat("pitch", playerIn.getRotationVector().x);
                playerDataNew.putBoolean("tele_to_block", tele_to_block);
                CompoundTag dimensionDataNew = new CompoundTag();
                dimensionDataNew.putString("namespace", worldIn.dimension().location().getNamespace());
                dimensionDataNew.putString("path", worldIn.dimension().location().getPath());
                nbtData.put("player_pos", (Tag)playerDataNew);
                nbtData.put("dimension_data", (Tag)dimensionDataNew);
                stack_tag.put("nbt_data", (Tag)nbtData);
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)stack_tag));
                pocket.shift(playerIn, EnumShiftDirection.ENTER, null, null, stack);
                this.extractEnergy(stack, this.getMaxUse(stack), false);
                return InteractionResultHolder.pass((Object)playerIn.getItemInHand(handIn));
            }
            CosmosChunkPos playerChunkPos = CosmosChunkPos.scaleToChunkPos((BlockPos)playerIn.blockPosition());
            if (!savedChunkPos.equals((Object)playerChunkPos)) {
                pocket.shift(playerIn, EnumShiftDirection.ENTER, null, null, stack);
                return InteractionResultHolder.pass((Object)playerIn.getItemInHand(handIn));
            }
            if (tele_to_block) {
                pocket.shift(playerIn, EnumShiftDirection.LEAVE, null, null, stack);
                this.extractEnergy(stack, this.getMaxUse(stack), false);
                return InteractionResultHolder.pass((Object)playerIn.getItemInHand(handIn));
            }
            ServerLevel level = ServerLifecycleHooks.getCurrentServer().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimension));
            EnumSafeTeleport teleport = EnumSafeTeleport.getValidTeleportLocation((Level)level, (BlockPos)teleport_pos);
            boolean teleportSafe = EnumSafeTeleport.isSafeTeleportLocation((Level)level, (BlockPos)teleport_pos);
            Shifter shifter = Shifter.createTeleporter((ResourceKey<Level>)saved_dimension, EnumShiftDirection.LEAVE, MathHelper.addBlockPos((BlockPos)teleport_pos, (BlockPos)teleport.toBlockPos()), player_yaw, player_pitch, false, true, !teleportSafe);
            ShifterCore.shiftPlayerToDimension(playerIn, shifter, shifter.getSafeSpawn());
            this.extractEnergy(stack, this.getMaxUse(stack), false);
            return InteractionResultHolder.pass((Object)playerIn.getItemInHand(handIn));
        }
        if (!nbtData.contains("player_pos")) return InteractionResultHolder.pass((Object)playerIn.getItemInHand(handIn));
        boolean change = (playerData = nbtData.getCompound("player_pos")).getBoolean("tele_to_block");
        playerData.putBoolean("tele_to_block", !change);
        nbtData.put("player_pos", (Tag)playerData);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)stack_tag));
        if (!change) {
            CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.style((ComponentColour)ComponentColour.PURPLE, (String)"dimensionalpocketsii.item.message.shifter.mode_change").append((Component)ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.item.message.shifter.mode_change_prefix").append((Component)ComponentHelper.style((ComponentColour)ComponentColour.GREEN, (String)"dimensionalpocketsii.item.message.shifter.mode_change_true").append((Component)ComponentHelper.comp((String)"\u00a77 ]")))));
            return InteractionResultHolder.pass((Object)playerIn.getItemInHand(handIn));
        }
        CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.style((ComponentColour)ComponentColour.PURPLE, (String)"dimensionalpocketsii.item.message.shifter.mode_change").append((Component)ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.item.message.shifter.mode_change_prefix").append((Component)ComponentHelper.style((ComponentColour)ComponentColour.RED, (String)"dimensionalpocketsii.item.message.shifter.mode_change_false").append((Component)ComponentHelper.comp((String)"\u00a77 ]")))));
        return InteractionResultHolder.pass((Object)playerIn.getItemInHand(handIn));
    }

    public boolean addOrUpdateShifterInformation(ItemStack stackIn, Pocket pocketIn, Level levelIn, Player playerIn) {
        BlockPos player_pos = playerIn.blockPosition();
        if (pocketIn != null) {
            if (pocketIn.checkIfOwner(playerIn)) {
                CosmosChunkPos pocket_get_pos = pocketIn.getDominantChunkPos();
                CompoundTag stack_tag = new CompoundTag();
                CompoundTag nbt_data = new CompoundTag();
                if (playerIn.isShiftKeyDown()) {
                    CompoundTag stackTag;
                    int x = pocket_get_pos.getX();
                    int z = pocket_get_pos.getZ();
                    CompoundTag chunk_tag = new CompoundTag();
                    chunk_tag.putInt("x", x);
                    chunk_tag.putInt("z", z);
                    nbt_data.put("chunk_pos", (Tag)chunk_tag);
                    CompoundTag playerData = new CompoundTag();
                    playerData.putInt("x", player_pos.getX());
                    playerData.putInt("y", player_pos.getY());
                    playerData.putInt("z", player_pos.getZ());
                    playerData.putFloat("yaw", playerIn.getRotationVector().y);
                    playerData.putFloat("pitch", playerIn.getRotationVector().x);
                    playerData.putBoolean("tele_to_block", true);
                    nbt_data.put("player_pos", (Tag)playerData);
                    CompoundTag dimensionData = new CompoundTag();
                    dimensionData.putString("namespace", levelIn.dimension().location().getNamespace());
                    dimensionData.putString("path", levelIn.dimension().location().getPath());
                    nbt_data.put("dimension_data", (Tag)dimensionData);
                    if (stackIn.has(DataComponents.CUSTOM_DATA) && (stackTag = ((CustomData)stackIn.get(DataComponents.CUSTOM_DATA)).copyTag()).contains("energy")) {
                        stack_tag.putInt("energy", stackTag.getInt("energy"));
                        stackIn.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)stack_tag));
                    }
                    nbt_data.putInt("colour", pocketIn.getDisplayColour());
                    stack_tag.put("nbt_data", (Tag)nbt_data);
                    stackIn.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)stack_tag));
                    CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.style((ComponentColour)ComponentColour.PURPLE, (String)"dimensionalpocketsii.item.message.shifter.linked").append((Component)ComponentHelper.comp((String)("\u00a77 {" + x + ", " + z + "}"))));
                    return true;
                }
            } else {
                CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.item.message.shifter.not_owner"));
                return false;
            }
        }
        return false;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }
}

