/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.core.item.device;

import com.tcn.cosmoslibrary.common.chat.CosmosChatUtil;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.cosmoslibrary.common.util.CosmosUtil;
import com.tcn.dimensionalpocketsii.pocket.core.shift.ShifterCore;
import com.tcn.dimensionalpocketsii.pocket.core.util.PocketUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;

public class DimensionalEjector
extends Item {
    public DimensionalEjector(Item.Properties properties) {
        super(properties);
    }

    public boolean canAttackBlock(BlockState state, Level worldIn, BlockPos pos, Player player) {
        return false;
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (playerIn.isShiftKeyDown()) {
            if (!PocketUtil.isDimensionEqual(worldIn, (ResourceKey<Level>)Level.OVERWORLD)) {
                ItemStack itemStack = CosmosUtil.getStack((Player)playerIn, (InteractionHand)handIn);
                itemStack.shrink(1);
                ResourceKey dimension = worldIn.dimension();
                ShifterCore.sendPlayerToDimensionSpawn(playerIn, (ResourceKey<Level>)Level.OVERWORLD, ComponentHelper.style2((ComponentColour)ComponentColour.GREEN, (String)"dimensionalpocketsii.item.message.ejector.success", (String)("\u00a76" + dimension.location().getNamespace() + "\u00a77: \u00a76" + dimension.location().getPath())));
            } else {
                CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.shifter_core.same_dimension"));
            }
        }
        return InteractionResultHolder.pass((Object)playerIn.getItemInHand(handIn));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        if (!ComponentHelper.isShiftKeyDown((Minecraft)Minecraft.getInstance())) {
            tooltip.add((Component)ComponentHelper.getTooltipInfo((String)"dimensionalpocketsii.info.ejector_info"));
            tooltip.add((Component)ComponentHelper.shiftForMoreDetails());
        } else {
            tooltip.add((Component)ComponentHelper.getTooltipOne((String)"dimensionalpocketsii.info.ejector_shift_one"));
            tooltip.add((Component)ComponentHelper.getTooltipTwo((String)"dimensionalpocketsii.info.ejector_shift_two"));
            tooltip.add((Component)ComponentHelper.getTooltipLimit((String)"dimensionalpocketsii.info.ejector_shift_limitation"));
            tooltip.add((Component)ComponentHelper.shiftForLessDetails());
        }
        super.appendHoverText(stack, context, tooltip, flagIn);
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }
}

