/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.core.item.tool;

import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.cosmoslibrary.energy.item.CosmosEnergyItem;
import com.tcn.cosmoslibrary.energy.item.CosmosEnergyTridentItem;
import com.tcn.dimensionalpocketsii.core.entity.DimensionalTridentEnhancedEntity;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class DimensionalTridentEnhanced
extends CosmosEnergyTridentItem {
    public DimensionalTridentEnhanced(Item.Properties properties, CosmosEnergyItem.Properties energyProperties, int useDuration, int enchantmentValue) {
        super(properties, energyProperties, useDuration, enchantmentValue);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        if (!ComponentHelper.isShiftKeyDown((Minecraft)Minecraft.getInstance())) {
            tooltip.add((Component)ComponentHelper.getTooltipInfo((String)"dimensionalpocketsii.item.info.trident_enhanced"));
            tooltip.add((Component)ComponentHelper.shiftForMoreDetails());
        } else {
            tooltip.add((Component)ComponentHelper.getTooltipOne((String)"dimensionalpocketsii.item.info.tool_charge"));
            tooltip.add((Component)ComponentHelper.getTooltipThree((String)"dimensionalpocketsii.item.info.tool_usage_enhanced"));
            tooltip.add((Component)ComponentHelper.getTooltipFour((String)"dimensionalpocketsii.item.info.tool_energy_enhanced"));
            tooltip.add((Component)ComponentHelper.getTooltipLimit((String)"dimensionalpocketsii.item.info.tool_limitation"));
            tooltip.add((Component)ComponentHelper.shiftForLessDetails());
        }
        super.appendHoverText(stack, context, tooltip, flagIn);
    }

    public void releaseUsing(ItemStack stackIn, Level levelIn, LivingEntity livingEntityIn, int timeLeft) {
        if (livingEntityIn instanceof Player) {
            float j;
            Player playerEntity = (Player)livingEntityIn;
            int i = this.getUseDuration(stackIn, livingEntityIn) - timeLeft;
            if (i >= 10 && (!((j = EnchantmentHelper.getTridentSpinAttackStrength((ItemStack)stackIn, (LivingEntity)playerEntity)) > 0.0f) || playerEntity.isInWaterOrRain())) {
                Holder holder = EnchantmentHelper.pickHighestLevel((ItemStack)stackIn, (DataComponentType)EnchantmentEffectComponents.TRIDENT_SOUND).orElse(SoundEvents.TRIDENT_THROW);
                if (!levelIn.isClientSide) {
                    this.extractEnergy(stackIn, this.getMaxUse(stackIn), false);
                    if (j == 0.0f) {
                        DimensionalTridentEnhancedEntity tridententity = new DimensionalTridentEnhancedEntity(levelIn, (LivingEntity)playerEntity, stackIn);
                        tridententity.shootFromRotation((Entity)playerEntity, playerEntity.getXRot(), playerEntity.getYRot(), 0.0f, 2.5f + j * 0.5f, 1.0f);
                        if (playerEntity.getAbilities().instabuild) {
                            tridententity.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        levelIn.addFreshEntity((Entity)tridententity);
                        levelIn.playSound(null, (Entity)tridententity, (SoundEvent)holder.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        if (!playerEntity.getAbilities().instabuild) {
                            playerEntity.getInventory().removeItem(stackIn);
                        }
                    }
                }
                playerEntity.awardStat(Stats.ITEM_USED.get((Object)this));
                if (j > 0.0f) {
                    float f7 = playerEntity.getYRot();
                    float f = playerEntity.getXRot();
                    float f1 = -Mth.sin((float)(f7 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
                    float f2 = -Mth.sin((float)(f * ((float)Math.PI / 180)));
                    float f3 = Mth.cos((float)(f7 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
                    float f4 = Mth.sqrt((float)(f1 * f1 + f2 * f2 + f3 * f3));
                    float f5 = 3.0f * ((1.0f + j) / 4.0f);
                    playerEntity.push((double)(f1 *= f5 / f4), (double)(f2 *= f5 / f4), (double)(f3 *= f5 / f4));
                    playerEntity.startAutoSpinAttack(20, 8.0f, stackIn);
                    if (playerEntity.onGround()) {
                        playerEntity.move(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                    }
                    levelIn.playSound(null, (Entity)playerEntity, (SoundEvent)holder.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }
}

