/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.core.management;

import com.tcn.dimensionalpocketsii.DimensionalPockets;
import com.tcn.dimensionalpocketsii.PocketReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class PocketsConfigManager {
    public static final PocketsConfigManager CONFIG;
    public static final ModConfigSpec SPEC;
    private final ModConfigSpec.IntValue internal_height;
    private final ModConfigSpec.IntValue internal_height_enhanced;
    private final ModConfigSpec.IntValue focus_jump_range;
    private final ModConfigSpec.BooleanValue can_place_structures;
    private final ModConfigSpec.BooleanValue can_use_items;
    private final ModConfigSpec.BooleanValue can_use_commands;
    private final ModConfigSpec.BooleanValue keep_chunks_loaded;
    private final ModConfigSpec.BooleanValue can_destroy_walls;
    private final ModConfigSpec.BooleanValue internal_replace;
    private final ModConfigSpec.BooleanValue stop_hostile_spawns;
    private final ModConfigSpec.BooleanValue create_backups;
    private final ModConfigSpec.BooleanValue info_message;
    private final ModConfigSpec.BooleanValue debug_message;
    private final ModConfigSpec.BooleanValue connected_textures_inside_pocket;
    private final ModConfigSpec.ConfigValue<List<? extends String>> blocked_structures;
    private final ModConfigSpec.ConfigValue<List<? extends String>> blocked_items;
    private final ModConfigSpec.IntValue op_level;
    private final ModConfigSpec.ConfigValue<List<? extends String>> blocked_commands;

    public static void save() {
        SPEC.save();
    }

    PocketsConfigManager(ModConfigSpec.Builder builder) {
        builder.push("general");
        this.internal_height = builder.comment("Allows you to change the the internal height of Pockets").defineInRange("internal_height", 15, 15, 255);
        this.internal_height_enhanced = builder.comment("Allows you to change the the internal height of Pockets").defineInRange("internal_height_enhanced", 31, 31, 255);
        this.focus_jump_range = builder.comment("Allows you to change the the range of Dimensional Focus Jump Distance.").defineInRange("focus_jump_range", 12, 4, 32);
        this.can_place_structures = builder.comment("Whether or not blocked Structures can be used inside of a Pocket").define("can_place_structures", false);
        this.can_use_items = builder.comment("Whether or not blocked Items can be used inside of a Pocket").define("can_use_items", false);
        this.can_use_commands = builder.comment("Whether or not blocked Commands can be used inside of a Pocket").define("can_use_commands", false);
        this.keep_chunks_loaded = builder.comment("Whether to keep the Chunks inside the Pocket Dimension Loaded").define("keep_chunks_loaded", true);
        this.can_destroy_walls = builder.comment("Whether the walls of Pockets can be destroyed in Creative Mode").define("can_destroy_walls", false);
        this.internal_replace = builder.comment("Whether if reducing the Internal Height of Pocket that is larger will make it smaller").define("internal_replace", false);
        this.stop_hostile_spawns = builder.comment("Whether or not Hostile Mobs should be stopped from spawning").define("stop_hostile_spawns", true);
        this.create_backups = builder.comment("Whether or not the Mod will create backups on world load").define("create_backups", true);
        builder.pop();
        builder.push("console_messages");
        this.info_message = builder.comment("Whether this mod will print [INFO] messages to the console/log").define("info", true);
        this.debug_message = builder.comment("Whether this mod will print [DEBUG] messages to the console/log").define("debug", false);
        builder.pop();
        builder.push("visual");
        this.connected_textures_inside_pocket = builder.comment("Whether or not connected textures work inside Pockets").define("connected_textures_inside_pocket", true);
        builder.pop();
        builder.push("blocked");
        this.blocked_structures = builder.comment("List of Structures that are blocked when inside a Pocket").defineList("blocked_structures", PocketReference.BlockedObjects.BLOCKS, () -> null, obj -> true);
        this.blocked_items = builder.comment("List of Items that are blocked when inside a Pocket").defineList("blocked_items", PocketReference.BlockedObjects.ITEMS, () -> null, obj -> true);
        this.op_level = builder.comment("The required OP level when on servers to bypass the below blocked commands").defineInRange("op_level", 4, 0, 4);
        this.blocked_commands = builder.comment("List of Commands that are blocked when inside a Pocket").defineList("blocked_commands", PocketReference.BlockedObjects.COMMANDS, () -> null, obj -> true);
        builder.pop();
    }

    public static PocketsConfigManager getInstance() {
        return CONFIG;
    }

    public int getInternalHeight() {
        return (Integer)this.internal_height.get();
    }

    public void setInternalHeight(int value) {
        this.internal_height.set((Object)value);
    }

    public int getInternalHeightEnhanced() {
        return (Integer)this.internal_height_enhanced.get();
    }

    public void setInternalHeightEnhanced(int value) {
        this.internal_height_enhanced.set((Object)value);
    }

    public int getFocusJumpRange() {
        return (Integer)this.focus_jump_range.get();
    }

    public void setFocusJumpRange(int value) {
        this.focus_jump_range.set((Object)value);
    }

    public boolean getCanPlaceStructures() {
        return (Boolean)this.can_place_structures.get();
    }

    public void setCanPlaceStructures(boolean value) {
        this.can_place_structures.set((Object)value);
    }

    public boolean getCanUseItems() {
        return (Boolean)this.can_use_items.get();
    }

    public void setCanUseItems(boolean value) {
        this.can_use_items.set((Object)value);
    }

    public boolean getCanUseCommands() {
        return (Boolean)this.can_use_commands.get();
    }

    public void setCanUseCommands(boolean value) {
        this.can_use_commands.set((Object)value);
    }

    public boolean getKeepChunksLoaded() {
        return (Boolean)this.keep_chunks_loaded.get();
    }

    public void setKeepChunksLoaded(boolean value) {
        this.keep_chunks_loaded.set((Object)value);
    }

    public boolean getCanDestroyWalls() {
        return (Boolean)this.can_destroy_walls.get();
    }

    public void setCanDestroyWalls(boolean value) {
        this.can_destroy_walls.set((Object)value);
    }

    public boolean getInternalReplace() {
        return (Boolean)this.internal_replace.get();
    }

    public void setInternalReplace(boolean value) {
        this.internal_replace.set((Object)value);
    }

    public boolean getStopHostileSpawns() {
        return (Boolean)this.stop_hostile_spawns.get();
    }

    public void setStopHostileSpawns(boolean value) {
        this.stop_hostile_spawns.set((Object)value);
    }

    public boolean getCreateBackups() {
        return (Boolean)this.create_backups.get();
    }

    public void setCreateBackups(boolean value) {
        this.create_backups.set((Object)value);
    }

    public boolean getInfoMessage() {
        return (Boolean)this.info_message.get();
    }

    public void setInfoMessage(boolean value) {
        DimensionalPockets.CONSOLE.updateInfoEnabled(value);
        this.info_message.set((Object)value);
    }

    public boolean getDebugMessage() {
        return (Boolean)this.debug_message.get();
    }

    public void setDebugMessage(boolean value) {
        DimensionalPockets.CONSOLE.updateDebugEnabled(value);
        this.debug_message.set((Object)value);
    }

    public boolean getConnectedTexturesInsidePocket() {
        return (Boolean)this.connected_textures_inside_pocket.get();
    }

    public void setConnectedTexturesInsidePocket(boolean value) {
        this.connected_textures_inside_pocket.set((Object)value);
    }

    public List<? extends String> getBlockedStructures() {
        return (List)this.blocked_structures.get();
    }

    public void setBlockedStructures(List<? extends String> value) {
        this.blocked_structures.set(value);
    }

    public void addBlockedStructure(String value) {
        if (!value.isBlank()) {
            ArrayList<String> list = new ArrayList<String>((Collection)this.blocked_structures.get());
            list.add(value);
            this.blocked_structures.set(list);
        }
    }

    public void removeBlockedStructure(String value) {
        List list = (List)this.blocked_structures.get();
        list.remove(value);
        this.blocked_structures.set((Object)list);
    }

    public void resetBlockedStructures() {
        ((List)this.blocked_structures.get()).clear();
        PocketReference.BlockedObjects.BLOCKS.forEach(item -> this.addBlockedStructure((String)item));
    }

    public List<? extends String> getBlockedItems() {
        return (List)this.blocked_items.get();
    }

    public void setBlockedItems(List<? extends String> value) {
        this.blocked_items.set(value);
    }

    public void addBlockedItem(String value) {
        if (!value.isBlank()) {
            ArrayList<String> list = new ArrayList<String>((Collection)this.blocked_items.get());
            list.add(value);
            this.blocked_items.set(list);
        }
    }

    public void removeBlockedItem(String value) {
        List list = (List)this.blocked_items.get();
        list.remove(value);
        this.blocked_items.set((Object)list);
    }

    public void resetBlockedItems() {
        ((List)this.blocked_items.get()).clear();
        PocketReference.BlockedObjects.ITEMS.forEach(item -> this.addBlockedItem((String)item));
    }

    public int getOPLevel() {
        return (Integer)this.op_level.get();
    }

    public void setOPLevel(int value) {
        this.op_level.set((Object)value);
    }

    public List<? extends String> getBlockedCommands() {
        return (List)this.blocked_commands.get();
    }

    public void setBlockedCommands(ArrayList<String> value) {
        this.blocked_commands.set(value);
    }

    public void addBlockedCommand(String value) {
        if (!value.isBlank()) {
            ArrayList<String> list = new ArrayList<String>((Collection)this.blocked_commands.get());
            list.add(value);
            this.blocked_commands.set(list);
        }
    }

    public void removeBlockedCommand(String value) {
        List list = (List)this.blocked_commands.get();
        list.remove(value);
        this.blocked_commands.set((Object)list);
    }

    public void resetBlockedCommands() {
        ((List)this.blocked_commands.get()).clear();
        PocketReference.BlockedObjects.COMMANDS.forEach(item -> this.addBlockedCommand((String)item));
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(PocketsConfigManager::new);
        CONFIG = (PocketsConfigManager)specPair.getLeft();
        SPEC = (ModConfigSpec)specPair.getRight();
    }
}

