/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.core.management;

import com.tcn.cosmoslibrary.common.chat.CosmosChatUtil;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.cosmoslibrary.common.lib.CosmosChunkPos;
import com.tcn.cosmoslibrary.energy.item.CosmosEnergyArmourItemColourable;
import com.tcn.dimensionalpocketsii.core.item.armour.DimensionalElytraplate;
import com.tcn.dimensionalpocketsii.core.item.armour.EnumElytraSetting;
import com.tcn.dimensionalpocketsii.core.item.armour.module.EnumElytraModule;
import com.tcn.dimensionalpocketsii.core.management.PocketsDimensionManager;
import com.tcn.dimensionalpocketsii.core.management.PocketsRegistrationManager;
import com.tcn.dimensionalpocketsii.core.network.packet.PacketDimensionChange;
import com.tcn.dimensionalpocketsii.core.network.packet.elytraplate.PacketElytraplateOpenConnector;
import com.tcn.dimensionalpocketsii.core.network.packet.elytraplate.PacketElytraplateOpenEnderChest;
import com.tcn.dimensionalpocketsii.core.network.packet.elytraplate.PacketElytraplateOpenSettings;
import com.tcn.dimensionalpocketsii.core.network.packet.elytraplate.PacketElytraplateShift;
import com.tcn.dimensionalpocketsii.core.network.packet.elytraplate.PacketElytraplateTagUpdate;
import com.tcn.dimensionalpocketsii.core.network.packet.elytraplate.PacketElytraplateUseEnergy;
import com.tcn.dimensionalpocketsii.core.network.packet.elytraplate.PacketElytraplateUseFirework;
import com.tcn.dimensionalpocketsii.pocket.core.registry.ChunkLoadingManager;
import com.tcn.dimensionalpocketsii.pocket.core.registry.StorageManager;
import com.tcn.dimensionalpocketsii.pocket.core.shift.EnumShiftDirection;
import com.tcn.dimensionalpocketsii.pocket.core.util.PocketUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="dimensionalpocketsii", bus=EventBusSubscriber.Bus.GAME)
public class PocketsGameEventsManager {
    @SubscribeEvent
    public static void onLivingEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        ItemStack stackTo;
        Item item;
        LivingEntity entity;
        EquipmentSlot slot = event.getSlot();
        if (!slot.equals((Object)EquipmentSlot.MAINHAND) && !slot.equals((Object)EquipmentSlot.OFFHAND) && !((entity = event.getEntity()) instanceof Player) && (item = (stackTo = event.getTo()).getItem()) instanceof CosmosEnergyArmourItemColourable) {
            CosmosEnergyArmourItemColourable item2 = (CosmosEnergyArmourItemColourable)item;
            item2.setDamage(stackTo, 0);
            if (!item2.hasEnergy(stackTo)) {
                item2.setEnergy(stackTo, 1000);
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onKeyPressEvent(InputEvent.Key event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer playerIn = mc.player;
        if (playerIn != null) {
            ItemStack armourStack;
            Item armour;
            Level world = playerIn.level();
            if (PocketsRegistrationManager.SUIT_SCREEN.isDown()) {
                ItemStack armourStack2;
                Item armour2;
                if (playerIn.getInventory().getArmor(2).getItem() != null && (armour2 = (armourStack2 = playerIn.getInventory().getArmor(2)).getItem()) instanceof DimensionalElytraplate) {
                    DimensionalElytraplate elytraplate = (DimensionalElytraplate)armour2;
                    if (DimensionalElytraplate.hasModuleInstalled(armourStack2, EnumElytraModule.SCREEN)) {
                        if (elytraplate.hasEnergy(armourStack2)) {
                            PacketDistributor.sendToServer((CustomPacketPayload)new PacketElytraplateOpenConnector(playerIn.getUUID(), 2), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            PacketDistributor.sendToServer((CustomPacketPayload)new PacketElytraplateUseEnergy(playerIn.getUUID(), 2, elytraplate.getMaxUse(armourStack2)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        } else {
                            CosmosChatUtil.sendClientPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.item.message.elytraplate.no_energy"));
                        }
                    } else {
                        CosmosChatUtil.sendClientPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.item.message.elytraplate.no_screen"));
                    }
                }
            } else if (PocketsRegistrationManager.SUIT_SCREEN_ENDER_CHEST.isDown()) {
                ItemStack armourStack3;
                Item armour3;
                if (playerIn.getInventory().getArmor(2).getItem() != null && (armour3 = (armourStack3 = playerIn.getInventory().getArmor(2)).getItem()) instanceof DimensionalElytraplate) {
                    DimensionalElytraplate elytraplate = (DimensionalElytraplate)armour3;
                    if (DimensionalElytraplate.hasModuleInstalled(armourStack3, EnumElytraModule.ENDER_CHEST)) {
                        if (elytraplate.hasEnergy(armourStack3)) {
                            PacketDistributor.sendToServer((CustomPacketPayload)new PacketElytraplateOpenEnderChest(playerIn.getUUID(), 2), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            PacketDistributor.sendToServer((CustomPacketPayload)new PacketElytraplateUseEnergy(playerIn.getUUID(), 2, elytraplate.getMaxUse(armourStack3)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        } else {
                            CosmosChatUtil.sendClientPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.item.message.elytraplate.no_energy"));
                        }
                    } else {
                        CosmosChatUtil.sendClientPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.item.message.elytraplate.no_ender_chest"));
                    }
                }
            } else if (PocketsRegistrationManager.SUIT_SETTINGS.isDown()) {
                ItemStack armourStack4;
                Item elytraplate;
                if (playerIn.getInventory().getArmor(2).getItem() != null && (elytraplate = (armourStack4 = playerIn.getInventory().getArmor(2)).getItem()) instanceof DimensionalElytraplate) {
                    DimensionalElytraplate elytraplate2 = (DimensionalElytraplate)elytraplate;
                    if (elytraplate2.hasEnergy(armourStack4)) {
                        PacketDistributor.sendToServer((CustomPacketPayload)new PacketElytraplateOpenSettings(playerIn.getUUID(), 2), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    } else {
                        CosmosChatUtil.sendClientPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.item.message.elytraplate.no_energy"));
                    }
                }
            } else if (PocketsRegistrationManager.SUIT_SHIFT.isDown()) {
                if (playerIn.getInventory().getArmor(2).getItem() != null) {
                    ItemStack armourStack5 = playerIn.getInventory().getArmor(2);
                    Item armour4 = armourStack5.getItem();
                    BlockPos player_pos_actual = playerIn.blockPosition();
                    if (armour4 instanceof DimensionalElytraplate) {
                        DimensionalElytraplate elytraplate = (DimensionalElytraplate)armour4;
                        if (DimensionalElytraplate.hasModuleInstalled(armourStack5, EnumElytraModule.SHIFTER)) {
                            if (armourStack5.has(DataComponents.CUSTOM_DATA)) {
                                CompoundTag stack_nbt = ((CustomData)armourStack5.get(DataComponents.CUSTOM_DATA)).copyTag();
                                if (stack_nbt.contains("nbt_data")) {
                                    CompoundTag nbt_data = stack_nbt.getCompound("nbt_data");
                                    if (nbt_data.contains("chunk_pos")) {
                                        CompoundTag chunk_pos = nbt_data.getCompound("chunk_pos");
                                        if (nbt_data.contains("player_pos")) {
                                            CompoundTag player_pos = nbt_data.getCompound("player_pos");
                                            int player_x = player_pos.getInt("x");
                                            int player_y = player_pos.getInt("y");
                                            int player_z = player_pos.getInt("z");
                                            float player_pitch = player_pos.getFloat("pitch");
                                            float player_yaw = player_pos.getFloat("yaw");
                                            boolean tele_to_block = DimensionalElytraplate.getElytraSetting(armourStack5, EnumElytraSetting.TELEPORT_TO_BLOCK);
                                            CompoundTag dim = nbt_data.getCompound("dimension");
                                            String namespace = dim.getString("namespace");
                                            String path = dim.getString("path");
                                            ResourceLocation loc = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
                                            ResourceKey source_dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)loc);
                                            BlockPos teleport_pos = new BlockPos(player_x, player_y, player_z);
                                            int x = chunk_pos.getInt("x");
                                            int z = chunk_pos.getInt("z");
                                            CosmosChunkPos chunk = new CosmosChunkPos(x, z);
                                            if (elytraplate.hasEnergy(armourStack5)) {
                                                if (PocketUtil.isDimensionEqual(world, PocketsDimensionManager.POCKET_WORLD)) {
                                                    if (tele_to_block) {
                                                        PacketDistributor.sendToServer((CustomPacketPayload)new PacketElytraplateUseEnergy(playerIn.getUUID(), 2, elytraplate.getMaxUse(armourStack5)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                                                        PacketDistributor.sendToServer((CustomPacketPayload)new PacketElytraplateShift(playerIn.getUUID(), (ResourceKey<Level>)world.dimension(), chunk), (CustomPacketPayload[])new CustomPacketPayload[0]);
                                                    } else {
                                                        PacketDistributor.sendToServer((CustomPacketPayload)new PacketElytraplateUseEnergy(playerIn.getUUID(), 2, elytraplate.getMaxUse(armourStack5)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                                                        PacketDistributor.sendToServer((CustomPacketPayload)new PacketDimensionChange(playerIn.getUUID(), (ResourceKey<Level>)source_dimension, loc, teleport_pos, EnumShiftDirection.LEAVE, player_yaw, player_pitch, false, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                                                    }
                                                } else {
                                                    CompoundTag pos_tag = new CompoundTag();
                                                    pos_tag.putInt("x", player_pos_actual.getX());
                                                    pos_tag.putInt("y", player_pos_actual.getY());
                                                    pos_tag.putInt("z", player_pos_actual.getZ());
                                                    pos_tag.putFloat("yaw", playerIn.getRotationVector().y);
                                                    pos_tag.putFloat("pitch", playerIn.getRotationVector().x);
                                                    CompoundTag dimension = new CompoundTag();
                                                    dimension.putString("namespace", world.dimension().location().getNamespace());
                                                    dimension.putString("path", world.dimension().location().getPath());
                                                    nbt_data.put("player_pos", (Tag)pos_tag);
                                                    nbt_data.put("dimension", (Tag)dimension);
                                                    stack_nbt.put("nbt_data", (Tag)nbt_data);
                                                    armourStack5.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)stack_nbt));
                                                    PacketDistributor.sendToServer((CustomPacketPayload)new PacketElytraplateTagUpdate(playerIn.getUUID(), 2, stack_nbt), (CustomPacketPayload[])new CustomPacketPayload[0]);
                                                    PacketDistributor.sendToServer((CustomPacketPayload)new PacketElytraplateUseEnergy(playerIn.getUUID(), 2, elytraplate.getMaxUse(armourStack5)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                                                    PacketDistributor.sendToServer((CustomPacketPayload)new PacketElytraplateShift(playerIn.getUUID(), (ResourceKey<Level>)world.dimension(), chunk), (CustomPacketPayload[])new CustomPacketPayload[0]);
                                                }
                                            } else {
                                                CosmosChatUtil.sendClientPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.item.message.elytraplate.no_energy"));
                                            }
                                        }
                                    }
                                } else {
                                    CosmosChatUtil.sendClientPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.item.message.elytraplate.not_linked"));
                                }
                            } else {
                                CosmosChatUtil.sendClientPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.item.message.elytraplate.not_linked"));
                            }
                        } else {
                            CosmosChatUtil.sendClientPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.item.message.elytraplate.no_shifter"));
                        }
                    }
                }
            } else if (PocketsRegistrationManager.SUIT_FIREWORK.isDown() && playerIn.getInventory().getArmor(2).getItem() != null && (armour = (armourStack = playerIn.getInventory().getArmor(2)).getItem()) instanceof DimensionalElytraplate) {
                DimensionalElytraplate elytraplate = (DimensionalElytraplate)armour;
                if (DimensionalElytraplate.hasModuleInstalled(armourStack, EnumElytraModule.FIREWORK)) {
                    if (DimensionalElytraplate.getElytraSetting(armourStack, EnumElytraSetting.FIREWORK).booleanValue()) {
                        if (elytraplate.hasEnergy(armourStack)) {
                            PacketDistributor.sendToServer((CustomPacketPayload)new PacketElytraplateUseFirework(2), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            PacketDistributor.sendToServer((CustomPacketPayload)new PacketElytraplateUseEnergy(playerIn.getUUID(), 2, elytraplate.getMaxUse(armourStack)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            return;
                        }
                        CosmosChatUtil.sendClientPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.item.message.elytraplate.no_energy"));
                    } else {
                        CosmosChatUtil.sendClientPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.item.message.elytraplate.firework_disabled"));
                    }
                } else {
                    CosmosChatUtil.sendClientPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.item.message.elytraplate.no_firework"));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onServerSaveEvent(LevelEvent.Save event) {
        LevelAccessor level = event.getLevel();
        DimensionType type = level.dimensionType();
        if (!level.isClientSide() && type.effectsLocation() == BuiltinDimensionTypes.OVERWORLD_EFFECTS) {
            StorageManager.saveRegistry((HolderLookup.Provider)level.registryAccess());
            ChunkLoadingManager.saveToStorage();
        }
    }

    @SubscribeEvent
    public static void onServerUnloadEvent(LevelEvent.Unload event) {
        LevelAccessor level = event.getLevel();
        if (!level.isClientSide()) {
            StorageManager.saveRegistry((HolderLookup.Provider)level.registryAccess());
            ChunkLoadingManager.saveToStorage();
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
    }

    @SubscribeEvent
    public static void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
    }
}

