/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.core.network;

import com.tcn.cosmoslibrary.common.chat.CosmosChatUtil;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.cosmoslibrary.common.lib.CosmosChunkPos;
import com.tcn.cosmoslibrary.common.lib.MathHelper;
import com.tcn.cosmoslibrary.common.util.CosmosUtil;
import com.tcn.cosmoslibrary.core.teleport.EnumSafeTeleport;
import com.tcn.dimensionalpocketsii.client.container.ContainerElytraplateConnector;
import com.tcn.dimensionalpocketsii.client.container.ContainerElytraplateEnderChest;
import com.tcn.dimensionalpocketsii.client.container.ContainerElytraplateSettings;
import com.tcn.dimensionalpocketsii.core.item.DimensionalTome;
import com.tcn.dimensionalpocketsii.core.item.armour.DimensionalElytraplate;
import com.tcn.dimensionalpocketsii.core.management.PocketsDimensionManager;
import com.tcn.dimensionalpocketsii.core.network.DimensionalPacket;
import com.tcn.dimensionalpocketsii.core.network.packet.PacketDimensionChange;
import com.tcn.dimensionalpocketsii.core.network.packet.PacketTomeUpdate;
import com.tcn.dimensionalpocketsii.core.network.packet.elytraplate.PacketElytraplateOpenConnector;
import com.tcn.dimensionalpocketsii.core.network.packet.elytraplate.PacketElytraplateOpenEnderChest;
import com.tcn.dimensionalpocketsii.core.network.packet.elytraplate.PacketElytraplateOpenSettings;
import com.tcn.dimensionalpocketsii.core.network.packet.elytraplate.PacketElytraplateSettingsChange;
import com.tcn.dimensionalpocketsii.core.network.packet.elytraplate.PacketElytraplateShift;
import com.tcn.dimensionalpocketsii.core.network.packet.elytraplate.PacketElytraplateTagUpdate;
import com.tcn.dimensionalpocketsii.core.network.packet.elytraplate.PacketElytraplateUpdateUIHelp;
import com.tcn.dimensionalpocketsii.core.network.packet.elytraplate.PacketElytraplateUpdateUIMode;
import com.tcn.dimensionalpocketsii.core.network.packet.elytraplate.PacketElytraplateUseEnergy;
import com.tcn.dimensionalpocketsii.core.network.packet.elytraplate.PacketElytraplateUseFirework;
import com.tcn.dimensionalpocketsii.pocket.core.Pocket;
import com.tcn.dimensionalpocketsii.pocket.core.registry.StorageManager;
import com.tcn.dimensionalpocketsii.pocket.core.shift.EnumShiftDirection;
import com.tcn.dimensionalpocketsii.pocket.core.shift.Shifter;
import com.tcn.dimensionalpocketsii.pocket.core.shift.ShifterCore;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class ServerPacketHandler {
    public static void handleDataOnNetwork(DimensionalPacket data, IPayloadContext context) {
        Record packet;
        RegistryAccess.Frozen provider = ServerLifecycleHooks.getCurrentServer().registryAccess();
        if (data instanceof PacketElytraplateShift) {
            packet = (PacketElytraplateShift)data;
            context.enqueueWork(() -> ServerPacketHandler.lambda$handleDataOnNetwork$0((PacketElytraplateShift)packet));
        }
        if (data instanceof PacketDimensionChange) {
            packet = (PacketDimensionChange)data;
            context.enqueueWork(() -> ServerPacketHandler.lambda$handleDataOnNetwork$1((PacketDimensionChange)packet));
        }
        if (data instanceof PacketElytraplateTagUpdate) {
            packet = (PacketElytraplateTagUpdate)data;
            context.enqueueWork(() -> ServerPacketHandler.lambda$handleDataOnNetwork$2((PacketElytraplateTagUpdate)packet));
        }
        if (data instanceof PacketElytraplateUseEnergy) {
            packet = (PacketElytraplateUseEnergy)data;
            context.enqueueWork(() -> ServerPacketHandler.lambda$handleDataOnNetwork$3((PacketElytraplateUseEnergy)packet));
        }
        if (data instanceof PacketTomeUpdate) {
            packet = (PacketTomeUpdate)data;
            context.enqueueWork(() -> ServerPacketHandler.lambda$handleDataOnNetwork$4((PacketTomeUpdate)packet));
        }
        if (data instanceof PacketElytraplateSettingsChange) {
            packet = (PacketElytraplateSettingsChange)data;
            context.enqueueWork(() -> ServerPacketHandler.lambda$handleDataOnNetwork$5((PacketElytraplateSettingsChange)packet));
        }
        if (data instanceof PacketElytraplateUpdateUIMode) {
            packet = (PacketElytraplateUpdateUIMode)data;
            context.enqueueWork(() -> ServerPacketHandler.lambda$handleDataOnNetwork$6((PacketElytraplateUpdateUIMode)packet));
        }
        if (data instanceof PacketElytraplateUpdateUIHelp) {
            packet = (PacketElytraplateUpdateUIHelp)data;
            context.enqueueWork(() -> ServerPacketHandler.lambda$handleDataOnNetwork$7((PacketElytraplateUpdateUIHelp)packet));
        }
        if (data instanceof PacketElytraplateOpenConnector) {
            packet = (PacketElytraplateOpenConnector)data;
            context.enqueueWork(() -> ServerPacketHandler.lambda$handleDataOnNetwork$9(context, (PacketElytraplateOpenConnector)packet, (HolderLookup.Provider)provider));
        }
        if (data instanceof PacketElytraplateOpenEnderChest) {
            packet = (PacketElytraplateOpenEnderChest)data;
            context.enqueueWork(() -> ServerPacketHandler.lambda$handleDataOnNetwork$11(context, (PacketElytraplateOpenEnderChest)packet));
        }
        if (data instanceof PacketElytraplateOpenSettings) {
            packet = (PacketElytraplateOpenSettings)data;
            context.enqueueWork(() -> ServerPacketHandler.lambda$handleDataOnNetwork$13(context, (PacketElytraplateOpenSettings)packet));
        }
        if (data instanceof PacketElytraplateUseFirework) {
            context.enqueueWork(() -> {
                Player player = context.player();
                if (player.isFallFlying() && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity(serverPlayer.level(), new ItemStack((ItemLike)Items.FIREWORK_ROCKET), (LivingEntity)player);
                    serverPlayer.level().addFreshEntity((Entity)fireworkrocketentity);
                }
            });
        }
    }

    private static /* synthetic */ void lambda$handleDataOnNetwork$13(IPayloadContext context, PacketElytraplateOpenSettings packet) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack stack = player.getInventory().getArmor(packet.index());
            serverPlayer.openMenu((MenuProvider)new ContainerElytraplateSettings.Provider(), packetBuffer -> ItemStack.STREAM_CODEC.encode(packetBuffer, (Object)stack));
        }
    }

    private static /* synthetic */ void lambda$handleDataOnNetwork$11(IPayloadContext context, PacketElytraplateOpenEnderChest packet) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack stack = player.getInventory().getArmor(packet.index());
            serverPlayer.openMenu((MenuProvider)new ContainerElytraplateEnderChest.Provider(), packetBuffer -> ItemStack.STREAM_CODEC.encode(packetBuffer, (Object)stack));
        }
    }

    private static /* synthetic */ void lambda$handleDataOnNetwork$9(IPayloadContext context, PacketElytraplateOpenConnector packet, HolderLookup.Provider provider) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack stack = player.getInventory().getArmor(packet.index());
            if (stack.has(DataComponents.CUSTOM_DATA)) {
                CompoundTag compound = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag();
                if (compound.contains("nbt_data")) {
                    CompoundTag nbtData = compound.getCompound("nbt_data");
                    if (nbtData.contains("chunk_pos")) {
                        CompoundTag chunkPos = nbtData.getCompound("chunk_pos");
                        int x = chunkPos.getInt("x");
                        int z = chunkPos.getInt("z");
                        CosmosChunkPos chunk = new CosmosChunkPos(x, z);
                        Pocket pocket_ = StorageManager.getPocketFromChunkPosition(null, chunk);
                        CompoundTag compoundA = new CompoundTag();
                        pocket_.writeToNBT(compoundA, provider);
                        if (pocket_ != null && stack.getItem() instanceof DimensionalElytraplate) {
                            serverPlayer.openMenu((MenuProvider)new ContainerElytraplateConnector.Provider(), packetBuffer -> {
                                packetBuffer.writeNbt((Tag)compoundA);
                                ItemStack.STREAM_CODEC.encode(packetBuffer, (Object)stack);
                            });
                        }
                    } else {
                        CosmosChatUtil.sendServerPlayerMessage((Player)player, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.item.message.elytraplate.not_linked"));
                    }
                } else {
                    CosmosChatUtil.sendServerPlayerMessage((Player)player, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.item.message.elytraplate.not_linked"));
                }
            } else {
                CosmosChatUtil.sendServerPlayerMessage((Player)player, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.item.message.elytraplate.not_linked"));
            }
        }
    }

    private static /* synthetic */ void lambda$handleDataOnNetwork$7(PacketElytraplateUpdateUIHelp packet) {
        ServerPlayer player = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayer(packet.playerUUID());
        ItemStack stack = (ItemStack)player.getInventory().armor.get(packet.index());
        if (stack != null && packet.mode() != null) {
            DimensionalElytraplate.setUIHelp(stack, packet.mode());
        }
    }

    private static /* synthetic */ void lambda$handleDataOnNetwork$6(PacketElytraplateUpdateUIMode packet) {
        ServerPlayer player = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayer(packet.playerUUID());
        ItemStack stack = (ItemStack)player.getInventory().armor.get(packet.index());
        if (stack != null && packet.mode() != null) {
            DimensionalElytraplate.setUIMode(stack, packet.mode());
        }
    }

    private static /* synthetic */ void lambda$handleDataOnNetwork$5(PacketElytraplateSettingsChange packet) {
        ServerPlayer player = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayer(packet.playerUUID());
        ItemStack stack = player.getInventory().getArmor(packet.armourIndex());
        DimensionalElytraplate.addOrUpdateElytraSetting(stack, packet.setting(), packet.value());
    }

    private static /* synthetic */ void lambda$handleDataOnNetwork$4(PacketTomeUpdate packet) {
        ServerPlayer player = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayer(packet.playerUUID());
        ItemStack stack = CosmosUtil.getStack((Player)player);
        if (stack != null) {
            if (packet.pageNumber() > -1) {
                DimensionalTome.setPage(stack, packet.pageNumber());
            }
            if (packet.mode() != null) {
                DimensionalTome.setUIMode(stack, packet.mode());
            }
        }
    }

    private static /* synthetic */ void lambda$handleDataOnNetwork$3(PacketElytraplateUseEnergy packet) {
        ServerPlayer player = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayer(packet.playerUUID());
        ItemStack itemStack = player.getInventory().getArmor(packet.index());
        Item item = itemStack.getItem();
        if (item instanceof DimensionalElytraplate) {
            DimensionalElytraplate elytraplate = (DimensionalElytraplate)item;
            elytraplate.extractEnergy(itemStack, packet.energyUsed(), false);
        }
    }

    private static /* synthetic */ void lambda$handleDataOnNetwork$2(PacketElytraplateTagUpdate packet) {
        ServerPlayer player = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayer(packet.playerUUID());
        ItemStack stack = player.getInventory().getArmor(packet.index());
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)packet.stackTag()));
    }

    private static /* synthetic */ void lambda$handleDataOnNetwork$1(PacketDimensionChange packet) {
        ServerLevel level = ServerLifecycleHooks.getCurrentServer().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)packet.toDimension()));
        EnumSafeTeleport teleport = EnumSafeTeleport.getValidTeleportLocation((Level)level, (BlockPos)packet.pos());
        boolean teleportSafe = EnumSafeTeleport.isSafeTeleportLocation((Level)level, (BlockPos)packet.pos());
        ServerPlayer player = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayer(packet.playerUUID());
        Shifter shifter = Shifter.createTeleporter(packet.dimension(), packet.direction(), MathHelper.addBlockPos((BlockPos)packet.pos(), (BlockPos)teleport.toBlockPos()), packet.yaw(), packet.pitch(), packet.playVanillaSound(), packet.sendMessage(), !teleportSafe);
        ShifterCore.shiftPlayerToDimension((Player)player, shifter, !teleportSafe);
    }

    private static /* synthetic */ void lambda$handleDataOnNetwork$0(PacketElytraplateShift packet) {
        ServerPlayer player = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayer(packet.playerUUID());
        Pocket pocket = StorageManager.getPocketFromChunkPosition(null, packet.chunkPos());
        if (pocket.exists()) {
            if (packet.dimension().equals(PocketsDimensionManager.POCKET_WORLD)) {
                pocket.shift((Player)player, EnumShiftDirection.LEAVE, null, null, null);
            } else {
                pocket.shift((Player)player, EnumShiftDirection.ENTER, null, null, null);
            }
        }
    }
}

