/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.core.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tcn.dimensionalpocketsii.core.management.PocketsRecipeManager;
import com.tcn.dimensionalpocketsii.core.management.PocketsRegistrationManager;
import com.tcn.dimensionalpocketsii.core.recipe.UpgradingRecipeInput;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class UpgradeStationRecipe
implements Recipe<UpgradingRecipeInput> {
    private final Ingredient focusIngredient;
    private final List<Ingredient> topIngredients;
    private final List<Ingredient> middleIngredients;
    private final List<Ingredient> bottomIngredients;
    private final ItemStack resultIngredient;
    public ResourceLocation ident;
    private static final int TOP_ROW = 3;
    private static final int MID_ROW = 2;
    private static final int BOT_ROW = 3;

    public UpgradeStationRecipe(Ingredient focusIngredientIn, List<Ingredient> topIngredientsIn, List<Ingredient> middleIngredientsIn, List<Ingredient> bottomIngredientsIn, ItemStack resultIngredientIn) {
        this.focusIngredient = focusIngredientIn;
        this.topIngredients = topIngredientsIn;
        this.middleIngredients = middleIngredientsIn;
        this.bottomIngredients = bottomIngredientsIn;
        this.resultIngredient = resultIngredientIn;
    }

    public boolean matches(UpgradingRecipeInput inputIn, Level levelIn) {
        if (!(this.size(Loc.TOP, 3) && this.size(Loc.MID, 2) && this.size(Loc.BOT, 3))) {
            return false;
        }
        boolean flagFocus = this.test(Loc.FOCUS, inputIn, 0, 0);
        boolean flagTopRow = this.test(Loc.TOP, inputIn, 0, 1) && this.test(Loc.TOP, inputIn, 1, 2) && this.test(Loc.TOP, inputIn, 2, 3);
        boolean flagMidRow = this.test(Loc.MID, inputIn, 0, 4) && this.test(Loc.MID, inputIn, 1, 5);
        boolean flagBotRow = this.test(Loc.BOT, inputIn, 0, 6) && this.test(Loc.BOT, inputIn, 1, 7) && this.test(Loc.BOT, inputIn, 2, 8);
        return flagFocus && flagTopRow && flagMidRow && flagBotRow;
    }

    public boolean size(Loc location, int size) {
        if (location.equals((Object)Loc.TOP)) {
            return this.topIngredients.size() == size;
        }
        if (location.equals((Object)Loc.MID)) {
            return this.middleIngredients.size() == size;
        }
        if (location.equals((Object)Loc.BOT)) {
            return this.bottomIngredients.size() == size;
        }
        return false;
    }

    public boolean test(Loc location, UpgradingRecipeInput inputIn, int recipeIndex, int containerIndex) {
        if (location.equals((Object)Loc.FOCUS)) {
            return this.focusIngredient.test(inputIn.getItem(containerIndex));
        }
        if (location.equals((Object)Loc.TOP)) {
            return this.topIngredients.get(recipeIndex).test(inputIn.getItem(containerIndex));
        }
        if (location.equals((Object)Loc.MID)) {
            return this.middleIngredients.get(recipeIndex).test(inputIn.getItem(containerIndex));
        }
        if (location.equals((Object)Loc.BOT)) {
            return this.bottomIngredients.get(recipeIndex).test(inputIn.getItem(containerIndex));
        }
        return false;
    }

    public boolean isFocusIngredient(ItemStack stackIn) {
        return this.getFocusIngredient().test(stackIn);
    }

    public ItemStack assemble(UpgradingRecipeInput recipeInput, HolderLookup.Provider accessIn) {
        ItemStack itemstack = recipeInput.getItem(0).transmuteCopy((ItemLike)this.resultIngredient.getItem(), this.resultIngredient.getCount());
        itemstack.applyComponents(this.resultIngredient.getComponentsPatch());
        return itemstack;
    }

    public boolean canCraftInDimensions(int xIn, int yIn) {
        return xIn * yIn >= 2;
    }

    public ItemStack getResultItem(HolderLookup.Provider accessIn) {
        return this.getResultItemStack().copy();
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)PocketsRegistrationManager.MODULE_UPGRADE_STATION.get());
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)PocketsRecipeManager.RECIPE_SERIALIZER_UPGRADE_STATION.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)PocketsRecipeManager.RECIPE_TYPE_UPGRADE_STATION.get();
    }

    public boolean isIncomplete() {
        return Stream.of(this.focusIngredient, this.getTopIngredient(0), this.getTopIngredient(1), this.getTopIngredient(2), this.getMiddleIngredient(0), this.getMiddleIngredient(1), this.getBottomIngredient(0), this.getBottomIngredient(1), this.getBottomIngredient(2)).anyMatch(ingredient -> ingredient.getItems().length == 0);
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)this.focusIngredient, (Object[])new Ingredient[]{this.topIngredients.get(0), this.topIngredients.get(1), this.topIngredients.get(2), this.middleIngredients.get(0), this.middleIngredients.get(1), this.bottomIngredients.get(0), this.bottomIngredients.get(1), this.bottomIngredients.get(2)});
    }

    public List<Ingredient> getIngredientList() {
        return List.of(this.focusIngredient, this.topIngredients.get(0), this.topIngredients.get(1), this.topIngredients.get(2), this.middleIngredients.get(0), this.middleIngredients.get(1), this.bottomIngredients.get(0), this.bottomIngredients.get(1), this.bottomIngredients.get(2));
    }

    public boolean isSpecial() {
        return true;
    }

    public Ingredient getFocusIngredient() {
        return this.focusIngredient;
    }

    public Ingredient getTopIngredient(int index) {
        return this.topIngredients.get(index);
    }

    public Ingredient getMiddleIngredient(int index) {
        return this.middleIngredients.get(index);
    }

    public Ingredient getBottomIngredient(int index) {
        return this.bottomIngredients.get(index);
    }

    public ItemStack getResultItemStack() {
        return this.resultIngredient;
    }

    public static enum Loc {
        FOCUS,
        TOP,
        MID,
        BOT;

    }

    public static class Serializer
    implements RecipeSerializer<UpgradeStationRecipe> {
        public static final MapCodec<UpgradeStationRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("focus").forGetter(recipe -> recipe.focusIngredient), (App)Ingredient.LIST_CODEC.fieldOf("topRow").forGetter(recipe -> recipe.topIngredients), (App)Ingredient.LIST_CODEC.fieldOf("middleRow").forGetter(recipe -> recipe.middleIngredients), (App)Ingredient.LIST_CODEC.fieldOf("bottomRow").forGetter(recipe -> recipe.bottomIngredients), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.resultIngredient)).apply((Applicative)instance, UpgradeStationRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, UpgradeStationRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<UpgradeStationRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, UpgradeStationRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static UpgradeStationRecipe fromNetwork(RegistryFriendlyByteBuf extraDataIn) {
            Ingredient focus = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)extraDataIn);
            ArrayList<Ingredient> topRow = new ArrayList<Ingredient>();
            for (int i = 0; i < 3; ++i) {
                topRow.add(i, (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)extraDataIn));
            }
            ArrayList<Ingredient> middleRow = new ArrayList<Ingredient>();
            for (int i = 0; i < 2; ++i) {
                middleRow.add(i, (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)extraDataIn));
            }
            ArrayList<Ingredient> bottomRow = new ArrayList<Ingredient>();
            for (int i = 0; i < 3; ++i) {
                bottomRow.add(i, (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)extraDataIn));
            }
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)extraDataIn);
            return new UpgradeStationRecipe(focus, topRow, middleRow, bottomRow, result);
        }

        private static void toNetwork(RegistryFriendlyByteBuf extraDataIn, UpgradeStationRecipe recipeIn) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)extraDataIn, (Object)recipeIn.focusIngredient);
            for (Ingredient ingredient : recipeIn.topIngredients) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)extraDataIn, (Object)ingredient);
            }
            for (Ingredient ingredient : recipeIn.middleIngredients) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)extraDataIn, (Object)ingredient);
            }
            for (Ingredient ingredient : recipeIn.bottomIngredients) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)extraDataIn, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)extraDataIn, (Object)recipeIn.resultIngredient);
        }
    }
}

