/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.integration.jei;

import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.dimensionalpocketsii.PocketReference;
import com.tcn.dimensionalpocketsii.core.management.PocketsRegistrationManager;
import com.tcn.dimensionalpocketsii.core.recipe.UpgradeStationRecipe;
import com.tcn.dimensionalpocketsii.integration.jei.PocketsRecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CategoryUpgradeStation
implements IRecipeCategory<UpgradeStationRecipe> {
    private IGuiHelper helper;
    private final IDrawable background;

    public CategoryUpgradeStation(IGuiHelper helperIn) {
        this.helper = helperIn;
        this.background = this.helper.createDrawable(PocketReference.GUI.RESOURCE.UPGRADE_STATION_JEI, 0, 0, 114, 72);
    }

    public Component getTitle() {
        return ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.integration.jei.upgrade_category");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)PocketsRegistrationManager.MODULE_UPGRADE_STATION.get()));
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayout, UpgradeStationRecipe recipe, IFocusGroup ingredients) {
        recipeLayout.addSlot(RecipeIngredientRole.INPUT, 28, 28).addIngredients(recipe.getFocusIngredient());
        recipeLayout.addSlot(RecipeIngredientRole.INPUT, 7, 7).addIngredients(recipe.getTopIngredient(0));
        recipeLayout.addSlot(RecipeIngredientRole.INPUT, 28, 7).addIngredients(recipe.getTopIngredient(1));
        recipeLayout.addSlot(RecipeIngredientRole.INPUT, 49, 7).addIngredients(recipe.getTopIngredient(2));
        recipeLayout.addSlot(RecipeIngredientRole.INPUT, 7, 28).addIngredients(recipe.getMiddleIngredient(0));
        recipeLayout.addSlot(RecipeIngredientRole.INPUT, 49, 28).addIngredients(recipe.getMiddleIngredient(1));
        recipeLayout.addSlot(RecipeIngredientRole.INPUT, 7, 49).addIngredients(recipe.getBottomIngredient(0));
        recipeLayout.addSlot(RecipeIngredientRole.INPUT, 28, 49).addIngredients(recipe.getBottomIngredient(1));
        recipeLayout.addSlot(RecipeIngredientRole.INPUT, 49, 49).addIngredients(recipe.getBottomIngredient(2));
        recipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 91, 28).addItemStack(recipe.getResultItemStack());
    }

    public RecipeType<UpgradeStationRecipe> getRecipeType() {
        return PocketsRecipeTypes.UPGRADING;
    }
}

