/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.integration.jei;

import com.tcn.cosmoslibrary.integration.jei.CosmosJEIHelper;
import com.tcn.dimensionalpocketsii.core.management.PocketsRecipeManager;
import com.tcn.dimensionalpocketsii.core.management.PocketsRegistrationManager;
import com.tcn.dimensionalpocketsii.core.recipe.UpgradeStationRecipe;
import com.tcn.dimensionalpocketsii.integration.jei.CategoryUpgradeStation;
import com.tcn.dimensionalpocketsii.integration.jei.PocketsRecipeTypes;
import com.tcn.dimensionalpocketsii.pocket.client.container.ContainerModuleBlastFurnace;
import com.tcn.dimensionalpocketsii.pocket.client.container.ContainerModuleCrafter;
import com.tcn.dimensionalpocketsii.pocket.client.container.ContainerModuleFurnace;
import com.tcn.dimensionalpocketsii.pocket.client.container.ContainerModuleSmithingTable;
import com.tcn.dimensionalpocketsii.pocket.client.container.ContainerModuleUpgradeStation;
import com.tcn.dimensionalpocketsii.pocket.client.screen.ScreenModuleAnvil;
import com.tcn.dimensionalpocketsii.pocket.client.screen.ScreenModuleBlastFurnace;
import com.tcn.dimensionalpocketsii.pocket.client.screen.ScreenModuleCrafter;
import com.tcn.dimensionalpocketsii.pocket.client.screen.ScreenModuleFurnace;
import com.tcn.dimensionalpocketsii.pocket.client.screen.ScreenModuleSmithingTable;
import com.tcn.dimensionalpocketsii.pocket.client.screen.ScreenModuleUpgradeStation;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class DimensionalJEIPlugin
implements IModPlugin {
    private IRecipeCategory<UpgradeStationRecipe> UPGRADE_STATION_CATEGORY;

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"dimensionalpocketsii", (String)"integration_jei");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[1];
        this.UPGRADE_STATION_CATEGORY = new CategoryUpgradeStation(guiHelper);
        iRecipeCategoryArray[0] = this.UPGRADE_STATION_CATEGORY;
        registration.addRecipeCategories(iRecipeCategoryArray);
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(PocketsRecipeTypes.UPGRADING, CosmosJEIHelper.getInstance().getRecipes(this.UPGRADE_STATION_CATEGORY, (net.minecraft.world.item.crafting.RecipeType)PocketsRecipeManager.RECIPE_TYPE_UPGRADE_STATION.get()));
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(ContainerModuleUpgradeStation.class, (MenuType)PocketsRegistrationManager.CONTAINER_TYPE_UPGRADE_STATION.get(), PocketsRecipeTypes.UPGRADING, 0, 9, 10, 36);
        registration.addRecipeTransferHandler(ContainerModuleCrafter.class, (MenuType)PocketsRegistrationManager.CONTAINER_TYPE_CRAFTER.get(), RecipeTypes.CRAFTING, 1, 9, 10, 36);
        registration.addRecipeTransferHandler(ContainerModuleSmithingTable.class, (MenuType)PocketsRegistrationManager.CONTAINER_TYPE_SMITHING_TABLE.get(), RecipeTypes.SMITHING, 0, 3, 3, 36);
        registration.addRecipeTransferHandler(ContainerModuleFurnace.class, (MenuType)PocketsRegistrationManager.CONTAINER_TYPE_FURNACE.get(), RecipeTypes.SMELTING, 0, 1, 3, 36);
        registration.addRecipeTransferHandler(ContainerModuleFurnace.class, (MenuType)PocketsRegistrationManager.CONTAINER_TYPE_FURNACE.get(), RecipeTypes.FUELING, 1, 1, 3, 36);
        registration.addRecipeTransferHandler(ContainerModuleBlastFurnace.class, (MenuType)PocketsRegistrationManager.CONTAINER_TYPE_BLAST_FURNACE.get(), RecipeTypes.BLASTING, 0, 1, 3, 36);
        registration.addRecipeTransferHandler(ContainerModuleBlastFurnace.class, (MenuType)PocketsRegistrationManager.CONTAINER_TYPE_BLAST_FURNACE.get(), RecipeTypes.FUELING, 1, 1, 3, 36);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)PocketsRegistrationManager.MODULE_UPGRADE_STATION.get()), new RecipeType[]{PocketsRecipeTypes.UPGRADING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)PocketsRegistrationManager.MODULE_CRAFTER.get()), new RecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)PocketsRegistrationManager.MODULE_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)PocketsRegistrationManager.MODULE_BLAST_FURNACE.get()), new RecipeType[]{RecipeTypes.BLASTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)PocketsRegistrationManager.MODULE_SMITHING_TABLE.get()), new RecipeType[]{RecipeTypes.SMITHING});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(ScreenModuleUpgradeStation.class, 116, 38, 20, 24, new RecipeType[]{PocketsRecipeTypes.UPGRADING});
        registration.addRecipeClickArea(ScreenModuleFurnace.class, 76, 35, 22, 15, new RecipeType[]{RecipeTypes.SMELTING});
        registration.addRecipeClickArea(ScreenModuleBlastFurnace.class, 76, 35, 22, 15, new RecipeType[]{RecipeTypes.BLASTING});
        registration.addRecipeClickArea(ScreenModuleCrafter.class, 94, 35, 22, 15, new RecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeClickArea(ScreenModuleSmithingTable.class, 72, 52, 22, 14, new RecipeType[]{RecipeTypes.SMITHING});
        registration.addRecipeClickArea(ScreenModuleAnvil.class, 105, 56, 22, 15, new RecipeType[]{RecipeTypes.ANVIL});
    }
}

