/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.pocket.client.container;

import com.tcn.cosmoslibrary.client.container.CosmosContainerMenuBlockEntity;
import com.tcn.cosmoslibrary.client.container.slot.SlotBucket;
import com.tcn.cosmoslibrary.client.container.slot.SlotBurnableItem;
import com.tcn.cosmoslibrary.client.container.slot.SlotRestrictedAccess;
import com.tcn.dimensionalpocketsii.core.management.PocketsRegistrationManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ContainerModuleGenerator
extends CosmosContainerMenuBlockEntity {
    private final ContainerData data;
    final EquipmentSlot[] SLOT_IDS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};

    public ContainerModuleGenerator(int indexIn, Inventory playerInventoryIn, FriendlyByteBuf extraData) {
        this(indexIn, playerInventoryIn, (Container)new SimpleContainer(8), (ContainerData)new SimpleContainerData(2), ContainerLevelAccess.NULL, extraData.readBlockPos());
    }

    public ContainerModuleGenerator(int indexIn, Inventory playerInventoryIn, Container contentsIn, ContainerData containerDataIn, ContainerLevelAccess accessIn, BlockPos posIn) {
        super((MenuType)PocketsRegistrationManager.CONTAINER_TYPE_GENERATOR.get(), indexIn, playerInventoryIn, accessIn, posIn);
        this.data = containerDataIn;
        this.addSlot((Slot)new SlotBurnableItem(contentsIn, 0, 73, 24));
        this.addSlot((Slot)new SlotBucket(contentsIn, 1, 126, 19));
        this.addSlot((Slot)new SlotRestrictedAccess(contentsIn, 2, 126, 40, false, true));
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.addSlot(new Slot((Container)playerInventoryIn, i1 + k * 9 + 9, 12 + i1 * 18, 99 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.addSlot(new Slot((Container)playerInventoryIn, l, 12 + l * 18, 157));
        }
    }

    public void addSlotListener(ContainerListener listenerIn) {
        super.addSlotListener(listenerIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void removeSlotListener(ContainerListener listenerIn) {
        super.removeSlotListener(listenerIn);
    }

    public void slotsChanged(Container inventoryIn) {
        super.slotsChanged(inventoryIn);
        this.broadcastChanges();
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
    }

    public boolean stillValid(Player playerIn) {
        return ContainerModuleGenerator.stillValid((ContainerLevelAccess)this.access, (Player)playerIn, (Block)((Block)PocketsRegistrationManager.BLOCK_WALL_GENERATOR.get()));
    }

    public ItemStack quickMoveStack(Player playerIn, int indexIn) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(indexIn);
        boolean flag = slot.mayPickup(playerIn);
        if (flag && slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (indexIn >= 0 && indexIn < 3 ? !this.moveItemStackTo(itemstack1, 4, this.slots.size() - 9, false) : indexIn >= 3 && indexIn < this.slots.size() && (itemstack.getItem() instanceof BucketItem ? !this.moveItemStackTo(itemstack1, 1, indexIn, false) : (itemstack.getBurnTime(null) > 0 ? !this.moveItemStackTo(itemstack1, 0, 3, false) : (indexIn >= this.slots.size() - 9 && indexIn < this.slots.size() ? !this.moveItemStackTo(itemstack1, 0, this.slots.size() - 9, false) : indexIn >= 3 && indexIn < this.slots.size() - 9 && !this.moveItemStackTo(itemstack1, this.slots.size() - 9, this.slots.size(), false))))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack != null ? itemstack : ItemStack.EMPTY;
    }
}

