/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.pocket.client.container;

import com.tcn.cosmoslibrary.client.container.CosmosContainerMenuBlockEntity;
import com.tcn.cosmoslibrary.client.container.slot.SlotArmourItem;
import com.tcn.cosmoslibrary.client.container.slot.SlotRestrictedAccess;
import com.tcn.dimensionalpocketsii.core.management.PocketsRecipeManager;
import com.tcn.dimensionalpocketsii.core.management.PocketsRegistrationManager;
import com.tcn.dimensionalpocketsii.core.management.PocketsSoundManager;
import com.tcn.dimensionalpocketsii.core.recipe.UpgradeStationRecipe;
import com.tcn.dimensionalpocketsii.core.recipe.UpgradingRecipeInput;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ContainerModuleUpgradeStation
extends CosmosContainerMenuBlockEntity {
    protected final ResultContainer resultSlots = new ResultContainer();
    protected final Container inputSlots = new SimpleContainer(9){

        public void setChanged() {
            super.setChanged();
            ContainerModuleUpgradeStation.this.slotsChanged((Container)this);
        }
    };
    @Nullable
    private RecipeHolder<UpgradeStationRecipe> selectedRecipe;

    public ContainerModuleUpgradeStation(int indexIn, Inventory playerInventoryIn, FriendlyByteBuf extraData) {
        this(indexIn, playerInventoryIn, ContainerLevelAccess.NULL, extraData.readBlockPos());
    }

    public ContainerModuleUpgradeStation(int indexIn, Inventory playerInventoryIn, ContainerLevelAccess accessIn, BlockPos posIn) {
        super((MenuType)PocketsRegistrationManager.CONTAINER_TYPE_UPGRADE_STATION.get(), indexIn, playerInventoryIn, accessIn, posIn);
        this.addSlot((Slot)new SlotRestrictedAccess(this.inputSlots, 0, 76, 42, 1, true, true));
        this.addSlot((Slot)new SlotRestrictedAccess(this.inputSlots, 1, 55, 21, 1, true, true));
        this.addSlot((Slot)new SlotRestrictedAccess(this.inputSlots, 2, 76, 21, 1, true, true));
        this.addSlot((Slot)new SlotRestrictedAccess(this.inputSlots, 3, 97, 21, 1, true, true));
        this.addSlot((Slot)new SlotRestrictedAccess(this.inputSlots, 4, 55, 42, 1, true, true));
        this.addSlot((Slot)new SlotRestrictedAccess(this.inputSlots, 5, 97, 42, 1, true, true));
        this.addSlot((Slot)new SlotRestrictedAccess(this.inputSlots, 6, 55, 63, 1, true, true));
        this.addSlot((Slot)new SlotRestrictedAccess(this.inputSlots, 7, 76, 63, 1, true, true));
        this.addSlot((Slot)new SlotRestrictedAccess(this.inputSlots, 8, 97, 63, 1, true, true));
        this.addSlot((Slot)new SlotRestrictedAccess((Container)this.resultSlots, 9, 139, 42, false, true){

            public boolean mayPlace(ItemStack stackIn) {
                return false;
            }

            public boolean mayPickup(Player playerIn) {
                return ContainerModuleUpgradeStation.this.mayPickup(playerIn, this.hasItem());
            }

            public void onTake(Player playerIn, ItemStack stackIn) {
                ContainerModuleUpgradeStation.this.onTake(playerIn, stackIn);
            }
        });
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.addSlot(new Slot((Container)playerInventoryIn, i1 + k * 9 + 9, 12 + i1 * 18, 102 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.addSlot(new Slot((Container)playerInventoryIn, l, 12 + l * 18, 160));
        }
        this.addSlot((Slot)new SlotArmourItem(playerInventoryIn, 39, 25, 15, this.player, 0));
        this.addSlot((Slot)new SlotArmourItem(playerInventoryIn, 38, 25, 33, this.player, 1));
        this.addSlot((Slot)new SlotArmourItem(playerInventoryIn, 37, 25, 51, this.player, 2));
        this.addSlot((Slot)new SlotArmourItem(playerInventoryIn, 36, 25, 69, this.player, 3));
    }

    protected boolean mayPickup(Player player, boolean hasStack) {
        return this.selectedRecipe != null && ((UpgradeStationRecipe)this.selectedRecipe.value()).matches(this.createRecipeInput(), this.getLevel());
    }

    public void slotsChanged(Container containerIn) {
        super.slotsChanged(containerIn);
        if (containerIn == this.inputSlots) {
            this.access.execute((level, pos) -> this.createResult((Level)level, this.player));
        }
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        this.access.execute((level, pos) -> this.clearContainer(playerIn, this.inputSlots));
    }

    public boolean stillValid(Player playerIn) {
        return ContainerModuleUpgradeStation.stillValid((ContainerLevelAccess)this.access, (Player)playerIn, (Block)((Block)PocketsRegistrationManager.BLOCK_WALL_UPGRADE_STATION.get()));
    }

    public void addSlotListener(ContainerListener listenerIn) {
        super.addSlotListener(listenerIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void removeSlotListener(ContainerListener listenerIn) {
        super.removeSlotListener(listenerIn);
    }

    protected void onTake(Player playerIn, ItemStack stackIn) {
        stackIn.onCraftedBy(playerIn.level(), playerIn, stackIn.getCount());
        this.resultSlots.awardUsedRecipes(playerIn, this.getRelevantItems());
        for (int i = 0; i < 9; ++i) {
            if (this.inputSlots.getItem(i).isEmpty()) continue;
            this.shrinkStackInSlot(i);
        }
        this.player.level().playSound(playerIn, this.getBlockPos(), (SoundEvent)PocketsSoundManager.TINK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private List<ItemStack> getRelevantItems() {
        return List.of(this.resultSlots.getItem(0));
    }

    private UpgradingRecipeInput createRecipeInput() {
        return new UpgradingRecipeInput(this.inputSlots.getItem(0), this.inputSlots.getItem(1), this.inputSlots.getItem(2), this.inputSlots.getItem(3), this.inputSlots.getItem(4), this.inputSlots.getItem(5), this.inputSlots.getItem(6), this.inputSlots.getItem(7), this.inputSlots.getItem(8));
    }

    private void shrinkStackInSlot(int slotIndex) {
        ItemStack itemstack = this.inputSlots.getItem(slotIndex);
        itemstack.shrink(1);
        this.inputSlots.setItem(slotIndex, itemstack);
    }

    public void createResult(Level levelIn, Player playerIn) {
        if (!levelIn.isClientSide) {
            UpgradingRecipeInput recipeInput = this.createRecipeInput();
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            ItemStack itemstack = ItemStack.EMPTY;
            Optional optional = levelIn.getServer().getRecipeManager().getRecipeFor((RecipeType)PocketsRecipeManager.RECIPE_TYPE_UPGRADE_STATION.get(), (RecipeInput)recipeInput, levelIn);
            for (int i = 0; i < 9; ++i) {
            }
            if (optional.isPresent()) {
                ItemStack itemstack1;
                RecipeHolder recipeholder = (RecipeHolder)optional.get();
                UpgradeStationRecipe craftingrecipe = (UpgradeStationRecipe)recipeholder.value();
                this.selectedRecipe = recipeholder;
                if (this.resultSlots.setRecipeUsed(levelIn, serverPlayer, recipeholder) && (itemstack1 = craftingrecipe.assemble(recipeInput, (HolderLookup.Provider)levelIn.registryAccess())).isItemEnabled(levelIn.enabledFeatures())) {
                    itemstack = itemstack1;
                }
            }
            this.resultSlots.setRecipeUsed(this.selectedRecipe);
            this.resultSlots.setItem(0, itemstack);
        }
    }

    public ItemStack quickMoveStack(Player playerIn, int indexIn) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(indexIn);
        boolean flag = slot.mayPickup(playerIn);
        if (flag && slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (indexIn == 0 ? (itemstack.getItem() instanceof ArmorItem ? !this.moveItemStackTo(itemstack1, this.slots.size() - 4, this.slots.size(), false) && !this.moveItemStackTo(itemstack1, 11, this.slots.size() - 13, false) : !this.moveItemStackTo(itemstack1, 11, this.slots.size() - 13, false)) : (indexIn >= 1 && indexIn <= 9 ? !this.moveItemStackTo(itemstack1, 10, this.slots.size() - 9, false) : indexIn > 9 && indexIn < this.slots.size() && (itemstack.getItem() instanceof ArmorItem && indexIn < this.slots.size() - 4 ? !this.moveItemStackTo(itemstack1, 0, 1, false) && !this.moveItemStackTo(itemstack1, this.slots.size() - 4, this.slots.size(), false) : !this.moveItemStackTo(itemstack1, 0, 9, false)))) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public boolean canTakeItemForPickAll(ItemStack stackIn, Slot slotIn) {
        return slotIn.container != this.resultSlots && super.canTakeItemForPickAll(stackIn, slotIn);
    }
}

