/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.pocket.client.screen;

import com.tcn.cosmoslibrary.client.container.CosmosContainerMenuBlockEntity;
import com.tcn.cosmoslibrary.client.ui.CosmosUISystem;
import com.tcn.cosmoslibrary.client.ui.screen.CosmosScreenBlockEntityUI;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IBEUIMode;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.dimensionalpocketsii.PocketReference;
import com.tcn.dimensionalpocketsii.client.screen.button.DimensionalButton;
import com.tcn.dimensionalpocketsii.pocket.client.container.ContainerFocus;
import com.tcn.dimensionalpocketsii.pocket.core.block.entity.BlockEntityFocus;
import com.tcn.dimensionalpocketsii.pocket.network.packet.misc.PacketFocus;
import java.util.Arrays;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class ScreenFocus
extends CosmosScreenBlockEntityUI<ContainerFocus> {
    private DimensionalButton jumpEnabledButton;
    private DimensionalButton shiftEnabledButton;

    public ScreenFocus(ContainerFocus containerIn, Inventory inventoryIn, Component componentIn) {
        super((CosmosContainerMenuBlockEntity)containerIn, inventoryIn, componentIn);
        this.setImageDims(172, 144);
        this.setLight(PocketReference.GUI.RESOURCE.FOCUS[0]);
        this.setDark(PocketReference.GUI.RESOURCE.FOCUS[1]);
        this.setUIModeButtonIndex(134, 5);
        this.setTitleLabelDims(36, 5);
        this.setInventoryLabelDims(5, 55);
    }

    protected void init() {
        super.init();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(graphics, partialTicks, mouseX, mouseY);
        BlockEntity blockEntity = this.getBlockEntity();
        if (blockEntity instanceof BlockEntityFocus) {
            BlockEntityFocus blockEntity2 = (BlockEntityFocus)blockEntity;
            CosmosUISystem.Render.renderStaticElementWithUIMode((GuiGraphics)graphics, (int[])this.getScreenCoords(), (int)0, (int)0, (int)0, (int)0, (int)this.imageWidth, (int)this.imageHeight, (IBEUIMode)blockEntity2, (ResourceLocation[])PocketReference.GUI.RESOURCE.FOCUS_SLOTS);
        }
    }

    public void renderStandardHoverEffect(GuiGraphics graphics, Style style, int mouseX, int mouseY) {
        BlockEntity blockEntity = this.getBlockEntity();
        if (blockEntity instanceof BlockEntityFocus) {
            BlockEntityFocus blockEntity2 = (BlockEntityFocus)blockEntity;
            if (this.jumpEnabledButton.isMouseOver(mouseX, mouseY)) {
                state = blockEntity2.getJump();
                Component[] comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.focus.jump_info"), ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.focus.jump_value").append((Component)state.getColouredComp())};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
            } else if (this.shiftEnabledButton.isMouseOver(mouseX, mouseY)) {
                state = blockEntity2.getShift();
                Component[] comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.focus.shift_info"), ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.focus.shift_value").append((Component)state.getColouredComp())};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
            }
        }
    }

    protected void addButtons() {
        super.addButtons();
        BlockEntity blockEntity = this.getBlockEntity();
        if (blockEntity instanceof BlockEntityFocus) {
            BlockEntityFocus blockEntity2 = (BlockEntityFocus)blockEntity;
            this.jumpEnabledButton = (DimensionalButton)this.addRenderableWidget((GuiEventListener)new DimensionalButton(this.getScreenCoords()[0] + 93, this.getScreenCoords()[1] + 19, 20, true, true, blockEntity2.getJumpEnabled() ? 26 : 27, (Component)ComponentHelper.empty(), button -> this.clickButton(button, true), button -> (MutableComponent)button.get()));
            this.shiftEnabledButton = (DimensionalButton)this.addRenderableWidget((GuiEventListener)new DimensionalButton(this.getScreenCoords()[0] + 59, this.getScreenCoords()[1] + 19, 20, true, true, blockEntity2.getShiftEnabled() ? 28 : 29, (Component)ComponentHelper.empty(), button -> this.clickButton(button, true), button -> (MutableComponent)button.get()));
        }
    }

    protected void clickButton(Button button, boolean isLeftClick) {
        BlockEntity blockEntity;
        super.clickButton(button, isLeftClick);
        if (isLeftClick && (blockEntity = this.getBlockEntity()) instanceof BlockEntityFocus) {
            BlockEntityFocus blockEntity2 = (BlockEntityFocus)blockEntity;
            if (button.equals((Object)this.jumpEnabledButton)) {
                state = blockEntity2.getJump();
                PacketDistributor.sendToServer((CustomPacketPayload)new PacketFocus(((ContainerFocus)this.menu).getBlockPos(), !state.getValue(), true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                blockEntity2.setJumpEnabled(!state.getValue());
            } else if (button.equals((Object)this.shiftEnabledButton)) {
                state = blockEntity2.getShift();
                PacketDistributor.sendToServer((CustomPacketPayload)new PacketFocus(((ContainerFocus)this.menu).getBlockPos(), !state.getValue(), false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                blockEntity2.setJumpEnabled(!state.getValue());
            }
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }
}

