/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.pocket.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tcn.cosmoslibrary.client.container.CosmosContainerMenuBlockEntity;
import com.tcn.cosmoslibrary.client.ui.CosmosUISystem;
import com.tcn.cosmoslibrary.client.ui.screen.CosmosScreenBlockEntityUI;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IBEUIMode;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.dimensionalpocketsii.PocketReference;
import com.tcn.dimensionalpocketsii.pocket.client.container.ContainerModuleAnvil;
import com.tcn.dimensionalpocketsii.pocket.core.Pocket;
import com.tcn.dimensionalpocketsii.pocket.core.block.entity.BlockEntityModuleAnvil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundRenameItemPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ScreenModuleAnvil
extends CosmosScreenBlockEntityUI<ContainerModuleAnvil>
implements ContainerListener {
    private static final Component TOO_EXPENSIVE_TEXT = Component.translatable((String)"container.repair.expensive");
    private EditBox textField;
    private int[] textFieldI = new int[]{48, 28, 103, 12};

    public ScreenModuleAnvil(ContainerModuleAnvil containerIn, Inventory playerInventoryIn, Component titleIn) {
        super((CosmosContainerMenuBlockEntity)containerIn, playerInventoryIn, titleIn);
        this.setImageDims(184, 177);
        this.setLight(PocketReference.GUI.RESOURCE.ANVIL[0]);
        this.setDark(PocketReference.GUI.RESOURCE.ANVIL[1]);
        this.setUIModeButtonIndex(167, 5);
        this.setUIHelpButtonIndex(167, 33);
        this.setUILockButtonIndex(167, 19);
        this.setUIHelpElementDeadzone(23, 13, 160, 86);
        this.setTitleLabelDims(this.imageWidth / 2 - 38, 4);
        this.setInventoryLabelDims(8, 75);
        this.setHasEditBox();
    }

    protected void init() {
        super.init();
        ((ContainerModuleAnvil)this.menu).addSlotListener(this);
    }

    public void removed() {
        super.removed();
        ((ContainerModuleAnvil)this.menu).removeSlotListener(this);
    }

    public void containerTick() {
        super.containerTick();
    }

    public void resize(Minecraft minecraftIn, int widthIn, int heightIn) {
        String beforeValue = this.textField.getValue();
        this.init(minecraftIn, widthIn, heightIn);
        this.textField.setValue(beforeValue);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.textField.render(graphics, mouseX, mouseY, partialTicks);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(graphics, partialTicks, mouseX, mouseY);
        BlockEntity entity = this.getBlockEntity();
        if (entity instanceof BlockEntityModuleAnvil) {
            BlockEntityModuleAnvil blockEntity = (BlockEntityModuleAnvil)entity;
            if (blockEntity.getPocket() != null) {
                Pocket pocket = blockEntity.getPocket();
                int decimal = pocket.getDisplayColour();
                ComponentColour colour = ComponentColour.col((int)decimal);
                float[] rgb = null;
                rgb = colour.equals((Object)ComponentColour.POCKET_PURPLE) ? ComponentColour.rgbFloatArray((int)ComponentColour.POCKET_PURPLE_LIGHT.dec()) : ComponentColour.rgbFloatArray((int)decimal);
                CosmosUISystem.Render.renderStaticElementWithUIMode((GuiGraphics)graphics, (int[])this.getScreenCoords(), (int)0, (int)0, (int)0, (int)0, (int)this.imageWidth, (int)this.imageHeight, (float[])new float[]{rgb[0], rgb[1], rgb[2], 1.0f}, (IBEUIMode)blockEntity, (ResourceLocation[])PocketReference.GUI.RESOURCE.ANVIL_BASE);
            }
            CosmosUISystem.Render.renderStaticElementWithUIMode((GuiGraphics)graphics, (int[])this.getScreenCoords(), (int)0, (int)0, (int)0, (int)0, (int)this.imageWidth, (int)this.imageHeight, (IBEUIMode)blockEntity, (ResourceLocation[])PocketReference.GUI.RESOURCE.ANVIL_OVERLAY);
            CosmosUISystem.Render.renderStaticElementWithUIMode((GuiGraphics)graphics, (int[])this.getScreenCoords(), (int)45, (int)24, (int)0, (int)(this.imageHeight + (((ContainerModuleAnvil)this.menu).getSlot(0).hasItem() ? 0 : 16)), (int)110, (int)16, (IBEUIMode)blockEntity, (ResourceLocation[])PocketReference.GUI.RESOURCE.ANVIL_OVERLAY);
            if ((((ContainerModuleAnvil)this.menu).getSlot(0).hasItem() || ((ContainerModuleAnvil)this.menu).getSlot(1).hasItem()) && !((ContainerModuleAnvil)this.menu).getSlot(2).hasItem()) {
                CosmosUISystem.Render.renderStaticElementWithUIMode((GuiGraphics)graphics, (int[])this.getScreenCoords(), (int)102, (int)49, (int)this.imageWidth, (int)0, (int)28, (int)21, (IBEUIMode)blockEntity, (ResourceLocation[])PocketReference.GUI.RESOURCE.ANVIL_OVERLAY);
            }
        }
    }

    protected void renderLabels(GuiGraphics graphicsIn, int mouseX, int mouseY) {
        RenderSystem.disableBlend();
        super.renderLabels(graphicsIn, mouseX, mouseY);
        int i = ((ContainerModuleAnvil)this.menu).getCost();
        if (i > 0) {
            Component component;
            int j = 8453920;
            if (i >= 40 && !this.minecraft.player.getAbilities().instabuild) {
                component = TOO_EXPENSIVE_TEXT;
                j = 0xFF6060;
            } else if (!((ContainerModuleAnvil)this.menu).getSlot(2).hasItem()) {
                component = null;
            } else {
                component = Component.translatable((String)"container.repair.cost", (Object[])new Object[]{i});
                if (!((ContainerModuleAnvil)this.menu).getSlot(2).mayPickup(((ContainerModuleAnvil)this.menu).getPlayer())) {
                    j = 0xFF6060;
                }
            }
            if (component != null) {
                int k = this.imageWidth - 9 - this.font.width((FormattedText)component) - 2;
                graphicsIn.fill(k - 2, 74, this.imageWidth - 8, 83, 0x4F000000);
                graphicsIn.drawString(this.font, component.getString(), (float)k + 1.0f, 75.0f, j, true);
            }
        }
    }

    protected void addUIHelpElements() {
        super.addUIHelpElements();
        this.addRenderableUIHelpElement(this.getScreenCoords(), 28, 49, 20, 20, ComponentColour.LIGHT_BLUE, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_BLUE, (String)"dimensionalpocketsii.gui.help.anvil.input_slot_a"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.anvil.input_slot_a_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.anvil.input_slot_a_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 77, 49, 20, 20, ComponentColour.LIGHT_BLUE, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_BLUE, (String)"dimensionalpocketsii.gui.help.anvil.input_slot_b"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.anvil.input_slot_b_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.anvil.input_slot_b_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 136, 49, 20, 20, ComponentColour.RED, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.RED, (String)"dimensionalpocketsii.gui.help.anvil.output_slot"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.anvil.output_slot_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.anvil.output_slot_two")});
    }

    protected boolean isHovering(int positionX, int positionY, int width, int height, double mouseX, double mouseY) {
        return super.isHovering(positionX, positionY, width, height, mouseX, mouseY);
    }

    public void initEditBox() {
        super.initEditBox();
        this.textField = new EditBox(this.font, this.getScreenCoords()[0] + this.textFieldI[0], this.getScreenCoords()[1] + this.textFieldI[1], this.textFieldI[2], this.textFieldI[3], (Component)ComponentHelper.comp((String)"Allowed Player Entry"));
        this.textField.setMaxLength(50);
        this.textField.setResponder(this::onNameChanged);
        this.textField.setVisible(true);
        this.textField.setTextColor(0xFFFFFF);
        this.textField.setTextColorUneditable(-1);
        this.textField.setBordered(false);
        this.textField.setCanLoseFocus(true);
        this.textField.setEditable(true);
        this.textField.setValue("");
        this.addWidget((GuiEventListener)this.textField);
        this.setInitialFocus((GuiEventListener)this.textField);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return this.textField.mouseClicked(mouseX, mouseY, mouseButton) ? true : super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double directionX, double directionY) {
        return this.textField.mouseScrolled(mouseX, mouseY, directionX, directionY) ? true : super.mouseScrolled(mouseX, mouseY, directionX, directionY);
    }

    public boolean keyPressed(int keyCode, int mouseX, int mouseY) {
        if (keyCode == 256) {
            if (this.textField.isFocused()) {
                this.textField.setFocused(false);
            } else {
                this.minecraft.player.closeContainer();
            }
        }
        return !this.textField.keyPressed(keyCode, mouseX, mouseY) && !this.textField.canConsumeInput() ? super.keyPressed(keyCode, mouseX, mouseY) : true;
    }

    public boolean charTyped(char charIn, int p_98522_) {
        return !this.textField.charTyped(charIn, p_98522_) && !this.textField.canConsumeInput() ? super.charTyped(charIn, p_98522_) : true;
    }

    protected void slotClicked(Slot slotIn, int mouseX, int mouseY, ClickType clickTypeIn) {
        super.slotClicked(slotIn, mouseX, mouseY, clickTypeIn);
    }

    public void slotChanged(AbstractContainerMenu menuIn, int slotId, ItemStack stackIn) {
        if (slotId == 0) {
            this.textField.setValue(stackIn.isEmpty() ? "" : stackIn.getHoverName().getString());
            this.textField.setEditable(!stackIn.isEmpty());
            this.setFocused((GuiEventListener)this.textField);
        }
    }

    public void dataChanged(AbstractContainerMenu menuIn, int slotId, int dataId) {
    }

    private void onNameChanged(String nameIn) {
        if (!nameIn.isEmpty()) {
            String s = nameIn;
            Slot slot = ((ContainerModuleAnvil)this.menu).getSlot(0);
            if (slot != null && slot.hasItem() && !slot.getItem().has(DataComponents.CUSTOM_NAME) && nameIn.equals(slot.getItem().getHoverName().getString())) {
                s = "";
            }
            ((ContainerModuleAnvil)this.menu).setItemName(s);
            this.minecraft.player.connection.send((Packet)new ServerboundRenameItemPacket(s));
        }
    }
}

