/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.pocket.client.screen;

import com.ibm.icu.text.DecimalFormat;
import com.tcn.cosmoslibrary.client.container.CosmosContainerMenuBlockEntity;
import com.tcn.cosmoslibrary.client.ui.CosmosUISystem;
import com.tcn.cosmoslibrary.client.ui.screen.CosmosScreenBlockEntityUI;
import com.tcn.cosmoslibrary.client.ui.screen.widget.CosmosButtonWithType;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IBEUIMode;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IEnergyHolder;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.dimensionalpocketsii.PocketReference;
import com.tcn.dimensionalpocketsii.pocket.client.container.ContainerModuleCharger;
import com.tcn.dimensionalpocketsii.pocket.core.Pocket;
import com.tcn.dimensionalpocketsii.pocket.core.block.entity.BlockEntityModuleCharger;
import com.tcn.dimensionalpocketsii.pocket.network.packet.misc.PacketChargerEnergyState;
import java.util.Arrays;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class ScreenModuleCharger
extends CosmosScreenBlockEntityUI<ContainerModuleCharger> {
    private CosmosButtonWithType energyStateButton;
    private int[] MBI = new int[]{83, 80};

    public ScreenModuleCharger(ContainerModuleCharger containerIn, Inventory playerInventoryIn, Component titleIn) {
        super((CosmosContainerMenuBlockEntity)containerIn, playerInventoryIn, titleIn);
        this.setImageDims(184, 206);
        this.setLight(PocketReference.GUI.RESOURCE.CHARGER[0]);
        this.setDark(PocketReference.GUI.RESOURCE.CHARGER[1]);
        this.setUIModeButtonIndex(167, 5);
        this.setUIHelpButtonIndex(167, 33);
        this.setUILockButtonIndex(167, 19);
        this.setUIHelpElementDeadzone(28, 13, 155, 104);
        this.setTitleLabelDims(53, 4);
        this.setInventoryLabelDims(8, 107);
    }

    protected void init() {
        super.init();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        BlockEntityModuleCharger blockEntity;
        super.renderBg(graphics, partialTicks, mouseX, mouseY);
        BlockEntity entity = this.getBlockEntity();
        if (entity instanceof BlockEntityModuleCharger && (blockEntity = (BlockEntityModuleCharger)entity).getPocket() != null) {
            Pocket pocket = blockEntity.getPocket();
            int decimal = pocket.getDisplayColour();
            ComponentColour colour = ComponentColour.col((int)decimal);
            float[] rgb = null;
            rgb = colour.equals((Object)ComponentColour.POCKET_PURPLE) ? ComponentColour.rgbFloatArray((int)ComponentColour.POCKET_PURPLE_LIGHT.dec()) : ComponentColour.rgbFloatArray((int)decimal);
            CosmosUISystem.Render.renderStaticElementWithUIMode((GuiGraphics)graphics, (int[])this.getScreenCoords(), (int)0, (int)0, (int)0, (int)0, (int)this.imageWidth, (int)this.imageHeight, (float[])new float[]{rgb[0], rgb[1], rgb[2], 1.0f}, (IBEUIMode)blockEntity, (ResourceLocation[])PocketReference.GUI.RESOURCE.CHARGER_BASE);
            CosmosUISystem.Render.renderStaticElementWithUIMode((GuiGraphics)graphics, (int[])this.getScreenCoords(), (int)0, (int)0, (int)0, (int)0, (int)this.imageWidth, (int)this.imageHeight, (IBEUIMode)blockEntity, (ResourceLocation[])PocketReference.GUI.RESOURCE.CHARGER_OVERLAY);
            CosmosUISystem.Render.renderEnergyDisplay((GuiGraphics)graphics, (ComponentColour)ComponentColour.RED, (IEnergyHolder)pocket, (int[])this.getScreenCoords(), (int)84, (int)23, (int)16, (int)48, (boolean)false);
        }
    }

    public void renderStandardHoverEffect(GuiGraphics graphics, Style style, int mouseX, int mouseY) {
        BlockEntityModuleCharger blockEntity;
        BlockEntity entity = this.getBlockEntity();
        if (entity instanceof BlockEntityModuleCharger && (blockEntity = (BlockEntityModuleCharger)entity).getPocket() != null) {
            Pocket pocket = blockEntity.getPocket();
            if (pocket != null && CosmosUISystem.Hovering.isHovering((int)mouseX, (int)mouseY, (int)(this.getScreenCoords()[0] + 84 - 1), (int)(this.getScreenCoords()[0] + 84 + 16), (int)(this.getScreenCoords()[1] + 24 - 1), (int)(this.getScreenCoords()[1] + 24 + 48 - 1))) {
                DecimalFormat formatter = new DecimalFormat("#,###,###,###");
                String[] energyString = new String[]{formatter.format((long)pocket.getEnergyStored()), formatter.format((long)pocket.getMaxEnergyStored())};
                Component[] comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.energy_bar.pre"), ComponentHelper.style2((ComponentColour)ComponentColour.RED, (String)(energyString[0] + " / " + energyString[1]), (String)"dimensionalpocketsii.gui.energy_bar.suff")};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
            }
            if (this.energyStateButton.isMouseOver((double)mouseX, (double)mouseY)) {
                Component[] comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.charger.mode_info"), ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.charger.mode_value").append((Component)blockEntity.getEnergyState().getColouredComp())};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
            }
        }
        super.renderStandardHoverEffect(graphics, style, mouseX, mouseY);
    }

    protected void addButtons() {
        super.addButtons();
        BlockEntity entity = this.getBlockEntity();
        if (entity instanceof BlockEntityModuleCharger) {
            BlockEntityModuleCharger blockEntity = (BlockEntityModuleCharger)entity;
            this.energyStateButton = (CosmosButtonWithType)this.addRenderableWidget((GuiEventListener)new CosmosButtonWithType(CosmosButtonWithType.TYPE.ENERGY, this.getScreenCoords()[0] + this.MBI[0], this.getScreenCoords()[1] + this.MBI[1], 18, true, true, blockEntity.getEnergyState().getIndex() + 16, (Component)ComponentHelper.empty(), (button, isLeftClick) -> this.clickButton((Button)this.energyStateButton, isLeftClick)));
        }
    }

    public void clickButton(Button button, boolean isLeftClick) {
        BlockEntity entity;
        super.clickButton(button, isLeftClick);
        if (isLeftClick && (entity = this.getBlockEntity()) instanceof BlockEntityModuleCharger) {
            BlockEntityModuleCharger blockEntity = (BlockEntityModuleCharger)entity;
            if (button.equals(this.energyStateButton)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new PacketChargerEnergyState(((ContainerModuleCharger)this.menu).getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                blockEntity.cycleEnergyState();
            }
        }
    }

    protected void addUIHelpElements() {
        super.addUIHelpElements();
        this.addRenderableUIHelpElement(this.getScreenCoords(), 82, 21, 20, 52, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.RED, (String)"dimensionalpocketsii.gui.help.power_display"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.power_display_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.power_display_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 82, 79, 20, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.GREEN, (String)"dimensionalpocketsii.gui.help.charger.mode_button"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.charger.mode_button_one"), ComponentHelper.style((ComponentColour)ComponentColour.GREEN, (String)"dimensionalpocketsii.gui.help.charger.mode_button_two_pre").append((Component)ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.charger.mode_button_two")), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.charger.mode_button_two_"), ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.help.charger.mode_button_two__"), ComponentHelper.style((ComponentColour)ComponentColour.RED, (String)"dimensionalpocketsii.gui.help.charger.mode_button_three_pre").append((Component)ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.charger.mode_button_three")), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.charger.mode_button_three_")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 58, 19, 20, 56, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_RED, (String)"dimensionalpocketsii.gui.help.charger.charge_slot"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.charger.charge_slot_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.charger.charge_slot_two"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.charger.charge_slot_three")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 106, 19, 20, 56, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_RED, (String)"dimensionalpocketsii.gui.help.charger.charge_slot"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.charger.charge_slot_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.charger.charge_slot_two"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.charger.charge_slot_three")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 34, 79, 20, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_BLUE, (String)"dimensionalpocketsii.gui.help.slot.helmet"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.armour_slot"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.armour_slot.helmet")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 58, 79, 20, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_BLUE, (String)"dimensionalpocketsii.gui.help.slot.chestplate"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.armour_slot"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.armour_slot.chestplate")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 106, 79, 20, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_BLUE, (String)"dimensionalpocketsii.gui.help.slot.leggings"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.armour_slot"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.armour_slot.leggings")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 130, 79, 20, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_BLUE, (String)"dimensionalpocketsii.gui.help.slot.boots"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.armour_slot"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.armour_slot.boots")});
    }

    protected boolean isHovering(int positionX, int positionY, int width, int height, double mouseX, double mouseY) {
        return super.isHovering(positionX, positionY, width, height, mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void slotClicked(Slot slotIn, int mouseX, int mouseY, ClickType clickTypeIn) {
        super.slotClicked(slotIn, mouseX, mouseY, clickTypeIn);
    }
}

