/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.pocket.client.screen;

import com.ibm.icu.text.DecimalFormat;
import com.tcn.cosmoslibrary.client.container.CosmosContainerMenuBlockEntity;
import com.tcn.cosmoslibrary.client.ui.CosmosUISystem;
import com.tcn.cosmoslibrary.client.ui.screen.CosmosScreenBlockEntityUI;
import com.tcn.cosmoslibrary.client.ui.screen.widget.CosmosButtonWithType;
import com.tcn.cosmoslibrary.common.enums.EnumGenerationMode;
import com.tcn.cosmoslibrary.common.enums.EnumUIMode;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IBEUIMode;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IEnergyHolder;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.dimensionalpocketsii.PocketReference;
import com.tcn.dimensionalpocketsii.pocket.client.container.ContainerModuleGenerator;
import com.tcn.dimensionalpocketsii.pocket.core.Pocket;
import com.tcn.dimensionalpocketsii.pocket.core.block.entity.BlockEntityModuleGenerator;
import com.tcn.dimensionalpocketsii.pocket.network.packet.misc.PacketGeneratorEmptyTank;
import com.tcn.dimensionalpocketsii.pocket.network.packet.misc.PacketGeneratorMode;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class ScreenModuleGenerator
extends CosmosScreenBlockEntityUI<ContainerModuleGenerator> {
    private CosmosButtonWithType modeChangeButton;
    private int[] MBI = new int[]{41, 60, 18};
    private CosmosButtonWithType buttonTankClear;
    private int[] TBI = new int[]{125, 60, 18};

    public ScreenModuleGenerator(ContainerModuleGenerator containerIn, Inventory playerInventoryIn, Component titleIn) {
        super((CosmosContainerMenuBlockEntity)containerIn, playerInventoryIn, titleIn);
        this.setImageDims(184, 185);
        this.setLight(PocketReference.GUI.RESOURCE.GENERATOR[0]);
        this.setDark(PocketReference.GUI.RESOURCE.GENERATOR[1]);
        this.setUIModeButtonIndex(167, 5);
        this.setUIHelpButtonIndex(167, 33);
        this.setUILockButtonIndex(167, 19);
        this.setUIHelpElementDeadzone(36, 13, 147, 82);
        this.setTitleLabelDims(36, 4);
        this.setInventoryLabelDims(8, 86);
    }

    protected void init() {
        super.init();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        BlockEntityModuleGenerator blockEntity;
        super.renderBg(graphics, partialTicks, mouseX, mouseY);
        BlockEntity entity = this.getBlockEntity();
        if (entity instanceof BlockEntityModuleGenerator && (blockEntity = (BlockEntityModuleGenerator)entity).getPocket() != null) {
            Pocket pocket = blockEntity.getPocket();
            int decimal = pocket.getDisplayColour();
            ComponentColour colour = ComponentColour.col((int)decimal);
            float[] rgb = null;
            rgb = colour.equals((Object)ComponentColour.POCKET_PURPLE) ? ComponentColour.rgbFloatArray((int)ComponentColour.POCKET_PURPLE_LIGHT.dec()) : ComponentColour.rgbFloatArray((int)decimal);
            CosmosUISystem.Render.renderStaticElementWithUIMode((GuiGraphics)graphics, (int[])this.getScreenCoords(), (int)0, (int)0, (int)0, (int)0, (int)this.imageWidth, (int)this.imageHeight, (float[])new float[]{rgb[0], rgb[1], rgb[2], 1.0f}, (IBEUIMode)blockEntity, (ResourceLocation[])PocketReference.GUI.RESOURCE.GENERATOR_BASE);
            CosmosUISystem.Render.renderStaticElementWithUIMode((GuiGraphics)graphics, (int[])this.getScreenCoords(), (int)0, (int)0, (int)0, (int)0, (int)this.imageWidth, (int)this.imageHeight, (IBEUIMode)blockEntity, (ResourceLocation[])PocketReference.GUI.RESOURCE.GENERATOR_OVERLAY);
            CosmosUISystem.Render.renderScaledElementUpNestled((GuiGraphics)graphics, (int[])this.getScreenCoords(), (int)72, (int)54, (int)184, (int)0, (int)18, (int)19, (int)blockEntity.getBurnTimeScaled(19), (ResourceLocation)(blockEntity.getUIMode().equals((Object)EnumUIMode.DARK) ? PocketReference.GUI.RESOURCE.GENERATOR_OVERLAY[1] : PocketReference.GUI.RESOURCE.GENERATOR_OVERLAY[0]));
            CosmosUISystem.Render.renderEnergyDisplay((GuiGraphics)graphics, (ComponentColour)ComponentColour.RED, (IEnergyHolder)pocket, (int[])this.getScreenCoords(), (int)42, (int)19, (int)16, (int)37, (boolean)false);
            CosmosUISystem.Render.renderFluidTank((GuiGraphics)graphics, (int[])this.getScreenCoords(), (int)105, (int)19, (IFluidTank)blockEntity.getFluidTank(), (int)blockEntity.getFluidLevelScaled(58), (int)58);
        }
    }

    protected void renderStandardHoverEffect(GuiGraphics graphics, Style style, int mouseX, int mouseY) {
        BlockEntityModuleGenerator blockEntity;
        BlockEntity entity = this.getBlockEntity();
        if (entity instanceof BlockEntityModuleGenerator && (blockEntity = (BlockEntityModuleGenerator)entity).getPocket() != null) {
            Component[] comp;
            Pocket pocket = blockEntity.getPocket();
            if (pocket != null && CosmosUISystem.Hovering.isHovering((int)mouseX, (int)mouseY, (int)(this.getScreenCoords()[0] + 42 - 1), (int)(this.getScreenCoords()[0] + 42 + 16), (int)(this.getScreenCoords()[1] + 20 - 1), (int)(this.getScreenCoords()[1] + 20 + 37 - 1))) {
                DecimalFormat formatter = new DecimalFormat("#,###,###,###");
                String amount_string = formatter.format((long)pocket.getEnergyStored());
                String capacity_string = formatter.format((long)pocket.getMaxEnergyStored());
                ArrayList<MutableComponent> comp2 = new ArrayList<MutableComponent>();
                comp2.add(ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.energy_bar.pre"));
                comp2.add(ComponentHelper.style2((ComponentColour)ComponentColour.RED, (String)(amount_string + " / " + capacity_string), (String)"dimensionalpocketsii.gui.energy_bar.suff"));
                if (blockEntity.getGenerationMode().equals((Object)EnumGenerationMode.BURNABLE_ITEM)) {
                    if (blockEntity.dataAccess.get(0) > 0) {
                        comp2.add(ComponentHelper.style2((ComponentColour)ComponentColour.ORANGE, (String)"cosmoslibrary.gui.generation.pre", (String)("" + blockEntity.dataAccess.get(2)), (String)"cosmoslibrary.gui.generation.suff"));
                    }
                } else if (blockEntity.dataAccess.get(3) > 0) {
                    comp2.add(ComponentHelper.style2((ComponentColour)ComponentColour.ORANGE, (String)"cosmoslibrary.gui.generation.pre", (String)("" + blockEntity.dataAccess.get(2)), (String)"cosmoslibrary.gui.generation.suff"));
                }
                graphics.renderComponentTooltip(this.font, comp2, mouseX, mouseY);
            }
            if (this.modeChangeButton.isMouseOver((double)mouseX, (double)mouseY)) {
                comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.GREEN, (String)"dimensionalpocketsii.gui.generator.mode_info"), ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.generator.mode_value").append((Component)blockEntity.getGenerationMode().getColouredComp())};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
            }
            if (this.buttonTankClear != null && this.buttonTankClear.isMouseOver((double)mouseX, (double)mouseY) && this.buttonTankClear.isActive()) {
                if (!ScreenModuleGenerator.hasShiftDown()) {
                    graphics.renderTooltip(this.font, (Component)ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.button.tank_clear"), mouseX, mouseY);
                } else {
                    comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.button.tank_clear"), ComponentHelper.style((ComponentColour)ComponentColour.RED, (String)"bold", (String)"dimensionalpocketsii.gui.button.tank_clear_shift")};
                    graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
                }
            }
            if (CosmosUISystem.Hovering.isHovering((int)mouseX, (int)mouseY, (int)(this.getScreenCoords()[0] + 105), (int)(this.getScreenCoords()[0] + 105 + 16), (int)(this.getScreenCoords()[1] + 19), (int)(this.getScreenCoords()[1] + 19 + 58 - 1))) {
                FluidTank tank = blockEntity.getFluidTank();
                DecimalFormat formatter = new DecimalFormat("#,###,###,###");
                String amount_string = formatter.format((long)tank.getFluidAmount());
                String capacity_string = formatter.format((long)tank.getCapacity());
                String fluid_name = tank.getFluid().getTranslationKey();
                Component[] comp3 = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.fluid_bar.pre").append((Component)ComponentHelper.style3((ComponentColour)ComponentColour.ORANGE, (String)"bold", (String)"[ ", (String)fluid_name, (String)" ]")), ComponentHelper.style2((ComponentColour)ComponentColour.CYAN, (String)(amount_string + " / " + capacity_string), (String)"dimensionalpocketsii.gui.fluid_bar.suff")};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp3), mouseX, mouseY);
            }
        }
        super.renderStandardHoverEffect(graphics, style, mouseX, mouseY);
    }

    protected void addButtons() {
        super.addButtons();
        BlockEntity entity = this.getBlockEntity();
        if (entity instanceof BlockEntityModuleGenerator) {
            BlockEntityModuleGenerator blockEntity = (BlockEntityModuleGenerator)entity;
            this.modeChangeButton = (CosmosButtonWithType)this.addRenderableWidget((GuiEventListener)new CosmosButtonWithType(CosmosButtonWithType.TYPE.GENERAL, this.getScreenCoords()[0] + this.MBI[0], this.getScreenCoords()[1] + this.MBI[1], this.MBI[2], true, true, blockEntity.getGenerationModeValue() ? 17 : 20, (Component)ComponentHelper.empty(), (button, isLeftClick) -> this.clickButton((Button)this.modeChangeButton, isLeftClick)));
            this.buttonTankClear = (CosmosButtonWithType)this.addRenderableWidget((GuiEventListener)new CosmosButtonWithType(CosmosButtonWithType.TYPE.FLUID, this.getScreenCoords()[0] + this.TBI[0], this.getScreenCoords()[1] + this.TBI[1], this.TBI[2], !blockEntity.getFluidTank().isEmpty(), true, blockEntity.getFluidTank().isEmpty() ? 15 : 16, (Component)ComponentHelper.empty(), (button, isLeftClick) -> this.clickButton((Button)this.buttonTankClear, isLeftClick)));
        }
    }

    protected void clickButton(Button button, boolean isLeftClick) {
        BlockEntity entity;
        super.clickButton(button, isLeftClick);
        if (isLeftClick && (entity = this.getBlockEntity()) instanceof BlockEntityModuleGenerator) {
            BlockEntityModuleGenerator blockEntity = (BlockEntityModuleGenerator)entity;
            if (button.equals(this.modeChangeButton)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new PacketGeneratorMode(((ContainerModuleGenerator)this.menu).getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                blockEntity.cycleGenerationMode();
            } else if (button.equals(this.buttonTankClear) && ScreenModuleGenerator.hasShiftDown()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new PacketGeneratorEmptyTank(((ContainerModuleGenerator)this.menu).getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                blockEntity.getFluidTank().setFluid(FluidStack.EMPTY);
            }
        }
    }

    protected void addUIHelpElements() {
        super.addUIHelpElements();
        this.addRenderableUIHelpElement(this.getScreenCoords(), 40, 17, 20, 41, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.RED, (String)"dimensionalpocketsii.gui.help.power_display"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.power_display_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.power_display_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 103, 17, 20, 62, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.ORANGE, (String)"dimensionalpocketsii.gui.help.fluid_display"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.generator.fluid_display_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.generator.fluid_display_two"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.generator.fluid_display_three")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 124, 59, 20, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.RED, (String)"dimensionalpocketsii.gui.help.fluid_clear_button"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.fluid_clear_button_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.fluid_clear_button_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 40, 59, 20, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.CYAN, (String)"dimensionalpocketsii.gui.help.generator.mode_button"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.generator.mode_button_one"), ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.help.generator.mode_button_two_pre").append((Component)ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.charger.mode_button_two")), ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.help.generator.mode_button_two__"), ComponentHelper.style((ComponentColour)ComponentColour.ORANGE, (String)"dimensionalpocketsii.gui.help.generator.mode_button_three_pre").append((Component)ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.charger.mode_button_three"))});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 70, 52, 22, 23, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.YELLOW, (String)"dimensionalpocketsii.gui.help.generator.burn_indicator"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.generator.burn_indicator_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.generator.burn_indicator_two"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.generator.burn_indicator_three")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 70, 21, 22, 22, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.help.generator.fuel_slot"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.generator.fuel_slot_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.generator.fuel_slot_two"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.generator.fuel_slot_three")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 124, 17, 20, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_BLUE, (String)"dimensionalpocketsii.gui.help.slot.bucket_input"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.slot.bucket_input_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.slot.bucket_input_two"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.slot.bucket_input_three"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.slot.bucket_input_four")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 124, 38, 20, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.GREEN, (String)"dimensionalpocketsii.gui.help.slot.bucket_output"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.slot.bucket_output_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.slot.bucket_output_two"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.slot.bucket_output_three")});
    }

    protected boolean isHovering(int positionX, int positionY, int width, int height, double mouseX, double mouseY) {
        return super.isHovering(positionX, positionY, width, height, mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void slotClicked(Slot slotIn, int mouseX, int mouseY, ClickType clickTypeIn) {
        super.slotClicked(slotIn, mouseX, mouseY, clickTypeIn);
    }
}

