/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.pocket.client.screen;

import com.ibm.icu.text.DecimalFormat;
import com.tcn.cosmoslibrary.client.container.CosmosContainerMenuBlockEntity;
import com.tcn.cosmoslibrary.client.ui.CosmosUISystem;
import com.tcn.cosmoslibrary.client.ui.screen.CosmosScreenBlockEntityListUI;
import com.tcn.cosmoslibrary.client.ui.screen.widget.CosmosButtonWithType;
import com.tcn.cosmoslibrary.client.ui.screen.widget.CosmosListWidget;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IBEUIMode;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IEnergyHolder;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.dimensionalpocketsii.PocketReference;
import com.tcn.dimensionalpocketsii.client.screen.button.DimensionalButton;
import com.tcn.dimensionalpocketsii.pocket.client.container.ContainerPocket;
import com.tcn.dimensionalpocketsii.pocket.core.Pocket;
import com.tcn.dimensionalpocketsii.pocket.core.block.entity.BlockEntityPocket;
import com.tcn.dimensionalpocketsii.pocket.network.packet.PacketAllowedPlayer;
import com.tcn.dimensionalpocketsii.pocket.network.packet.PacketBlockSideState;
import com.tcn.dimensionalpocketsii.pocket.network.packet.PacketEmptyTank;
import com.tcn.dimensionalpocketsii.pocket.network.packet.PacketHostileSpawnState;
import com.tcn.dimensionalpocketsii.pocket.network.packet.PacketLock;
import com.tcn.dimensionalpocketsii.pocket.network.packet.PacketLockToAllowedPlayers;
import com.tcn.dimensionalpocketsii.pocket.network.packet.PacketTrapPlayers;
import com.tcn.dimensionalpocketsii.pocket.network.packet.block.PacketSideGuide;
import java.util.Arrays;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class ScreenPocket
extends CosmosScreenBlockEntityListUI<ContainerPocket> {
    private int[] energyBarData = new int[]{14, 184};
    private int[] fluidBarData = new int[]{37, 52, 185, 184, 18, 57};
    private CosmosButtonWithType buttonTextClear;
    private int[] TCBI = new int[]{191, 18, 18};
    private CosmosButtonWithType buttonTextPlus;
    private int[] TABI = new int[]{212, 18, 18};
    private CosmosButtonWithType buttonTextMinus;
    private int[] TMBI = new int[]{233, 18, 18};
    private CosmosButtonWithType buttonTankClear;
    private int[] TBCI = new int[]{59, 225, 20};
    private EditBox textField;
    private int[] textFieldI = new int[]{98, 23, 93, 16};
    private DimensionalButton buttonNorth;
    private int[] NBI = new int[]{57, 20, 18};
    private DimensionalButton buttonSouth;
    private int[] SBI = new int[]{15, 63, 18};
    private DimensionalButton buttonUp;
    private int[] UBI = new int[]{15, 20, 18};
    private DimensionalButton buttonDown;
    private int[] DBI = new int[]{36, 20, 18};
    private DimensionalButton buttonEast;
    private int[] EBI = new int[]{57, 63, 18};
    private DimensionalButton buttonWest;
    private int[] WBI = new int[]{36, 63, 18};
    private CosmosButtonWithType buttonLock;
    private int[] LBI = new int[]{13, 124};
    private CosmosButtonWithType buttonAllowedPlayers;
    private int[] APBI = new int[]{36, 124};
    private DimensionalButton buttonTrapPlayers;
    private int[] TPBI = new int[]{59, 124};
    private CosmosButtonWithType buttonHostileSpawn;
    private int[] HSBI = new int[]{24, 145};
    private DimensionalButton buttonSideGuide;
    private int[] SIBI = new int[]{48, 145};

    public ScreenPocket(ContainerPocket containerIn, Inventory playerInventoryIn, Component title) {
        super((CosmosContainerMenuBlockEntity)containerIn, playerInventoryIn, title);
        this.setImageDims(362, 256);
        this.setLight(PocketReference.GUI.RESOURCE.POCKET[0]);
        this.setDark(PocketReference.GUI.RESOURCE.POCKET[1]);
        this.setDualScreen();
        this.setDualScreenIndex(256, 0, 104, 256);
        this.setDualLight(PocketReference.GUI.RESOURCE.POCKET_SIDE[0]);
        this.setDualDark(PocketReference.GUI.RESOURCE.POCKET_SIDE[1]);
        this.setUIModeButtonIndex(345, 5);
        this.setUIHelpButtonIndex(345, 19);
        this.setUIHelpTitleOffset(5);
        this.setUIHelpElementDeadzone(0, 0, 360, 256);
        this.setTitleLabelDims(23, 4);
        this.setInventoryLabelDims(88, 157);
        this.setScrollElementDims(237, 52);
        this.setListDims(94, 52, 138, 98, 14, 0);
        this.setHasEditBox();
    }

    protected void init() {
        super.init();
    }

    public void removed() {
        super.removed();
    }

    public void containerTick() {
        super.containerTick();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.textField.render(graphics, mouseX, mouseY, partialTicks);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        BlockEntityPocket blockEntity;
        super.renderBg(graphics, partialTicks, mouseX, mouseY);
        BlockEntity blockEntity2 = this.getBlockEntity();
        if (blockEntity2 instanceof BlockEntityPocket && (blockEntity = (BlockEntityPocket)blockEntity2).getPocket() != null) {
            Pocket pocket = blockEntity.getPocket();
            ComponentColour colour = ComponentColour.col((int)pocket.getDisplayColour());
            float[] rgb = colour.equals((Object)ComponentColour.POCKET_PURPLE) ? ComponentColour.rgbFloatArray((ComponentColour)ComponentColour.POCKET_PURPLE_LIGHT) : ComponentColour.rgbFloatArray((ComponentColour)colour);
            CosmosUISystem.Render.renderStaticElementWithUIMode((GuiGraphics)graphics, (int[])this.getScreenCoords(), (int)0, (int)0, (int)0, (int)0, (int)256, (int)256, (float[])new float[]{rgb[0], rgb[1], rgb[2], 1.0f}, (IBEUIMode)blockEntity, (ResourceLocation[])PocketReference.GUI.RESOURCE.POCKET_BASE_NORMAL);
            CosmosUISystem.Render.renderStaticElementWithUIMode((GuiGraphics)graphics, (int[])this.getScreenCoords(), (int)256, (int)0, (int)0, (int)0, (int)92, (int)256, (float[])new float[]{rgb[0], rgb[1], rgb[2], 1.0f}, (IBEUIMode)blockEntity, (ResourceLocation[])PocketReference.GUI.RESOURCE.POCKET_BASE_SIDE);
            CosmosUISystem.Render.renderStaticElementWithUIMode((GuiGraphics)graphics, (int[])this.getScreenCoords(), (int)0, (int)0, (int)0, (int)0, (int)256, (int)256, (IBEUIMode)blockEntity, (ResourceLocation[])PocketReference.GUI.RESOURCE.POCKET_OVERLAY_NORMAL);
            CosmosUISystem.Render.renderStaticElementWithUIMode((GuiGraphics)graphics, (int[])this.getScreenCoords(), (int)256, (int)0, (int)0, (int)0, (int)92, (int)256, (IBEUIMode)blockEntity, (ResourceLocation[])PocketReference.GUI.RESOURCE.POCKET_OVERLAY_SIDE);
            CosmosUISystem.Render.renderFluidTank((GuiGraphics)graphics, (int[])this.getScreenCoords(), (int)this.fluidBarData[0], (int)this.fluidBarData[2], (IFluidTank)pocket.getFluidTank(), (int)pocket.getFluidLevelScaled(57), (int)57);
            CosmosUISystem.Render.renderEnergyDisplay((GuiGraphics)graphics, (ComponentColour)ComponentColour.RED, (IEnergyHolder)pocket, (int[])this.getScreenCoords(), (int)this.energyBarData[0], (int)this.energyBarData[1], (int)16, (int)58, (boolean)false);
        }
        this.textField.render(graphics, mouseX + 30, mouseY, partialTicks);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        BlockEntity blockEntity = this.getBlockEntity();
        if (blockEntity instanceof BlockEntityPocket) {
            BlockEntityPocket blockEntity2 = (BlockEntityPocket)blockEntity;
            graphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, ComponentColour.WHITE.dec(), true);
            if (blockEntity2.getPocket() != null) {
                Pocket pocket = blockEntity2.getPocket();
                CosmosUISystem.FontRenderer.drawString((GuiGraphics)graphics, (Font)this.font, (int[])this.getScreenCoords(), (int)93, (int)40, (boolean)false, (Component)ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.header.allowed_players"), (boolean)true);
                CosmosUISystem.FontRenderer.drawString((GuiGraphics)graphics, (Font)this.font, (int[])this.getScreenCoords(), (int)88, (int)4, (boolean)false, (Component)ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.pocket.header"), (boolean)true);
                CosmosUISystem.FontRenderer.drawString((GuiGraphics)graphics, (Font)this.font, (int[])this.getScreenCoords(), (int)8, (int)4, (boolean)false, (Component)ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.header.config"), (boolean)true);
                CosmosUISystem.FontRenderer.drawString((GuiGraphics)graphics, (Font)this.font, (int[])this.getScreenCoords(), (int)262, (int)4, (boolean)false, (Component)ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.header.pocket_inv"), (boolean)true);
                CosmosUISystem.FontRenderer.drawString((GuiGraphics)graphics, (Font)this.font, (int[])this.getScreenCoords(), (int)8, (int)169, (boolean)false, (Component)ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.header.storage"), (boolean)true);
                CosmosUISystem.FontRenderer.drawString((GuiGraphics)graphics, (Font)this.font, (int[])this.getScreenCoords(), (int)8, (int)110, (boolean)false, (Component)ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.header.settings"), (boolean)true);
            }
        }
    }

    protected void updateWidgetList() {
        BlockEntityPocket blockEntity;
        BlockEntity blockEntity2 = this.getBlockEntity();
        if (blockEntity2 instanceof BlockEntityPocket && (blockEntity = (BlockEntityPocket)blockEntity2).getPocket() != null) {
            Pocket pocket = blockEntity.getPocket();
            this.updateFromList(pocket.getAllowedPlayersArray());
            super.updateWidgetList();
        }
    }

    protected void addButtons() {
        BlockEntityPocket blockEntity;
        super.addButtons();
        BlockEntity blockEntity2 = this.getBlockEntity();
        if (blockEntity2 instanceof BlockEntityPocket && (blockEntity = (BlockEntityPocket)blockEntity2).getPocket() != null) {
            Pocket pocket = blockEntity.getPocket();
            int[] sides = new int[]{0, 0, 0, 0, 0, 0};
            for (Direction c : Direction.values()) {
                sides[c.get3DDataValue()] = pocket.getSide(c).getIndex();
            }
            this.buttonDown = (DimensionalButton)this.addRenderableWidget((GuiEventListener)new DimensionalButton(this.getScreenCoords()[0] + this.DBI[0], this.getScreenCoords()[1] + this.DBI[1], 18, true, true, sides[0], (Component)ComponentHelper.empty(), button -> this.clickButton(this.buttonDown, true), button -> (MutableComponent)button.get()));
            this.buttonUp = (DimensionalButton)this.addRenderableWidget((GuiEventListener)new DimensionalButton(this.getScreenCoords()[0] + this.UBI[0], this.getScreenCoords()[1] + this.UBI[1], 18, true, true, sides[1], (Component)ComponentHelper.empty(), button -> this.clickButton(this.buttonUp, true), button -> (MutableComponent)button.get()));
            this.buttonNorth = (DimensionalButton)this.addRenderableWidget((GuiEventListener)new DimensionalButton(this.getScreenCoords()[0] + this.NBI[0], this.getScreenCoords()[1] + this.NBI[1], 18, true, true, sides[2], (Component)ComponentHelper.empty(), button -> this.clickButton(this.buttonNorth, true), button -> (MutableComponent)button.get()));
            this.buttonSouth = (DimensionalButton)this.addRenderableWidget((GuiEventListener)new DimensionalButton(this.getScreenCoords()[0] + this.SBI[0], this.getScreenCoords()[1] + this.SBI[1], 18, true, true, sides[3], (Component)ComponentHelper.empty(), button -> this.clickButton(this.buttonSouth, true), button -> (MutableComponent)button.get()));
            this.buttonWest = (DimensionalButton)this.addRenderableWidget((GuiEventListener)new DimensionalButton(this.getScreenCoords()[0] + this.WBI[0], this.getScreenCoords()[1] + this.WBI[1], 18, true, true, sides[4], (Component)ComponentHelper.empty(), button -> this.clickButton(this.buttonWest, true), button -> (MutableComponent)button.get()));
            this.buttonEast = (DimensionalButton)this.addRenderableWidget((GuiEventListener)new DimensionalButton(this.getScreenCoords()[0] + this.EBI[0], this.getScreenCoords()[1] + this.EBI[1], 18, true, true, sides[5], (Component)ComponentHelper.empty(), button -> this.clickButton(this.buttonEast, true), button -> (MutableComponent)button.get()));
            this.buttonSideGuide = (DimensionalButton)this.addRenderableWidget((GuiEventListener)new DimensionalButton(this.getScreenCoords()[0] + this.SIBI[0], this.getScreenCoords()[1] + this.SIBI[1], 18, true, true, blockEntity.getSideGuide().getIndex() + 12, (Component)ComponentHelper.empty(), button -> this.clickButton(this.buttonSideGuide, true), button -> (MutableComponent)button.get()));
            this.buttonTrapPlayers = (DimensionalButton)this.addRenderableWidget((GuiEventListener)new DimensionalButton(this.getScreenCoords()[0] + this.TPBI[0], this.getScreenCoords()[1] + this.TPBI[1], 18, true, true, pocket.getTrapState().getIndex() + 14, (Component)ComponentHelper.empty(), button -> this.clickButton(this.buttonTrapPlayers, true), button -> (MutableComponent)button.get()));
            this.buttonTankClear = (CosmosButtonWithType)this.addRenderableWidget((GuiEventListener)new CosmosButtonWithType(CosmosButtonWithType.TYPE.FLUID, this.getScreenCoords()[0] + this.TBCI[0], this.getScreenCoords()[1] + this.TBCI[1], 18, !pocket.getFluidTank().isEmpty(), true, pocket.getFluidTank().isEmpty() ? 15 : 16, (Component)ComponentHelper.empty(), (button, isLeftClick) -> this.clickButton((Button)this.buttonTankClear, isLeftClick)));
            this.buttonLock = (CosmosButtonWithType)this.addRenderableWidget((GuiEventListener)new CosmosButtonWithType(CosmosButtonWithType.TYPE.GENERAL, this.getScreenCoords()[0] + this.LBI[0], this.getScreenCoords()[1] + this.LBI[1], 18, true, true, pocket.getLockState().getIndex() + 8, (Component)ComponentHelper.empty(), (button, isLeftClick) -> this.clickButton((Button)this.buttonLock, isLeftClick)));
            this.buttonAllowedPlayers = (CosmosButtonWithType)this.addRenderableWidget((GuiEventListener)new CosmosButtonWithType(CosmosButtonWithType.TYPE.GENERAL, this.getScreenCoords()[0] + this.APBI[0], this.getScreenCoords()[1] + this.APBI[1], 18, true, true, pocket.getAllowedPlayerState().getIndex() + 10, (Component)ComponentHelper.empty(), (button, isLeftClick) -> this.clickButton((Button)this.buttonAllowedPlayers, isLeftClick)));
            this.buttonHostileSpawn = (CosmosButtonWithType)this.addRenderableWidget((GuiEventListener)new CosmosButtonWithType(CosmosButtonWithType.TYPE.GENERAL, this.getScreenCoords()[0] + this.HSBI[0], this.getScreenCoords()[1] + this.HSBI[1], 18, true, true, pocket.getHostileSpawnState().getIndex() + 15, (Component)ComponentHelper.empty(), (button, isLeftClick) -> this.clickButton((Button)this.buttonHostileSpawn, isLeftClick)));
            this.buttonTextClear = (CosmosButtonWithType)this.addRenderableWidget((GuiEventListener)new CosmosButtonWithType(CosmosButtonWithType.TYPE.GENERAL, this.getScreenCoords()[0] + this.TCBI[0], this.getScreenCoords()[1] + this.TCBI[1], 18, !this.textField.getValue().isEmpty(), true, 14, (Component)ComponentHelper.empty(), (button, isLeftClick) -> this.clickButton((Button)this.buttonTextClear, isLeftClick)));
            this.buttonTextPlus = (CosmosButtonWithType)this.addRenderableWidget((GuiEventListener)new CosmosButtonWithType(CosmosButtonWithType.TYPE.GENERAL, this.getScreenCoords()[0] + this.TABI[0], this.getScreenCoords()[1] + this.TABI[1], 18, !this.textField.getValue().isEmpty(), true, 1, (Component)ComponentHelper.empty(), (button, isLeftClick) -> this.clickButton((Button)this.buttonTextPlus, isLeftClick)));
            this.buttonTextMinus = (CosmosButtonWithType)this.addRenderableWidget((GuiEventListener)new CosmosButtonWithType(CosmosButtonWithType.TYPE.GENERAL, this.getScreenCoords()[0] + this.TMBI[0], this.getScreenCoords()[1] + this.TMBI[1], 18, true, true, 2, (Component)ComponentHelper.empty(), (button, isLeftClick) -> this.clickButton((Button)this.buttonTextMinus, isLeftClick)));
        }
    }

    public void renderStandardHoverEffect(GuiGraphics graphics, Style style, int mouseX, int mouseY) {
        BlockEntityPocket blockEntity;
        BlockEntity blockEntity2 = this.getBlockEntity();
        if (blockEntity2 instanceof BlockEntityPocket && (blockEntity = (BlockEntityPocket)blockEntity2).getPocket() != null) {
            Pocket pocket = blockEntity.getPocket();
            if (this.buttonLock.isMouseOver((double)mouseX, (double)mouseY)) {
                Component[] comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.lock_info"), ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.lock_value").append((Component)pocket.getLockState().getColouredComp())};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
            } else if (this.buttonSideGuide.isMouseOver(mouseX, mouseY)) {
                Component[] comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.pocket.side_guide_info"), ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.pocket.side_guide_value").append((Component)blockEntity.getSideGuide().getColouredComp())};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
            } else if (this.buttonTrapPlayers.isMouseOver(mouseX, mouseY)) {
                Component[] comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.trap_players_info"), ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.trap_players_value").append((Component)pocket.getTrapState().getColouredComp())};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
            } else if (this.buttonHostileSpawn.isMouseOver((double)mouseX, (double)mouseY)) {
                Component[] comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.hostile_spawn_info"), ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.hostile_spawn_value").append((Component)pocket.getHostileSpawnState().getColouredComp())};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
            } else if (this.buttonAllowedPlayers.isMouseOver((double)mouseX, (double)mouseY)) {
                Component[] comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.allowed_player_info"), ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.allowed_player_value").append((Component)pocket.getAllowedPlayerState().getColouredComp())};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
            } else if (this.buttonTextClear.isMouseOver((double)mouseX, (double)mouseY)) {
                if (this.buttonTextClear.isActive()) {
                    graphics.renderTooltip(this.font, (Component)ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.button.text.clear"), mouseX, mouseY);
                }
            } else if (this.buttonTextPlus.isMouseOver((double)mouseX, (double)mouseY)) {
                if (this.buttonTextPlus.isActive()) {
                    graphics.renderTooltip(this.font, (Component)ComponentHelper.style((ComponentColour)ComponentColour.GREEN, (String)"dimensionalpocketsii.gui.button.text.plus"), mouseX, mouseY);
                }
            } else if (this.buttonTextMinus.isMouseOver((double)mouseX, (double)mouseY)) {
                if (this.buttonTextMinus.isActive()) {
                    graphics.renderTooltip(this.font, (Component)ComponentHelper.style((ComponentColour)ComponentColour.RED, (String)"dimensionalpocketsii.gui.button.text.minus"), mouseX, mouseY);
                }
            } else if (this.buttonDown.isMouseOver(mouseX, mouseY)) {
                Component[] comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.button.direction.prefix").append((Component)ComponentHelper.style3((ComponentColour)ComponentColour.YELLOW, (String)"bold", (String)" [", (String)"dimensionalpocketsii.gui.button.direction.down", (String)"]")), ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.button.direction.suffix").append((Component)pocket.getSide(Direction.DOWN).getColouredComp())};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
            } else if (this.buttonUp.isMouseOver(mouseX, mouseY)) {
                Component[] comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.button.direction.prefix").append((Component)ComponentHelper.style3((ComponentColour)ComponentColour.ORANGE, (String)"bold", (String)" [", (String)"dimensionalpocketsii.gui.button.direction.up", (String)"]")), ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.button.direction.suffix").append((Component)pocket.getSide(Direction.UP).getColouredComp())};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
            } else if (this.buttonNorth.isMouseOver(mouseX, mouseY)) {
                Component[] comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.button.direction.prefix").append((Component)ComponentHelper.style3((ComponentColour)ComponentColour.BLUE, (String)"bold", (String)" [", (String)"dimensionalpocketsii.gui.button.direction.north", (String)"]")), ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.button.direction.suffix").append((Component)pocket.getSide(Direction.NORTH).getColouredComp())};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
            } else if (this.buttonSouth.isMouseOver(mouseX, mouseY)) {
                Component[] comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.button.direction.prefix").append((Component)ComponentHelper.style3((ComponentColour)ComponentColour.LIME, (String)"bold", (String)" [", (String)"dimensionalpocketsii.gui.button.direction.south", (String)"]")), ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.button.direction.suffix").append((Component)pocket.getSide(Direction.SOUTH).getColouredComp())};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
            } else if (this.buttonWest.isMouseOver(mouseX, mouseY)) {
                Component[] comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.button.direction.prefix").append((Component)ComponentHelper.style3((ComponentColour)ComponentColour.WHITE, (String)"bold", (String)" [", (String)"dimensionalpocketsii.gui.button.direction.west", (String)"]")), ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.button.direction.suffix").append((Component)pocket.getSide(Direction.WEST).getColouredComp())};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
            } else if (this.buttonEast.isMouseOver(mouseX, mouseY)) {
                Component[] comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.button.direction.prefix").append((Component)ComponentHelper.style3((ComponentColour)ComponentColour.GRAY, (String)"bold", (String)" [", (String)"dimensionalpocketsii.gui.button.direction.east", (String)"]")), ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.button.direction.suffix").append((Component)pocket.getSide(Direction.EAST).getColouredComp())};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
            } else if (CosmosUISystem.Hovering.isHovering((int)mouseX, (int)mouseY, (int)(this.getScreenCoords()[0] + this.fluidBarData[0] - 1), (int)(this.getScreenCoords()[0] + this.fluidBarData[0] + 16), (int)(this.getScreenCoords()[1] + this.fluidBarData[2]), (int)(this.getScreenCoords()[1] + this.fluidBarData[2] + 57))) {
                FluidTank tank = pocket.getFluidTank();
                DecimalFormat formatter = new DecimalFormat("#,###,###,###");
                String amount_string = formatter.format((long)tank.getFluidAmount());
                String capacity_string = formatter.format((long)tank.getCapacity());
                String fluid_name = tank.getFluid().getTranslationKey();
                Component[] comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.fluid_bar.pre").append((Component)ComponentHelper.style3((ComponentColour)ComponentColour.CYAN, (String)"bold", (String)"[ ", (String)fluid_name, (String)" ]")), ComponentHelper.style2((ComponentColour)ComponentColour.ORANGE, (String)(amount_string + " / " + capacity_string), (String)"dimensionalpocketsii.gui.fluid_bar.suff")};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
            } else if (CosmosUISystem.Hovering.isHovering((int)mouseX, (int)mouseY, (int)(this.getScreenCoords()[0] + this.energyBarData[0] - 1), (int)(this.getScreenCoords()[0] + this.energyBarData[0] + 16), (int)(this.getScreenCoords()[1] + this.energyBarData[1] - 1), (int)(this.getScreenCoords()[1] + this.energyBarData[1] + 64))) {
                DecimalFormat formatter = new DecimalFormat("#,###,###,###");
                String amount_string = formatter.format((long)pocket.getEnergyStored());
                String capacity_string = formatter.format((long)pocket.getMaxEnergyStored());
                Component[] comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.energy_bar.pre"), ComponentHelper.style2((ComponentColour)ComponentColour.RED, (String)(amount_string + " / " + capacity_string), (String)"dimensionalpocketsii.gui.energy_bar.suff")};
                graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
            } else if (this.buttonTankClear != null && this.buttonTankClear.isMouseOver((double)mouseX, (double)mouseY) && this.buttonTankClear.isActive()) {
                if (!ScreenPocket.hasShiftDown()) {
                    graphics.renderTooltip(this.font, (Component)ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.button.tank_clear"), mouseX, mouseY);
                } else {
                    Component[] comp = new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.button.tank_clear"), ComponentHelper.style((ComponentColour)ComponentColour.RED, (String)"bold", (String)"dimensionalpocketsii.gui.button.tank_clear_shift")};
                    graphics.renderComponentTooltip(this.font, Arrays.asList(comp), mouseX, mouseY);
                }
            }
        }
        super.renderStandardHoverEffect(graphics, style, mouseX, mouseY);
    }

    public void clickButton(Button button, boolean isLeftClick) {
        super.clickButton(button, isLeftClick);
        if (isLeftClick) {
            BlockEntityPocket blockEntity;
            String value = this.textField.getValue();
            BlockEntity blockEntity2 = this.getBlockEntity();
            if (blockEntity2 instanceof BlockEntityPocket && (blockEntity = (BlockEntityPocket)blockEntity2).getPocket() != null) {
                Pocket pocket = blockEntity.getPocket();
                if (button.equals(this.buttonLock)) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new PacketLock(pocket.getDominantChunkPos(), !pocket.getLockStateValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    blockEntity.setLockState(!pocket.getLockStateValue(), true);
                    blockEntity.setChanged();
                } else if (button.equals((Object)this.buttonSideGuide)) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new PacketSideGuide(((ContainerPocket)this.menu).getBlockPos(), (ResourceKey<Level>)((ContainerPocket)this.menu).getLevel().dimension()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    blockEntity.toggleSideGuide();
                    blockEntity.setChanged();
                } else if (button.equals((Object)this.buttonTrapPlayers)) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new PacketTrapPlayers(pocket.getDominantChunkPos(), !pocket.getTrapStateValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    pocket.setTrapState(!pocket.getTrapStateValue());
                    blockEntity.setChanged();
                } else if (button.equals(this.buttonHostileSpawn)) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new PacketHostileSpawnState(pocket.getDominantChunkPos(), !pocket.getHostileSpawnStateValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    pocket.setHostileSpawnState(!pocket.getHostileSpawnStateValue());
                    blockEntity.setChanged();
                } else if (button.equals(this.buttonAllowedPlayers)) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new PacketLockToAllowedPlayers(pocket.getDominantChunkPos(), !pocket.getAllowedPlayerStateValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    pocket.setAllowedPlayerState(!pocket.getAllowedPlayerStateValue());
                    blockEntity.setChanged();
                } else if (button.equals(this.buttonTextClear)) {
                    this.textField.setValue("");
                } else if (button.equals(this.buttonTextPlus)) {
                    if (!value.isEmpty() && value.length() >= 3) {
                        PacketDistributor.sendToServer((CustomPacketPayload)new PacketAllowedPlayer(pocket.getDominantChunkPos(), value, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        pocket.addAllowedPlayerNBT(value);
                        blockEntity.setChanged();
                        this.textField.setValue("");
                    }
                } else if (button.equals(this.buttonTextMinus)) {
                    int selected = this.getSelectedWidgetIndex();
                    if (selected != 0) {
                        String string = ((CosmosListWidget)this.getWidgetList().get(selected)).getDisplayString();
                        PacketDistributor.sendToServer((CustomPacketPayload)new PacketAllowedPlayer(pocket.getDominantChunkPos(), string, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        blockEntity.setChanged();
                        pocket.removeAllowedPlayerNBT(string);
                        this.removeElement();
                    }
                } else if (button.equals(this.buttonTankClear)) {
                    if (ScreenPocket.hasShiftDown()) {
                        PacketDistributor.sendToServer((CustomPacketPayload)new PacketEmptyTank(pocket.getDominantChunkPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        pocket.emptyFluidTank();
                    }
                } else if (button.equals((Object)this.buttonDown)) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new PacketBlockSideState(pocket.getDominantChunkPos(), Direction.DOWN.get3DDataValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else if (button.equals((Object)this.buttonUp)) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new PacketBlockSideState(pocket.getDominantChunkPos(), Direction.UP.get3DDataValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else if (button.equals((Object)this.buttonNorth)) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new PacketBlockSideState(pocket.getDominantChunkPos(), Direction.NORTH.get3DDataValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else if (button.equals((Object)this.buttonSouth)) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new PacketBlockSideState(pocket.getDominantChunkPos(), Direction.SOUTH.get3DDataValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else if (button.equals((Object)this.buttonWest)) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new PacketBlockSideState(pocket.getDominantChunkPos(), Direction.WEST.get3DDataValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else if (button.equals((Object)this.buttonEast)) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new PacketBlockSideState(pocket.getDominantChunkPos(), Direction.EAST.get3DDataValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }

    protected void addUIHelpElements() {
        super.addUIHelpElements();
        this.addRenderableUIHelpElement(this.getScreenCoords(), 12, 182, 20, 62, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.RED, (String)"dimensionalpocketsii.gui.help.power_display"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.power_display_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.power_display_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 35, 182, 20, 62, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.ORANGE, (String)"dimensionalpocketsii.gui.help.fluid_display"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.fluid_display_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.fluid_display_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 58, 182, 20, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_BLUE, (String)"dimensionalpocketsii.gui.help.slot.bucket_input"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.slot.bucket_input_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.slot.bucket_input_two"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.slot.bucket_input_three"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.slot.bucket_input_four")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 58, 203, 20, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.GREEN, (String)"dimensionalpocketsii.gui.help.slot.bucket_output"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.slot.bucket_output_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.slot.bucket_output_two"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.slot.bucket_output_three")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 58, 224, 20, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.RED, (String)"dimensionalpocketsii.gui.help.fluid_clear_button"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.fluid_clear_button_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.fluid_clear_button_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 12, 40, 66, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.POCKET_PURPLE_LIGHT, (String)"dimensionalpocketsii.gui.help.pocket.surrounding"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.surrounding_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.surrounding_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 12, 84, 66, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.POCKET_PURPLE_LIGHT, (String)"dimensionalpocketsii.gui.help.pocket.surrounding"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.surrounding_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.surrounding_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 12, 17, 66, 22, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.PURPLE, (String)"dimensionalpocketsii.gui.help.pocket.surrounding_config"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.surrounding_config_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.surrounding_config_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 12, 61, 66, 22, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.PURPLE, (String)"dimensionalpocketsii.gui.help.pocket.surrounding_config"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.surrounding_config_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.surrounding_config_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 92, 17, 97, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.help.pocket.allowed_players"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.allowed_players_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.allowed_players_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 190, 17, 20, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.RED, (String)"dimensionalpocketsii.gui.help.pocket.text_clear"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.text_clear_one")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 211, 17, 20, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.GREEN, (String)"dimensionalpocketsii.gui.help.pocket.add_player"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.add_player_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.add_player_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 232, 17, 20, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.RED, (String)"dimensionalpocketsii.gui.help.pocket.remove_player"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.remove_player_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.remove_player_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 92, 50, 142, 102, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.help.pocket.allowed_players_list"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.allowed_players_list_one")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 235, 50, 17, 102, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.help.pocket.scroll_bar"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.scroll_bar_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.scroll_bar_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 12, 123, 20, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.RED, (String)"dimensionalpocketsii.gui.help.pocket.lock"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.lock_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.lock_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 12, 144, 20, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.YELLOW, (String)"dimensionalpocketsii.gui.help.pocket.allow"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.allow_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.allow_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 35, 123, 20, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_RED, (String)"dimensionalpocketsii.gui.help.pocket.trap"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.trap_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.trap_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 35, 144, 20, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.GREEN, (String)"dimensionalpocketsii.gui.help.pocket.mobs"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.mobs_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.mobs_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 58, 144, 20, 20, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.WHITE, (String)"dimensionalpocketsii.gui.help.pocket.guide"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.guide_one")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 264, 15, 74, 182, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.GRAY, (String)"dimensionalpocketsii.gui.help.pocket.items"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.items_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.items_two")});
        this.addRenderableUIHelpElement(this.getScreenCoords(), 264, 208, 74, 38, new Component[]{ComponentHelper.style((ComponentColour)ComponentColour.CYAN, (String)"dimensionalpocketsii.gui.help.pocket.buffer_items"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.buffer_items_one"), ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_GRAY, (String)"dimensionalpocketsii.gui.help.pocket.buffer_items_two")});
    }

    public void initEditBox() {
        super.initEditBox();
        this.textField = new EditBox(this.font, this.getScreenCoords()[0] + this.textFieldI[0], this.getScreenCoords()[1] + this.textFieldI[1], this.textFieldI[2], this.textFieldI[3], (Component)ComponentHelper.comp((String)"Allowed Player Entry"));
        this.textField.setMaxLength(16);
        this.textField.setVisible(true);
        this.textField.setTextColor(0xFFFFFF);
        this.textField.setBordered(false);
        this.textField.setCanLoseFocus(true);
        this.textField.setEditable(true);
        this.addWidget((GuiEventListener)this.textField);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean textClicked = this.textField.mouseClicked(mouseX, mouseY, mouseButton);
        if (!textClicked) {
            this.textField.setFocused(false);
        } else {
            this.textField.setFocused(true);
        }
        return this.textField.mouseClicked(mouseX, mouseY, mouseButton) ? true : super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double directionX, double directionY) {
        return this.textField.mouseScrolled(mouseX, mouseY, directionX, directionY) ? true : super.mouseScrolled(mouseX, mouseY, directionX, directionY);
    }

    public boolean keyPressed(int keyCode, int mouseX, int mouseY) {
        if (keyCode == 256) {
            this.minecraft.player.closeContainer();
        }
        return !this.textField.keyPressed(keyCode, mouseX, mouseY) && !this.textField.canConsumeInput() ? super.keyPressed(keyCode, mouseX, mouseY) : true;
    }

    public boolean charTyped(char charIn, int p_98522_) {
        return !this.textField.charTyped(charIn, p_98522_) && !this.textField.canConsumeInput() ? super.charTyped(charIn, p_98522_) : true;
    }
}

