/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.pocket.core;

import com.google.gson.annotations.SerializedName;
import com.tcn.cosmoslibrary.common.blockentity.CosmosBlockEntityUpdateable;
import com.tcn.cosmoslibrary.common.chat.CosmosChatUtil;
import com.tcn.cosmoslibrary.common.enums.EnumGeneralAllowState;
import com.tcn.cosmoslibrary.common.enums.EnumGeneratedState;
import com.tcn.cosmoslibrary.common.enums.EnumLockState;
import com.tcn.cosmoslibrary.common.enums.EnumSideState;
import com.tcn.cosmoslibrary.common.enums.EnumTrapState;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IEnergyHolder;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.cosmoslibrary.common.lib.CosmosChunkPos;
import com.tcn.cosmoslibrary.common.lib.MathHelper;
import com.tcn.cosmoslibrary.core.teleport.EnumSafeTeleport;
import com.tcn.cosmoslibrary.registry.gson.object.ObjectBlockPosDimension;
import com.tcn.cosmoslibrary.registry.gson.object.ObjectDestinationInfo;
import com.tcn.cosmoslibrary.registry.gson.object.ObjectFluidTankCustom;
import com.tcn.cosmoslibrary.registry.gson.object.ObjectPlayerInformation;
import com.tcn.dimensionalpocketsii.DimensionalPockets;
import com.tcn.dimensionalpocketsii.core.advancement.CoreTriggers;
import com.tcn.dimensionalpocketsii.core.management.PocketsConfigManager;
import com.tcn.dimensionalpocketsii.core.management.PocketsDimensionManager;
import com.tcn.dimensionalpocketsii.core.management.PocketsRegistrationManager;
import com.tcn.dimensionalpocketsii.pocket.core.block.AbstractBlockPocket;
import com.tcn.dimensionalpocketsii.pocket.core.block.BlockWallBase;
import com.tcn.dimensionalpocketsii.pocket.core.block.BlockWallEdge;
import com.tcn.dimensionalpocketsii.pocket.core.block.BlockWallModule;
import com.tcn.dimensionalpocketsii.pocket.core.block.entity.AbstractBlockEntityPocket;
import com.tcn.dimensionalpocketsii.pocket.core.block.entity.BlockEntityModuleConnector;
import com.tcn.dimensionalpocketsii.pocket.core.gson.PocketChunkInfo;
import com.tcn.dimensionalpocketsii.pocket.core.management.PocketEventFactory;
import com.tcn.dimensionalpocketsii.pocket.core.registry.StorageManager;
import com.tcn.dimensionalpocketsii.pocket.core.shift.EnumShiftDirection;
import com.tcn.dimensionalpocketsii.pocket.core.shift.Shifter;
import com.tcn.dimensionalpocketsii.pocket.core.shift.ShifterCore;
import com.tcn.dimensionalpocketsii.pocket.network.packet.system.PacketSystem;
import io.netty.util.internal.ThreadLocalRandom;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class Pocket
implements IEnergyHolder,
Container {
    private static final String NBT_DIMENSIONAL_POCKET_KEY = "pocket_data";
    private static final String NBT_OWNER_KEY = "owner";
    private static final String NBT_GENERATED_KEY = "is_generated";
    private static final String NBT_LOCKED_KEY = "is_locked";
    private static final String NBT_ALLOWED_PLAYER_SHIFT_KEY = "allowed_player_shift";
    private static final String NBT_TRAP_KEY = "trap_players";
    private static final String NBT_HOSTILE_SPAWNS_KEY = "allow_hostile_spawns";
    private static final String NBT_COLOUR_KEY = "display_colour";
    private static final String NBT_INTERNAL_HEIGHT_KEY = "internal_height";
    private static final String NBT_ENERGY_STORED_KEY = "energy_stored";
    private static final String NBT_ENERGY_CAPACITY_KEY = "energy_capacity";
    private static final String NBT_ENERGY_RECEIVE_KEY = "energy_max_receive";
    private static final String NBT_ENERGY_EXTRACT_KEY = "energy_max_extract";
    private static final String NBT_BLOCK_DIMENSION_KEY = "source_dimension";
    private static final String NBT_CHUNK_POS_KEY = "chunk_pos";
    private static final String NBT_CHUNK_INFO_KEY = "chunk_info";
    private static final String NBT_LAST_POS_KEY = "last_pos";
    private static final String NBT_SPAWN_POS_KEY = "spawn_pos";
    private static final String NBT_FLUID_TANK_KEY = "fluid_tank";
    private static final String NBT_ALLOWED_PLAYERS_KEY = "allowed_players_array";
    private static final String NBT_BLOCK_ARRAY_KEY = "block_array";
    private static final String NBT_UPDATE_ARRAY_KEY = "update_array";
    private static final String NBT_POCKET_SIDE_KEY = "pocket_side_array";
    private static final String NBT_ITEMS_KEY = "items_array";
    private static final String NBT_SURROUNDING_KEY = "surrounding_array";
    @SerializedName(value="owner")
    private ObjectPlayerInformation owner;
    @SerializedName(value="is_generated")
    private EnumGeneratedState is_generated = EnumGeneratedState.UNGENERATED;
    @SerializedName(value="is_locked")
    private EnumLockState is_locked = EnumLockState.UNLOCKED;
    @SerializedName(value="allowed_player_shift")
    private EnumGeneralAllowState allowed_players_shift = EnumGeneralAllowState.ALLOWED;
    @SerializedName(value="trap_players")
    private EnumTrapState trap_players = EnumTrapState.FREE;
    @SerializedName(value="allow_hostile_spawns")
    private EnumGeneralAllowState allow_hostile_spawns = EnumGeneralAllowState.BLOCKED;
    @SerializedName(value="display_colour")
    private int display_colour = ComponentColour.POCKET_PURPLE.dec();
    @SerializedName(value="internal_height")
    private int internal_height = PocketsConfigManager.getInstance().getInternalHeight();
    @SerializedName(value="energy_stored")
    private int energy_stored = 0;
    @SerializedName(value="energy_capacity")
    public int energy_capacity = 500000000;
    @SerializedName(value="energy_max_receive")
    public int energy_max_receive = 100000;
    @SerializedName(value="energy_max_extract")
    public int energy_max_extract = 100000;
    @SerializedName(value="source_dimension")
    private ResourceLocation block_dimension = ResourceLocation.parse((String)"");
    @SerializedName(value="chunk_pos")
    public CosmosChunkPos chunk_pos = CosmosChunkPos.ZERO;
    @SerializedName(value="chunk_info")
    public PocketChunkInfo chunk_info = null;
    @SerializedName(value="last_pos")
    private ObjectBlockPosDimension last_pos = ObjectBlockPosDimension.BLANK;
    @SerializedName(value="spawn_pos")
    private ObjectDestinationInfo spawn_pos = ObjectDestinationInfo.BLANK;
    @SerializedName(value="fluid_tank")
    public ObjectFluidTankCustom fluid_tank = new ObjectFluidTankCustom(1000000, 0);
    @SerializedName(value="allowed_players_array")
    private ArrayList<String> allowed_players_array = new ArrayList();
    @SerializedName(value="update_array")
    private ArrayList<BlockPos> update_array = new ArrayList();
    @SerializedName(value="block_array")
    private LinkedHashMap<Integer, ObjectBlockPosDimension> block_array = new LinkedHashMap();
    @SerializedName(value="pocket_side_array")
    public EnumSideState[] pocket_side_array = (EnumSideState[])EnumSideState.STANDARD.clone();
    @SerializedName(value="items_array")
    public NonNullList<ItemStack> item_array = NonNullList.withSize((int)48, (Object)ItemStack.EMPTY);
    @SerializedName(value="surrounding_array")
    public NonNullList<ItemStack> surrounding_array = NonNullList.withSize((int)6, (Object)ItemStack.EMPTY);

    protected Pocket() {
    }

    public Pocket(PocketChunkInfo infoIn) {
        this.chunk_info = infoIn;
    }

    public Pocket(CosmosChunkPos chunkPosIn, boolean isSingleChunk, ResourceKey<Level> blockDimensionIn, BlockPos blockPos) {
        this.setSourceBlockDimension(blockDimensionIn);
        this.addPosToBlockArray(blockPos, blockDimensionIn.location());
        this.setSpawnInPocket(isSingleChunk ? new BlockPos(7, 2, 7) : new BlockPos(15, 2, 15), 0.0f, 0.0f);
        this.chunk_info = new PocketChunkInfo(chunkPosIn, isSingleChunk);
        this.chunk_pos = chunkPosIn;
        this.setInternalHeight(isSingleChunk ? PocketsConfigManager.getInstance().getInternalHeight() : PocketsConfigManager.getInstance().getInternalHeightEnhanced());
    }

    public boolean exists() {
        return this.chunk_info != null;
    }

    public boolean isSourceBlockPlaced() {
        return this.getSourceBlock() instanceof AbstractBlockPocket;
    }

    public Block getSourceBlock() {
        return this.getSourceBlockState().getBlock();
    }

    public BlockState getSourceBlockState() {
        Level world = this.getSourceBlockLevel();
        if (world == null) {
            DimensionalPockets.CONSOLE.debugWarn((Object)("[Pocket] <getsourceblock> Dimension: " + String.valueOf(this.block_dimension) + " returned <null>!! (Mystcraft or GalactiCraft world?). Will return <null>. This will cause a problem."));
            return null;
        }
        return world.getBlockState(this.getLastBlockPos());
    }

    public BlockPos getSourceBlockPos() {
        return this.getLastBlockPos();
    }

    public void setSourceBlockDimension(ResourceKey<Level> type) {
        this.block_dimension = type.location();
    }

    public ResourceKey<Level> getSourceBlockDimension() {
        return ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)this.block_dimension);
    }

    public Level getSourceBlockLevel() {
        return this.getLevelFromResource(this.block_dimension);
    }

    public Level getLevelFromResource(ResourceLocation location) {
        return ServerLifecycleHooks.getCurrentServer().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)location));
    }

    public void resetSourceBlock() {
        for (int i = 0; i < this.block_array.size(); ++i) {
            BlockPos pos;
            ObjectBlockPosDimension object = this.block_array.get(i);
            Level level = this.getLevelFromResource(object.getDimension());
            if (!(level.getBlockState(pos = object.getPos()).getBlock() instanceof AbstractBlockPocket)) continue;
            this.last_pos = object;
            this.setSourceBlockDimension((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)object.getDimension()));
            DimensionalPockets.CONSOLE.debug((Object)("[Pocket] <resetsourceblock> Pocket Source Block has been reset to: [" + String.valueOf(pos) + "]"));
            break;
        }
    }

    public EnumGeneratedState getGeneratedState() {
        return this.is_generated;
    }

    public boolean getGeneratedStateValue() {
        return this.is_generated.getValue();
    }

    public void setGeneratedState(EnumGeneratedState state) {
        this.is_generated = state;
    }

    public void setGeneratedState(boolean change) {
        this.setGeneratedState(EnumGeneratedState.getStateFromValue((boolean)change));
    }

    public EnumLockState getLockState() {
        return this.is_locked;
    }

    public boolean getLockStateValue() {
        return this.is_locked.getValue();
    }

    public void setLockState(EnumLockState state) {
        this.is_locked = state;
    }

    public void setLockState(boolean change) {
        this.setLockState(EnumLockState.getStateFromValue((boolean)change));
    }

    public EnumGeneralAllowState getAllowedPlayerState() {
        return this.allowed_players_shift;
    }

    public boolean getAllowedPlayerStateValue() {
        return this.allowed_players_shift.getValue();
    }

    public void setAllowedPlayerState(EnumGeneralAllowState state) {
        this.allowed_players_shift = state;
    }

    public void setAllowedPlayerState(boolean change) {
        this.setAllowedPlayerState(EnumGeneralAllowState.getStateFromValue((boolean)change));
    }

    public EnumGeneralAllowState getHostileSpawnState() {
        return this.allow_hostile_spawns;
    }

    public boolean getHostileSpawnStateValue() {
        return this.allow_hostile_spawns.getValue();
    }

    public void setHostileSpawnState(EnumGeneralAllowState state) {
        this.allow_hostile_spawns = state;
    }

    public void setHostileSpawnState(boolean change) {
        this.setHostileSpawnState(EnumGeneralAllowState.getStateFromValue((boolean)change));
    }

    public EnumTrapState getTrapState() {
        return this.trap_players;
    }

    public boolean getTrapStateValue() {
        return this.trap_players.getValue();
    }

    public void setTrapState(EnumTrapState state) {
        this.trap_players = state;
    }

    public void setTrapState(boolean change) {
        this.setTrapState(EnumTrapState.getStateFromValue((boolean)change));
    }

    public int getDisplayColour() {
        return this.display_colour;
    }

    public void setDisplayColour(Player playerIn, Level levelIn, int colourIn) {
        if (this.display_colour != colourIn) {
            this.display_colour = colourIn;
            this.updateWallBlocks(playerIn, levelIn);
        }
    }

    public void setDisplayColour(ComponentColour colour) {
        this.display_colour = colour.dec();
    }

    private void setDisplayColour(int colourIn) {
        this.display_colour = colourIn;
    }

    public int getInternalHeight() {
        return this.internal_height;
    }

    public void setInternalHeight(int height) {
        this.internal_height = height;
    }

    public BlockPos getLastBlockPos() {
        return this.last_pos.getPos();
    }

    public ObjectBlockPosDimension getLastBlock() {
        return this.last_pos;
    }

    public BlockPos getLastBlockPosPlus(BlockPos pos) {
        return MathHelper.addBlockPos((BlockPos)this.getLastBlockPos(), (BlockPos)pos);
    }

    private BlockPos getSpawnPos() {
        return this.spawn_pos.getPos();
    }

    public void updatePocketSpawnPos(BlockPos pos) {
        this.spawn_pos.setPos(pos);
        PacketDistributor.sendToServer((CustomPacketPayload)new PacketSystem(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void setSpawnInPocket(BlockPos posIn, float yawIn, float pitchIn) {
        this.spawn_pos = new ObjectDestinationInfo(posIn, yawIn, pitchIn);
    }

    public PocketChunkInfo getChunkInfo() {
        return this.chunk_info;
    }

    public CosmosChunkPos getDominantChunkPos() {
        return this.chunk_info.getDominantChunk();
    }

    public boolean updateOwner(@Nullable ServerPlayer oldPlayerIn, ServerPlayer newPlayerIn) {
        if (oldPlayerIn != null) {
            if (this.owner.equals(new ObjectPlayerInformation((Player)oldPlayerIn))) {
                CosmosChatUtil.sendPlayerMessageServer((ServerPlayer)oldPlayerIn, (Component)ComponentHelper.style((ComponentColour)ComponentColour.GREEN, (String)"dimensionalpocketsii.command.transfer.success.old").append((Component)ComponentHelper.style((ComponentColour)ComponentColour.CYAN, (String)newPlayerIn.getDisplayName().getString())));
                CosmosChatUtil.sendPlayerMessageServer((ServerPlayer)newPlayerIn, (Component)ComponentHelper.style((ComponentColour)ComponentColour.CYAN, (String)oldPlayerIn.getDisplayName().getString()).append((Component)ComponentHelper.style((ComponentColour)ComponentColour.GREEN, (String)"dimensionalpocketsii.command.transfer.success.new")));
                this.setOwnerInternal((Player)newPlayerIn);
                return true;
            }
            CosmosChatUtil.sendPlayerMessageServer((ServerPlayer)oldPlayerIn, (Component)ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_RED, (String)"dimensionalpocketsii.command.transfer.error.not_owner"));
            return false;
        }
        CosmosChatUtil.sendPlayerMessageServer((ServerPlayer)newPlayerIn, (Component)ComponentHelper.style((ComponentColour)ComponentColour.CYAN, (String)this.getOwnerName()).append((Component)ComponentHelper.style((ComponentColour)ComponentColour.GREEN, (String)"dimensionalpocketsii.command.transfer.success.new")));
        this.setOwnerInternal((Player)newPlayerIn);
        return true;
    }

    private void setOwnerInternal(Player playerIn) {
        this.owner = new ObjectPlayerInformation(playerIn);
        this.addAllowedPlayer(playerIn, true);
    }

    public void setOwner(Player playerIn) {
        if (!(playerIn == null || this.getGeneratedStateValue() && this.owner != null)) {
            this.owner = new ObjectPlayerInformation(playerIn);
            this.addAllowedPlayer(playerIn, true);
        }
    }

    public boolean checkIfOwner(Player playerIn) {
        String player_name = playerIn.getDisplayName().getString();
        UUID player_uuid = playerIn.getUUID();
        if (this.owner != null && this.owner.getPlayerUUID().equals(player_uuid)) {
            if (!this.owner.getPlayerName().equals(player_name)) {
                this.owner.setPlayerName(player_name);
            }
            return true;
        }
        return false;
    }

    public ObjectPlayerInformation getOwner() {
        return this.owner;
    }

    public String getOwnerName() {
        return this.getOwner().getPlayerName();
    }

    protected UUID getOwnerUUID() {
        return this.getOwner().getPlayerUUID();
    }

    public void addPosToBlockArray(BlockPos posIn, ResourceLocation dimensionIn) {
        this.addPosToBlockArray(new ObjectBlockPosDimension(posIn, dimensionIn), true);
    }

    public void addPosToBlockArray(ObjectBlockPosDimension objectIn, boolean updateLastPos) {
        if (!this.doesBlockArrayContain(objectIn.getPos(), objectIn.getDimension())) {
            this.block_array.put(this.block_array.size(), objectIn);
        }
        if (updateLastPos) {
            this.last_pos = objectIn;
        }
    }

    public boolean doesBlockArrayContain(BlockPos pos, ResourceLocation dimensionIn) {
        for (int i = 0; i < this.block_array.size(); ++i) {
            BlockPos checkPos = this.block_array.get(i).getPos();
            ResourceLocation checkLocation = this.block_array.get(i).getDimension();
            if (!(checkLocation.getNamespace().equals("") || checkLocation.getPath().equals("") ? checkPos.equals((Object)pos) : checkPos.equals((Object)pos) && checkLocation.equals((Object)dimensionIn))) continue;
            return true;
        }
        return false;
    }

    public void addUpdateable(BlockPos posIn) {
        if (this.update_array.contains(posIn)) {
            DimensionalPockets.CONSOLE.debug((Object)("[Pocket] <addupdateable> Array already contains: [" + String.valueOf(posIn) + "]. Array will not be updated."));
        } else {
            this.update_array.add(posIn);
            DimensionalPockets.CONSOLE.debug((Object)("[Pocket] <addupdateable> BlockPos: [" + String.valueOf(posIn) + "] added."));
        }
    }

    public void removeUpdateable(BlockPos posIn) {
        if (this.update_array.contains(posIn)) {
            this.update_array.remove(posIn);
            DimensionalPockets.CONSOLE.debug((Object)("[Pocket] <removeupdateable> BlockPos: [" + String.valueOf(posIn) + "] removed."));
        } else {
            DimensionalPockets.CONSOLE.debug((Object)("[Pocket] <removeupdateable> Array does not contain: [" + String.valueOf(posIn) + "]."));
        }
    }

    public void forceUpdateInsidePocket() {
        ServerLevel level = StorageManager.getServerLevel();
        if (level != null) {
            for (BlockPos pos : this.update_array) {
                BlockEntity entity = level.getBlockEntity(pos);
                if (entity != null) {
                    if (entity instanceof CosmosBlockEntityUpdateable) {
                        CosmosBlockEntityUpdateable blockEntity = (CosmosBlockEntityUpdateable)entity;
                        blockEntity.sendUpdates(true);
                        continue;
                    }
                    BlockState state = level.getBlockState(pos);
                    level.sendBlockUpdated(pos, state, state, 3);
                    level.markAndNotifyBlock(pos, level.getChunkAt(pos), state, state, 3, 0);
                    continue;
                }
                BlockState state = level.getBlockState(pos);
                level.sendBlockUpdated(pos, state, state, 3);
                level.markAndNotifyBlock(pos, level.getChunkAt(pos), state, state, 3, 0);
            }
        }
    }

    public void forceUpdateOutsidePocket() {
        BlockEntity blockEntity;
        Level level = this.getSourceBlockLevel();
        if (level != null && (blockEntity = level.getBlockEntity(this.getLastBlockPos())) instanceof AbstractBlockEntityPocket) {
            AbstractBlockEntityPocket blockEntity2 = (AbstractBlockEntityPocket)blockEntity;
            blockEntity2.sendUpdates(true);
        }
    }

    public ArrayList<String> getAllowedPlayersArray() {
        return this.allowed_players_array;
    }

    public void addAllowedPlayer(Player playerIn, boolean replace) {
        if (!this.checkIfAllowedPlayer(playerIn)) {
            String player = playerIn.getDisplayName().getString();
            if (replace) {
                if (this.allowed_players_array.size() > 0) {
                    this.allowed_players_array.set(0, player);
                } else {
                    this.allowed_players_array.add(player);
                }
            } else {
                this.allowed_players_array.add(player);
            }
        }
    }

    public void addAllowedPlayerNBT(String playerNameIn) {
        if (!this.checkIfAllowedPlayerNBT(playerNameIn)) {
            this.allowed_players_array.add(playerNameIn);
        }
    }

    private boolean checkIfAllowedPlayerNBT(String playerNameIn) {
        for (int i = 0; i < this.allowed_players_array.size(); ++i) {
            if (!this.allowed_players_array.get(i).equals(playerNameIn)) continue;
            return true;
        }
        return false;
    }

    public void removeAllowedPlayer(Player playerIn) {
        for (int i = 0; i < this.allowed_players_array.size(); ++i) {
            if (this.checkIfOwner(playerIn) || !this.allowed_players_array.get(i).equals(playerIn.getDisplayName().getString())) continue;
            this.allowed_players_array.remove(i);
        }
    }

    public void removeAllowedPlayerNBT(String playerNameIn) {
        for (int i = 0; i < this.allowed_players_array.size(); ++i) {
            String test_player = this.allowed_players_array.get(i);
            if (this.owner != null) {
                if (this.owner.getPlayerName().equals(playerNameIn) || !test_player.equals(playerNameIn)) continue;
                this.allowed_players_array.remove(i);
                continue;
            }
            if (!test_player.equals(playerNameIn)) continue;
            this.allowed_players_array.remove(i);
        }
    }

    public boolean checkIfAllowedPlayer(Player playerIn) {
        for (int i = 0; i < this.allowed_players_array.size(); ++i) {
            if (!this.allowed_players_array.get(i).equals(playerIn.getDisplayName().getString())) continue;
            return true;
        }
        return false;
    }

    public boolean checkIfPlayerCanShift(Player playerIn, EnumShiftDirection directionIn) {
        if (this.checkIfOwner(playerIn)) {
            return true;
        }
        if (this.getAllowedPlayerStateValue()) {
            if (this.getLockStateValue()) {
                return this.checkIfAllowedPlayer(playerIn);
            }
            return true;
        }
        return false;
    }

    public boolean canPlayerLeave(Player playerIn) {
        return this.checkIfOwner(playerIn) || this.checkIfAllowedPlayer(playerIn) ? true : !this.getTrapStateValue();
    }

    public void setMaxIO(int maxTransfer) {
        this.setMaxReceive(maxTransfer);
        this.setMaxExtract(maxTransfer);
    }

    public void setMaxReceive(int max_receive) {
        this.energy_max_receive = max_receive;
    }

    public void setMaxExtract(int max_extract) {
        this.energy_max_extract = max_extract;
    }

    public int getMaxReceive() {
        return this.energy_max_receive;
    }

    public int getMaxExtract() {
        return this.energy_max_extract;
    }

    public void setEnergyStored(int stored) {
        this.energy_stored = stored;
        if (this.energy_stored > this.energy_capacity) {
            this.energy_stored = this.energy_capacity;
        } else if (this.energy_stored < 0) {
            this.energy_stored = 0;
        }
    }

    public void modifyEnergyStored(int stored) {
        this.energy_stored += stored;
        if (this.energy_stored > this.energy_capacity) {
            this.energy_stored = this.energy_capacity;
        } else if (this.energy_stored < 0) {
            this.energy_stored = 0;
        }
    }

    public int receiveEnergy(int max_receive, boolean simulate) {
        int storedReceived = Math.min(this.getMaxEnergyStored() - this.energy_stored, Math.min(this.energy_max_receive, max_receive));
        if (!simulate) {
            this.energy_stored += storedReceived;
        }
        return storedReceived;
    }

    public int extractEnergy(int max_extract, boolean simulate) {
        int storedExtracted = Math.min(this.energy_stored, Math.min(this.energy_max_extract, max_extract));
        if (!simulate) {
            this.energy_stored -= storedExtracted;
        }
        return storedExtracted;
    }

    public int getEnergyStored() {
        return this.energy_stored;
    }

    public int getMaxEnergyStored() {
        return this.energy_capacity;
    }

    public boolean hasEnergyStored() {
        return this.energy_stored > 0;
    }

    public int getEnergyStoredScaled(int scale) {
        return this.getEnergyStored() / 100 * scale / (this.getMaxEnergyStored() / 100);
    }

    public boolean canExtractEnergy() {
        return this.hasEnergyStored();
    }

    public boolean canReceiveEnergy() {
        return this.getEnergyStored() < this.getMaxEnergyStored();
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank() {
        return this.getFluidTank().getFluid();
    }

    public int getFluidLevelScaled(int one) {
        float scaled = this.getCurrentFluidAmount() * one / this.getFluidTankCapacity() + 1;
        if (scaled == 0.0f && this.getCurrentFluidAmount() > 0) {
            return 1;
        }
        return (int)scaled;
    }

    public int getCurrentFluidAmount() {
        return this.fluid_tank.getFluidTank().getFluidAmount();
    }

    public Fluid getCurrentStoredFluid() {
        this.updateFluidFillLevel();
        if (!this.isFluidTankEmpty()) {
            return this.fluid_tank.getFluidTank().getFluid().getFluid();
        }
        return null;
    }

    public String getCurrentStoredFluidName() {
        if (this.isFluidTankEmpty()) {
            return "Empty";
        }
        return this.fluid_tank.getFluidTank().getFluid().getHoverName().getString();
    }

    public boolean isFluidTankEmpty() {
        return this.fluid_tank.getFluidTank().getFluidAmount() == 0;
    }

    public int getFluidTankCapacity() {
        return this.fluid_tank.getFluidTank().getCapacity();
    }

    public int getFluidFillLevel() {
        return this.fluid_tank.getFillLevel();
    }

    public void setFluidFillLevel(int set) {
        this.fluid_tank.setFillLevel(set);
    }

    public void updateFluidFillLevel() {
        if (!this.isFluidTankEmpty()) {
            if (this.getFluidLevelScaled(16) == 0) {
                this.fluid_tank.setFillLevel(1);
            } else {
                this.fluid_tank.setFillLevel(this.getFluidLevelScaled(16));
            }
        } else {
            this.fluid_tank.setFillLevel(0);
        }
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
        this.updateFluidFillLevel();
        return this.fluid_tank.getFluidTank().fill(resource, doFill);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
        this.updateFluidFillLevel();
        return this.fluid_tank.getFluidTank().drain(resource.getAmount(), doDrain);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
        this.updateFluidFillLevel();
        return this.fluid_tank.getFluidTank().drain(maxDrain, doDrain);
    }

    public boolean canFill(Direction from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(Direction from, Fluid fluid) {
        return true;
    }

    public FluidTank getFluidTank() {
        return this.fluid_tank.getFluidTank();
    }

    public void setFluidTank(FluidTank tank) {
        this.fluid_tank.setFluidTank(tank);
    }

    public void emptyFluidTank() {
        this.fluid_tank.getFluidTank().setFluid(FluidStack.EMPTY);
    }

    public EnumSideState getSide(Direction facing) {
        return this.pocket_side_array[facing.get3DDataValue()];
    }

    public void setSide(Direction facing, EnumSideState side_state, boolean update) {
        this.pocket_side_array[facing.get3DDataValue()] = side_state;
    }

    public EnumSideState[] getSideArray() {
        return this.pocket_side_array;
    }

    public void setSideArray(EnumSideState[] new_array, boolean update) {
        this.pocket_side_array = new_array;
    }

    public void cycleSide(Direction facing, boolean update) {
        this.setSide(facing, this.pocket_side_array[facing.get3DDataValue()].getNextState(), update);
    }

    public boolean canConnect(Direction direction) {
        return !this.pocket_side_array[direction.get3DDataValue()].equals((Object)EnumSideState.DISABLED);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.isEmpty() || slot < 0 || slot >= 64) {
            return stack;
        }
        ItemStack existing = (ItemStack)this.item_array.get(slot);
        if (existing.isEmpty()) {
            int insertAmount = Math.min(stack.getCount(), stack.getMaxStackSize());
            if (!simulate) {
                ItemStack newStack = stack.copy();
                newStack.setCount(insertAmount);
                this.item_array.set(slot, (Object)newStack);
            }
            if (stack.getCount() > insertAmount) {
                ItemStack remainder = stack.copy();
                remainder.shrink(insertAmount);
                return remainder;
            }
            return ItemStack.EMPTY;
        }
        if (!ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)stack)) {
            return stack;
        }
        int maxStackSize = existing.getMaxStackSize();
        int currentCount = existing.getCount();
        int insertAmount = Math.min(stack.getCount(), maxStackSize - currentCount);
        if (insertAmount <= 0) {
            return stack;
        }
        if (!simulate) {
            existing.grow(insertAmount);
        }
        if (stack.getCount() > insertAmount) {
            ItemStack remainder = stack.copy();
            remainder.shrink(insertAmount);
            return remainder;
        }
        return ItemStack.EMPTY;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = this.getItem(slot);
        if (stackInSlot.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (simulate) {
            if (stackInSlot.getCount() < amount) {
                return stackInSlot.copy();
            }
            ItemStack copy = stackInSlot.copy();
            copy.setCount(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.getCount(), amount);
        ItemStack decrStackSize = this.removeItem(slot, m);
        return decrStackSize;
    }

    public boolean canPlaceItem(int indexIn, ItemStack stackIn) {
        return true;
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.item_array) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int getContainerSize() {
        return this.item_array.size();
    }

    public ItemStack getItem(int index) {
        if (index < 48) {
            return (ItemStack)this.item_array.get(index);
        }
        return (ItemStack)this.surrounding_array.get(index - 48);
    }

    public ItemStack removeItem(int index, int count) {
        if (index < 48) {
            return ContainerHelper.removeItem(this.item_array, (int)index, (int)count);
        }
        return ContainerHelper.removeItem(this.surrounding_array, (int)(index - 48), (int)count);
    }

    public ItemStack removeItemNoUpdate(int index) {
        if (index < 48) {
            return ContainerHelper.takeItem(this.item_array, (int)index);
        }
        return ContainerHelper.takeItem(this.surrounding_array, (int)(index - 48));
    }

    public void setItem(int index, ItemStack stack) {
        if (index < 48) {
            this.item_array.set(index, (Object)stack);
        } else {
            this.surrounding_array.set(index - 48, (Object)stack);
        }
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
    }

    public void setChanged() {
    }

    public boolean stillValid(Player playerIn) {
        return true;
    }

    public void clearContent() {
    }

    public void setSurroundingStacks(Level levelIn, BlockPos posIn) {
        if (!levelIn.isClientSide()) {
            for (Direction dir : Direction.values()) {
                this.setItem(dir.get3DDataValue() + 48, new ItemStack((ItemLike)levelIn.getBlockState(posIn.offset(dir.getNormal())).getBlock()));
            }
        }
    }

    public void updateWallBlocks(Player playerIn, Level levelIn) {
        if (!levelIn.isClientSide() && playerIn != null && levelIn.dimension().equals(PocketsDimensionManager.POCKET_WORLD)) {
            int bottomYOffset = StorageManager.getPocketYOffset() + 2;
            int[] spacing = new int[]{1, 3};
            this.updateColumn(levelIn, this.getDominantChunkPos(), new BlockPos(1, 0, -1), new int[]{bottomYOffset, 0, ThreadLocalRandom.current().nextInt(spacing[0], spacing[1])});
            this.updateColumn(levelIn, this.getDominantChunkPos(), new BlockPos(-1, 0, 1), new int[]{bottomYOffset, 0, ThreadLocalRandom.current().nextInt(spacing[0], spacing[1])});
            if (!this.getChunkInfo().isSingleChunk()) {
                this.updateColumn(levelIn, this.getChunkInfo().getChunks().get(2), new BlockPos(1, 0, 15), new int[]{bottomYOffset, 0, ThreadLocalRandom.current().nextInt(spacing[0], spacing[1])});
                this.updateColumn(levelIn, this.getChunkInfo().getChunks().get(3), new BlockPos(15, 0, 13), new int[]{bottomYOffset, 0, ThreadLocalRandom.current().nextInt(spacing[0], spacing[1])});
            }
            StorageManager.saveRegistry((HolderLookup.Provider)levelIn.registryAccess());
        }
    }

    public void updateColumn(Level levelIn, CosmosChunkPos chunkPosIn, BlockPos posIn, int[] argsIn) {
        BlockPos worldPos = new BlockPos(CosmosChunkPos.scaleFromChunkPos((CosmosChunkPos)chunkPosIn).getX(), 0, CosmosChunkPos.scaleFromChunkPos((CosmosChunkPos)chunkPosIn).getZ());
        if (this.updateConnector(levelIn, chunkPosIn)) {
            for (int y = argsIn[0] + argsIn[1]; y < this.getInternalHeight(); y += argsIn[2]) {
                LevelChunk chunkIn = levelIn.getChunkAt(worldPos);
                BlockPos actualPos = MathHelper.addBlockPos((BlockPos)worldPos, (BlockPos)new BlockPos(posIn.getX(), y, posIn.getZ()));
                BlockState oldState = Blocks.STONE.defaultBlockState();
                BlockState newState = Blocks.AIR.defaultBlockState();
                levelIn.setBlockAndUpdate(actualPos, oldState);
                levelIn.setBlocksDirty(actualPos, oldState, newState);
                levelIn.markAndNotifyBlock(actualPos, chunkIn, oldState, newState, 3, 3);
                levelIn.updateNeighborsAt(actualPos, newState.getBlock());
                chunkIn.setBlockState(actualPos, newState, true);
                levelIn.sendBlockUpdated(actualPos, oldState, newState, 3);
                levelIn.setBlockAndUpdate(actualPos, newState);
            }
        }
    }

    public boolean updateBaseConnectors(Level levelIn) {
        boolean[] checks = new boolean[]{false, false, false, false};
        checks[0] = this.updateConnector(levelIn, this.getDominantChunkPos());
        if (!this.getChunkInfo().isSingleChunk()) {
            ArrayList<CosmosChunkPos> chunks = this.getChunkInfo().getChunks();
            for (int i = 1; i < chunks.size(); ++i) {
                checks[i] = this.updateConnector(levelIn, chunks.get(i));
            }
            return checks[0] && checks[1] && checks[2] && checks[3];
        }
        return checks[0];
    }

    public boolean updateConnector(Level levelIn, CosmosChunkPos chunkPosIn) {
        ServerLevel pocketLevel;
        if (!levelIn.isClientSide() && (pocketLevel = StorageManager.getServerLevel()) != null) {
            BlockPos pos = CosmosChunkPos.scaleFromChunkPos((CosmosChunkPos)chunkPosIn);
            BlockState state = pocketLevel.getBlockState(pos);
            BlockEntity blockEntity = pocketLevel.getBlockEntity(pos);
            if (blockEntity instanceof BlockEntityModuleConnector) {
                BlockEntityModuleConnector blockEntity2 = (BlockEntityModuleConnector)blockEntity;
                blockEntity2.sendUpdates(false);
                pocketLevel.sendBlockUpdated(pos, state, state, 3);
                return true;
            }
        }
        return false;
    }

    public void generatePocket(Player playerIn, Level levelIn) {
        ServerLevel level = StorageManager.getServerLevel();
        if (this.getInternalHeight() == PocketsConfigManager.getInstance().getInternalHeightEnhanced() && this.chunk_info.isSingleChunk()) {
            this.setInternalHeight(PocketsConfigManager.getInstance().getInternalHeight());
            this.setGeneratedState(false);
        }
        if (!this.getGeneratedStateValue() || this.chunk_info.isSingleChunk() && this.getInternalHeight() != PocketsConfigManager.getInstance().getInternalHeight() || !this.chunk_info.isSingleChunk() && this.getInternalHeight() != PocketsConfigManager.getInstance().getInternalHeightEnhanced()) {
            if (this.chunk_info.isSingleChunk()) {
                LevelChunk chunk = level.getChunk(this.getDominantChunkPos().getX(), this.getDominantChunkPos().getZ());
                BlockPos worldPos = new BlockPos(CosmosChunkPos.scaleFromChunkPos((CosmosChunkPos)this.getDominantChunkPos()).getX(), 1, CosmosChunkPos.scaleFromChunkPos((CosmosChunkPos)this.getDominantChunkPos()).getZ());
                int height = PocketsConfigManager.getInstance().getInternalHeight();
                if (height != this.getInternalHeight()) {
                    if (this.getInternalHeight() > height) {
                        if (PocketsConfigManager.getInstance().getInternalReplace()) {
                            int z;
                            int x;
                            int[] edge = new int[]{0, 14};
                            for (x = edge[0]; x < edge[1]; ++x) {
                                for (z = edge[0]; z < edge[1]; ++z) {
                                    BlockPos pos = new BlockPos(x, this.internal_height, z);
                                    if (!chunk.getBlockState(pos).getBlock().equals(PocketsRegistrationManager.BLOCK_WALL.get())) continue;
                                    chunk.setBlockState(pos, ((Block)PocketsRegistrationManager.BLOCK_WALL_EDGE.get()).defaultBlockState(), false);
                                }
                            }
                            this.generateStructureAndUpdate((Level)level);
                            this.setInternalHeight(height);
                            for (x = 0; x < StorageManager.getPocketSize(); ++x) {
                                for (z = 0; z < StorageManager.getPocketSize(); ++z) {
                                    BlockPos updatePos = new BlockPos(x, height - 1, z);
                                    if (!(level.getBlockState(updatePos).getBlock() instanceof BlockWallEdge)) continue;
                                    level.setBlockAndUpdate(updatePos, level.getBlockState(updatePos).updateShape(Direction.UP, level.getBlockState(updatePos), (LevelAccessor)level, updatePos, updatePos.offset(Direction.UP.getNormal())));
                                }
                            }
                        } else {
                            DimensionalPockets.CONSOLE.debug((Object)"[Pocket] <generatepocket> Pocket internal height is larger than the Config Value. Pocket will not reduce in size.");
                        }
                    } else {
                        int[] upd = new int[]{0, 1, 13, 14};
                        int[] rep = new int[]{1, 14};
                        for (int x = rep[0]; x < rep[1]; ++x) {
                            for (int z = rep[0]; z < rep[1]; ++z) {
                                BlockPos pos = new BlockPos(x, this.getInternalHeight(), z);
                                chunk.setBlockState(pos, Blocks.AIR.defaultBlockState(), false);
                            }
                        }
                        this.generateStructureAndUpdate((Level)level);
                        BlockPos upd1 = MathHelper.addBlockPos((BlockPos)worldPos, (BlockPos)new BlockPos(upd[0], this.getInternalHeight() - 1, upd[1]));
                        BlockPos upd2 = MathHelper.addBlockPos((BlockPos)worldPos, (BlockPos)new BlockPos(upd[1], this.getInternalHeight() - 1, upd[0]));
                        BlockPos upd3 = MathHelper.addBlockPos((BlockPos)worldPos, (BlockPos)new BlockPos(upd[2], this.getInternalHeight() - 1, upd[3]));
                        BlockPos upd4 = MathHelper.addBlockPos((BlockPos)worldPos, (BlockPos)new BlockPos(upd[3], this.getInternalHeight() - 1, upd[2]));
                        BlockPos upd5 = MathHelper.addBlockPos((BlockPos)worldPos, (BlockPos)new BlockPos(upd[0], this.getInternalHeight() - 1, upd[2]));
                        BlockPos upd6 = MathHelper.addBlockPos((BlockPos)worldPos, (BlockPos)new BlockPos(upd[1], this.getInternalHeight() - 1, upd[3]));
                        BlockPos upd7 = MathHelper.addBlockPos((BlockPos)worldPos, (BlockPos)new BlockPos(upd[2], this.getInternalHeight() - 1, upd[0]));
                        BlockPos upd8 = MathHelper.addBlockPos((BlockPos)worldPos, (BlockPos)new BlockPos(upd[3], this.getInternalHeight() - 1, upd[1]));
                        level.setBlockAndUpdate(upd1, ((Block)PocketsRegistrationManager.BLOCK_WALL_EDGE.get()).defaultBlockState().updateShape(Direction.UP, level.getBlockState(upd1), (LevelAccessor)level, upd1, upd1.offset(Direction.UP.getNormal())));
                        level.setBlockAndUpdate(upd2, ((Block)PocketsRegistrationManager.BLOCK_WALL_EDGE.get()).defaultBlockState().updateShape(Direction.UP, level.getBlockState(upd2), (LevelAccessor)level, upd2, upd2.offset(Direction.UP.getNormal())));
                        level.setBlockAndUpdate(upd3, ((Block)PocketsRegistrationManager.BLOCK_WALL_EDGE.get()).defaultBlockState().updateShape(Direction.UP, level.getBlockState(upd3), (LevelAccessor)level, upd3, upd3.offset(Direction.UP.getNormal())));
                        level.setBlockAndUpdate(upd4, ((Block)PocketsRegistrationManager.BLOCK_WALL_EDGE.get()).defaultBlockState().updateShape(Direction.UP, level.getBlockState(upd4), (LevelAccessor)level, upd4, upd4.offset(Direction.UP.getNormal())));
                        level.setBlockAndUpdate(upd5, ((Block)PocketsRegistrationManager.BLOCK_WALL_EDGE.get()).defaultBlockState().updateShape(Direction.UP, level.getBlockState(upd5), (LevelAccessor)level, upd5, upd5.offset(Direction.UP.getNormal())));
                        level.setBlockAndUpdate(upd6, ((Block)PocketsRegistrationManager.BLOCK_WALL_EDGE.get()).defaultBlockState().updateShape(Direction.UP, level.getBlockState(upd6), (LevelAccessor)level, upd6, upd6.offset(Direction.UP.getNormal())));
                        level.setBlockAndUpdate(upd7, ((Block)PocketsRegistrationManager.BLOCK_WALL_EDGE.get()).defaultBlockState().updateShape(Direction.UP, level.getBlockState(upd7), (LevelAccessor)level, upd7, upd7.offset(Direction.UP.getNormal())));
                        level.setBlockAndUpdate(upd8, ((Block)PocketsRegistrationManager.BLOCK_WALL_EDGE.get()).defaultBlockState().updateShape(Direction.UP, level.getBlockState(upd8), (LevelAccessor)level, upd8, upd8.offset(Direction.UP.getNormal())));
                        this.setInternalHeight(height);
                    }
                    chunk.isUnsaved();
                } else {
                    this.generateStructureAndUpdate((Level)level);
                }
                Block check_block_one = level.getBlockState(MathHelper.addBlockPos((BlockPos)worldPos, (BlockPos)new BlockPos(1, 0, 1))).getBlock();
                Block check_block_two = level.getBlockState(MathHelper.addBlockPos((BlockPos)worldPos, (BlockPos)new BlockPos(2, 0, 2))).getBlock();
                Block check_block_three = level.getBlockState(MathHelper.addBlockPos((BlockPos)worldPos, (BlockPos)new BlockPos(0, -1, 0))).getBlock();
                Block check_block_four = level.getBlockState(MathHelper.addBlockPos((BlockPos)worldPos, (BlockPos)new BlockPos(0, this.getInternalHeight() - 1, 0))).getBlock();
                this.setOwner(playerIn);
                this.setGeneratedState(check_block_one instanceof BlockWallEdge && check_block_two instanceof BlockWallBase && check_block_three.equals(PocketsRegistrationManager.BLOCK_WALL_CONNECTOR.get()) && check_block_four.equals(Blocks.BEDROCK));
                StorageManager.saveRegistry((HolderLookup.Provider)levelIn.registryAccess());
            } else if (!this.getChunkInfo().isSingleChunk()) {
                int height = PocketsConfigManager.getInstance().getInternalHeightEnhanced();
                BlockPos[] worldPos = new BlockPos[]{new BlockPos(CosmosChunkPos.scaleFromChunkPos((CosmosChunkPos)this.getDominantChunkPos()).getX(), 1, CosmosChunkPos.scaleFromChunkPos((CosmosChunkPos)this.getDominantChunkPos()).getZ()), new BlockPos(CosmosChunkPos.scaleFromChunkPos((CosmosChunkPos)this.getChunkInfo().getChunks().get(1)).getX(), 1, CosmosChunkPos.scaleFromChunkPos((CosmosChunkPos)this.getChunkInfo().getChunks().get(1)).getZ()), new BlockPos(CosmosChunkPos.scaleFromChunkPos((CosmosChunkPos)this.getChunkInfo().getChunks().get(2)).getX(), 1, CosmosChunkPos.scaleFromChunkPos((CosmosChunkPos)this.getChunkInfo().getChunks().get(2)).getZ()), new BlockPos(CosmosChunkPos.scaleFromChunkPos((CosmosChunkPos)this.getChunkInfo().getChunks().get(3)).getX(), 1, CosmosChunkPos.scaleFromChunkPos((CosmosChunkPos)this.getChunkInfo().getChunks().get(3)).getZ())};
                if (height != this.getInternalHeight()) {
                    if (this.getInternalHeight() < PocketsConfigManager.getInstance().getInternalHeight()) {
                        int[] rep = new int[]{0, 16};
                        for (int i = 0; i < this.chunk_info.getChunks().size(); ++i) {
                            for (int x = rep[0]; x < rep[1]; ++x) {
                                for (int z = rep[0]; z < rep[1]; ++z) {
                                    BlockPos pos = new BlockPos(x, this.getInternalHeight(), z);
                                    level.getChunk(this.chunk_info.getChunks().get(i).getX(), this.chunk_info.getChunks().get(i).getZ()).setBlockState(pos, Blocks.AIR.defaultBlockState(), false);
                                }
                            }
                        }
                        this.setInternalHeight(height);
                        this.generateStructureAndUpdate((Level)level);
                    }
                    if (this.getInternalHeight() > height && PocketsConfigManager.getInstance().getInternalReplace()) {
                        // empty if block
                    }
                } else {
                    this.generateStructureAndUpdate((Level)level);
                }
                Block check_one_one = level.getBlockState(MathHelper.addBlockPos((BlockPos)worldPos[0], (BlockPos)new BlockPos(1, 0, 1))).getBlock();
                Block check_one_two = level.getBlockState(MathHelper.addBlockPos((BlockPos)worldPos[0], (BlockPos)new BlockPos(2, 0, 2))).getBlock();
                Block check_one_three = level.getBlockState(MathHelper.addBlockPos((BlockPos)worldPos[0], (BlockPos)new BlockPos(0, -1, 0))).getBlock();
                Block check_one_four = level.getBlockState(MathHelper.addBlockPos((BlockPos)worldPos[0], (BlockPos)new BlockPos(0, this.getInternalHeight() - 1, 0))).getBlock();
                Block check_two_one = level.getBlockState(MathHelper.addBlockPos((BlockPos)worldPos[1], (BlockPos)new BlockPos(14, 1, 0))).getBlock();
                Block check_two_two = level.getBlockState(MathHelper.addBlockPos((BlockPos)worldPos[1], (BlockPos)new BlockPos(0, -1, 0))).getBlock();
                Block check_three = level.getBlockState(MathHelper.addBlockPos((BlockPos)worldPos[2], (BlockPos)new BlockPos(0, -1, 0))).getBlock();
                boolean checks = check_one_one instanceof BlockWallEdge && check_one_two instanceof BlockWallBase && check_one_three.equals(PocketsRegistrationManager.BLOCK_WALL_CONNECTOR.get()) && check_one_four.equals(Blocks.BEDROCK) && check_two_one.equals(Blocks.BEDROCK) && check_two_two.equals(PocketsRegistrationManager.BLOCK_WALL_CONNECTOR.get()) && check_three.equals(PocketsRegistrationManager.BLOCK_WALL_CONNECTOR.get());
                this.setOwner(playerIn);
                this.setGeneratedState(checks);
                StorageManager.saveRegistry((HolderLookup.Provider)levelIn.registryAccess());
            }
        } else {
            BlockPos pos = new BlockPos(CosmosChunkPos.scaleFromChunkPos((CosmosChunkPos)this.getDominantChunkPos()).getX(), 0, CosmosChunkPos.scaleFromChunkPos((CosmosChunkPos)this.getDominantChunkPos()).getZ());
            if (level.getBlockEntity(pos) == null) {
                level.setBlockAndUpdate(pos, ((Block)PocketsRegistrationManager.BLOCK_WALL_CONNECTOR.get()).defaultBlockState());
                level.setBlockAndUpdate(pos.offset(Direction.UP.getNormal()), Blocks.BEDROCK.defaultBlockState());
            }
        }
        if (this.chunk_info == PocketChunkInfo.EMPTY) {
            this.chunk_info = new PocketChunkInfo(this.chunk_pos, true);
        }
    }

    public void generateStructureAndUpdate(Level levelIn) {
        block59: {
            BlockState worldState;
            BlockPos world_pos;
            BlockPos pos;
            boolean flagZ;
            boolean flagY;
            boolean flagX;
            int z;
            int y;
            int x;
            int size;
            int y_offset;
            block60: {
                y_offset = StorageManager.getPocketYOffset();
                size = StorageManager.getPocketSize();
                if (!PocketEventFactory.onPocketGenerate(levelIn, this)) break block59;
                if (!this.getChunkInfo().isSingleChunk()) break block60;
                int height = PocketsConfigManager.getInstance().getInternalHeight();
                BlockPos worldPos = new BlockPos(CosmosChunkPos.scaleFromChunkPos((CosmosChunkPos)this.getDominantChunkPos()).getX(), 1, CosmosChunkPos.scaleFromChunkPos((CosmosChunkPos)this.getDominantChunkPos()).getZ());
                LevelChunk levelChunk = levelIn.getChunk(this.getDominantChunkPos().getX(), this.getDominantChunkPos().getZ());
                for (int x2 = 0; x2 < size; ++x2) {
                    for (int y2 = y_offset; y2 < height + y_offset; ++y2) {
                        for (int z2 = 0; z2 < size; ++z2) {
                            boolean flagX2 = x2 == 0 || x2 == size - 1;
                            boolean flagY2 = y2 == y_offset || y2 == height;
                            boolean flagZ2 = z2 == 0 || z2 == size - 1;
                            BlockPos pos2 = new BlockPos(x2, y2, z2);
                            BlockPos world_pos2 = new BlockPos(worldPos.getX() + x2, y2, worldPos.getZ() + z2);
                            if (!(levelChunk.getBlockState(pos2).getBlock() instanceof BlockWallModule)) {
                                if (x2 == 0 || y2 == 1 || z2 == 0) {
                                    levelChunk.setBlockState(pos2, Blocks.BEDROCK.defaultBlockState(), false);
                                } else if (x2 == size - 1 || y2 == height - (1 - y_offset) || z2 == size - 1) {
                                    levelChunk.setBlockState(pos2, Blocks.BEDROCK.defaultBlockState(), false);
                                }
                            }
                            if (x2 == 0 && y2 == 1 && z2 == 0) {
                                levelIn.setBlockAndUpdate(world_pos2.offset(Direction.DOWN.getNormal()), ((Block)PocketsRegistrationManager.BLOCK_WALL_CONNECTOR.get()).defaultBlockState());
                            }
                            if (!flagX2 && !flagY2 && !flagZ2 || flagX2 && (flagY2 || flagZ2) || flagY2 && flagZ2) continue;
                            if (x2 == 1 || y2 == 1 + y_offset || z2 == 1) {
                                levelChunk.setBlockState(pos2, ((Block)PocketsRegistrationManager.BLOCK_WALL_EDGE.get()).defaultBlockState().updateShape(Direction.UP, levelChunk.getBlockState(pos2), (LevelAccessor)levelIn, pos2, pos2.offset(Direction.UP.getNormal())), false);
                            } else if (x2 == size - 2 || y2 == height - (2 - y_offset) || z2 == size - 2) {
                                levelChunk.setBlockState(pos2, ((Block)PocketsRegistrationManager.BLOCK_WALL_EDGE.get()).defaultBlockState().updateShape(Direction.UP, levelChunk.getBlockState(pos2), (LevelAccessor)levelIn, pos2, pos2.offset(Direction.UP.getNormal())), false);
                            } else if (!(levelChunk.getBlockState(pos2).getBlock() instanceof BlockWallModule)) {
                                levelChunk.setBlockState(pos2, ((Block)PocketsRegistrationManager.BLOCK_WALL.get()).defaultBlockState().updateShape(Direction.UP, levelChunk.getBlockState(pos2), (LevelAccessor)levelIn, pos2, pos2.offset(Direction.UP.getNormal())), false);
                            }
                            BlockState worldState2 = levelIn.getBlockState(world_pos2);
                            levelIn.sendBlockUpdated(world_pos2, worldState2, worldState2.getBlock().defaultBlockState(), 19);
                            levelIn.markAndNotifyBlock(world_pos2, levelChunk, worldState2, worldState2.getBlock().defaultBlockState(), 19, 0);
                            worldState2.updateNeighbourShapes((LevelAccessor)levelIn, world_pos2, 19);
                            worldState2.updateIndirectNeighbourShapes((LevelAccessor)levelIn, world_pos2, 19);
                        }
                    }
                }
                break block59;
            }
            if (this.getChunkInfo().isSingleChunk()) break block59;
            int height = PocketsConfigManager.getInstance().getInternalHeightEnhanced();
            CosmosChunkPos chunkPosA = this.getDominantChunkPos();
            BlockPos worldPosA = new BlockPos(CosmosChunkPos.scaleFromChunkPos((CosmosChunkPos)chunkPosA).getX(), 1, CosmosChunkPos.scaleFromChunkPos((CosmosChunkPos)chunkPosA).getZ());
            LevelChunk levelChunkA = levelIn.getChunk(chunkPosA.getX(), chunkPosA.getZ());
            for (x = 0; x < size + 1; ++x) {
                for (y = y_offset; y < height + y_offset; ++y) {
                    for (z = 0; z < size + 1; ++z) {
                        flagX = x == 0;
                        flagY = y == y_offset || y == height;
                        flagZ = z == 0;
                        pos = new BlockPos(x, y, z);
                        world_pos = new BlockPos(worldPosA.getX() + x, y, worldPosA.getZ() + z);
                        if (!(levelChunkA.getBlockState(pos).getBlock() instanceof BlockWallModule || x != 0 && y != 1 && z != 0)) {
                            levelChunkA.setBlockState(pos, Blocks.BEDROCK.defaultBlockState(), false);
                        }
                        if (x == 0 && y == 1 && z == 0) {
                            levelIn.setBlockAndUpdate(world_pos.offset(Direction.DOWN.getNormal()), ((Block)PocketsRegistrationManager.BLOCK_WALL_CONNECTOR.get()).defaultBlockState());
                        }
                        if (!flagX && !flagY && !flagZ || flagX && (flagY || flagZ) || flagY && flagZ) continue;
                        if (x == 1 || y == 1 + y_offset || z == 1) {
                            levelChunkA.setBlockState(pos, ((Block)PocketsRegistrationManager.BLOCK_WALL_EDGE.get()).defaultBlockState().updateShape(Direction.UP, levelChunkA.getBlockState(pos), (LevelAccessor)levelIn, pos, pos.offset(Direction.UP.getNormal())), false);
                        } else if (y == height - (2 - y_offset)) {
                            levelChunkA.setBlockState(pos, ((Block)PocketsRegistrationManager.BLOCK_WALL_EDGE.get()).defaultBlockState().updateShape(Direction.UP, levelChunkA.getBlockState(pos), (LevelAccessor)levelIn, pos, pos.offset(Direction.UP.getNormal())), false);
                        } else if (!(levelChunkA.getBlockState(pos).getBlock() instanceof BlockWallModule)) {
                            levelChunkA.setBlockState(pos, ((Block)PocketsRegistrationManager.BLOCK_WALL.get()).defaultBlockState().updateShape(Direction.UP, levelChunkA.getBlockState(pos), (LevelAccessor)levelIn, pos, pos.offset(Direction.UP.getNormal())), false);
                        }
                        worldState = levelIn.getBlockState(world_pos);
                        levelIn.sendBlockUpdated(world_pos, worldState, worldState.getBlock().defaultBlockState(), 19);
                        levelIn.markAndNotifyBlock(world_pos, levelChunkA, worldState, worldState.getBlock().defaultBlockState(), 19, 0);
                        worldState.updateNeighbourShapes((LevelAccessor)levelIn, world_pos, 19);
                        worldState.updateIndirectNeighbourShapes((LevelAccessor)levelIn, world_pos, 19);
                    }
                }
            }
            CosmosChunkPos chunkPosB = this.getChunkInfo().getChunks().get(1);
            BlockPos worldPosB = new BlockPos(CosmosChunkPos.scaleFromChunkPos((CosmosChunkPos)chunkPosB).getX(), 1, CosmosChunkPos.scaleFromChunkPos((CosmosChunkPos)chunkPosB).getZ());
            LevelChunk levelChunkB = levelIn.getChunk(chunkPosB.getX(), chunkPosB.getZ());
            for (x = 0; x < size; ++x) {
                for (y = y_offset; y < height + y_offset; ++y) {
                    for (z = 0; z < size + 1; ++z) {
                        flagX = x == size - 1;
                        flagY = y == y_offset || y == height;
                        flagZ = z == 0;
                        pos = new BlockPos(x, y, z);
                        world_pos = new BlockPos(worldPosB.getX() + x, y, worldPosB.getZ() + z);
                        if (!(levelChunkB.getBlockState(pos).getBlock() instanceof BlockWallModule)) {
                            if (y == 1 || z == 0) {
                                levelChunkB.setBlockState(pos, Blocks.BEDROCK.defaultBlockState(), false);
                            } else if (x == size - 1 || y == height - (1 - y_offset)) {
                                levelChunkB.setBlockState(pos, Blocks.BEDROCK.defaultBlockState(), false);
                            }
                        }
                        if (x == 0 && y == 1 && z == 0) {
                            levelIn.setBlockAndUpdate(world_pos.offset(Direction.DOWN.getNormal()), ((Block)PocketsRegistrationManager.BLOCK_WALL_CONNECTOR.get()).defaultBlockState());
                        }
                        if (!flagX && !flagY && !flagZ || flagX && (flagY || flagZ) || flagY && flagZ) continue;
                        if (y == 1 + y_offset || z == 1) {
                            levelChunkB.setBlockState(pos, ((Block)PocketsRegistrationManager.BLOCK_WALL_EDGE.get()).defaultBlockState().updateShape(Direction.UP, levelChunkB.getBlockState(pos), (LevelAccessor)levelIn, pos, pos.offset(Direction.UP.getNormal())), false);
                        } else if (x == size - 2 || y == height - (2 - y_offset)) {
                            levelChunkB.setBlockState(pos, ((Block)PocketsRegistrationManager.BLOCK_WALL_EDGE.get()).defaultBlockState().updateShape(Direction.UP, levelChunkB.getBlockState(pos), (LevelAccessor)levelIn, pos, pos.offset(Direction.UP.getNormal())), false);
                        } else if (!(levelChunkB.getBlockState(pos).getBlock() instanceof BlockWallModule)) {
                            levelChunkB.setBlockState(pos, ((Block)PocketsRegistrationManager.BLOCK_WALL.get()).defaultBlockState().updateShape(Direction.UP, levelChunkB.getBlockState(pos), (LevelAccessor)levelIn, pos, pos.offset(Direction.UP.getNormal())), false);
                        }
                        worldState = levelIn.getBlockState(world_pos);
                        levelIn.sendBlockUpdated(world_pos, worldState, worldState.getBlock().defaultBlockState(), 19);
                        levelIn.markAndNotifyBlock(world_pos, levelChunkB, worldState, worldState.getBlock().defaultBlockState(), 19, 0);
                        worldState.updateNeighbourShapes((LevelAccessor)levelIn, world_pos, 19);
                        worldState.updateIndirectNeighbourShapes((LevelAccessor)levelIn, world_pos, 19);
                    }
                }
            }
            CosmosChunkPos chunkPosC = this.getChunkInfo().getChunks().get(2);
            BlockPos worldPosC = new BlockPos(CosmosChunkPos.scaleFromChunkPos((CosmosChunkPos)chunkPosC).getX(), 1, CosmosChunkPos.scaleFromChunkPos((CosmosChunkPos)chunkPosC).getZ());
            LevelChunk levelChunkC = levelIn.getChunk(chunkPosC.getX(), chunkPosC.getZ());
            for (x = 0; x < size + 1; ++x) {
                for (y = y_offset; y < height + y_offset; ++y) {
                    for (z = 0; z < size; ++z) {
                        flagX = x == 0;
                        flagY = y == y_offset || y == height;
                        flagZ = z == size - 1;
                        pos = new BlockPos(x, y, z);
                        world_pos = new BlockPos(worldPosC.getX() + x, y, worldPosC.getZ() + z);
                        if (!(levelChunkC.getBlockState(pos).getBlock() instanceof BlockWallModule)) {
                            if (x == 0 || y == 1) {
                                levelChunkC.setBlockState(pos, Blocks.BEDROCK.defaultBlockState(), false);
                            } else if (y == height - (1 - y_offset) || z == size - 1) {
                                levelChunkC.setBlockState(pos, Blocks.BEDROCK.defaultBlockState(), false);
                            }
                        }
                        if (x == 0 && y == 1 && z == 0) {
                            levelIn.setBlockAndUpdate(world_pos.offset(Direction.DOWN.getNormal()), ((Block)PocketsRegistrationManager.BLOCK_WALL_CONNECTOR.get()).defaultBlockState());
                        }
                        if (!flagX && !flagY && !flagZ || flagX && (flagY || flagZ) || flagY && flagZ) continue;
                        if (x == 1 || y == 1 + y_offset) {
                            levelChunkC.setBlockState(pos, ((Block)PocketsRegistrationManager.BLOCK_WALL_EDGE.get()).defaultBlockState().updateShape(Direction.UP, levelChunkC.getBlockState(pos), (LevelAccessor)levelIn, pos, pos.offset(Direction.UP.getNormal())), false);
                        } else if (y == height - (2 - y_offset) || z == size - 2) {
                            levelChunkC.setBlockState(pos, ((Block)PocketsRegistrationManager.BLOCK_WALL_EDGE.get()).defaultBlockState().updateShape(Direction.UP, levelChunkC.getBlockState(pos), (LevelAccessor)levelIn, pos, pos.offset(Direction.UP.getNormal())), false);
                        } else if (!(levelChunkC.getBlockState(pos).getBlock() instanceof BlockWallModule)) {
                            levelChunkC.setBlockState(pos, ((Block)PocketsRegistrationManager.BLOCK_WALL.get()).defaultBlockState().updateShape(Direction.UP, levelChunkC.getBlockState(pos), (LevelAccessor)levelIn, pos, pos.offset(Direction.UP.getNormal())), false);
                        }
                        worldState = levelIn.getBlockState(world_pos);
                        levelIn.sendBlockUpdated(world_pos, worldState, worldState.getBlock().defaultBlockState(), 19);
                        levelIn.markAndNotifyBlock(world_pos, levelChunkC, worldState, worldState.getBlock().defaultBlockState(), 19, 0);
                        worldState.updateNeighbourShapes((LevelAccessor)levelIn, world_pos, 19);
                        worldState.updateIndirectNeighbourShapes((LevelAccessor)levelIn, world_pos, 19);
                    }
                }
            }
            CosmosChunkPos chunkPosD = this.getChunkInfo().getChunks().get(3);
            BlockPos worldPosD = new BlockPos(CosmosChunkPos.scaleFromChunkPos((CosmosChunkPos)chunkPosD).getX(), 1, CosmosChunkPos.scaleFromChunkPos((CosmosChunkPos)chunkPosD).getZ());
            LevelChunk levelChunkD = levelIn.getChunk(chunkPosD.getX(), chunkPosD.getZ());
            for (x = 0; x < size; ++x) {
                for (y = y_offset; y < height + y_offset; ++y) {
                    for (z = 0; z < size; ++z) {
                        flagX = x == size - 1;
                        flagY = y == y_offset || y == height;
                        flagZ = z == size - 1;
                        pos = new BlockPos(x, y, z);
                        world_pos = new BlockPos(worldPosD.getX() + x, y, worldPosD.getZ() + z);
                        if (!(levelChunkD.getBlockState(pos).getBlock() instanceof BlockWallModule || x != size - 1 && y != height - (1 - y_offset) && z != size - 1)) {
                            levelChunkD.setBlockState(pos, Blocks.BEDROCK.defaultBlockState(), false);
                        }
                        if (x == 0 && y == 1 && z == 0) {
                            levelIn.setBlockAndUpdate(world_pos.offset(Direction.DOWN.getNormal()), ((Block)PocketsRegistrationManager.BLOCK_WALL_CONNECTOR.get()).defaultBlockState());
                        }
                        if (!flagX && !flagY && !flagZ || flagX && (flagY || flagZ) || flagY && flagZ) continue;
                        if (y == 1 + y_offset) {
                            levelChunkD.setBlockState(pos, ((Block)PocketsRegistrationManager.BLOCK_WALL_EDGE.get()).defaultBlockState().updateShape(Direction.UP, levelChunkD.getBlockState(pos), (LevelAccessor)levelIn, pos, pos.offset(Direction.UP.getNormal())), false);
                        } else if (x == size - 2 || y == height - (2 - y_offset) || z == size - 2) {
                            levelChunkD.setBlockState(pos, ((Block)PocketsRegistrationManager.BLOCK_WALL_EDGE.get()).defaultBlockState().updateShape(Direction.UP, levelChunkD.getBlockState(pos), (LevelAccessor)levelIn, pos, pos.offset(Direction.UP.getNormal())), false);
                        } else if (!(levelChunkD.getBlockState(pos).getBlock() instanceof BlockWallModule)) {
                            levelChunkD.setBlockState(pos, ((Block)PocketsRegistrationManager.BLOCK_WALL.get()).defaultBlockState().updateShape(Direction.UP, levelChunkD.getBlockState(pos), (LevelAccessor)levelIn, pos, pos.offset(Direction.UP.getNormal())), false);
                        }
                        worldState = levelIn.getBlockState(world_pos);
                        levelIn.sendBlockUpdated(world_pos, worldState, worldState.getBlock().defaultBlockState(), 19);
                        levelIn.markAndNotifyBlock(world_pos, levelChunkD, worldState, worldState.getBlock().defaultBlockState(), 19, 0);
                        worldState.updateNeighbourShapes((LevelAccessor)levelIn, world_pos, 19);
                        worldState.updateIndirectNeighbourShapes((LevelAccessor)levelIn, world_pos, 19);
                    }
                }
            }
        }
    }

    public void shift(Player playerIn, EnumShiftDirection direction, @Nullable BlockPos pocket_pos, @Nullable ResourceKey<Level> dimensionIn, @Nullable ItemStack stack) {
        if (playerIn.level().isClientSide() || !(playerIn instanceof ServerPlayer)) {
            return;
        }
        Level source_world = this.getSourceBlockLevel();
        ServerPlayer server_player = (ServerPlayer)playerIn;
        if (this.checkIfPlayerCanShift(playerIn, direction)) {
            if (direction.equals((Object)EnumShiftDirection.ENTER)) {
                if (pocket_pos != null && dimensionIn != null) {
                    this.addPosToBlockArray(pocket_pos, dimensionIn.location());
                }
                BlockPos chunk = CosmosChunkPos.scaleFromChunkPos((CosmosChunkPos)this.getDominantChunkPos());
                EnumSafeTeleport location = EnumSafeTeleport.getValidTeleportLocation((Level)StorageManager.getServerLevel(), (BlockPos)MathHelper.addBlockPos((BlockPos)chunk, (BlockPos)this.getSpawnPos()));
                if (location != EnumSafeTeleport.UNKNOWN) {
                    boolean safeLocation = EnumSafeTeleport.isSafeTeleportLocation((Level)StorageManager.getServerLevel(), (BlockPos)MathHelper.addBlockPos((BlockPos)chunk, (BlockPos)this.getSpawnPos()));
                    BlockPos test = location.toBlockPos();
                    BlockPos spawn = this.getSpawnPos();
                    BlockPos shiftPos = MathHelper.addBlockPos((BlockPos)chunk, (BlockPos)spawn, (BlockPos)test);
                    Shifter shifter = Shifter.createTeleporter(PocketsDimensionManager.POCKET_WORLD, direction, shiftPos, this.spawn_pos.getYaw(), this.spawn_pos.getPitch(), false, true, false);
                    this.generatePocket((Player)server_player, source_world);
                    ShifterCore.shiftPlayerToDimension((Player)server_player, shifter, !safeLocation);
                    if (stack != null) {
                        CoreTriggers.triggerUseShifter(server_player, stack);
                    }
                } else {
                    ShifterCore.sendPlayerToBedWithMessage((Player)server_player, direction, "dimensionalpocketsii.pocket.status.location_blocked");
                }
            } else if (direction.equals((Object)EnumShiftDirection.LEAVE)) {
                if (this.isSourceBlockPlaced()) {
                    if (this.canPlayerLeave(playerIn)) {
                        EnumSafeTeleport location = EnumSafeTeleport.getValidTeleportLocation((Level)source_world, (BlockPos)this.getLastBlockPos());
                        boolean safeLcation = EnumSafeTeleport.isSafeTeleportLocation((Level)source_world, (BlockPos)this.getLastBlockPos());
                        if (location != EnumSafeTeleport.UNKNOWN) {
                            Shifter shifter = Shifter.createTeleporter(this.getSourceBlockDimension(), direction, MathHelper.addBlockPos((BlockPos)this.getLastBlockPos(), (BlockPos)location.toBlockPos()), 0.0f, 0.0f, false, true, false);
                            if (stack != null) {
                                CoreTriggers.triggerUseShifter(server_player, stack);
                            }
                            ShifterCore.shiftPlayerToDimension((Player)server_player, shifter, !safeLcation);
                        } else {
                            ShifterCore.sendPlayerToBedWithMessage((Player)server_player, direction, "dimensionalpocketsii.pocket.status.blocked");
                            Shifter shifter = Shifter.createTeleporter(this.getSourceBlockDimension(), direction, this.getSourceBlockLevel().getSharedSpawnPos(), 0.0f, 0.0f, false, true, false);
                            if (stack != null) {
                                CoreTriggers.triggerUseShifter(server_player, stack);
                            }
                            ShifterCore.shiftPlayerToDimension((Player)server_player, shifter, !safeLcation);
                        }
                    } else {
                        CosmosChatUtil.sendServerPlayerMessage((Player)server_player, (Component)ComponentHelper.style((ComponentColour)ComponentColour.LIGHT_RED, (String)"dimensionalpocketsii.pocket.status.trapped"));
                    }
                } else {
                    ShifterCore.sendPlayerToBedWithMessage((Player)server_player, direction, "dimensionalpocketsii.pocket.status.broken");
                }
            } else {
                ShifterCore.sendPlayerToBedWithMessage((Player)server_player, direction, "dimensionalpocketsii.pocket.status.direction_unknown");
            }
        } else {
            CosmosChatUtil.sendServerPlayerMessage((Player)server_player, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.status.locked"));
        }
    }

    public void writeToNBT(CompoundTag tag, HolderLookup.Provider provider) {
        tag.put(NBT_DIMENSIONAL_POCKET_KEY, (Tag)this.getNBT(provider));
    }

    private CompoundTag getNBT(HolderLookup.Provider provider) {
        CompoundTag compound_nbt = new CompoundTag();
        if (this.getOwner() != null) {
            this.getOwner().writeToNBT(compound_nbt, NBT_OWNER_KEY);
        }
        compound_nbt.putBoolean(NBT_GENERATED_KEY, this.getGeneratedStateValue());
        compound_nbt.putBoolean(NBT_LOCKED_KEY, this.getLockStateValue());
        compound_nbt.putBoolean(NBT_TRAP_KEY, this.getTrapStateValue());
        compound_nbt.putBoolean(NBT_ALLOWED_PLAYER_SHIFT_KEY, this.getAllowedPlayerStateValue());
        compound_nbt.putBoolean(NBT_HOSTILE_SPAWNS_KEY, this.getHostileSpawnStateValue());
        compound_nbt.putInt(NBT_COLOUR_KEY, this.getDisplayColour());
        compound_nbt.putInt(NBT_INTERNAL_HEIGHT_KEY, this.getInternalHeight());
        compound_nbt.putInt(NBT_ENERGY_STORED_KEY, this.getEnergyStored());
        compound_nbt.putInt(NBT_ENERGY_CAPACITY_KEY, this.getMaxEnergyStored());
        compound_nbt.putInt(NBT_ENERGY_RECEIVE_KEY, this.getMaxReceive());
        compound_nbt.putInt(NBT_ENERGY_EXTRACT_KEY, this.getMaxExtract());
        CompoundTag chunkPos = new CompoundTag();
        this.chunk_pos.saveRaw(chunkPos);
        compound_nbt.put(NBT_CHUNK_POS_KEY, (Tag)chunkPos);
        CompoundTag chunk = new CompoundTag();
        this.chunk_info.save(chunk);
        compound_nbt.put(NBT_CHUNK_INFO_KEY, (Tag)chunk);
        CompoundTag blockDimension = new CompoundTag();
        blockDimension.putString("namespace", this.block_dimension.getNamespace());
        blockDimension.putString("path", this.block_dimension.getPath());
        compound_nbt.put(NBT_BLOCK_DIMENSION_KEY, (Tag)blockDimension);
        CompoundTag last = new CompoundTag();
        this.last_pos.save(last);
        compound_nbt.put(NBT_LAST_POS_KEY, (Tag)last);
        if (this.getSpawnPos() != null) {
            CompoundTag spawn = new CompoundTag();
            this.spawn_pos.writeToNBT(spawn);
            compound_nbt.put(NBT_SPAWN_POS_KEY, (Tag)spawn);
        }
        CompoundTag tank = new CompoundTag();
        this.fluid_tank.writeToNBT(tank);
        compound_nbt.put(NBT_FLUID_TANK_KEY, (Tag)tank);
        CompoundTag players = new CompoundTag();
        for (int i = 0; i < this.allowed_players_array.size(); ++i) {
            players.putString(Integer.toString(i), this.allowed_players_array.get(i));
        }
        players.putInt("length", this.allowed_players_array.size());
        compound_nbt.put(NBT_ALLOWED_PLAYERS_KEY, (Tag)players);
        CompoundTag sideMapTag = new CompoundTag();
        if (this.block_array.size() > 0) {
            for (int i = 0; i < this.block_array.size(); ++i) {
                CompoundTag blockTag = new CompoundTag();
                ObjectBlockPosDimension test = this.block_array.get(i);
                test.save(blockTag);
                sideMapTag.put(Integer.toString(i), (Tag)blockTag);
            }
        }
        sideMapTag.putInt("length", this.block_array.size());
        compound_nbt.put(NBT_BLOCK_ARRAY_KEY, (Tag)sideMapTag);
        CompoundTag item_list = new CompoundTag();
        for (int i = 0; i < this.item_array.size(); ++i) {
            ItemStack stack = (ItemStack)this.item_array.get(i);
            CompoundTag itemTag = new CompoundTag();
            if (stack.isEmpty()) continue;
            itemTag.putByte("Slot", (byte)i);
            itemTag.merge((CompoundTag)stack.save(provider));
            item_list.put(Integer.toString(i), (Tag)itemTag);
        }
        compound_nbt.put(NBT_ITEMS_KEY, (Tag)item_list);
        CompoundTag surrounding_list = new CompoundTag();
        for (int i = 0; i < this.surrounding_array.size(); ++i) {
            ItemStack stack = (ItemStack)this.surrounding_array.get(i);
            CompoundTag itemTag = new CompoundTag();
            if (stack.isEmpty()) continue;
            itemTag.putByte("Slot", (byte)i);
            itemTag.merge((CompoundTag)stack.save(provider));
            surrounding_list.put(Integer.toString(i), (Tag)itemTag);
        }
        compound_nbt.put(NBT_SURROUNDING_KEY, (Tag)surrounding_list);
        CompoundTag side_array = new CompoundTag();
        for (int i = 0; i < this.pocket_side_array.length; ++i) {
            side_array.putInt(Integer.toString(i), this.pocket_side_array[i].getIndex());
        }
        side_array.putInt("length", this.pocket_side_array.length);
        compound_nbt.put(NBT_POCKET_SIDE_KEY, (Tag)side_array);
        return compound_nbt;
    }

    public static Pocket readFromNBT(CompoundTag compound, HolderLookup.Provider provider) {
        return Pocket.readFromNBT(compound, NBT_DIMENSIONAL_POCKET_KEY, provider);
    }

    public static Pocket readFromNBT(CompoundTag compound_nbt, String key, HolderLookup.Provider provider) {
        CompoundTag pocketTag = compound_nbt.getCompound(key);
        Pocket pocket = new Pocket(null);
        pocket.owner = ObjectPlayerInformation.readFromNBT((CompoundTag)pocketTag, (String)NBT_OWNER_KEY);
        pocket.setGeneratedState(pocketTag.getBoolean(NBT_GENERATED_KEY));
        pocket.setLockState(pocketTag.getBoolean(NBT_LOCKED_KEY));
        pocket.setAllowedPlayerState(pocketTag.getBoolean(NBT_ALLOWED_PLAYER_SHIFT_KEY));
        pocket.setTrapState(pocketTag.getBoolean(NBT_TRAP_KEY));
        pocket.setHostileSpawnState(pocketTag.getBoolean(NBT_HOSTILE_SPAWNS_KEY));
        pocket.setDisplayColour(pocketTag.getInt(NBT_COLOUR_KEY));
        pocket.setInternalHeight(pocketTag.getInt(NBT_INTERNAL_HEIGHT_KEY));
        pocket.setEnergyStored(pocketTag.getInt(NBT_ENERGY_STORED_KEY));
        pocket.energy_capacity = pocketTag.getInt(NBT_ENERGY_CAPACITY_KEY);
        pocket.energy_max_receive = pocketTag.getInt(NBT_ENERGY_RECEIVE_KEY);
        pocket.energy_max_extract = pocketTag.getInt(NBT_ENERGY_EXTRACT_KEY);
        CompoundTag chunkPos = pocketTag.getCompound(NBT_CHUNK_POS_KEY);
        pocket.chunk_pos = CosmosChunkPos.loadRaw((CompoundTag)chunkPos);
        CompoundTag chunkTag = pocketTag.getCompound(NBT_CHUNK_INFO_KEY);
        pocket.chunk_info = PocketChunkInfo.load(chunkTag);
        CompoundTag blockDimension = pocketTag.getCompound(NBT_BLOCK_DIMENSION_KEY);
        pocket.block_dimension = ResourceLocation.fromNamespaceAndPath((String)blockDimension.getString("namespace"), (String)blockDimension.getString("path"));
        CompoundTag lastTag = pocketTag.getCompound(NBT_LAST_POS_KEY);
        pocket.last_pos = ObjectBlockPosDimension.load((CompoundTag)lastTag);
        CompoundTag spawnTag = pocketTag.getCompound(NBT_SPAWN_POS_KEY);
        pocket.spawn_pos = ObjectDestinationInfo.readFromNBT((CompoundTag)spawnTag);
        CompoundTag tankTag = pocketTag.getCompound(NBT_FLUID_TANK_KEY);
        pocket.fluid_tank = ObjectFluidTankCustom.readFromNBT((CompoundTag)tankTag);
        CompoundTag playersTag = pocketTag.getCompound(NBT_ALLOWED_PLAYERS_KEY);
        for (int i = 0; i < playersTag.getInt("length"); ++i) {
            pocket.addAllowedPlayerNBT(playersTag.getString(Integer.toString(i)));
        }
        CompoundTag sideMapTag = pocketTag.getCompound(NBT_BLOCK_ARRAY_KEY);
        for (int i = 0; i < sideMapTag.getInt("length"); ++i) {
            pocket.addPosToBlockArray(ObjectBlockPosDimension.load((CompoundTag)sideMapTag.getCompound(Integer.toString(i))), false);
        }
        CompoundTag itemsTag = pocketTag.getCompound(NBT_ITEMS_KEY);
        for (int i = 0; i < 48; ++i) {
            pocket.item_array.set(i, (Object)ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)itemsTag.getCompound(Integer.toString(i))));
        }
        CompoundTag surroundingTag = pocketTag.getCompound(NBT_SURROUNDING_KEY);
        for (int i = 0; i < 6; ++i) {
            pocket.surrounding_array.set(i, (Object)ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)surroundingTag.getCompound(Integer.toString(i))));
        }
        CompoundTag sideArrayTag = pocketTag.getCompound(NBT_POCKET_SIDE_KEY);
        for (int i = 0; i < sideArrayTag.getInt("length"); ++i) {
            pocket.pocket_side_array[i] = EnumSideState.getStateFromIndex((int)sideArrayTag.getInt(Integer.toString(i)));
        }
        return pocket;
    }

    public ItemStack generateItemStackWithNBT() {
        ItemStack item_stack = new ItemStack((ItemLike)PocketsRegistrationManager.BLOCK_POCKET.get());
        CompoundTag stackTag = new CompoundTag();
        if (!item_stack.has(DataComponents.CUSTOM_DATA)) {
            item_stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)stackTag));
        }
        CompoundTag compound = new CompoundTag();
        CompoundTag chunk_tag = new CompoundTag();
        int x = this.chunk_info.getDominantChunk().getX();
        int z = this.chunk_info.getDominantChunk().getZ();
        chunk_tag.putInt("X", x);
        chunk_tag.putInt("Z", z);
        compound.put("chunk_set", (Tag)chunk_tag);
        compound.putInt("colour", this.getDisplayColour());
        stackTag.put("nbt_data", (Tag)compound);
        item_stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)stackTag));
        return item_stack;
    }
}

