/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.pocket.core.block;

import com.tcn.cosmoslibrary.common.nbt.CosmosBlockRemovableNBT;
import com.tcn.dimensionalpocketsii.pocket.core.block.entity.AbstractBlockEntityPocket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public abstract class AbstractBlockPocket
extends CosmosBlockRemovableNBT
implements EntityBlock {
    public static final IntegerProperty NORTH = IntegerProperty.create((String)"north", (int)0, (int)3);
    public static final IntegerProperty EAST = IntegerProperty.create((String)"east", (int)0, (int)3);
    public static final IntegerProperty SOUTH = IntegerProperty.create((String)"south", (int)0, (int)3);
    public static final IntegerProperty WEST = IntegerProperty.create((String)"west", (int)0, (int)3);
    public static final IntegerProperty UP = IntegerProperty.create((String)"up", (int)0, (int)3);
    public static final IntegerProperty DOWN = IntegerProperty.create((String)"down", (int)0, (int)3);
    public static final BooleanProperty LOCKED = BooleanProperty.create((String)"locked");
    public static final BooleanProperty SIDE_GUIDE = BooleanProperty.create((String)"side_guide");
    private boolean isSingleChunk;

    public AbstractBlockPocket(BlockBehaviour.Properties prop, boolean isSingleChunkIn) {
        super(prop);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH, (Comparable)Integer.valueOf(0))).setValue((Property)EAST, (Comparable)Integer.valueOf(0))).setValue((Property)SOUTH, (Comparable)Integer.valueOf(0))).setValue((Property)WEST, (Comparable)Integer.valueOf(0))).setValue((Property)UP, (Comparable)Integer.valueOf(0))).setValue((Property)DOWN, (Comparable)Integer.valueOf(0))).setValue((Property)LOCKED, (Comparable)Boolean.valueOf(false))).setValue((Property)SIDE_GUIDE, (Comparable)Boolean.valueOf(false)));
        this.isSingleChunk = isSingleChunkIn;
    }

    public void attack(BlockState state, Level world, BlockPos pos, Player player) {
        BlockEntity tileEntity = world.getBlockEntity(pos);
        if (tileEntity instanceof AbstractBlockEntityPocket) {
            AbstractBlockEntityPocket blockEntity = (AbstractBlockEntityPocket)tileEntity;
            blockEntity.attack(state, world, pos, player);
        }
    }

    public ItemInteractionResult useItemOn(ItemStack stackIn, BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        if (tileEntity instanceof AbstractBlockEntityPocket) {
            AbstractBlockEntityPocket blockEntity = (AbstractBlockEntityPocket)tileEntity;
            return blockEntity.useItemOn(stackIn, state, worldIn, pos, playerIn, handIn, hit);
        }
        return ItemInteractionResult.FAIL;
    }

    public void onPlace(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        if (tileEntity instanceof AbstractBlockEntityPocket) {
            AbstractBlockEntityPocket blockEntity = (AbstractBlockEntityPocket)tileEntity;
            blockEntity.onPlace(state, worldIn, pos, oldState, isMoving);
        }
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        if (tileEntity instanceof AbstractBlockEntityPocket) {
            AbstractBlockEntityPocket blockEntity = (AbstractBlockEntityPocket)tileEntity;
            blockEntity.setPlacedBy(worldIn, pos, state, placer, stack);
        }
    }

    public BlockState playerWillDestroy(Level worldIn, BlockPos pos, BlockState state, Player player) {
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        if (tileEntity instanceof AbstractBlockEntityPocket) {
            AbstractBlockEntityPocket blockEntity = (AbstractBlockEntityPocket)tileEntity;
            return blockEntity.playerWillDestroy(worldIn, pos, state, player);
        }
        return state;
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        if (tileEntity instanceof AbstractBlockEntityPocket) {
            AbstractBlockEntityPocket blockEntity = (AbstractBlockEntityPocket)tileEntity;
            blockEntity.neighborChanged(state, worldIn, pos, blockIn, fromPos, isMoving);
        }
    }

    public BlockState updateState(BlockState state, BlockPos posIn, Level worldIn) {
        if (!worldIn.isClientSide) {
            BlockEntity entity = worldIn.getBlockEntity(posIn);
            if (entity instanceof AbstractBlockEntityPocket) {
                AbstractBlockEntityPocket blockEntity = (AbstractBlockEntityPocket)entity;
                if (blockEntity.getPocket() != null) {
                    return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH, (Comparable)Integer.valueOf(blockEntity.getSide(Direction.NORTH).getIndex()))).setValue((Property)EAST, (Comparable)Integer.valueOf(blockEntity.getSide(Direction.EAST).getIndex()))).setValue((Property)SOUTH, (Comparable)Integer.valueOf(blockEntity.getSide(Direction.SOUTH).getIndex()))).setValue((Property)WEST, (Comparable)Integer.valueOf(blockEntity.getSide(Direction.WEST).getIndex()))).setValue((Property)UP, (Comparable)Integer.valueOf(blockEntity.getSide(Direction.UP).getIndex()))).setValue((Property)DOWN, (Comparable)Integer.valueOf(blockEntity.getSide(Direction.DOWN).getIndex()))).setValue((Property)LOCKED, (Comparable)Boolean.valueOf(blockEntity.getLockState()))).setValue((Property)SIDE_GUIDE, (Comparable)Boolean.valueOf(blockEntity.getSideGuideValue()));
                }
                return this.defaultBlockState();
            }
            return this.defaultBlockState();
        }
        return this.defaultBlockState();
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        return false;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, WEST, SOUTH, UP, DOWN, LOCKED, SIDE_GUIDE});
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockEntity tile_in = worldIn.getBlockEntity(currentPos);
        if (tile_in instanceof AbstractBlockEntityPocket) {
            AbstractBlockEntityPocket blockEntity = (AbstractBlockEntityPocket)tile_in;
            if (blockEntity.getPocket() != null) {
                return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH, (Comparable)Integer.valueOf(blockEntity.getSide(Direction.NORTH).getIndex()))).setValue((Property)EAST, (Comparable)Integer.valueOf(blockEntity.getSide(Direction.EAST).getIndex()))).setValue((Property)SOUTH, (Comparable)Integer.valueOf(blockEntity.getSide(Direction.SOUTH).getIndex()))).setValue((Property)WEST, (Comparable)Integer.valueOf(blockEntity.getSide(Direction.WEST).getIndex()))).setValue((Property)UP, (Comparable)Integer.valueOf(blockEntity.getSide(Direction.UP).getIndex()))).setValue((Property)DOWN, (Comparable)Integer.valueOf(blockEntity.getSide(Direction.DOWN).getIndex()))).setValue((Property)LOCKED, (Comparable)Boolean.valueOf(blockEntity.getLockState()))).setValue((Property)SIDE_GUIDE, (Comparable)Boolean.valueOf(blockEntity.getSideGuideValue()));
            }
            return this.defaultBlockState();
        }
        return this.defaultBlockState();
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        return false;
    }

    public boolean getIsSingleChunk() {
        return this.isSingleChunk;
    }
}

