/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.pocket.core.block;

import com.tcn.dimensionalpocketsii.core.management.PocketsConfigManager;
import com.tcn.dimensionalpocketsii.core.management.PocketsRegistrationManager;
import com.tcn.dimensionalpocketsii.pocket.client.container.ContainerModuleArmourWorkbench;
import com.tcn.dimensionalpocketsii.pocket.core.block.BlockWallModule;
import com.tcn.dimensionalpocketsii.pocket.core.block.entity.BlockEntityModuleArmourWorkbench;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class BlockWallArmourWorkbench
extends BlockWallModule
implements EntityBlock {
    private static final Component CONTAINER_NAME = Component.translatable((String)"dimensionalpocketsii.gui.armour_workbench");

    public BlockWallArmourWorkbench(BlockBehaviour.Properties prop) {
        super(prop);
    }

    public BlockEntity newBlockEntity(BlockPos posIn, BlockState stateIn) {
        return new BlockEntityModuleArmourWorkbench(posIn, stateIn);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level levelIn, BlockState stateIn, BlockEntityType<T> entityTypeIn) {
        return BlockWallArmourWorkbench.createTicker(levelIn, entityTypeIn, (BlockEntityType<? extends BlockEntityModuleArmourWorkbench>)((BlockEntityType)PocketsRegistrationManager.BLOCK_ENTITY_TYPE_ARMOUR_WORKBENCH.get()));
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createTicker(Level levelIn, BlockEntityType<T> entityTypeIn, BlockEntityType<? extends BlockEntityModuleArmourWorkbench> entityIn) {
        return BlockWallArmourWorkbench.createTickerHelper(entityTypeIn, entityIn, BlockEntityModuleArmourWorkbench::tick);
    }

    public ItemInteractionResult useItemOn(ItemStack stackIn, BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        if (tileEntity instanceof BlockEntityModuleArmourWorkbench) {
            return ((BlockEntityModuleArmourWorkbench)tileEntity).useItemOn(stackIn, state, worldIn, pos, playerIn, handIn, hit);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void attack(BlockState state, Level world, BlockPos pos, Player player) {
        BlockEntity tileEntity = world.getBlockEntity(pos);
        if (tileEntity instanceof BlockEntityModuleArmourWorkbench) {
            ((BlockEntityModuleArmourWorkbench)tileEntity).attack(state, world, pos, player);
        }
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        if (tileEntity instanceof BlockEntityModuleArmourWorkbench) {
            BlockEntityModuleArmourWorkbench tileFurnace = (BlockEntityModuleArmourWorkbench)tileEntity;
            return new SimpleMenuProvider((id, inventory, player) -> new ContainerModuleArmourWorkbench(id, inventory, tileFurnace, ContainerLevelAccess.create((Level)worldIn, (BlockPos)pos), pos), CONTAINER_NAME);
        }
        return null;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (PocketsConfigManager.getInstance().getCanDestroyWalls()) {
            return this.defaultBlockState();
        }
        return Blocks.AIR.defaultBlockState();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult result, LevelReader reader, BlockPos posIn, Player playerIn) {
        return new ItemStack((ItemLike)PocketsRegistrationManager.MODULE_ARMOUR_WORKBENCH.get());
    }
}

