/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.pocket.core.block;

import com.tcn.dimensionalpocketsii.core.management.PocketsConfigManager;
import com.tcn.dimensionalpocketsii.core.management.PocketsRegistrationManager;
import com.tcn.dimensionalpocketsii.pocket.client.container.ContainerModuleBlastFurnace;
import com.tcn.dimensionalpocketsii.pocket.core.block.BlockWallModule;
import com.tcn.dimensionalpocketsii.pocket.core.block.entity.BlockEntityModuleBlastFurnace;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockWallBlastFurnace
extends BlockWallModule
implements EntityBlock {
    private static final Component CONTAINER_NAME = Component.translatable((String)"dimensionalpocketsii.gui.blast_furnace");
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    public BlockWallBlastFurnace(BlockBehaviour.Properties prop) {
        super(prop);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity newBlockEntity(BlockPos posIn, BlockState stateIn) {
        return new BlockEntityModuleBlastFurnace(posIn, stateIn);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level levelIn, BlockState stateIn, BlockEntityType<T> entityTypeIn) {
        return BlockWallBlastFurnace.createTicker(levelIn, entityTypeIn, (BlockEntityType<? extends BlockEntityModuleBlastFurnace>)((BlockEntityType)PocketsRegistrationManager.BLOCK_ENTITY_TYPE_BLAST_FURNACE.get()));
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createTicker(Level levelIn, BlockEntityType<T> entityTypeIn, BlockEntityType<? extends BlockEntityModuleBlastFurnace> entityIn) {
        return BlockWallBlastFurnace.createTickerHelper(entityTypeIn, entityIn, BlockEntityModuleBlastFurnace::tick);
    }

    public ItemInteractionResult useItemOn(ItemStack stackIn, BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        if (tileEntity instanceof BlockEntityModuleBlastFurnace) {
            return ((BlockEntityModuleBlastFurnace)tileEntity).useItemOn(stackIn, state, worldIn, pos, playerIn, handIn, hit);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void attack(BlockState state, Level world, BlockPos pos, Player player) {
        BlockEntity tileEntity = world.getBlockEntity(pos);
        if (tileEntity instanceof BlockEntityModuleBlastFurnace) {
            ((BlockEntityModuleBlastFurnace)tileEntity).attack(state, world, pos, player);
        }
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        if (tileEntity instanceof BlockEntityModuleBlastFurnace) {
            BlockEntityModuleBlastFurnace tileFurnace = (BlockEntityModuleBlastFurnace)tileEntity;
            return new SimpleMenuProvider((id, inventory, player) -> new ContainerModuleBlastFurnace(id, inventory, (Container)tileFurnace, tileFurnace.dataAccess, pos), CONTAINER_NAME);
        }
        return null;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateContainer) {
        stateContainer.add(new Property[]{LIT});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level worldIn, BlockPos posIn, Random randomIn) {
        if (((Boolean)stateIn.getValue((Property)LIT)).booleanValue()) {
            double d0 = (double)posIn.getX() + 0.5;
            double d1 = posIn.getY();
            double d2 = (double)posIn.getZ() + 0.5;
            if (randomIn.nextDouble() < 0.1) {
                worldIn.playLocalSound(d0, d1, d2, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            for (Direction direction : Direction.values()) {
                BlockState state;
                if (direction == Direction.UP || direction == Direction.DOWN || !(state = worldIn.getBlockState(posIn.offset(direction.getNormal()))).isAir()) continue;
                Direction.Axis direction$axis = direction.getAxis();
                double d4 = randomIn.nextDouble() * 0.6 - 0.3;
                double d5 = direction$axis == Direction.Axis.X ? (double)direction.getStepX() * 0.52 : d4;
                double d6 = randomIn.nextDouble() * 6.0 / 16.0;
                double d7 = direction$axis == Direction.Axis.Z ? (double)direction.getStepZ() * 0.52 : d4;
                worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
                worldIn.addParticle((ParticleOptions)ParticleTypes.FLAME, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            }
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (PocketsConfigManager.getInstance().getCanDestroyWalls()) {
            return this.defaultBlockState();
        }
        return Blocks.AIR.defaultBlockState();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult result, LevelReader reader, BlockPos posIn, Player playerIn) {
        return new ItemStack((ItemLike)PocketsRegistrationManager.MODULE_BLAST_FURNACE.get());
    }
}

