/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.pocket.core.block;

import com.tcn.dimensionalpocketsii.core.management.PocketsConfigManager;
import com.tcn.dimensionalpocketsii.core.management.PocketsRegistrationManager;
import com.tcn.dimensionalpocketsii.pocket.core.block.BlockWallModule;
import com.tcn.dimensionalpocketsii.pocket.core.block.entity.BlockEntityModuleConnector;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class BlockWallConnector
extends BlockWallModule
implements EntityBlock {
    public static final IntegerProperty MODE = IntegerProperty.create((String)"mode", (int)0, (int)3);
    public static final IntegerProperty TYPE = IntegerProperty.create((String)"type", (int)0, (int)3);

    public BlockWallConnector(BlockBehaviour.Properties prop) {
        super(prop);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)MODE, (Comparable)Integer.valueOf(0))).setValue((Property)TYPE, (Comparable)Integer.valueOf(0)));
    }

    public BlockEntity newBlockEntity(BlockPos posIn, BlockState stateIn) {
        return new BlockEntityModuleConnector(posIn, stateIn);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level levelIn, BlockState stateIn, BlockEntityType<T> entityTypeIn) {
        return BlockWallConnector.createTicker(levelIn, entityTypeIn, (BlockEntityType<? extends BlockEntityModuleConnector>)((BlockEntityType)PocketsRegistrationManager.BLOCK_ENTITY_TYPE_CONNECTOR.get()));
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createTicker(Level levelIn, BlockEntityType<T> entityTypeIn, BlockEntityType<? extends BlockEntityModuleConnector> entityIn) {
        return BlockWallConnector.createTickerHelper(entityTypeIn, entityIn, BlockEntityModuleConnector::tick);
    }

    public void attack(BlockState state, Level world, BlockPos pos, Player player) {
        BlockEntity tileEntity = world.getBlockEntity(pos);
        if (tileEntity instanceof BlockEntityModuleConnector) {
            ((BlockEntityModuleConnector)tileEntity).attack(state, world, pos, player);
        }
    }

    public ItemInteractionResult useItemOn(ItemStack stackIn, BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        if (tileEntity instanceof BlockEntityModuleConnector) {
            return ((BlockEntityModuleConnector)tileEntity).useItemOn(stackIn, state, worldIn, pos, playerIn, handIn, hit);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{MODE, TYPE});
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockEntity tile_in = worldIn.getBlockEntity(currentPos);
        if (tile_in instanceof BlockEntityModuleConnector) {
            BlockEntityModuleConnector tile = (BlockEntityModuleConnector)worldIn.getBlockEntity(currentPos);
            return (BlockState)((BlockState)stateIn.setValue((Property)MODE, (Comparable)Integer.valueOf(tile.getSide(Direction.UP).getIndex()))).setValue((Property)TYPE, (Comparable)Integer.valueOf(tile.getConnectionType().getIndex()));
        }
        return this.defaultBlockState();
    }

    public BlockState updateState(BlockState state, BlockPos posIn, Level worldIn) {
        if (!worldIn.isClientSide) {
            BlockEntity entity = worldIn.getBlockEntity(posIn);
            if (entity instanceof BlockEntityModuleConnector) {
                BlockEntityModuleConnector connector = (BlockEntityModuleConnector)entity;
                return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)MODE, (Comparable)Integer.valueOf(connector.getSide(Direction.UP).getIndex()))).setValue((Property)TYPE, (Comparable)Integer.valueOf(connector.getConnectionType().getIndex()));
            }
            return this.defaultBlockState();
        }
        return this.defaultBlockState();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (PocketsConfigManager.getInstance().getCanDestroyWalls()) {
            return this.defaultBlockState();
        }
        return Blocks.AIR.defaultBlockState();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult result, LevelReader reader, BlockPos posIn, Player playerIn) {
        return new ItemStack((ItemLike)PocketsRegistrationManager.MODULE_CONNECTOR.get());
    }
}

