/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.pocket.core.block;

import com.tcn.cosmoslibrary.common.block.CosmosBlockDoor;
import com.tcn.cosmoslibrary.common.chat.CosmosChatUtil;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.cosmoslibrary.common.lib.CosmosChunkPos;
import com.tcn.cosmoslibrary.common.util.CosmosUtil;
import com.tcn.dimensionalpocketsii.core.management.PocketsConfigManager;
import com.tcn.dimensionalpocketsii.core.management.PocketsDimensionManager;
import com.tcn.dimensionalpocketsii.core.management.PocketsRegistrationManager;
import com.tcn.dimensionalpocketsii.pocket.core.Pocket;
import com.tcn.dimensionalpocketsii.pocket.core.registry.StorageManager;
import com.tcn.dimensionalpocketsii.pocket.core.shift.EnumShiftDirection;
import com.tcn.dimensionalpocketsii.pocket.core.util.PocketUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class BlockWallDoor
extends CosmosBlockDoor {
    public BlockWallDoor(BlockBehaviour.Properties propertiesIn, BlockSetType typeIn) {
        super(propertiesIn, typeIn);
    }

    public ItemInteractionResult useItemOn(ItemStack stackIn, BlockState stateIn, Level levelIn, BlockPos posIn, Player playerIn, InteractionHand handIn, BlockHitResult resultIn) {
        if (CosmosUtil.getStackItem((Player)playerIn) instanceof BlockItem) {
            return ItemInteractionResult.FAIL;
        }
        if (PocketUtil.isDimensionEqual(levelIn, PocketsDimensionManager.POCKET_WORLD)) {
            Pocket pocket = StorageManager.getPocketFromChunkPosition(levelIn, CosmosChunkPos.scaleToChunkPos((BlockPos)posIn));
            if (pocket.exists()) {
                if (playerIn.isShiftKeyDown()) {
                    if (CosmosUtil.handEmpty((Player)playerIn)) {
                        pocket.shift(playerIn, EnumShiftDirection.LEAVE, null, null, null);
                        return ItemInteractionResult.SUCCESS;
                    }
                } else if (pocket.checkIfOwner(playerIn)) {
                    return super.useItemOn(stackIn, stateIn, levelIn, posIn, playerIn, handIn, resultIn);
                }
            } else {
                CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.status.action.null"));
                return ItemInteractionResult.FAIL;
            }
        }
        return ItemInteractionResult.FAIL;
    }

    public void neighborChanged(BlockState stateIn, Level levelIn, BlockPos posIn, Block blockIn, BlockPos otherPosIn, boolean valueIn) {
    }

    public boolean canSurvive(BlockState stateIn, LevelReader levelIn, BlockPos posIn) {
        return true;
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        return false;
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        return false;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (PocketsConfigManager.getInstance().getCanDestroyWalls()) {
            return super.getStateForPlacement(context);
        }
        return Blocks.AIR.defaultBlockState();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult result, LevelReader reader, BlockPos posIn, Player playerIn) {
        if (PocketsConfigManager.getInstance().getCanDestroyWalls()) {
            return new ItemStack((ItemLike)PocketsRegistrationManager.BLOCK_WALL.get());
        }
        return ItemStack.EMPTY;
    }
}

