/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.pocket.core.block;

import com.tcn.cosmoslibrary.common.block.CosmosBlockConnectedUnbreakable;
import com.tcn.cosmoslibrary.common.chat.CosmosChatUtil;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.cosmoslibrary.common.lib.CosmosChunkPos;
import com.tcn.cosmoslibrary.common.util.CosmosUtil;
import com.tcn.dimensionalpocketsii.core.management.PocketsConfigManager;
import com.tcn.dimensionalpocketsii.core.management.PocketsDimensionManager;
import com.tcn.dimensionalpocketsii.pocket.core.Pocket;
import com.tcn.dimensionalpocketsii.pocket.core.block.BlockFocus;
import com.tcn.dimensionalpocketsii.pocket.core.block.BlockWallBase;
import com.tcn.dimensionalpocketsii.pocket.core.block.BlockWallDoor;
import com.tcn.dimensionalpocketsii.pocket.core.block.BlockWallGlass;
import com.tcn.dimensionalpocketsii.pocket.core.block.BlockWallModule;
import com.tcn.dimensionalpocketsii.pocket.core.registry.StorageManager;
import com.tcn.dimensionalpocketsii.pocket.core.shift.EnumShiftDirection;
import com.tcn.dimensionalpocketsii.pocket.core.util.PocketUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class BlockWallEdge
extends CosmosBlockConnectedUnbreakable {
    public BlockWallEdge(BlockBehaviour.Properties prop) {
        super(prop.randomTicks());
    }

    public void tick(BlockState stateIn, ServerLevel levelIn, BlockPos posIn, RandomSource source) {
    }

    public ItemInteractionResult useItemOn(ItemStack stackIn, BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult hit) {
        if (PocketUtil.isDimensionEqual(worldIn, PocketsDimensionManager.POCKET_WORLD)) {
            Pocket pocket = StorageManager.getPocketFromChunkPosition(worldIn, CosmosChunkPos.scaleToChunkPos((BlockPos)pos));
            if (pocket.exists()) {
                if (playerIn.isShiftKeyDown() && CosmosUtil.handEmpty((Player)playerIn)) {
                    pocket.shift(playerIn, EnumShiftDirection.LEAVE, null, null, null);
                    return ItemInteractionResult.SUCCESS;
                }
            } else {
                CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.status.action.null"));
                return ItemInteractionResult.FAIL;
            }
        }
        return ItemInteractionResult.FAIL;
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        return false;
    }

    protected boolean canConnect(@Nonnull BlockState orig, @Nonnull BlockState conn) {
        if (PocketsConfigManager.getInstance().getConnectedTexturesInsidePocket()) {
            if (conn.getBlock().equals(Blocks.AIR)) {
                return false;
            }
            if (orig.getBlock().equals(conn.getBlock())) {
                return true;
            }
            if (conn.getBlock() instanceof BlockWallBase) {
                return true;
            }
            if (conn.getBlock() instanceof BlockWallGlass) {
                return true;
            }
            if (conn.getBlock() instanceof BlockWallModule) {
                return true;
            }
            if (conn.getBlock() instanceof BlockFocus) {
                return true;
            }
            return conn.getBlock() instanceof BlockWallDoor;
        }
        return false;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        DebugPackets.sendNeighborsUpdatePacket((Level)worldIn, (BlockPos)pos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (PocketsConfigManager.getInstance().getCanDestroyWalls()) {
            return this.defaultBlockState();
        }
        return Blocks.AIR.defaultBlockState();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult result, LevelReader reader, BlockPos posIn, Player playerIn) {
        if (PocketsConfigManager.getInstance().getCanDestroyWalls()) {
            return new ItemStack((ItemLike)this);
        }
        return ItemStack.EMPTY;
    }
}

