/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.pocket.core.block;

import com.tcn.cosmoslibrary.common.chat.CosmosChatUtil;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.cosmoslibrary.common.lib.CosmosChunkPos;
import com.tcn.cosmoslibrary.common.util.CosmosUtil;
import com.tcn.dimensionalpocketsii.core.management.PocketsConfigManager;
import com.tcn.dimensionalpocketsii.core.management.PocketsDimensionManager;
import com.tcn.dimensionalpocketsii.core.management.PocketsRegistrationManager;
import com.tcn.dimensionalpocketsii.pocket.core.Pocket;
import com.tcn.dimensionalpocketsii.pocket.core.block.BlockWallModule;
import com.tcn.dimensionalpocketsii.pocket.core.block.entity.BlockEntityModuleConnector;
import com.tcn.dimensionalpocketsii.pocket.core.registry.StorageManager;
import com.tcn.dimensionalpocketsii.pocket.core.shift.EnumShiftDirection;
import com.tcn.dimensionalpocketsii.pocket.core.util.PocketUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class BlockWallEnergyDisplay
extends BlockWallModule {
    public static final IntegerProperty ENERGY = IntegerProperty.create((String)"energy", (int)0, (int)24);

    public BlockWallEnergyDisplay(BlockBehaviour.Properties prop) {
        super(prop);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)ENERGY, (Comparable)Integer.valueOf(0)));
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos posIn, RandomSource randIn) {
        worldIn.setBlockAndUpdate(posIn, this.updateState(stateIn, posIn, worldIn));
        worldIn.blockUpdated(posIn, (Block)this);
        worldIn.sendBlockUpdated(posIn, stateIn, this.updateState(stateIn, posIn, worldIn), 3);
    }

    public ItemInteractionResult useItemOn(ItemStack stackIn, BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult hit) {
        if (CosmosUtil.getStackItem((Player)playerIn) instanceof BlockItem) {
            return ItemInteractionResult.FAIL;
        }
        CosmosChunkPos chunkPos = CosmosChunkPos.scaleToChunkPos((BlockPos)pos);
        Pocket pocketIn = StorageManager.getPocketFromChunkPosition(worldIn, chunkPos);
        if (playerIn.isShiftKeyDown() && pocketIn.exists()) {
            if (CosmosUtil.holdingWrench((Player)playerIn)) {
                if (pocketIn.checkIfOwner(playerIn)) {
                    if (!worldIn.isClientSide) {
                        worldIn.setBlockAndUpdate(pos, ((Block)PocketsRegistrationManager.BLOCK_WALL.get()).defaultBlockState());
                        CosmosUtil.addItem((Level)worldIn, (Player)playerIn, (Item)((Item)PocketsRegistrationManager.MODULE_ENERGY_DISPLAY.get()), (int)1);
                        pocketIn.removeUpdateable(pos);
                    }
                    return ItemInteractionResult.SUCCESS;
                }
                CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.status.no_access"));
                return ItemInteractionResult.FAIL;
            }
            if (CosmosUtil.handEmpty((Player)playerIn)) {
                pocketIn.shift(playerIn, EnumShiftDirection.LEAVE, null, null, null);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.FAIL;
    }

    public void onPlace(BlockState stateIn, Level worldIn, BlockPos posIn, BlockState oldState, boolean isMoving) {
        worldIn.blockUpdated(posIn, (Block)this);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ENERGY});
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockEntityModuleConnector connector;
        BlockPos scaled;
        BlockEntity entity;
        CosmosChunkPos chunkPos = CosmosChunkPos.scaleToChunkPos((BlockPos)currentPos);
        if (chunkPos != null && (entity = worldIn.getBlockEntity(scaled = CosmosChunkPos.scaleFromChunkPos((CosmosChunkPos)chunkPos))) != null && entity instanceof BlockEntityModuleConnector && (connector = (BlockEntityModuleConnector)entity).getPocket() != null) {
            Pocket pocket = connector.getPocket();
            int scaled_energy = pocket.getEnergyStoredScaled(24);
            return (BlockState)this.defaultBlockState().setValue((Property)ENERGY, (Comparable)Integer.valueOf(scaled_energy));
        }
        return this.defaultBlockState();
    }

    public BlockState updateState(BlockState state, BlockPos posIn, Level worldIn) {
        BlockEntityModuleConnector connector;
        BlockPos scaled;
        BlockEntity entity;
        CosmosChunkPos chunkPos = CosmosChunkPos.scaleToChunkPos((BlockPos)posIn);
        if (PocketUtil.isDimensionEqual(worldIn, PocketsDimensionManager.POCKET_WORLD) && chunkPos != null && (entity = worldIn.getBlockEntity(scaled = CosmosChunkPos.scaleFromChunkPos((CosmosChunkPos)chunkPos))) != null && entity instanceof BlockEntityModuleConnector && (connector = (BlockEntityModuleConnector)entity).getPocket() != null) {
            Pocket pocket = connector.getPocket();
            int scaled_energy = pocket.getEnergyStoredScaled(24);
            return (BlockState)this.defaultBlockState().setValue((Property)ENERGY, (Comparable)Integer.valueOf(scaled_energy));
        }
        return this.defaultBlockState();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (PocketsConfigManager.getInstance().getCanDestroyWalls()) {
            return this.defaultBlockState();
        }
        return Blocks.AIR.defaultBlockState();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult result, LevelReader reader, BlockPos posIn, Player playerIn) {
        return new ItemStack((ItemLike)PocketsRegistrationManager.MODULE_ENERGY_DISPLAY.get());
    }
}

