/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.pocket.core.block;

import com.tcn.cosmoslibrary.common.block.CosmosBlockConnectedUnbreakable;
import com.tcn.cosmoslibrary.common.chat.CosmosChatUtil;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.cosmoslibrary.common.lib.CosmosChunkPos;
import com.tcn.cosmoslibrary.common.util.CosmosUtil;
import com.tcn.dimensionalpocketsii.core.management.PocketsConfigManager;
import com.tcn.dimensionalpocketsii.core.management.PocketsDimensionManager;
import com.tcn.dimensionalpocketsii.core.management.PocketsRegistrationManager;
import com.tcn.dimensionalpocketsii.pocket.core.Pocket;
import com.tcn.dimensionalpocketsii.pocket.core.registry.StorageManager;
import com.tcn.dimensionalpocketsii.pocket.core.shift.EnumShiftDirection;
import com.tcn.dimensionalpocketsii.pocket.core.util.PocketUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockWallGlass
extends CosmosBlockConnectedUnbreakable {
    public BlockWallGlass(BlockBehaviour.Properties prop) {
        super(prop.randomTicks());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemInteractionResult useItemOn(ItemStack stackIn, BlockState state, Level levelIn, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult hit) {
        if (CosmosUtil.getStackItem((Player)playerIn) instanceof BlockItem) {
            return ItemInteractionResult.FAIL;
        }
        if (!PocketUtil.isDimensionEqual(levelIn, PocketsDimensionManager.POCKET_WORLD)) return ItemInteractionResult.FAIL;
        Pocket pocket = StorageManager.getPocketFromChunkPosition(levelIn, CosmosChunkPos.scaleToChunkPos((BlockPos)pos));
        if (pocket.exists()) {
            if (!playerIn.isShiftKeyDown()) {
                return ItemInteractionResult.FAIL;
            }
            if (CosmosUtil.handEmpty((Player)playerIn)) {
                pocket.shift(playerIn, EnumShiftDirection.LEAVE, null, null, null);
                return ItemInteractionResult.SUCCESS;
            }
            if (levelIn.isClientSide) return ItemInteractionResult.FAIL;
            CosmosChunkPos chunkPos = CosmosChunkPos.scaleToChunkPos((BlockPos)pos);
            Pocket pocketIn = StorageManager.getPocketFromChunkPosition(levelIn, chunkPos);
            if (pocketIn.exists()) {
                if (CosmosUtil.holdingWrench((Player)playerIn)) {
                    if (pocketIn.checkIfOwner(playerIn)) {
                        ItemStack stack = new ItemStack((ItemLike)PocketsRegistrationManager.MODULE_GLASS.get());
                        levelIn.setBlockAndUpdate(pos, ((Block)PocketsRegistrationManager.BLOCK_WALL.get()).defaultBlockState());
                        CosmosUtil.addStack((Level)levelIn, (Player)playerIn, (ItemStack)stack);
                        return ItemInteractionResult.SUCCESS;
                    }
                    CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.status.no_access"));
                    return ItemInteractionResult.FAIL;
                }
                if (!CosmosUtil.handEmpty((Player)playerIn)) return ItemInteractionResult.FAIL;
                pocketIn.shift(playerIn, EnumShiftDirection.LEAVE, null, null, null);
                return ItemInteractionResult.SUCCESS;
            }
            CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.status.action.null"));
            return ItemInteractionResult.FAIL;
        }
        CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.status.action.null"));
        return ItemInteractionResult.FAIL;
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (PocketsConfigManager.getInstance().getCanDestroyWalls()) {
            return this.defaultBlockState();
        }
        return Blocks.AIR.defaultBlockState();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult result, LevelReader reader, BlockPos posIn, Player playerIn) {
        if (PocketsConfigManager.getInstance().getCanDestroyWalls()) {
            return new ItemStack((ItemLike)this);
        }
        return ItemStack.EMPTY;
    }

    public VoxelShape getVisualShape(BlockState blockStateIn, BlockGetter levelIn, BlockPos posIn, CollisionContext collisionContext) {
        return Shapes.empty();
    }

    public float getShadeBrightness(BlockState blockStateIn, BlockGetter levelIn, BlockPos posIn) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState blockStateIn, BlockGetter levelIn, BlockPos posIn) {
        return true;
    }

    protected boolean canConnect(@Nonnull BlockState orig, @Nonnull BlockState conn) {
        if (PocketsConfigManager.getInstance().getConnectedTexturesInsidePocket()) {
            if (conn.getBlock().equals(Blocks.AIR)) {
                return false;
            }
            return orig.getBlock().equals(conn.getBlock());
        }
        return false;
    }

    public boolean skipRendering(BlockState state, BlockState adjacentState, Direction direction) {
        return adjacentState.is((Block)this) ? true : super.skipRendering(state, adjacentState, direction);
    }
}

