/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.pocket.core.block.entity;

import com.tcn.cosmoslibrary.common.chat.CosmosChatUtil;
import com.tcn.cosmoslibrary.common.enums.EnumGeneralEnableState;
import com.tcn.cosmoslibrary.common.enums.EnumUIHelp;
import com.tcn.cosmoslibrary.common.enums.EnumUILock;
import com.tcn.cosmoslibrary.common.enums.EnumUIMode;
import com.tcn.cosmoslibrary.common.interfaces.block.IBlockInteract;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IBEUILockable;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IBEUIMode;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.cosmoslibrary.common.lib.CosmosChunkPos;
import com.tcn.cosmoslibrary.common.util.CosmosUtil;
import com.tcn.dimensionalpocketsii.core.management.PocketsConfigManager;
import com.tcn.dimensionalpocketsii.core.management.PocketsDimensionManager;
import com.tcn.dimensionalpocketsii.core.management.PocketsRegistrationManager;
import com.tcn.dimensionalpocketsii.pocket.client.container.ContainerFocus;
import com.tcn.dimensionalpocketsii.pocket.core.Pocket;
import com.tcn.dimensionalpocketsii.pocket.core.block.BlockFocus;
import com.tcn.dimensionalpocketsii.pocket.core.registry.StorageManager;
import com.tcn.dimensionalpocketsii.pocket.core.shift.EnumShiftDirection;
import com.tcn.dimensionalpocketsii.pocket.core.util.PocketUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class BlockEntityFocus
extends BlockEntity
implements IBlockInteract,
MenuProvider,
Nameable,
IBEUIMode,
IBEUILockable {
    private Pocket pocket;
    private EnumGeneralEnableState jumpEnabled = EnumGeneralEnableState.ENABLED;
    private EnumGeneralEnableState shiftEnabled = EnumGeneralEnableState.ENABLED;
    private EnumUIMode uiMode = EnumUIMode.DARK;
    private EnumUIHelp uiHelp = EnumUIHelp.HIDDEN;
    private EnumUILock uiLock = EnumUILock.PRIVATE;

    public BlockEntityFocus(BlockPos posIn, BlockState stateIn) {
        super((BlockEntityType)PocketsRegistrationManager.BLOCK_ENTITY_TYPE_FOCUS.get(), posIn, stateIn);
    }

    public Pocket getPocket() {
        if (this.level.isClientSide) {
            return this.pocket;
        }
        return StorageManager.getPocketFromChunkPosition(this.getLevel(), CosmosChunkPos.scaleToChunkPos((BlockPos)this.getBlockPos()));
    }

    public void sendUpdates(boolean update) {
        if (this.level != null) {
            this.setChanged();
            BlockState state = this.getBlockState();
            BlockFocus block = (BlockFocus)state.getBlock();
            this.level.sendBlockUpdated(this.getBlockPos(), state, block.updateState(state, this.getBlockPos(), this.level), 3);
            if (update) {
                if (!this.level.isClientSide) {
                    this.level.setBlockAndUpdate(this.getBlockPos(), block.updateState(state, this.getBlockPos(), this.level));
                    if (this.getPocket() != null) {
                        this.getPocket().updateBaseConnectors(this.getLevel());
                    }
                }
            } else if (!this.level.isClientSide) {
                this.level.setBlockAndUpdate(this.getBlockPos(), block.updateState(state, this.getBlockPos(), this.level));
            }
        }
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        if (this.getPocket() != null) {
            this.getPocket().writeToNBT(compound, provider);
        }
        compound.putInt("jumpEnabled", this.jumpEnabled.getIndex());
        compound.putInt("shiftEnabled", this.shiftEnabled.getIndex());
        compound.putInt("ui_mode", this.uiMode.getIndex());
        compound.putInt("ui_help", this.uiHelp.getIndex());
        compound.putInt("ui_lock", this.uiLock.getIndex());
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        if (PocketUtil.hasPocketKey(compound)) {
            this.pocket = Pocket.readFromNBT(compound, provider);
        }
        this.jumpEnabled = EnumGeneralEnableState.getStateFromIndex((int)compound.getInt("jumpEnabled"));
        this.shiftEnabled = EnumGeneralEnableState.getStateFromIndex((int)compound.getInt("shiftEnabled"));
        this.uiMode = EnumUIMode.getStateFromIndex((int)compound.getInt("ui_mode"));
        this.uiHelp = EnumUIHelp.getStateFromIndex((int)compound.getInt("ui_help"));
        this.uiLock = EnumUILock.getStateFromIndex((int)compound.getInt("ui_lock"));
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, provider);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        super.onDataPacket(net, pkt, provider);
        CompoundTag tag_ = pkt.getTag();
        this.handleUpdateTag(tag_, provider);
        this.sendUpdates(true);
    }

    public void onLoad() {
    }

    public void attack(BlockState state, Level levelIn, BlockPos pos, Player playerIn) {
    }

    public ItemInteractionResult useItemOn(ItemStack stackIn, BlockState state, Level levelIn, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult hit) {
        Pocket pocket;
        this.setChanged();
        if (CosmosUtil.getStackItem((Player)playerIn) instanceof BlockItem) {
            return ItemInteractionResult.FAIL;
        }
        if (PocketUtil.isDimensionEqual(levelIn, PocketsDimensionManager.POCKET_WORLD) && (pocket = this.getPocket()) != null) {
            if (!playerIn.isShiftKeyDown()) {
                if (levelIn.isClientSide) {
                    return ItemInteractionResult.SUCCESS;
                }
                if (playerIn instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)playerIn;
                    if (this.canPlayerAccess(playerIn)) {
                        serverPlayer.openMenu((MenuProvider)this, packetBuffer -> packetBuffer.writeBlockPos(pos));
                        return ItemInteractionResult.SUCCESS;
                    }
                }
            } else if (!levelIn.isClientSide) {
                CosmosChunkPos chunkPos = CosmosChunkPos.scaleToChunkPos((BlockPos)pos);
                Pocket pocketIn = StorageManager.getPocketFromChunkPosition(levelIn, chunkPos);
                if (CosmosUtil.holdingWrench((Player)playerIn)) {
                    if (pocketIn.checkIfOwner(playerIn)) {
                        if (this.getBlockPos().getY() == 1 || this.getBlockPos().getY() == this.getPocket().getInternalHeight() || this.getBlockPos().getY() == PocketsConfigManager.getInstance().getInternalHeight()) {
                            ItemStack stack = new ItemStack((ItemLike)PocketsRegistrationManager.MODULE_FOCUS.get());
                            levelIn.setBlockAndUpdate(pos, ((Block)PocketsRegistrationManager.BLOCK_WALL.get()).defaultBlockState());
                            levelIn.removeBlockEntity(pos);
                            CosmosUtil.addStack((Level)levelIn, (Player)playerIn, (ItemStack)stack);
                            return ItemInteractionResult.SUCCESS;
                        }
                        ItemStack stack = new ItemStack((ItemLike)PocketsRegistrationManager.BLOCK_FOCUS.get());
                        levelIn.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                        CosmosUtil.addStack((Level)levelIn, (Player)playerIn, (ItemStack)stack);
                        return ItemInteractionResult.SUCCESS;
                    }
                    CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.status.no_access"));
                    return ItemInteractionResult.FAIL;
                }
                if (pocketIn.exists()) {
                    if (CosmosUtil.handEmpty((Player)playerIn) && this.getShiftEnabled()) {
                        pocketIn.shift(playerIn, EnumShiftDirection.LEAVE, null, null, null);
                        return ItemInteractionResult.SUCCESS;
                    }
                } else {
                    CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.status.action.null"));
                    return ItemInteractionResult.FAIL;
                }
            }
        }
        return ItemInteractionResult.FAIL;
    }

    public InteractionResult useWithoutItem(BlockState state, Level levelIn, BlockPos posIn, Player playerIn, BlockHitResult hit) {
        return InteractionResult.FAIL;
    }

    public Component getDisplayName() {
        return ComponentHelper.title((String)"dimensionalpocketsii.gui.focus");
    }

    public Component getName() {
        return ComponentHelper.title((String)"dimensionalpocketsii.gui.focus");
    }

    public AbstractContainerMenu createMenu(int idIn, Inventory playerInventoryIn, Player playerIn) {
        return new ContainerFocus(idIn, playerInventoryIn, ContainerLevelAccess.create((Level)this.getLevel(), (BlockPos)this.getBlockPos()), this.getBlockPos());
    }

    public EnumGeneralEnableState getJump() {
        return this.jumpEnabled;
    }

    public boolean getJumpEnabled() {
        return this.jumpEnabled.getValue();
    }

    public void setJumpEnabled(EnumGeneralEnableState state) {
        this.jumpEnabled = state;
        this.sendUpdates(true);
    }

    public void setJumpEnabled(Boolean state) {
        this.jumpEnabled = EnumGeneralEnableState.getStateFromValue((boolean)state);
        this.sendUpdates(true);
    }

    public EnumGeneralEnableState getShift() {
        return this.shiftEnabled;
    }

    public boolean getShiftEnabled() {
        return this.shiftEnabled.getValue();
    }

    public void setShiftEnabled(EnumGeneralEnableState state) {
        this.shiftEnabled = state;
        this.sendUpdates(true);
    }

    public void setShiftEnabled(Boolean state) {
        this.shiftEnabled = EnumGeneralEnableState.getStateFromValue((boolean)state);
        this.sendUpdates(true);
    }

    public EnumUIMode getUIMode() {
        return this.uiMode;
    }

    public void setUIMode(EnumUIMode modeIn) {
        this.uiMode = modeIn;
    }

    public void cycleUIMode() {
        this.uiMode = EnumUIMode.getNextStateFromState((EnumUIMode)this.uiMode);
    }

    public EnumUIHelp getUIHelp() {
        return this.uiHelp;
    }

    public void setUIHelp(EnumUIHelp modeIn) {
        this.uiHelp = modeIn;
    }

    public void cycleUIHelp() {
        this.uiHelp = EnumUIHelp.getNextStateFromState((EnumUIHelp)this.uiHelp);
    }

    public EnumUILock getUILock() {
        return this.uiLock;
    }

    public void setUILock(EnumUILock modeIn) {
        this.uiLock = modeIn;
    }

    public void cycleUILock() {
        this.uiLock = EnumUILock.getNextStateFromState((EnumUILock)this.uiLock);
    }

    public void setOwner(Player playerIn) {
    }

    public boolean canPlayerAccess(Player playerIn) {
        if (this.getUILock().equals((Object)EnumUILock.PUBLIC)) {
            return true;
        }
        return this.getPocket().checkIfOwner(playerIn);
    }

    public boolean checkIfOwner(Player playerIn) {
        return this.getPocket().checkIfOwner(playerIn);
    }
}

