/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.pocket.core.block.entity;

import com.tcn.cosmoslibrary.common.blockentity.CosmosBlockEntityUpdateable;
import com.tcn.cosmoslibrary.common.chat.CosmosChatUtil;
import com.tcn.cosmoslibrary.common.enums.EnumUIHelp;
import com.tcn.cosmoslibrary.common.enums.EnumUILock;
import com.tcn.cosmoslibrary.common.enums.EnumUIMode;
import com.tcn.cosmoslibrary.common.interfaces.block.IBlockInteract;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IBEUILockable;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IBEUIMode;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IBEUpdates;
import com.tcn.cosmoslibrary.common.item.CosmosArmourItemColourable;
import com.tcn.cosmoslibrary.common.item.CosmosArmourItemElytra;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.cosmoslibrary.common.lib.CosmosChunkPos;
import com.tcn.cosmoslibrary.common.util.CosmosUtil;
import com.tcn.dimensionalpocketsii.core.item.armour.DimensionalElytraplate;
import com.tcn.dimensionalpocketsii.core.item.armour.module.EnumElytraModule;
import com.tcn.dimensionalpocketsii.core.item.armour.module.IModuleItem;
import com.tcn.dimensionalpocketsii.core.management.PocketsRegistrationManager;
import com.tcn.dimensionalpocketsii.pocket.core.Pocket;
import com.tcn.dimensionalpocketsii.pocket.core.registry.StorageManager;
import com.tcn.dimensionalpocketsii.pocket.core.shift.EnumShiftDirection;
import com.tcn.dimensionalpocketsii.pocket.core.util.PocketUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class BlockEntityModuleArmourWorkbench
extends CosmosBlockEntityUpdateable
implements IBlockInteract,
Container,
IBEUpdates.Base,
IBEUIMode,
IBEUILockable {
    public NonNullList<ItemStack> inventoryItems = NonNullList.withSize((int)11, (Object)ItemStack.EMPTY);
    private Pocket pocket;
    private EnumUIMode uiMode = EnumUIMode.DARK;
    private EnumUIHelp uiHelp = EnumUIHelp.HIDDEN;
    private EnumUILock uiLock = EnumUILock.PRIVATE;
    public ComponentColour customColourArmour = ComponentColour.POCKET_PURPLE;
    public ComponentColour customColourWings = ComponentColour.ELYTRA;

    public BlockEntityModuleArmourWorkbench(BlockPos posIn, BlockState stateIn) {
        super((BlockEntityType)PocketsRegistrationManager.BLOCK_ENTITY_TYPE_ARMOUR_WORKBENCH.get(), posIn, stateIn);
    }

    public Pocket getPocket() {
        if (this.level.isClientSide) {
            return this.pocket;
        }
        return StorageManager.getPocketFromChunkPosition(this.getLevel(), CosmosChunkPos.scaleToChunkPos((BlockPos)this.getBlockPos()));
    }

    public void sendUpdates(boolean forceUpdate) {
        super.sendUpdates(forceUpdate);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        if (this.getPocket().exists()) {
            this.getPocket().writeToNBT(compound, provider);
        }
        ContainerHelper.saveAllItems((CompoundTag)compound, this.inventoryItems, (HolderLookup.Provider)provider);
        compound.putInt("ui_mode", this.uiMode.getIndex());
        compound.putInt("ui_help", this.uiHelp.getIndex());
        compound.putInt("ui_lock", this.uiLock.getIndex());
        compound.putInt("armourColour", this.customColourArmour.getIndex());
        compound.putInt("wingColour", this.customColourWings.getIndex());
    }

    public void saveToItemStack(ItemStack stackIn, HolderLookup.Provider provider) {
        CompoundTag compound = ((CustomData)stackIn.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        ContainerHelper.saveAllItems((CompoundTag)compound, this.inventoryItems, (HolderLookup.Provider)provider);
        compound.putInt("ui_mode", this.uiMode.getIndex());
        compound.putInt("ui_help", this.uiHelp.getIndex());
        compound.putInt("ui_lock", this.uiLock.getIndex());
        compound.putInt("armourColour", this.customColourArmour.getIndex());
        compound.putInt("wingColour", this.customColourWings.getIndex());
        stackIn.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)compound));
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        if (PocketUtil.hasPocketKey(compound)) {
            this.pocket = Pocket.readFromNBT(compound, provider);
        }
        this.inventoryItems = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)compound, this.inventoryItems, (HolderLookup.Provider)provider);
        this.uiMode = EnumUIMode.getStateFromIndex((int)compound.getInt("ui_mode"));
        this.uiHelp = EnumUIHelp.getStateFromIndex((int)compound.getInt("ui_help"));
        this.uiLock = EnumUILock.getStateFromIndex((int)compound.getInt("ui_lock"));
        this.customColourArmour = ComponentColour.fromIndex((int)compound.getInt("armourColour"));
        this.customColourWings = ComponentColour.fromIndex((int)compound.getInt("wingColour"));
    }

    public void loadFromItemStack(ItemStack stackIn, HolderLookup.Provider provider) {
        if (stackIn.has(DataComponents.CUSTOM_DATA)) {
            CompoundTag compound = ((CustomData)stackIn.get(DataComponents.CUSTOM_DATA)).copyTag();
            this.inventoryItems = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
            ContainerHelper.loadAllItems((CompoundTag)compound, this.inventoryItems, (HolderLookup.Provider)provider);
            this.uiMode = EnumUIMode.getStateFromIndex((int)compound.getInt("ui_mode"));
            this.uiHelp = EnumUIHelp.getStateFromIndex((int)compound.getInt("ui_help"));
            this.uiLock = EnumUILock.getStateFromIndex((int)compound.getInt("ui_lock"));
            this.customColourArmour = ComponentColour.fromIndex((int)compound.getInt("armourColour"));
            this.customColourWings = ComponentColour.fromIndex((int)compound.getInt("wingColour"));
        }
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        this.sendUpdates(true);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, provider);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        super.onDataPacket(net, pkt, provider);
        CompoundTag tag_ = pkt.getTag();
        this.handleUpdateTag(tag_, provider);
    }

    public void onLoad() {
    }

    public static void tick(Level levelIn, BlockPos posIn, BlockState stateIn, BlockEntityModuleArmourWorkbench entityIn) {
        entityIn.displayPreviewSlot();
    }

    public void attack(BlockState state, Level levelIn, BlockPos pos, Player player) {
    }

    public ItemInteractionResult useItemOn(ItemStack stackIn, BlockState state, Level levelIn, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult hit) {
        levelIn.sendBlockUpdated(pos, state, state, 3);
        this.setChanged();
        this.sendUpdates(true);
        if (CosmosUtil.getStackItem((Player)playerIn) instanceof BlockItem) {
            return ItemInteractionResult.FAIL;
        }
        if (!playerIn.isShiftKeyDown()) {
            if (levelIn.isClientSide) {
                return ItemInteractionResult.SUCCESS;
            }
            if (playerIn instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)playerIn;
                if (this.canPlayerAccess(playerIn)) {
                    serverPlayer.openMenu(state.getMenuProvider(levelIn, pos), packetBuffer -> packetBuffer.writeBlockPos(pos));
                } else {
                    CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.status.no_access"));
                    return ItemInteractionResult.FAIL;
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (!levelIn.isClientSide) {
            CosmosChunkPos chunkPos = CosmosChunkPos.scaleToChunkPos((BlockPos)pos);
            Pocket pocketIn = StorageManager.getPocketFromChunkPosition(levelIn, chunkPos);
            if (pocketIn.exists()) {
                if (CosmosUtil.holdingWrench((Player)playerIn)) {
                    if (pocketIn.checkIfOwner(playerIn)) {
                        ItemStack stack = new ItemStack((ItemLike)PocketsRegistrationManager.MODULE_ARMOUR_WORKBENCH.get());
                        this.saveToItemStack(stack, (HolderLookup.Provider)levelIn.registryAccess());
                        levelIn.setBlockAndUpdate(pos, ((Block)PocketsRegistrationManager.BLOCK_WALL.get()).defaultBlockState());
                        levelIn.removeBlockEntity(pos);
                        CosmosUtil.addStack((Level)levelIn, (Player)playerIn, (ItemStack)stack);
                        return ItemInteractionResult.SUCCESS;
                    }
                    CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.status.no_access"));
                    return ItemInteractionResult.FAIL;
                }
                if (CosmosUtil.handEmpty((Player)playerIn)) {
                    pocketIn.shift(playerIn, EnumShiftDirection.LEAVE, null, null, null);
                    return ItemInteractionResult.SUCCESS;
                }
            } else {
                CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.status.action.null"));
                return ItemInteractionResult.FAIL;
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    public InteractionResult useWithoutItem(BlockState state, Level levelIn, BlockPos posIn, Player playerIn, BlockHitResult hit) {
        return InteractionResult.FAIL;
    }

    public void applyToArmourItem(boolean colourIn, boolean moduleIn) {
        ItemStack inputStack = this.getItem(0);
        if (moduleIn && inputStack != ItemStack.EMPTY) {
            for (int i = 3; i < 11; ++i) {
                IModuleItem item;
                EnumElytraModule module;
                Item item2;
                ItemStack stackIn = this.getItem(i);
                if (stackIn.isEmpty() || !((item2 = stackIn.getItem()) instanceof IModuleItem) || !DimensionalElytraplate.addModule(inputStack, module = (item = (IModuleItem)item2).getModule(), true)) continue;
                DimensionalElytraplate.addModule(inputStack, module, false);
                if (item.doesInformationCarry() && item.transferInformation(stackIn, inputStack, true)) {
                    item.transferInformation(stackIn, inputStack, false);
                }
                this.getItem(i).shrink(1);
            }
        }
        if (inputStack != this.getResultStack(true, colourIn, moduleIn)) {
            this.setItem(0, this.getResultStack(true, colourIn, moduleIn));
        }
        this.setChanged();
    }

    public void removeFromArmourItem() {
        ItemStack inputStack = this.getItem(0);
        if (inputStack != ItemStack.EMPTY) {
            block0: for (int i = 3; i < 11; ++i) {
                ItemStack stackIn = this.getItem(i);
                if (!stackIn.isEmpty()) continue;
                for (int j = 0; j < 7; ++j) {
                    EnumElytraModule module = EnumElytraModule.getStateFromIndex(j);
                    if (DimensionalElytraplate.removeModule(inputStack, module, true).isEmpty()) continue;
                    ItemStack moduleStack = DimensionalElytraplate.removeModule(inputStack, module, false);
                    this.setItem(i, moduleStack);
                    continue block0;
                }
            }
        }
    }

    public ItemStack getResultStack(boolean useColour, boolean colourIn, boolean moduleIn) {
        ItemStack inputStack = this.getItem(0);
        Item inputItem = inputStack.getItem();
        ItemStack resultStack = inputStack.copy();
        if (inputStack != ItemStack.EMPTY) {
            if (moduleIn) {
                for (int i = 3; i < 11; ++i) {
                    ItemStack stackIn = this.getItem(i);
                    if (!stackIn.isEmpty()) {
                        Item item = stackIn.getItem();
                        if (!(item instanceof IModuleItem)) continue;
                        IModuleItem item2 = (IModuleItem)item;
                        EnumElytraModule module = item2.getModule();
                        if (!useColour || !DimensionalElytraplate.addModule(resultStack, module, true)) continue;
                        DimensionalElytraplate.addModule(resultStack, module, false);
                        if (!item2.doesInformationCarry() || !item2.transferInformation(stackIn, resultStack, true)) continue;
                        item2.transferInformation(stackIn, resultStack, false);
                        continue;
                    }
                    if (useColour) continue;
                    DimensionalElytraplate.removeAllModules(resultStack, false);
                }
            }
            if (colourIn) {
                if (inputItem instanceof CosmosArmourItemColourable) {
                    resultStack = useColour ? CosmosUtil.setArmourColourInformation((ItemStack)resultStack, (ComponentColour)this.customColourArmour, null) : CosmosUtil.setArmourColourInformation((ItemStack)resultStack, (ComponentColour)ComponentColour.POCKET_PURPLE_LIGHT, null);
                }
                if (inputItem instanceof CosmosArmourItemElytra) {
                    resultStack = useColour ? CosmosUtil.setArmourColourInformation((ItemStack)resultStack, null, (ComponentColour)this.customColourWings) : CosmosUtil.setArmourColourInformation((ItemStack)resultStack, null, (ComponentColour)ComponentColour.LIGHT_GRAY);
                }
            }
        }
        return resultStack;
    }

    public void displayPreviewSlot() {
        if (!this.getItem(0).isEmpty()) {
            if (this.getItem(1) != this.getResultStack(true, true, true)) {
                this.setItem(1, this.getResultStack(true, true, true));
            }
            if (this.getItem(2) != this.getResultStack(false, true, true)) {
                this.setItem(2, this.getResultStack(false, true, true));
            }
        } else {
            this.setItem(1, ItemStack.EMPTY);
            this.setItem(2, ItemStack.EMPTY);
        }
    }

    public int getContainerSize() {
        return this.inventoryItems.size();
    }

    public boolean isEmpty() {
        for (ItemStack inventoryItemstack : this.inventoryItems) {
            if (inventoryItemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int indexIn) {
        return (ItemStack)this.inventoryItems.get(indexIn);
    }

    public ItemStack removeItem(int indexIn, int countIn) {
        this.setChanged();
        return ContainerHelper.removeItem(this.inventoryItems, (int)indexIn, (int)countIn);
    }

    public ItemStack removeItemNoUpdate(int indexIn) {
        return ContainerHelper.takeItem(this.inventoryItems, (int)indexIn);
    }

    public void setItem(int indexIn, ItemStack stackIn) {
        this.inventoryItems.set(indexIn, (Object)stackIn);
        if (stackIn.getCount() > this.getMaxStackSize()) {
            stackIn.setCount(this.getMaxStackSize());
        }
        this.setChanged();
    }

    public boolean stillValid(Player playerIn) {
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return playerIn.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public boolean canPlaceItem(int indexIn, ItemStack stackIn) {
        return true;
    }

    public void clearContent() {
        this.inventoryItems.clear();
    }

    public EnumUIMode getUIMode() {
        return this.uiMode;
    }

    public void setUIMode(EnumUIMode modeIn) {
        this.uiMode = modeIn;
    }

    public void cycleUIMode() {
        this.uiMode = EnumUIMode.getNextStateFromState((EnumUIMode)this.uiMode);
    }

    public EnumUIHelp getUIHelp() {
        return this.uiHelp;
    }

    public void setUIHelp(EnumUIHelp modeIn) {
        this.uiHelp = modeIn;
    }

    public void cycleUIHelp() {
        this.uiHelp = EnumUIHelp.getNextStateFromState((EnumUIHelp)this.uiHelp);
    }

    public EnumUILock getUILock() {
        return this.uiLock;
    }

    public void setUILock(EnumUILock modeIn) {
        this.uiLock = modeIn;
    }

    public void cycleUILock() {
        this.uiLock = EnumUILock.getNextStateFromState((EnumUILock)this.uiLock);
    }

    public void setOwner(Player playerIn) {
    }

    public boolean canPlayerAccess(Player playerIn) {
        if (this.getUILock().equals((Object)EnumUILock.PUBLIC)) {
            return true;
        }
        return this.getPocket().checkIfOwner(playerIn);
    }

    public boolean checkIfOwner(Player playerIn) {
        return this.getPocket().checkIfOwner(playerIn);
    }

    public void updateColour(ComponentColour colourIn, boolean wingColour) {
        if (colourIn.isEmpty()) {
            if (wingColour) {
                this.customColourWings = ComponentColour.ELYTRA;
            } else {
                this.customColourArmour = ComponentColour.POCKET_PURPLE;
            }
        } else if (wingColour) {
            this.customColourWings = colourIn;
        } else {
            this.customColourArmour = colourIn;
        }
        this.sendUpdates(true);
    }

    public ComponentColour getCustomColour(boolean wingColour) {
        return wingColour ? this.customColourWings : this.customColourArmour;
    }
}

