/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.dimensionalpocketsii.pocket.core.block.entity;

import com.tcn.cosmoslibrary.common.chat.CosmosChatUtil;
import com.tcn.cosmoslibrary.common.enums.EnumEnergyState;
import com.tcn.cosmoslibrary.common.enums.EnumUIHelp;
import com.tcn.cosmoslibrary.common.enums.EnumUILock;
import com.tcn.cosmoslibrary.common.enums.EnumUIMode;
import com.tcn.cosmoslibrary.common.interfaces.block.IBlockInteract;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IBEUILockable;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IBEUIMode;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IEnergyHolder;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.cosmoslibrary.common.lib.CosmosChunkPos;
import com.tcn.cosmoslibrary.common.util.CosmosUtil;
import com.tcn.cosmoslibrary.energy.CosmosEnergyUtil;
import com.tcn.dimensionalpocketsii.core.management.PocketsDimensionManager;
import com.tcn.dimensionalpocketsii.core.management.PocketsRegistrationManager;
import com.tcn.dimensionalpocketsii.pocket.client.container.ContainerModuleCharger;
import com.tcn.dimensionalpocketsii.pocket.core.Pocket;
import com.tcn.dimensionalpocketsii.pocket.core.block.BlockWallCharger;
import com.tcn.dimensionalpocketsii.pocket.core.registry.StorageManager;
import com.tcn.dimensionalpocketsii.pocket.core.shift.EnumShiftDirection;
import com.tcn.dimensionalpocketsii.pocket.core.util.PocketUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class BlockEntityModuleCharger
extends BlockEntity
implements IBlockInteract,
WorldlyContainer,
MenuProvider,
Nameable,
IBEUIMode,
IBEUILockable {
    private NonNullList<ItemStack> inventoryItems = NonNullList.withSize((int)6, (Object)ItemStack.EMPTY);
    private Pocket pocket;
    private int update = 0;
    private EnumEnergyState energy_state = EnumEnergyState.FILL;
    private EnumUIMode uiMode = EnumUIMode.DARK;
    private EnumUIHelp uiHelp = EnumUIHelp.HIDDEN;
    private EnumUILock uiLock = EnumUILock.PRIVATE;

    public BlockEntityModuleCharger(BlockPos posIn, BlockState stateIn) {
        super((BlockEntityType)PocketsRegistrationManager.BLOCK_ENTITY_TYPE_CHARGER.get(), posIn, stateIn);
    }

    public Pocket getPocket() {
        if (this.getLevel().isClientSide()) {
            return this.pocket;
        }
        return StorageManager.getPocketFromChunkPosition(this.getLevel(), CosmosChunkPos.scaleToChunkPos((BlockPos)this.getBlockPos()));
    }

    public void sendUpdates(boolean update) {
        if (this.getLevel() != null) {
            this.setChanged();
            BlockState state = this.getBlockState();
            BlockWallCharger block = (BlockWallCharger)state.getBlock();
            this.getLevel().sendBlockUpdated(this.getBlockPos(), state, state, 3);
            if (update) {
                if (!this.getLevel().isClientSide()) {
                    this.getLevel().setBlockAndUpdate(this.getBlockPos(), block.defaultBlockState());
                    if (this.getPocket() != null) {
                        this.getPocket().updateBaseConnectors(this.getLevel());
                    }
                }
            } else if (!this.getLevel().isClientSide()) {
                this.getLevel().setBlockAndUpdate(this.getBlockPos(), block.defaultBlockState());
            }
        }
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        if (this.getPocket() != null) {
            this.getPocket().writeToNBT(compound, provider);
        }
        ContainerHelper.saveAllItems((CompoundTag)compound, this.inventoryItems, (HolderLookup.Provider)provider);
        compound.putInt("energy_state", this.energy_state.getIndex());
        compound.putInt("ui_mode", this.uiMode.getIndex());
        compound.putInt("ui_lock", this.uiLock.getIndex());
        compound.putInt("ui_help", this.uiHelp.getIndex());
    }

    public void saveToItemStack(ItemStack stackIn, HolderLookup.Provider provider) {
        CompoundTag compound = ((CustomData)stackIn.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        ContainerHelper.saveAllItems((CompoundTag)compound, this.inventoryItems, (HolderLookup.Provider)provider);
        compound.putInt("energy_state", this.energy_state.getIndex());
        compound.putInt("ui_mode", this.uiMode.getIndex());
        compound.putInt("ui_help", this.uiHelp.getIndex());
        compound.putInt("ui_lock", this.uiLock.getIndex());
        stackIn.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)compound));
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        if (PocketUtil.hasPocketKey(compound)) {
            this.pocket = Pocket.readFromNBT(compound, provider);
        }
        this.inventoryItems = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)compound, this.inventoryItems, (HolderLookup.Provider)provider);
        this.energy_state = EnumEnergyState.getStateFromIndex((int)compound.getInt("energy_state"));
        this.uiMode = EnumUIMode.getStateFromIndex((int)compound.getInt("ui_mode"));
        this.uiHelp = EnumUIHelp.getStateFromIndex((int)compound.getInt("ui_help"));
        this.uiLock = EnumUILock.getStateFromIndex((int)compound.getInt("ui_lock"));
    }

    public void loadFromItemStack(ItemStack stackIn, HolderLookup.Provider provider) {
        if (stackIn.has(DataComponents.CUSTOM_DATA)) {
            CompoundTag compound = ((CustomData)stackIn.get(DataComponents.CUSTOM_DATA)).copyTag();
            this.inventoryItems = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
            ContainerHelper.loadAllItems((CompoundTag)compound, this.inventoryItems, (HolderLookup.Provider)provider);
            this.energy_state = EnumEnergyState.getStateFromIndex((int)compound.getInt("energy_state"));
            this.uiMode = EnumUIMode.getStateFromIndex((int)compound.getInt("ui_mode"));
            this.uiHelp = EnumUIHelp.getStateFromIndex((int)compound.getInt("ui_help"));
            this.uiLock = EnumUILock.getStateFromIndex((int)compound.getInt("ui_lock"));
        }
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, provider);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        super.onDataPacket(net, pkt, provider);
        CompoundTag tag_ = pkt.getTag();
        this.handleUpdateTag(tag_, provider);
        this.sendUpdates(true);
    }

    public void onLoad() {
    }

    public static void tick(Level levelIn, BlockPos posIn, BlockState stateIn, BlockEntityModuleCharger entityIn) {
        boolean flag;
        if (entityIn.energy_state.equals((Object)EnumEnergyState.FILL)) {
            for (i = 0; i < entityIn.inventoryItems.size(); ++i) {
                entityIn.chargeItem(i);
            }
        } else {
            for (i = 0; i < entityIn.inventoryItems.size(); ++i) {
                entityIn.drainItem(i);
            }
        }
        boolean bl = flag = entityIn.update > 0;
        if (flag) {
            --entityIn.update;
        } else {
            entityIn.update = 20;
            entityIn.sendUpdates(true);
        }
    }

    public void attack(BlockState state, Level levelIn, BlockPos pos, Player playerIn) {
    }

    public ItemInteractionResult useItemOn(ItemStack stackIn, BlockState state, Level levelIn, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult hit) {
        Pocket pocket;
        this.setChanged();
        if (CosmosUtil.getStackItem((Player)playerIn) instanceof BlockItem) {
            return ItemInteractionResult.FAIL;
        }
        if (PocketUtil.isDimensionEqual(levelIn, PocketsDimensionManager.POCKET_WORLD) && (pocket = this.getPocket()) != null) {
            if (!playerIn.isShiftKeyDown()) {
                if (levelIn.isClientSide) {
                    return ItemInteractionResult.SUCCESS;
                }
                if (playerIn instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)playerIn;
                    if (this.canPlayerAccess(playerIn)) {
                        serverPlayer.openMenu((MenuProvider)this, packetBuffer -> packetBuffer.writeBlockPos(pos));
                    } else {
                        CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.status.no_access"));
                        return ItemInteractionResult.FAIL;
                    }
                }
                return ItemInteractionResult.SUCCESS;
            }
            if (!levelIn.isClientSide) {
                CosmosChunkPos chunkPos = CosmosChunkPos.scaleToChunkPos((BlockPos)pos);
                Pocket pocketIn = StorageManager.getPocketFromChunkPosition(levelIn, chunkPos);
                if (pocketIn.exists()) {
                    if (CosmosUtil.holdingWrench((Player)playerIn)) {
                        if (pocketIn.checkIfOwner(playerIn)) {
                            ItemStack stack = new ItemStack((ItemLike)PocketsRegistrationManager.MODULE_CHARGER.get());
                            this.saveToItemStack(stack, (HolderLookup.Provider)levelIn.registryAccess());
                            levelIn.setBlockAndUpdate(pos, ((Block)PocketsRegistrationManager.BLOCK_WALL.get()).defaultBlockState());
                            levelIn.removeBlockEntity(pos);
                            CosmosUtil.addStack((Level)levelIn, (Player)playerIn, (ItemStack)stack);
                            pocketIn.removeUpdateable(pos);
                            return ItemInteractionResult.SUCCESS;
                        }
                        CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.status.no_access"));
                        return ItemInteractionResult.FAIL;
                    }
                    if (CosmosUtil.handEmpty((Player)playerIn)) {
                        pocketIn.shift(playerIn, EnumShiftDirection.LEAVE, null, null, null);
                        return ItemInteractionResult.SUCCESS;
                    }
                } else {
                    CosmosChatUtil.sendServerPlayerMessage((Player)playerIn, (Component)ComponentHelper.getErrorText((String)"dimensionalpocketsii.pocket.status.action.null"));
                    return ItemInteractionResult.FAIL;
                }
            }
        }
        return ItemInteractionResult.FAIL;
    }

    public InteractionResult useWithoutItem(BlockState state, Level levelIn, BlockPos posIn, Player playerIn, BlockHitResult hit) {
        return InteractionResult.FAIL;
    }

    public void chargeItem(int indexIn) {
        Object object;
        if (!this.getItem(indexIn).isEmpty() && (object = this.getItem(indexIn).getCapability(Capabilities.EnergyStorage.ITEM)) instanceof IEnergyStorage) {
            IEnergyStorage energyItem = (IEnergyStorage)object;
            if (this.getPocket().hasEnergyStored() && energyItem.canReceive()) {
                this.getPocket().extractEnergy(energyItem.receiveEnergy(this.getPocket().getMaxReceive(), false), false);
            }
        }
    }

    public void drainItem(int indexIn) {
        Object object;
        if (!this.getItem(indexIn).isEmpty() && (object = this.getItem(indexIn).getCapability(Capabilities.EnergyStorage.ITEM)) instanceof IEnergyStorage) {
            IEnergyStorage energyItem = (IEnergyStorage)object;
            if (!CosmosEnergyUtil.isEnergyFull((IEnergyHolder)this.getPocket()) && CosmosEnergyUtil.hasEnergy((IEnergyStorage)energyItem) && energyItem.canExtract()) {
                this.getPocket().receiveEnergy(energyItem.extractEnergy(this.getPocket().getMaxExtract(), false), false);
            }
        }
    }

    public void clearContent() {
    }

    public boolean canPlaceItemThroughFace(int arg0, ItemStack arg1, Direction arg2) {
        return false;
    }

    public boolean canTakeItemThroughFace(int arg0, ItemStack arg1, Direction arg2) {
        return false;
    }

    public int getContainerSize() {
        return 6;
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.inventoryItems.get(index);
    }

    public ItemStack removeItem(int index, int count) {
        this.setChanged();
        return ContainerHelper.removeItem(this.inventoryItems, (int)index, (int)count);
    }

    public ItemStack removeItemNoUpdate(int index) {
        this.setChanged();
        return ContainerHelper.takeItem(this.inventoryItems, (int)index);
    }

    public void setItem(int index, ItemStack stack) {
        this.inventoryItems.set(index, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        this.setChanged();
    }

    public boolean stillValid(Player playerIn) {
        return true;
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.inventoryItems) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int[] getSlotsForFace(Direction arg0) {
        return new int[]{0, 0, 0, 0, 0, 0};
    }

    public Component getDisplayName() {
        return ComponentHelper.title((String)"dimensionalpocketsii.gui.charger");
    }

    public Component getName() {
        return ComponentHelper.title((String)"dimensionalpocketsii.gui.charger");
    }

    public AbstractContainerMenu createMenu(int idIn, Inventory playerInventoryIn, Player playerIn) {
        return new ContainerModuleCharger(idIn, playerInventoryIn, (Container)this, ContainerLevelAccess.create((Level)this.getLevel(), (BlockPos)this.getBlockPos()), this.getBlockPos());
    }

    public EnumEnergyState getEnergyState() {
        return this.energy_state;
    }

    public boolean getEnergyStateValue() {
        return this.energy_state.getValue();
    }

    public void setEnergyState(EnumEnergyState state) {
        this.energy_state = state;
        this.sendUpdates(true);
    }

    public void setEnergyState(boolean change) {
        this.energy_state = EnumEnergyState.getStateFromValue((boolean)change);
        this.sendUpdates(true);
    }

    public void cycleEnergyState() {
        this.setEnergyState(EnumEnergyState.getOpposite((EnumEnergyState)this.energy_state));
        this.sendUpdates(true);
    }

    public EnumUIMode getUIMode() {
        return this.uiMode;
    }

    public void setUIMode(EnumUIMode modeIn) {
        this.uiMode = modeIn;
    }

    public void cycleUIMode() {
        this.uiMode = EnumUIMode.getNextStateFromState((EnumUIMode)this.uiMode);
    }

    public EnumUIHelp getUIHelp() {
        return this.uiHelp;
    }

    public void setUIHelp(EnumUIHelp modeIn) {
        this.uiHelp = modeIn;
    }

    public void cycleUIHelp() {
        this.uiHelp = EnumUIHelp.getNextStateFromState((EnumUIHelp)this.uiHelp);
    }

    public EnumUILock getUILock() {
        return this.uiLock;
    }

    public void setUILock(EnumUILock modeIn) {
        this.uiLock = modeIn;
    }

    public void cycleUILock() {
        this.uiLock = EnumUILock.getNextStateFromState((EnumUILock)this.uiLock);
    }

    public void setOwner(Player playerIn) {
    }

    public boolean canPlayerAccess(Player playerIn) {
        if (this.getUILock().equals((Object)EnumUILock.PUBLIC)) {
            return true;
        }
        return this.getPocket().checkIfOwner(playerIn);
    }

    public boolean checkIfOwner(Player playerIn) {
        return this.getPocket().checkIfOwner(playerIn);
    }
}

